//--------------------------------------
//	Detail Window Dragging
//--------------------------------------

// *** Note: Don't "defer" this script since these drag functions are required on the <body> tag ***

var gDrag = false;
var gStartX = 0;
var gMStartX = 0;
var gDetMaxX = 760;
var gDetMinX = -300;

function DetDragStart(evt)
{
	gStartX = parent.gDetFrame.offsetLeft;
	gMStartX = evt.screenX;
	gDrag = true;

	return true;
}

function DetDrag(evt)
{
	if (gDrag) {
		if (!evt.button) {
			gDrag = false;
		}
		else {
			var deltaX = evt.screenX - gMStartX;
			var newX = gStartX + deltaX;
			if (newX < gDetMinX) {
				newX = gDetMinX;
			}
			else if (newX > gDetMaxX) {
				newX = gDetMaxX;
			}

			parent.gDetFrame.style.left = newX + "px";
		}
	}

	return true;
}

function ns6DetDrag(evt)
{
	if (gDrag) {
		var deltaX = evt.screenX - gMStartX;
		var newX = gStartX + deltaX;
		if (newX < gDetMinX) {
			newX = gDetMinX;
		}
		else if (newX > gDetMaxX) {
			newX = gDetMaxX;
		}

		parent.gDetFrame.style.left = newX + "px";
	}

	return true;
}


//--------------------------------------
//	TabObj()
//--------------------------------------

function	TabObj(inSet, inContent)
{
	this.btnObj = Btn2Obj;
	this.btnObj();

	this.topImg.mySet = inSet;

	this.cDiv = inContent;

	if (gIsNS6) this.smbeTabNum = parseInt(this.cDiv.attributes.smbeTabNum.value);
	else this.smbeTabNum = parseInt(this.cDiv.smbeTabNum);

	this.SetOn = TabSetOn;
	this.SetOff = TabSetOff;
}

function TabSetOn()
{
	this.onImg.style.visibility = "inherit";
	this.isOn = true;
	this.cDiv.style.visibility = "inherit";
	gDetForm.activeTab.value = this.smbeTabNum;
}

function TabSetOff()
{
	this.onImg.style.visibility = "hidden";
	this.isOn = false;
	this.cDiv.style.visibility = "hidden";
}

//--------------------------------------
//	TabSetObj()
//--------------------------------------

function TabSetObj(inFrame)
{
	var c;
	if (this.childNodes) {
		c = this.childNodes;
		if (!c.length) return;

		this.tabBkgd = c[0];
		this.tabLine = c[0].childNodes[0];
		this.closeImg = c[0].childNodes[1];
		this.myTabs = c[1];
		this.tabList = c[1].childNodes;
		this.myContent = c[2];
		this.cList = c[2].childNodes[0].childNodes;
	}
	else {
		c = this.children;
		if (!c.length) return;

		this.tabBkgd = c[0];
		this.tabLine = c[0].children[0];
		this.closeImg = c[0].children[1];
		this.myTabs = c[1];
		this.tabList = c[1].children;
		this.myContent = c[2];
		this.cList = c[2].children[0].children;
	}

	this.eClick = TabSetClick;

	this.activeTab = null;
	var aTabNum = parseInt(gDetForm.activeTab.value);
	var tabSumX = 0;
	var cMaxX = 325;
	var cMaxY = 0;
	var i;
	var t = this.tabList;
	var tObj;
	var cObj;
	c = this.cList;
	for (i=0; i<t.length; i++) {
		cObj = c[i];
		cObj.Init = gCInitA[i]; //gCInitA is populated in the <body> of the document
		cObj.Init(this);

		tObj = t[i];
		tObj.indexNum = i;
		tObj.tabObj = TabObj;
		tObj.tabObj(this, cObj);
		tObj.style.left = tabSumX + "px";
		tabSumX += tObj.xSize;
		if (cObj.xSize > cMaxX) cMaxX = cObj.xSize;
		if (cObj.ySize > cMaxY) cMaxY = cObj.ySize;
		if (tObj.smbeTabNum == aTabNum) this.activeTab = tObj;
	}
	tabSumX += this.closeImg.offsetWidth + 2;
	if (!this.activeTab) this.activeTab = t[0];
	this.activeTab.SetOn();

	var topYSize = t[0].ySize + this.closeImg.offsetHeight;
	this.ySize = cMaxY + 16 + topYSize;
	this.oSize = this.ySize;

	cMaxX += 16;
	if (tabSumX > cMaxX) cMaxX = tabSumX;
	this.xSize = cMaxX;

	this.tabBkgd.style.width = cMaxX + "px";
	this.closeImg.style.left = (cMaxX - this.closeImg.offsetWidth) + "px";
	this.tabLine.width = cMaxX;
	this.myContent.style.width = cMaxX + "px";
}

function TabSetClick(tab, evt)
{
	if (this.activeTab != tab) {
		this.activeTab.SetOff();
		this.activeTab = tab;
		tab.SetOn();
	}
}

//--------------------------------------
//	DetailObj()
//--------------------------------------

function DetSetSize(inW, inH)
{
	this.myFrame.SetSize(inW, inH);
	if (parent.gDetFrame) {
		parent.gDetFrame.style.width = inW + 12 + "px";
		parent.gDetFrame.style.height = inH + 12 + "px";
	}
}

function DetShowCA()
{
	if (!gIsRO) {
		this.SetSize(this.tabSet.xSize, this.tabSet.ySize + this.caHeight);
		this.caDiv.style.visibility = "inherit";
	}
	return true;
}

function DetHideCA()
{
	this.SetSize(this.tabSet.xSize, this.tabSet.ySize);
	this.caDiv.style.visibility = "hidden";
	return true;
}

function DetailObj()
{
	var c;
	var b;
	if (this.childNodes) {
		c = this.childNodes; 
		this.caDiv = c[2];
		this.caDivList = c[2].childNodes;
	}
	else {
		c = this.children;
		this.caDiv = c[2];
		this.caDivList = c[2].children;
	}

	b = c[0];
	this.myFrame = b;
	b.frameObj = FrameObj;
	b.frameObj();

	var t = c[1];
	this.tabSet = t;
	t.tabSetObj = TabSetObj;
	t.tabSetObj();

	if (gIsNS6) this.caHeight = parseInt(this.caDiv.attributes.smbeHeight.value);
	else this.caHeight = parseInt(this.caDiv.smbeHeight);
	if (this.caHeight) {
		b = this.caDivList[0];
		this.cancelBtn = b;
		b.btn2Obj = Btn2Obj;
		b.btn2Obj();

		b = this.caDivList[1];
		this.applyBtn = b;
		b.btn2Obj = Btn2Obj;
		b.btn2Obj();
		b.style.left = b.offsetLeft + this.cancelBtn.xSize + 15 + "px";

		this.caDiv.style.top = t.ySize + "px";
		this.ShowCA = DetShowCA;
		this.HideCA = DetHideCA;
		if (this.childNodes) this.applyMsgs = c[2].childNodes[2].childNodes;
		else this.applyMsgs = c[2].children[2].children;
	}

	this.SetSize = DetSetSize;
	this.SetSize(t.xSize, t.ySize);

	this.eCancel = DoNothing;
	this.abortCnt = 0;
	this.priorCnt = 0;
	this.taskType = "0";
}

var gDetDiv = null;
var gDetForm = null;
var gOptForm = null;
var gIsLoaded = false;

//--------------------------------------
//	Content Initializers
//--------------------------------------

function StdCInit()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;
}

function InitEncSlots()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;
	this.xSize += 25;
	c.style.width = this.xSize + "px";
}

function InitEncSpeaker()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;

	var m = (c.childNodes) ? c.childNodes[1].childNodes : c.children[1].children;

	c = GetPageElement("speakerBtn", true);
	if (c) {
		c.btn2Obj = Btn2Obj;
		c.btn2Obj();

		c.eClick = DetBtnClick;
		c.reqStr = "encSilence";
		c.actType = parent.gActEncSilence;
		c.grayOut = 0;
		c.myMsgs = m;
	}
}

function InitChan()
{

	var m;
	if (this.childNodes) {
		if (gIsNS6) m = this.childNodes[0].childNodes[2].childNodes;
		else m = this.childNodes[2].childNodes;
	}
	else m = this.children[2].children;

	var btn = GetPageElement("pauseBtn", true);
	if (btn) {
		btn.btn2Obj = Btn2Obj;
		btn.btn2Obj();
		btn.eClick = DetBtnClick;
		btn.reqStr = "pauseIO";
		btn.actType = parent.gActPauseIO;
		btn.grayOut = 1;
	}
	else {
		btn = GetPageElement("resumeBtn");
		btn.btn2Obj = Btn2Obj;
		btn.btn2Obj();
		btn.eClick = DetBtnClick;
		btn.reqStr = "resumeIO";
		btn.actType = parent.gActResumeIO;
		btn.grayOut = 1;
	}
	btn.myMsgs = m;


	this.ySize = this.offsetHeight;
	this.xSize = 325;
}

function InitPhyCap()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) this.xSize = this.children[0].scrollWidth;
	else if (gIsNS6) this.xSize = this.childNodes[0].childNodes[0].offsetWidth;
	else this.xSize = this.childNodes[0].offsetWidth;

	gCapSelect = GetPageElement("detSelect");
	gCapViews = GetPageElement("capViews");
	var gc = gCapViews;
	var maxY = 0;
	if (gIsNS6) {
		if (typeof(gCapViews.attributes.capHeight)!="undefined") maxY = parseInt(gCapViews.attributes.capHeight.value);
	}
	else {
		if (typeof(gCapViews.capHeight)!="undefined") maxY = parseInt(gCapViews.capHeight);
	}

	gCapViews = (gCapViews.childNodes) ? gCapViews.childNodes : gCapViews.children;
	c = gCapViews[0];
	var c1 = gCapViews[1];
	var c2 = gCapViews[2];

	if (c.scrollWidth > this.xSize) this.xSize = c.scrollWidth;
	if (c1.scrollWidth > this.xSize) this.xSize = c1.scrollWidth;
	if (c2.scrollWidth > this.xSize) this.xSize = c2.scrollWidth;

	if (!maxY) {
		maxY = c.offsetHeight;
		if (c1.offsetHeight > maxY) maxY = c1.offsetHeight;
		if (c2.offsetHeight > maxY) maxY = c2.offsetHeight;
		this.ySize += maxY;
	}
	else {
		this.xSize += 25;
		gc.style.width = this.xSize;
	}

	if (gIsIE4) c.style.width = this.xSize + 16;
}

function InitPhyLED()
{
	var c;
	var b1;
	var b2;
	var m1;
	var m2;
	if (this.childNodes) {
		if (gIsNS6) c = this.childNodes[0].childNodes;
		else c = this.childNodes;
		b1 = c[0].childNodes[0];
		b2 = c[1].childNodes[0];
		m1 = c[2].childNodes[0].childNodes;
		m2 = c[2].childNodes[1].childNodes;
	}
	else {
		c = this.children;
		b1 = c[0].children[0];
		b2 = c[1].children[0];
		m1 = c[2].children[0].children;
		m2 = c[2].children[1].children;
	}

	b1.btn2Obj = Btn2Obj;
	b1.btn2Obj();
	b1.eClick = DetBtnClick;
	b1.reqStr = "blinkLED";
	b1.actType = parent.gActBlinkLED;
	b1.grayOut = 0;
	b1.myMsgs = m1;
	var mm = b1.midSize;

	b2.btn2Obj = Btn2Obj;
	b2.btn2Obj();
	b2.eClick = DetBtnClick;
	b2.reqStr = "unblinkAll";
	b2.actType = parent.gActUnblinkAll;
	b2.grayOut = 0;
	b2.myMsgs = m2;
	if (b2.midSize > mm) mm = b2.midSize;

	b1.SetMidSize(mm);
	b2.SetMidSize(mm);

	this.ySize = this.offsetHeight;
	this.xSize = 325;
}

function InitAlarm()
{
	var m;
	if (this.childNodes) {
		if (gIsNS6) m = this.childNodes[0].childNodes[3].childNodes;
		else m = this.childNodes[3].childNodes;
	}
	else m = this.children[3].children;

	var btn1 = GetPageElement("alarmEnaBtn", true);
	if (btn1) {
		btn1.btn2Obj = Btn2Obj;
		btn1.btn2Obj();
		btn1.eClick = DetBtnClick;
		btn1.reqStr = "alarmEnable";
		btn1.actType = parent.gActAlarmEna;
		btn1.grayOut = 0;
	}
	else {
		btn1 = GetPageElement("alarmDisBtn");
		btn1.btn2Obj = Btn2Obj;
		btn1.btn2Obj();
		btn1.eClick = DetBtnClick;
		btn1.reqStr = "alarmDisable";
		btn1.actType = parent.gActAlarmDis;
		btn1.grayOut = 0;
	}
	btn1.myMsgs = (this.childNodes) ? m[0].childNodes : m[0].children;

	var btn2 = GetPageElement("alarmSilBtn");
	btn2.btn2Obj = Btn2Obj;
	btn2.btn2Obj();
	btn2.eClick = DetBtnClick;
	btn2.reqStr = "alarmSilence";
	btn2.actType = parent.gActAlarmSil;
	btn2.grayOut = 0;
	btn2.myMsgs = (this.childNodes) ? m[1].childNodes : m[1].children;

	var btn3 = GetPageElement("alarmTstBtn");
	btn3.btn2Obj = Btn2Obj;
	btn3.btn2Obj();
	btn3.eClick = DetBtnClick;
	btn3.reqStr = "alarmTest";
	btn3.actType = parent.gActAlarmTst;
	btn3.grayOut = 0;
	btn3.myMsgs = (this.childNodes) ? m[2].childNodes : m[2].children;

	var maxMid = btn1.midSize;
	if (btn2.midSize > maxMid) maxMid = btn2.midSize;
	if (btn3.midSize > maxMid) maxMid = btn3.midSize;

	btn1.SetMidSize(maxMid);
	btn2.SetMidSize(maxMid);
	btn3.SetMidSize(maxMid);

	this.xSize = 325;
	this.ySize = this.offsetHeight;
}

function InitBattery()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;

	c = (this.childNodes) ? this.childNodes : this.children;
	if (c.length > 1) {
		c = c[1];
		c.btn2Obj = Btn2Obj;
		c.btn2Obj();
		c.eClick = DetBtnClick;
		c.reqStr = "batteryRecal";
		c.actType = parent.gActBatRec;
		c.grayOut = 0;
		var m;
		if (this.childNodes) {
			if (gIsNS6) m = this.childNodes[0].childNodes[2].childNodes;
			else m = this.childNodes[2].childNodes;
		}
		else m = this.children[2].children;
		c.myMsgs = m;
	}
}

function InitLogDrive()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;

	if (gIsNS6) setTimeout("InitAName()", 250);

	gDetDiv.reqStr = "setLogicalProps";
	gDetDiv.actType = parent.gActLogProps;
	gDetDiv.grayOut = 0;
}

function InitAName()
{
	var v = gOptForm.aname.value;
	gOptForm.aname.value = "Text box fix";
	gOptForm.aname.value = v;
}

function InitEvView()
{
	var c = this;
	var lim = 3;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) {
		c = this.childNodes[0];
		lim = 4;
	}
	this.xSize = c.scrollWidth;

	c = (c.childNodes) ? c.childNodes : c.children;
	if (c.length >= lim) {
		if (gIsNS6) c = c[3].childNodes;
		else c = (c.childNodes) ? c[2].childNodes : c[2].children;

		var i;
		var xPos = c[0].scrollWidth + 15;
		for (i=1; i<c.length; i++) {
			btn = c[i];
			btn.btn2Obj = Btn2Obj;
			btn.btn2Obj();
			btn.style.left = xPos + "px";
			xPos += btn.xSize + 15;
		}
		if (gIsNS6) setTimeout("InitEvList()", 250);
	}
}

function InitEvList()
{
	var et = GetPageElement("sysLogEvents", true);
	if (et) et.style.visibility = "inherit";
}

var gEnApply = null;
var gEnCancel = null;

function InitEvNot()
{
	var c = this;
	this.ySize = c.offsetHeight;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;

	var btn = GetPageElement("enCancel");
	gEnCancel = btn;
	btn.btn2Obj = Btn2Obj;
	btn.btn2Obj();
	btn.eClick = EnCancel;

	btn = GetPageElement("enApply");
	gEnApply = btn;
	btn.btn2Obj = Btn2Obj;
	btn.btn2Obj();
	btn.eClick = DetBtnClick;
	btn.reqStr = "enConfig";
	btn.actType = parent.gActEnConfig;
	btn.grayOut = 0;
	c = GetPageElement("enMsgs");
	btn.myMsgs = (c.childNodes) ? c.childNodes : c.children;
}

function EnCancel()
{
	gEnApply.style.visibility = "hidden";
	gEnCancel.style.visibility = "hidden";
	gOptForm.reset();
}

function EnShowCA()
{
	gEnApply.style.visibility = "inherit";
	gEnCancel.style.visibility = "inherit";
	return true;
}

function InitNewTask()
{
	var c = this;
	if (gIsIE4) c.style.width = c.scrollWidth + 16;
	else if (gIsNS6) c = this.childNodes[0];
	this.xSize = c.scrollWidth;

	gDetDiv.sDiv = GetPageElement("taskSchedule");
	var o = GetPageElement("clrWarn", true);
	gDetDiv.detSched = GetPageElement("detSched");
	if (typeof(o) == "undefined") gDetDiv.clrWarn = null;
	else {
		gDetDiv.clrWarn = o;
		o.ySize = o.offsetHeight;
		o.style.display = "none";
	}

	this.ySize = this.offsetHeight;
}

function InitViewTask()
{
	this.ySize = this.offsetHeight;

	var c = this;
	if (gIsIE4) c = this.children[0];
	else if (gIsNS6) c = this.childNodes[0].childNodes[0];
	else c = this.childNodes[0];

	this.xSize = c.offsetWidth;

	var tt = GetPageElement("taskTable", true);
	if (tt) {
		var maxY = 0;
		if (gIsNS6) {
			if (typeof(c.attributes.divHeight)!="undefined") maxY = parseInt(c.attributes.divHeight.value);
		}
		else {
			if (typeof(c.divHeight)!="undefined") maxY = parseInt(c.divHeight);
		}
		if (maxY) {
			this.xSize = tt.offsetWidth + 25;
			c.style.width = this.xSize;
		}

		c = (tt.childNodes) ? tt.childNodes[0].childNodes : tt.children[0].children;
		var i;
		var sid;
		for (i=1; i<c.length; i++) {
			c[i].myIcon = null;
			if (gIsNS6) sid = parseInt(c[i].attributes.smbeId.value);
			else sid = parseInt(c[i].smbeId);
			if (sid) {
				sid = parent.GetPageElement("i" + sid, true);
				if (sid) c[i].myIcon = sid.myIcon;
			}
		}
	}

	gDetDiv.reqStr = "taskReq";
	gDetDiv.actType = parent.gActTask;
	gDetDiv.grayOut = 1;
}

//--------------------------------------
//	Button Click Handlers
//--------------------------------------

function DetBtnClick()
{
	if (this.myTip) gCmdTipMgr.Stop(this);
	this.SetOn();
	gOptForm.requestType.value = this.reqStr;
	parent.gPrevAction = parent.gAction;
	parent.gAction = this.actType;
	parent.gInfoBox.ReqSubmitting(this.myMsgs, this.grayOut);
	parent.gSubmitReq = 1;
	return true;
}

function EvBtnClick(btn, cmd, filter)
{
	if (btn) btn.SetOn();

	gDetForm.tabFlags.value &= (0 << 16);
	gDetForm.tabFlags.value |= (cmd << 24); // shift here versus on the server to guarantee bit #0 doesn't get corrupted
	gDetForm.tabFlags.value |= (filter << 16); // shift here versus on the server to guarantee bit #0 doesn't get corrupted
	parent.ReloadDetails();
	return true;
}

function EvSaveLog()
{
	window.open(parent.gBaseUrl + "?frame=event", "adptEventWin");
}

function SetEvFilter()
{
	var val = gOptForm.evFilter.value;
	val = parseInt(val);
	if (val!=val) val = 0;
	var Btn;
	EvBtnClick(Btn, 0, val);
}


//--------------------------------------
//	Form Functions
//--------------------------------------

var gCapViews = null;
var gCapSelect = null;

function SetCapView(viewNum)
{
	if (!viewNum) {
		gOptForm.capview[0].checked = true;
		gCapViews[0].style.visibility = "inherit";
		gCapViews[1].style.visibility = "hidden";
		gCapViews[2].style.visibility = "hidden";
		gCapViews[3].style.visibility = "hidden";
		gCapSelect.style.visibility = "hidden";
		gDetForm.tabFlags.value = 0;
	}
	else {
		gOptForm.capview[1].checked = true;
		var viewnum = parseInt(gOptForm.detunits.value);
		gCapViews[0].style.visibility = "hidden";
		gCapViews[1].style.visibility = "hidden";
		gCapViews[2].style.visibility = "hidden";
		gCapViews[3].style.visibility = "hidden";
		gCapViews[viewnum].style.visibility = "inherit";
		gCapSelect.style.visibility = "inherit";
		gDetForm.tabFlags.value = (viewnum << 1);
	}

}

function SetOptions()
{
	var val = gOptForm.secLevel.value;
	gDetForm.secLevel.value = val;
	val = parseInt(val);
	if (val!=val) val = 0;
	parent.gShowSec = val;
	if (val) parent.gSysObj.ShowSecs();
	else parent.gSysObj.HideSecs();

	val = gOptForm.bkgdFreq.value;
	gDetForm.bkgdFreq.value = val;
	val = parseInt(val);
	if (val!=val) val = 0;
	parent.gStdPollFreq = val;
	parent.gPollFreq = val;

	val = gOptForm.hiMouse.value;
	gDetForm.hiMouse.value = val;
	val = parseInt(val);
	if (val!=val) val = 0;
	parent.gHiMode = val;

	val = gOptForm.tipDelay.value;
	gDetForm.tipDelay.value = val;
	val = parseInt(val);
	if (val!=val) val = 0;
	if (val==0) {
		parent.gCmdTipMgr.delay = 100;
		parent.gDevTipMgr.delay = 100;
	}
	else if (val==1) {
		parent.gCmdTipMgr.delay = 0;
		parent.gDevTipMgr.delay = 0;
	}
	else {
		parent.gCmdTipMgr.delay = 2;
		parent.gDevTipMgr.delay = 2;
	}

	gDetForm.optChange.value = "1";
}

function CancelChanges()
{
	gDetDiv.eCancel();
	gOptForm.reset();
	return gDetDiv.HideCA();
}

function ApplyChanges()
{
	if (typeof(gOptForm.taskType)!="undefined") {
		if (gOptForm.taskType.value == "clear") {
			var m = GetPageElement("clrWarnText");
			if (!m) m = "WARNING: Clearing this drive will destroy all existing data on the drive.";
			if (!confirm(m.innerHTML)) return CancelChanges();
		}
	}

	gDetDiv.applyBtn.SetOn();
	gOptForm.requestType.value = gDetDiv.reqStr;
	parent.gPrevAction = parent.gAction;
	parent.gAction = gDetDiv.actType;
	parent.gInfoBox.ReqSubmitting(gDetDiv.applyMsgs, gDetDiv.grayOut);
	parent.gSubmitReq = 1;
	return true;
}

function ToggleReadCache()
{
	if (!gIsRO) {
		if (gOptForm.rdcache.checked) gOptForm.rdcache.checked = false;
		else gOptForm.rdcache.checked = true;
		gDetDiv.ShowCA();
	}
	return true;
}

function DoNothing()
{
}

function ClickNow()
{
	gOptForm.taskstart[0].checked = true;
	gDetDiv.detSched.style.visibility = "hidden";
}

function ClickSched()
{
	gOptForm.taskstart[1].checked = true;
	gDetDiv.detSched.style.visibility = "inherit";
}

function ClickTime()
{
	var u = parseInt(gOptForm.timeunits.value, 10);
	var h = parseInt(gOptForm.taskhour.value, 10);
	if (h!=h) h = (u==2) ? 0 : 12;
	var m = parseInt(gOptForm.taskmin.value, 10);
	if (m!=m) m = 0;

	if (u==2) { if (h > 23) h = 0; }
	else if (h > 12) h = 12;
	else if (h < 0) h = 0;

	if ((m>59) || (m<0)) m = 0;

	gOptForm.taskhour.value = (h<10) ? "0" + h : h;
	gOptForm.taskmin.value = (m<10) ? "0" + m : m;
}

function hTaskCancel()
{
	if (gOptForm.taskType.value == "clear") {
		var ts = gDetDiv.tabSet;
		gDetDiv.clrWarn.style.display = "none";
		ts.ySize = ts.oSize;
		gDetDiv.caDiv.style.top = ts.ySize + "px";
	}
	gDetDiv.sDiv.style.visibility = "hidden";
	gDetDiv.detSched.style.visibility = "hidden";
	gDetDiv.abortCnt = 0;
	gDetDiv.priorCnt = 0;
	gDetDiv.taskType = "0";
}

function TaskChange()
{
	var tt = gOptForm.taskType;
	var cw = gDetDiv.clrWarn;
	var ts = gDetDiv.tabSet;

	if (tt.value == "clear") {
		cw.style.display = "block";
		ts.ySize += cw.ySize;
		gDetDiv.caDiv.style.top = ts.ySize + "px";
	}
	else if (gDetDiv.clrWarn) {
		cw.style.display = "none";
		ts.ySize = ts.oSize;
		gDetDiv.caDiv.style.top = ts.ySize + "px";
	}

	gDetDiv.taskType = tt.value;
	gDetDiv.eCancel = hTaskCancel;

	if (tt.value == "0") gDetDiv.sDiv.style.visibility = "hidden";
	else gDetDiv.sDiv.style.visibility = "inherit";

	if (gDetDiv.abortCnt || gDetDiv.priorCnt || gDetDiv.taskType!="0") gDetDiv.ShowCA();
	else gDetDiv.HideCA();

	return true;
}

function AbortClick(cb)
{
	var ac = parseInt(gOptForm.abortCnt.value);
	if (ac!=ac) ac = 0;

	if (cb.checked) ac++;
	else if (ac > 0) ac--;
	
	gOptForm.abortCnt.value = ac;
	gDetDiv.abortCnt = ac;

	if (gDetDiv.abortCnt || gDetDiv.priorCnt || gDetDiv.taskType!="0") gDetDiv.ShowCA();
	else gDetDiv.HideCA();

	return true;
}

function TPChange(sb)
{
	var pc = parseInt(gOptForm.priorCnt.value);
	if (pc!=pc) pc = 0;

	var n = parseInt(sb.value);
	if (n!=n) n=0;

	if (typeof(sb.prevValue)=="undefined") sb.prevValue = 0;

	if ((sb.prevValue < 10)	&& (n >= 10)) pc++;
	else if ((sb.prevValue >= 10)	&& (n < 10)) pc--;

	sb.prevValue = n;
	gOptForm.priorCnt.value = pc;
	gDetDiv.priorCnt = pc;

	if (gDetDiv.abortCnt || gDetDiv.priorCnt || gDetDiv.taskType!="0") gDetDiv.ShowCA();
	else gDetDiv.HideCA();

	return true;
}

// Temperature comversion functions
function F2C(temp)
{
	var celNum = 5*(temp - 32)/9;
	var low = 0;
	var retVal = ((celNum - 0.5) < (low=Math.floor(celNum))) ? low : Math.ceil(celNum);
	return retVal;
}

function C2F(temp)
{
	var farNum = 9*temp/5 + 32;
	var low = 0;
	var retVal = ((farNum - 0.5) < (low=Math.floor(farNum))) ? low : Math.ceil(farNum);
	return retVal;
}

function SetDegreeView(viewNum)
{
	if (viewNum == gDegView) return;

	gDegView = viewNum;
	var tempTable = GetPageElement("TempTable");
	var rows = tempTable.childNodes[0].childNodes;
	var num = null;
	var i = 0;
	gOptForm.degreeType[viewNum].checked = true;
	var fn = (viewNum) ? C2F : F2C;

	var obj;
	for(i=1; i<rows.length; i++) {
		obj = rows[i].childNodes[1].childNodes[0];
		num = parseInt(obj.innerHTML);
		if (num!=num) num = 0;
		obj.innerHTML = fn(num);
	}
}

function SetWrCache(inIndex)
{
	if (!gIsRO) {
		gOptForm.wrcache[inIndex].checked = true;
		gDetDiv.ShowCA();
	}

	return true;
}

//--------------------------------------
//	Init() - For the detail frame
//--------------------------------------

var gDegView = 1;

function Init()
{
	gDetForm = GetPageElement("detForm");
	parent.gDetForm = gDetForm;

	gOptForm = GetPageElement("detOptForm");
	parent.gOptForm = gOptForm;

	gDetDiv = GetPageElement("detDiv", true);
	parent.gDetDiv = gDetDiv;
	if (gDetDiv) {
		gDetDiv.detailObj = DetailObj;
		gDetDiv.detailObj();
		gDetDiv.style.visibility = "inherit";
	}

	gIsLoaded = true;
}

