
//--------------------------------------
//	HdrBtn()
//--------------------------------------

function SetCurHdrBtn(btn)
{
	gCurHdrBtn = btn;
	var f = parent.mainFrame;
	if (f) {
		if (f.gIsLoaded) {
			f.ShowDetail(btn.indexNum);
		}
	}
}

function ClrCurHdrBtn()
{
	var f = parent.mainFrame;
	if (f) {
		if (f.gIsLoaded) {
			f.HideDetail(gCurHdrBtn.indexNum);
		}
	}
	gCurHdrBtn = null;
}

function HdrBtnClick(btn, evt)
{
	var f = parent.mainFrame;
	if (!f) return;
	f = f.gDetForm;
	if (!f) return;

	if (gCurHdrBtn) {
		if (gCurHdrBtn == btn) {
			gCurHdrBtn.SetOff(true);
			ClrCurHdrBtn();
		}
		else {
			gCurHdrBtn.SetOff(false);
			btn.SetOn();
			SetCurHdrBtn(btn);
		}
	}
	else {
		btn.SetOn();
		SetCurHdrBtn(btn);
	}
}

function HdrBtnOn()
{
	this.onImg.style.visibility = "inherit";
	this.isOn = true;
	if (this.mirBtn) {
		this.mirBtn.onImg.style.visibility = "inherit";
		this.mirBtn.isOn = true;
	}
}

function HdrBtnOff()
{
	this.onImg.style.visibility = "hidden";
	this.isOn = false;
	if (this.mirBtn) {
		this.mirBtn.onImg.style.visibility = "hidden";
		this.mirBtn.isOn = false;
	}
}


//--------------------------------------
//	ShowSelBtns(), HideSelBtns()
//--------------------------------------

function ShowSelBtns()
{
	if (gCurHdrBtn) if (gCurHdrBtn.mirBtn) SetCurHdrBtn(gCurHdrBtn.mirBtn);
	gHdrBtns[6].style.visibility = "inherit";
	gHdrBtns[8].style.visibility = "inherit";
}


function HideSelBtns()
{
	if (gCurHdrBtn) if (gCurHdrBtn.mirBtn) SetCurHdrBtn(gCurHdrBtn.mirBtn);
	gHdrBtns[6].style.visibility = "hidden";
	gHdrBtns[8].style.visibility = "hidden";
}


//--------------------------------------
//	Function button click handlers
//--------------------------------------

function RescanClick()
{
	gCmdTipMgr.Stop(this);
	var f = parent.mainFrame;
	if (f && f.gIsLoaded && f.gOptForm) {
		this.SetOn();
		f.gOptForm.requestType.value = "rescanHW";
		f.gPrevAction = f.gAction;
		f.gAction = f.gActRescan;
		//f.gInfoBox.hideObj = f.gDetFrame;
		f.gInfoBox.ReqSubmitting(f.gInfoBox.rescanMsgs, true);
		f.gSubmitReq = 1;
	}
	return true;
}

function ReloadClick()
{
	var f = parent.mainFrame;
	if (f && f.gIsLoaded) f.ReloadMain();

	return true;
}

function LogoutClick()
{
	var f = parent.mainFrame;
	if (f && f.gIsLoaded) parent.window.location.replace(f.gBaseUrl + "?logout");

	return true;
}

//--------------------------------------
//	Init()
//--------------------------------------

var gIsLoaded = false;
var gHdrBtns = new Array(9);
var gCurHdrBtn = null;
var gGrayCover = null;
var gClearCover = null;
var gRescanBtn = null;
var gReloadBtn = null;

function Init()
{
	var leftPos = 0;
	var topPos = 0;
	var xSpace = 10;
	var i;
	var iMax;
	var d;
	var b;
	var dd;
	var j;

	var btnDiv = GetPageElement("hdrBtns");
	var btnDiv2 = btnDiv;
	if (!btnDiv.childNodes) btnDiv.childNodes = btnDiv.children;
	btnDiv = btnDiv.childNodes;

	d = btnDiv[0];
	if (!d.childNodes) d.childNodes = d.children;
	d = d.childNodes;
	iMax = d.length;
	for (i=0; i<iMax; i++) {
		b = d[i];
		if ((i==0) && gIsRO) {
			b.xSize = b.offsetWidth;
			b.ySize = b.offsetHeight;
			b.SetOff = doNothing;
			b.SetOn = doNothing;
		}
		else {
			b.btn2Obj = Btn2Obj;
			b.btn2Obj();
		}
		topPos = 47 - b.ySize - 2;
		b.style.left = leftPos + "px";
		b.style.top = topPos + "px";
		leftPos += b.xSize + xSpace;

		if (i==0) { b.eClick = RescanClick; gRescanBtn = b; }
		else if (i==1) b.eClick = LogoutClick;
		else if (i==2) { b.eClick = ReloadClick; gReloadBtn = b; }
	}

	d = btnDiv[1];
	if (!d.childNodes) d.childNodes = d.children;
	d = d.childNodes;
	iMax = d.length;
	var maxMid = 0;
	for (i=0; i<iMax; i++) {
		b = d[i];
		b.btn2Obj = Btn2Obj;
		b.btn2Obj();
		gHdrBtns.Append(b);
		if (b.midSize > maxMid) maxMid = b.midSize;
	}
	btnDiv[1].style.left = leftPos - (maxMid>>1) - xSpace + "px";

	iMax = gHdrBtns.numItems;
	for (i=0; i<iMax; i++) {
		gHdrBtns[i].SetMidSize(maxMid);
		gHdrBtns[i].SetOn = HdrBtnOn;
		gHdrBtns[i].SetOff = HdrBtnOff;
		gHdrBtns[i].indexNum = i;
	}

	// Position the top buttons
	leftPos = 0;
	topPos = "2px";
	var deltaX = xSpace + gHdrBtns[0].xSize;
	gHdrBtns[4].style.left = leftPos + "px";
	gHdrBtns[4].mirBtn = gHdrBtns[7];
	gHdrBtns[4].style.top = topPos;
	gHdrBtns[7].mirBtn = gHdrBtns[4];
	gHdrBtns[7].style.left = leftPos + "px";
	gHdrBtns[7].style.top = topPos;
	leftPos += deltaX;
	gHdrBtns[1].style.left = leftPos + "px";
	gHdrBtns[1].style.top = topPos;
	gHdrBtns[1].mirBtn = null;
	leftPos += deltaX;
	gHdrBtns[2].style.left = leftPos + "px";
	gHdrBtns[2].style.top = topPos;
	gHdrBtns[2].mirBtn = null;

	// Position the bottom buttons
	topPos = 47 - gHdrBtns[0].ySize - 2;
	leftPos = deltaX>>1;
	gHdrBtns[3].style.left = leftPos + "px";
	gHdrBtns[3].style.top = topPos + "px";
	gHdrBtns[3].mirBtn = gHdrBtns[6];
	gHdrBtns[6].mirBtn = gHdrBtns[3];
	gHdrBtns[6].style.left = leftPos + "px";
	gHdrBtns[6].style.top = topPos + "px";
	leftPos += deltaX;
	gHdrBtns[5].style.left = leftPos + "px";
	gHdrBtns[5].style.top = topPos + "px";
	gHdrBtns[5].mirBtn = gHdrBtns[8];
	gHdrBtns[8].mirBtn = gHdrBtns[5];
	gHdrBtns[8].style.left = leftPos + "px";
	gHdrBtns[8].style.top = topPos + "px";

	d = GetPageElement("coverImgs");
	if (d.childNodes) {
		gClearCover = d.childNodes[0];
		gGrayCover = d.childNodes[1];
	}
	else {
		gClearCover = d.children[0];
		gGrayCover = d.children[1];
	}

	btnDiv2.style.visibility = "visible";
	gIsLoaded = true;
}

