
//--------------------
// Miscellaneous
//--------------------

function doNothing()
{
	return;
}

// *******************************************************************
//				IE4 specific settings
// *******************************************************************


var gShow = "visible";
var gHide = "hidden";

/*
function GetPageElement(inId, errorOk) {
	var obj = document.getElementById(inId);
	if (!obj) {
		if (!errorOk) {
			alert("Error: Failed to get object: " + inId);
		}
	}

	return obj;
}
*/

//-------------
// IE4 VisObj()
//-------------

function VisObj()
{
	this.xPos = this.offsetLeft;
	this.yPos = this.offsetTop;
	this.xSize = this.clientWidth;
	this.ySize = this.clientHeight;
	this.isShown = true;

	this.Show = VisObjShow;
	this.Hide = VisObjHide;
	this.MoveTo = VisObjMoveTo;
	this.MoveBy = VisObjMoveBy;
	this.MoveByX = VisObjMoveByX;
	this.MoveByY = VisObjMoveByY;
}

function GetVisObj(objName)
{
	var obj = GetPageElement(objName);
	if (obj) {
		obj.visObj = VisObj;
		obj.visObj();
	}

	return obj;
}

function InitVisObj(obj)
{
	if (obj) {
		obj.visObj = VisObj;
		obj.visObj();
	}

	return obj;
}

function VisObjShow()
{
	this.isShown = true;
	this.style.visibility = "inherit";
}

function VisObjHide()
{
	this.isShown = false;
	this.style.visibility = gHide;
}

function VisObjMoveTo(inLeft, inTop)
{
	this.xPos = inLeft;
	this.style.posLeft = inLeft;

	this.yPos = inTop;
	this.style.posTop = inTop;
}

function VisObjMoveByX(deltaX)
{
	this.xPos += deltaX;
	this.style.posLeft += deltaX;
}

function VisObjMoveByY(deltaY)
{
	this.yPos += deltaY;
	this.style.posTop += deltaY;
}

function VisObjMoveBy(deltaX, deltaY)
{
	this.xPos += deltaX;
	this.style.posLeft += deltaX;

	this.yPos += deltaY;
	this.style.posTop += deltaY;
}


//-------------
// IE DivObj()
//-------------

function DivObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.SetContent = SetDivContent;
}

function InitDivObj(obj)
{
	if (obj) {
		obj.divObj = DivObj;
		obj.divObj();
	}

	return obj;
}

function GetDivObj(objName)
{
	return InitDivObj(GetPageElement(objName));
}

function SetDivContent(inContent)
{
	this.innerHTML = inContent;
	this.xSize = this.clientWidth;
	this.ySize = this.clientHeight;
}

//-------------
// IE ImgObj()
//-------------

function ImgObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.SetUrl = SetImgObjUrl;
}

function InitImgObj(obj)
{
	if (obj) {
		obj.imgObj = ImgObj;
		obj.imgObj();
	}

	return obj;
}

function GetImgObj(objName)
{
	return InitImgObj(GetPageElement(objName));
}

function SetImgObjUrl(inUrl)
{
	this.src = inUrl;
}

//-------------
// IE VarHImg()
//-------------

function VarHImg(inLeftSize, inMidSize, inRightSize)
{
	this.visObj = VisObj;
	this.visObj();

	this.leftDiv = this.children[0];
	this.leftDiv.visObj = VisObj;
	this.leftDiv.visObj();
	this.leftSize = (inLeftSize) ? inLeftSize : 0;

	this.rightImg = this.children[1];
	this.rightImg.visObj = VisObj;
	this.rightImg.visObj();
	this.rightSize = (inRightSize) ? inRightSize : this.rightImg.xSize;

	this.midSize = inMidSize;
	if (!this.midSize) {
		this.midSize = 0;
	}

	this.SetSize = SetVarHImgSize;
	this.SetMidSize = SetVarHImgMidSize;

	this.SetMidSize(this.midSize);
	this.ySize = this.rightImg.ySize;
}

function InitVarHImg(obj, inLeftSize, inMidSize, inRightSize)
{
	if (obj) {
		obj.varHImg = VarHImg;
		obj.varHImg(inLeftSize, inMidSize, inRightSize);
	}

	return obj;
}

function GetVarHImg(objName, inLeftSize, inMidSize, inRightSize)
{
	return InitVarHImg(GetPageElement(objName), inLeftSize, inMidSize, inRightSize);
}

function SetVarHImgSize(inSize)
{
	var minSize = this.leftSize + this.rightSize;
	this.midSize = (inSize <= minSize) ? 0 : inSize - minSize;

	this.SetMidSize(this.midSize);
}

function SetVarHImgMidSize(inMidSize)
{
	this.midSize = inMidSize;
	var rightAdjust = this.rightSize - this.rightImg.xSize;

	this.leftDiv.xSize = this.leftSize + inMidSize + rightAdjust;
	this.leftDiv.style.clip = "rect(0," + this.leftDiv.xSize + "," + this.leftDiv.ySize + ",0)";

	this.rightImg.MoveTo(this.leftDiv.xSize, 0);

	this.xSize = this.leftDiv.xSize + this.rightImg.xSize;
}

//-------------
// IE VarVImg()
//-------------

function VarVImg(inTopSize, inMidSize, inBtmSize)
{
	this.visObj = VisObj;
	this.visObj();

	this.topDiv = this.children[0];
	this.topDiv.visObj = VisObj;
	this.topDiv.visObj();
	this.topSize = (inTopSize) ? inTopSize : 0;

	this.btmImg = this.children[1];
	this.btmImg.visObj = VisObj;
	this.btmImg.visObj();
	this.btmSize = (inBtmSize) ? inBtmSize : this.btmImg.ySize;

	this.midSize = (inMidSize) ? inMidSize : 0;

	this.SetSize = SetVarVImgSize;
	this.SetMidSize = SetVarVImgMidSize;

	this.SetMidSize(this.midSize);
	this.xSize = this.btmImg.xSize;
}

function InitVarVImg(obj, inTopSize, inMidSize, inBtmSize)
{
	if (obj) {
		obj.varVImg = VarVImg;
		obj.varVImg(inTopSize, inMidSize, inBtmSize);
	}

	return obj;
}

function GetVarVImg(objName, inTopSize, inMidSize, inBtmSize)
{
	return InitVarVImg(GetPageElement(objName), inTopSize, inMidSize, inBtmSize);
}

function SetVarVImgSize(inSize)
{
	var minSize = this.topSize + this.btmSize;
	this.midSize = (inSize <= minSize) ? 0 : inSize - minSize;

	this.SetMidSize(this.midSize);
}

function SetVarVImgMidSize(inMidSize)
{
	this.midSize = inMidSize;
	var btmAdjust = this.btmSize - this.btmImg.ySize;

	this.topDiv.ySize = this.topSize + inMidSize + btmAdjust;
	this.topDiv.style.clip = "rect(0," + this.btmImg.xSize + "," + this.topDiv.ySize + ",0)";

	this.btmImg.MoveTo(0, this.topDiv.ySize);

	this.ySize = this.topDiv.ySize + this.btmImg.ySize;
}

//-------------
// TextBoxObj
//-------------

function TextBoxObj(inLeftSize, inTopSize, inBtmSize)
{
	this.textDiv = InitDivObj(this.children[2]);

	this.varVImg = VarVImg;
	this.varVImg(inTopSize, this.textDiv.ySize, inBtmSize);

	this.textDiv.MoveTo(inLeftSize, inTopSize);

	this.SetContent = TextBoxSetContent;
}

function InitTextBoxObj(obj, inLeftSize, inTopSize, inBtmSize)
{
	if (obj) {
		obj.textBoxObj = TextBoxObj;
		obj.textBoxObj(inLeftSize, inTopSize, inBtmSize);
	}

	return obj;
}

function TextBoxSetContent(inContent)
{
	var obj = this.textDiv;
	obj.innerHTML = inContent;
	obj.xSize = obj.clientWidth;
	obj.ySize = obj.clientHeight;

	this.SetMidSize(obj.ySize);
}


//-------------
// StackBoxObj
//-------------

function StackBoxObj(inLeftSize, inTopSize, inBtmSize)
{
	this.textBoxObj = TextBoxObj;
	this.textBoxObj(inLeftSize, inTopSize, inBtmSize);

	this.strList = new Array();
	this.Push = StackBoxPush;
	this.Pop = StackBoxPop;
}

function GetStackBoxObj(objName, inLeftSize, inTopSize, inBtmSize)
{
	return InitStackBoxObj(GetPageElement(objName), inLeftSize, inTopSize, inBtmSize);
}

function InitStackBoxObj(obj, inLeftSize, inTopSize, inBtmSize)
{
	if (obj) {
		obj.stackBoxObj = StackBoxObj;
		obj.stackBoxObj(inLeftSize, inTopSize, inBtmSize);
	}

	return obj;
}

function StackBoxPush(inStr)
{
	var obj = this.strList;
	obj.Append(inStr);
	var str = "";
	var iMax = obj.numItems;
	var i;
	str = obj[0];
	for (i=1; i < iMax; i++) {
		str += "<br>" + obj[i];
	}
	this.SetContent(str);
}


function StackBoxPop()
{
	var obj = this.strList;
	var str = "";
	var iMax = obj.numItems;
	if (iMax) {
		iMax--;
		obj.numItems = iMax;
		if (iMax) {
			var i;
			str = obj[0];
			for (i=1; i < iMax; i++) {
				str += "<br>" + obj[i];
			}
		}
	}
	this.SetContent(str);
}


//----------------
// VarSeg()
//----------------

function VarSeg()
{
	this.varHImg = VarHImg;
	this.varHImg(2, 0, 3);

	this.SetMidSize = VarSegSetMidSize;

}

function VarSegSetMidSize(inMidSize)
{
	this.midSize = inMidSize;

	this.leftDiv.xSize = this.leftSize + inMidSize;
	this.leftDiv.style.clip = "rect(0," + this.leftDiv.xSize + "," + this.leftDiv.ySize + ",0)";

	this.rightImg.MoveTo(this.leftDiv.xSize - 2, 0);

	this.xSize = this.leftDiv.xSize + this.rightSize;
}

function InitVarSeg(obj)
{
	if (obj) {
		obj.varSeg = VarSeg;
		obj.varSeg();
	}

	return obj;
}

//----------------
// RaidVarSeg()
//----------------

function RaidVarSeg()
{
	this.varSeg = VarSeg;
	this.varSeg();

	this.myExpImg = InitVisObj(this.children[2]);
	this.myRSelImg = InitVisObj(this.children[3]);

	this.VarMidSize = this.SetMidSize;
	this.SetMidSize = RaidVSSetMidSize;
}

function InitRaidVarSeg(obj)
{
	if (obj) {
		obj.raidVarSeg = RaidVarSeg;
		obj.raidVarSeg();
	}

	return obj;
}

function RaidVSSetMidSize(inMidSize)
{
	this.VarMidSize(inMidSize);

	var leftPos = (inMidSize - this.myRSelImg.xSize) >> 1;
	leftPos += this.leftSize;
	
	this.myExpImg.MoveTo(leftPos, 0);
	this.myRSelImg.MoveTo(leftPos, 0);
}

//----------------
// ToolTip()
//----------------

var gTipRight = 1;
var gTipLeft  = 2;
var gTipMiddle = 3;

var gTipTop = 1;
var gTipBottom = 2;

function ToolTip(inHStyle)
{
	// Note: this.xSize and this.ySize are not accurate for this object type

	this.varHImg = VarHImg;
	this.varHImg(9, 0, 12);

	this.tipX = 0;
	this.tipY = 0;

	this.bubbleImg = this.children[2];
	this.bubbleImg.visObj = VisObj;
	this.bubbleImg.visObj();
	this.bubbleImg.MoveTo(this.leftSize, this.leftDiv.ySize - 4);

	this.textDiv = this.children[3];
	this.textDiv.divObj = DivObj;
	this.textDiv.divObj();
	this.textDiv.MoveTo(this.leftSize, 1);

	this.hStyle = (inHStyle) ? inHStyle : gTipRight;
	this.vStyle = gTipTop;

	this.OrigMoveTo = this.MoveTo;
	this.MoveTo = MoveToolTip;
	this.SetContent = SetToolTipContent;

	this.SetMidSize(this.textDiv.xSize);
}


function InitToolTip(obj, inHStyle)
{
	if (obj) {
		obj.toolTip = ToolTip;
		obj.toolTip(inHStyle);
	}

	return obj;
}

function GetToolTip(objName, inHStyle)
{
	return InitToolTip(GetPageElement(objName, false), inHStyle);
}

function SetToolTipContent(inContent)
{
	this.textDiv.SetContent(inContent);
	this.SetMidSize(this.textDiv.xSize);
	this.MoveTo(this.tipX, this.tipY);
}

function MoveToolTip(inLeft, inTop)
{
	this.tipX = inLeft;
	this.tipY = inTop;

	var halfBubble = this.bubbleImg.xSize >> 1;
	var xAdjust = this.leftSize;
	if (this.hStyle == gTipRight) {
		xAdjust += halfBubble;
		this.bubbleImg.MoveTo(this.leftSize, this.leftDiv.ySize - 4);
	}
	else if (this.hStyle == gTipLeft) {
		xAdjust += this.textDiv.xSize - halfBubble;
		this.bubbleImg.MoveTo(xAdjust - halfBubble, this.leftDiv.ySize - 4);
	}
	else {
		xAdjust += this.textDiv.xSize + this.rightSize;
		xAdjust >>= 1;
		this.bubbleImg.MoveTo(xAdjust - halfBubble, this.leftDiv.ySize - 4);
	}

	// + 5 is for the -4 from shadow and overlap plus one to start at requested yPos
	this.OrigMoveTo(inLeft - xAdjust, inTop - this.leftDiv.ySize - this.bubbleImg.ySize + 5);
}

//----------------
// VarHText()
//----------------

function VarHText(inLeft, inRight)
{
	this.contentImg = InitVisObj(this.children[2]);
	this.midSize = this.contentImg.xSize;

	this.textDiv = this.children[3];
	this.textDiv.visObj = VisObj;
	this.textDiv.visObj();
	this.midSize += this.textDiv.xSize;

	this.varHImg = VarHImg;
	this.varHImg(inLeft, this.midSize, inRight);

	var leftPos = this.leftSize;
	var topPos = (this.ySize - this.contentImg.ySize) >> 1;
	this.contentImg.MoveTo(leftPos, topPos);

	leftPos += this.contentImg.xSize;
	topPos = (this.ySize - this.textDiv.ySize) >> 1;
	topPos--;
	this.textDiv.MoveTo(leftPos, topPos);
}

function InitVarHText(obj, inLeft, inRight)
{
	if (obj) {
		obj.varHText = VarHText;
		obj.varHText(inLeft, inRight);
	}

	return obj;
}

//----------------
// BtnImg()
//----------------

function BtnImg(inLeft, inRight)
{
	this.varHText = VarHText;
	this.varHText(inLeft, inRight);

	this.emptyDiv = this.children[4];

	this.onImg = InitVarHImg(this.children[5], inLeft, this.midSize, inRight);

	leftPos = this.rightImg.xPos + this.rightImg.xSize;
	this.emptyDiv.style.clip = "rect(0," + leftPos + "," + this.rightImg.ySize + ",0)";

	this.hClick = doNothing;
	this.hMouseOver = doNothing;
	this.hMouseOut = doNothing;
}

function InitBtnImg(obj, inLeft, inRight)
{
	if (obj) {
		obj.btnImg = BtnImg;
		obj.btnImg(inLeft, inRight);
	}

	return obj;
}

function GetBtnImg(objName, inLeft, inRight)
{
	return InitBtnImg(GetPageElement(objName), inLeft, inRight);
}

//----------------
// HeaderBtnImg()
//----------------

var gHeaderDown = 0;
var gHeaderUp = 1;
var gHeaderNoArrow = 2;

function HeaderBtnImg()
{
	this.btnImg = BtnImg;
	this.btnImg(20, 10);

	this.contentImg2 = this.children[6];
	this.contentImg2.visObj = VisObj;
	this.contentImg2.visObj();
	this.contentImg2.MoveTo(this.contentImg.xPos, this.contentImg.yPos);

	this.SetDown = HeaderBtnImgDown;
	this.SetUp = HeaderBtnImgUp;
	this.SetNoArrow = HeaderBtnImgNoArrow;

	this.state = gHeaderDown;
}

function InitHeaderBtnImg(obj)
{
	if (obj) {
		obj.headerBtnImg = HeaderBtnImg;
		obj.headerBtnImg();
	}

	return obj;
}

function GetHeaderBtnImg(objName)
{
	return InitHeaderBtnImg(GetPageElement(objName));
}

function HeaderBtnImgDown()
{
	this.contentImg2.Hide();
	this.contentImg.Show();
	this.state = gHeaderDown;
}

function HeaderBtnImgUp()
{
	this.contentImg.Hide();
	this.contentImg2.Show();
	this.state = gHeaderUp;
}

function HeaderBtnImgNoArrow()
{
	this.contentImg.Hide();
	this.contentImg2.Hide();
	this.state = gHeaderNoArrow;
}

//----------------
// BtnObj()
//----------------

function BtnObj(inLeft, inRight, inTipStyle)
{
	this.visObj = VisObj;
	this.visObj();

	this.myBtn = InitBtnImg(this.children[0], inLeft, inRight);
	this.myBtn.myOwner = this;
	this.myBtn.hClick = BtnObjClick;
	this.myBtn.hMouseOver = BtnObjMouseOver;
	this.myBtn.hMouseOut = BtnObjMouseOut;
	this.myBtn.isOn = false;

	this.xSize = this.myBtn.xSize;
	this.ySize = this.myBtn.ySize;

	if (!inTipStyle) {
		inTipStyle = gTipMiddle;
	}
	this.myTip = InitToolTip(this.children[1], inTipStyle);
	this.myTip.myOwner = this;
	this.myTip.MoveTo(this.myBtn.xSize >> 1, -1);
}

function InitBtnObj(obj, inLeft, inRight, inTipStyle)
{
	if (obj) {
		obj.btnObj = BtnObj;
		obj.btnObj(inLeft, inRight, inTipStyle);
	}

	return obj;
}

function GetBtnObj(objName, inLeft, inRight, inTipStyle)
{
	return InitBtnObj(GetPageElement(objName, false), inLeft, inRight, inTipStyle);
}


function BtnObjMouseOver()
{
	gCmdTipMgr.Start(this.myOwner);
}

function BtnObjMouseOut()
{
	gCmdTipMgr.Stop(this.myOwner);
}

function BtnObjClick()
{
	gCmdTipMgr.Stop(this.myOwner);
	if (this.isOn) {
		this.isOn = false;
		this.onImg.Hide();
	}
	else {
		this.isOn = true;
		this.onImg.Show();
	}
}

//----------------
// HeaderBtnObj()
//----------------

function HeaderBtnObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.myBtn = InitHeaderBtnImg(this.children[0]);
	this.myBtn.myOwner = this;

	this.myTip = InitToolTip(this.children[1], 2);
	this.myTip.myOwner = this;
	this.myTip.MoveTo(this.myBtn.xSize >> 1, -1);
}

function InitHeaderBtnObj(obj)
{
	if (obj) {
		obj.headerBtnObj = HeaderBtnObj;
		obj.headerBtnObj();
	}

	return obj;
}

function GetHeaderBtnObj(objName)
{
	return InitHeaderBtnObj(GetPageElement(objName, false));
}


