//--------------------------------------
//	ReloadMain()
//--------------------------------------

function ReloadMain(inMsg)
{
	IBHdrHide();
	var qStr = "?frame=main";
	if (typeof(inMsg!="undefined")) qStr += "&msg=" + inMsg;
	var uiStr = gSysObj.GetState();
	if (uiStr != "") qStr += "&ui=" + uiStr;
	HideSelHdrBtns(true);
	var f = parent.headerFrame;
	if (f && f.gIsLoaded) {
		f.gRescanBtn.SetOff();
		f.gReloadBtn.SetOff();
		gBlink.StopOn(f.gReloadBtn.textDiv);
		f.gReloadBtn.style.visibility = "hidden";
		if (f.gCurHdrBtn) f.HdrBtnClick(f.gCurHdrBtn, null);
	}
	window.location.replace(gBaseUrl + qStr);
}

function ReloadDetails()
{
	var f = gDetForm;
	if (!f) return;

	f.hdrBtn.value = gHdrBtnNum;
	if (gSelObj) {
		if (typeof(gSelObj.segType)!="undefined") {
			f.smbeId.value = gSelObj.myOwner.smbeId;
			f.segIndex.value = gSelObj.myIndex+1;
		}
		else if (typeof(gSelObj.smbeId)!="undefined") f.smbeId.value = gSelObj.smbeId;
	}
	gDetForm = null;
	gOptForm = null;
	if (gDetDiv) {
		gDetDiv.style.visibility = "hidden";
		gDetDiv = null;
	}
	f.submit();
}

//--------------------------------------
// DataInit() & StatusUpdate()
//--------------------------------------

function DataInit(inDataForm)
{
	StatusUpdate(inDataForm);
}

function DetailCleanup()
{
	ReloadDetails();
	gAction = gPrevAction;
	gPrevAction = 0;
	gPollFreq = gStdPollFreq;
}

function StatusUpdate(inForm)
{
	var i;
	var iMax = (!inForm || typeof(inForm.elements)=="undefined") ? 0 : inForm.elements.length;
	var str;
	var obj;
	var isCC = false;
	for (i=0; i < iMax; i++) {
		str = inForm.elements[i].value.split(gSepChar);
		if (str.length) {
			if (str[0] == "status") {
				obj = GetPageElement(str[2], true);
				if (obj) {
					if (str[1]=="segobj") {
						obj.SetMainImg(str[3]);
						obj.SetISelImg(str[4]);
						obj.SetSelImg(str[5]);
						if (str.length >= 7) obj.SetTipContent(str[6]);
					}
					else if (str[1]=="mainicon") obj.myIcon.mainImg.src = str[3];
					else if (str[1]=="taskicon") obj.myIcon.taskImg.src = str[3];
					else if (str[1]=="statusicon") obj.myIcon.statusImg.src = str[3];
					else if (str[1]=="cstatusicon") obj.myIcon.cstatusImg.src = str[3];
					else if (str[1]=="ctaskicon") obj.myIcon.taskImg.src = str[3];
					else if (str[1]=="taskstop") obj.aTask = 0;
					else if (str[1]=="taskstart") obj.aTask = 1;
					else if (str[1]=="description") {
						if (typeof(obj.myIcon.myText)!="undefined") obj.myIcon.myText.innerHTML = str[3];
						// Note: Logical drive tool-tip initialization is not delayed because this update can occur before a mouseover
						if (typeof(obj.myIcon.myTip)!="undefined") {
							var myTip=obj.myIcon.myTip;
							if (myTip) {
								if (!myTip.SetContent) {
									myTip.toolTip=ToolTip;
									myTip.toolTip(0);
								}
								myTip.SetContent(str[3]);
							}
						}
						// If a non-dasd device...
						if (typeof(obj.devType)!="undefined") {
							if (obj.devType) {
								var altD = GetPageElement("fc" + obj.smbeId, true);
								if (altD) altD.innerHTML = str[3];
								altD = GetPageElement("rc" + obj.smbeId, true);
								if (altD) altD.innerHTML = str[3];
							}
						}
					}
				}
			}
			else if (str[0]=="configchg") {
				isCC = true;
			}
			else if (str[0]=="propfield") {
				var pf = frames.detFrame.GetPageElement(str[1], true);
				if (pf) pf.innerHTML = str[2];
			}
			else if (str[0]=="propvis") {
				var pf = frames.detFrame.GetPageElement(str[1], true);
				if (pf) pf.style.visibility = str[2];
			}
			else if (str[0]=="tempval") {
				var pf = frames.detFrame.GetPageElement(str[1], true);
				if (pf) {
					var num = parseInt(str[2]);
					if (frames.detFrame.gOptForm.degreeType[0].checked) num = frames.detFrame.F2C(num);
					pf.innerHTML = num;
				}
			}
			else if (str[0] == "request") {
				if (str[1] == "accepted") {
					gInfoBox.ReqProcessing();
				}
				else if (str[1] == "rejected") {
					if (str.length >= 3) gInfoBox.ReqRejected(str[2]);
					else gInfoBox.ReqRejected(null);
					if (gAction > gActModifyLog) DetailCleanup();
				}
				else if (str[1] == "partial") {
					if (str.length >= 3) gInfoBox.ReqPartial(str[2]);
					else gInfoBox.ReqPartial(null);
					if (gAction > gActModifyLog) DetailCleanup();
				}
				else if (str[1] == "success") {
					if (gAction <= gActRescan) {
						if (gAction == gActCreateLog) ReloadMain("createok");
						else if (gAction == gActDeleteLog) ReloadMain("deleteok");
						else if (gAction == gActSpare) ReloadMain("spareok");
						else if (gAction == gActModifyLog) ReloadMain("modifyok");
						else ReloadMain();
						return;
					}
					else {
						gInfoBox.eClose();
						DetailCleanup();
					}
				}
				else if (str[1] == "failed") {
					if (str.length >= 3) gInfoBox.ReqFailed(str[2]);
					else gInfoBox.ReqFailed(null);
					if (gAction > gActLogout) DetailCleanup();
				}
			}
		}
	}

	if (isCC) {
		if (confirm(gCCMsg)) {
			ReloadMain();
		}
		else {
			var f = parent.headerFrame;
			if (f && f.gReloadBtn) f.gReloadBtn.style.visibility = "inherit";
			gBlink.Start(f.gReloadBtn.textDiv);
		}
	}

	var ct = new Date();
	gDFLastTime = ct.getTime();
	ct = null;
}


//--------------------------------------
//	Blink Functions
//--------------------------------------

function BlinkStart(obj)
{
	var i;
	var f = false;
	var iMax = this.numItems;
	for (i=0; i<iMax; i++) {
		if (this[i] == obj) { f = true; break; }
	}
	if (!f) {
		obj.style.visibility = "inherit";
		this[this.numItems++] = obj;
	}
}

function BlinkStopOn(obj)
{
	this.Remove(obj);
	obj.style.visibility = "inherit";
}

function BlinkStopOff(obj)
{
	this.Remove(obj);
	obj.style.visibility = "hidden";
}


//--------------------------------------
//	CheckWiz()
//--------------------------------------

function CheckWiz()
{
	if (!gWizDiv) {
		gWizDiv = GetWizDivObj("wizDiv");
		gWizObj = GetWizObj("wiz", gWizDiv);
	}

	var curY = gWizObj.clipY;
	var tgtY = gWizObj.tgtY;
	var extraY;
	var deltaY;
	if (curY < tgtY) {
		extraY = 0;
		deltaY = gWizDeltaY;
		if ((curY + deltaY) > tgtY) {
			deltaY = tgtY - curY;
			extraY = 8;
		}
		curY += deltaY;
		gWizObj.clipY = curY;
		gWizObj.curCtlr.AdjustForWiz(deltaY + extraY);
		gWizObj.style.clip = "rect(0, " + gWizObj.largeX + "," +  curY + ", 0)";
	}
	else if (curY > tgtY) {
		extraY = 0;
		deltaY = -gWizDeltaY;
		var ctlr = gWizObj.curCtlr;
		if ((curY + deltaY) < tgtY) {
			deltaY = tgtY - curY;
			extraY = -8;
		}
		curY += deltaY;
		gWizObj.clipY = curY;
		gWizObj.style.clip = "rect(0, " + gWizObj.largeX + "," +  curY + ", 0)";
		ctlr.AdjustForWiz(deltaY + extraY);
		if (curY <= tgtY) {
			gWizObj.eClosed();
		}
	}
	else {
		var curX = gWizObj.clipX;
		var tgtX = gWizObj.tgtX;
		var bk = gWizObj.myBkgd;
		var deltaX;
		if (curX < tgtX) {
			deltaX = gWizDeltaX;
			if ((curX + deltaX) > tgtX) {
				// Advanced area is open
				deltaX = tgtX - curX;
			}
			curX += deltaX;
			gWizObj.clipX = curX;
			bk.style.width = bk.offsetWidth + deltaX + "px";
			//gWizObj.clipDiv.style.clip = "rect(0, " + curX + "," +  gWizObj.tgtY + ", 0)";
			gWizObj.clipDiv.style.clip = "rect(0, " + curX + "," +  500 + ", 0)";
		}
		else if (curX > tgtX) {
			deltaX = -gWizDeltaX;
			if ((curX + deltaX) < tgtX) {
				// Advanced area is hidden
				deltaX = tgtX - curX;
			}
			curX += deltaX;
			gWizObj.clipX = curX;
			bk.style.width = bk.offsetWidth + deltaX + "px";
			//gWizObj.clipDiv.style.clip = "rect(0, " + curX + "," +  gWizObj.tgtY + ", 0)";
			gWizObj.clipDiv.style.clip = "rect(0, " + curX + "," +  500 + ", 0)";
		}
	}
}


//--------------------------------------
//	BkgdTask()
//--------------------------------------


var gBkgdTaskHandle = null;
var gBkgdFreq = 62; // about 1/16 sec
var gBC = 0;
var gDFC = 0;

var gBlink = new Array();
gBlink.Start = BlinkStart;
gBlink.StopOn = BlinkStopOn;
gBlink.StopOff = BlinkStopOff;
var gBlinkCntr = 0;

// Position the detail window
var gDetTop = 0;
var gLastTop = 0;

function BkgdTask()
{
	if (gBC >= 4) {
		var sy;
		if (gIsNS6) sy = window.pageYOffset;
		else {
		    sy = document.body.scrollTop;
			if (gDetTop != sy) { // ns6 supports fixed position so this reposition of the detail window isn't required
				if (gLastTop == sy) {
					gDetFrame.style.top = sy - 6 + "px";
					gDetTop = sy;
				}
				gLastTop = sy;
			}
		}
		if (gInfoBox.state) {
			sy -= 40;
			if (gInfoBox.offsetTop != sy) gInfoBox.style.top = sy + "px";
		}

		if (gInfoBox.reqStartTime) gInfoBox.ReqUpdateTime();

		// Device tips
		if (gDevTipMgr.curObj) gDevTipMgr.Check();

		// Command tips
		if (gCmdTipMgr.curObj) gCmdTipMgr.Check();

		// Yellow arrow hints on physical device rows
		if (gRowHintsShown) {
			gRowHintsShown = false;
			var pm;
			var c = gSysObj.myCtlrs;
			if (c) {
				for (i=0; i<c.length; i++) {
					pm = c[i].phyMgr;
					if (pm.rowHintCntr < 20) {
						pm.rowHintCntr++;
						if (pm.rowHintCntr >= 20) pm.RowHintsOff();
						else gRowHintsShown = true;
					}
				}
			}
		}

		if (gBlink.numItems) {
			var i;
			var iMax = gBlink.numItems;
			if (gBlinkCntr == 1) for (i=0; i<iMax; i++) gBlink[i].style.visibility = "hidden";
			else if (gBlinkCntr == 2) for (i=0; i<iMax; i++) gBlink[i].style.visibility = "inherit";
			else if (gBlinkCntr >= 3) gBlinkCntr = 0;

			gBlinkCntr++;
		}
		gBC = 0;

		// Data frame status update check (about once a second)
		if (gDFLastTime) {
			if (gSubmitReq) {
				gDFLastTime = 0;
				gPollFreq = gActionPollFreq;
				if (gAction <= gActModifyLog) { gWizObj.curWiz.myForm.submit(); }
				else { gOptForm.submit(); }
				gSubmitReq = 0;
			}
			else if (gDFC>=4) {
				gDFC = 0;
				var ct = new Date();
				if ((ct.getTime()-gDFLastTime)>=gPollFreq) {
					gDFLastTime = 0;
					gDataFrame.location.replace(gBaseUrl + "?frame=data");
				}
				delete ct;
			}
		}
		gDFC++;

	}

	CheckWiz();

	gBC++;
}


//--------------------------------------
//	TestUnload()
//--------------------------------------

/*
function TestUnload()
{
	clearInterval(gBkgdTaskHandle);

	var o;

	gBlink = null;

	gWizObj.myCreateWiz.curSegs = null;

	o = gWizObj.myDeleteWiz;
	o.logList = null;
	o.spareList = null;

	o = gWizObj.mySpareWiz;
	o.assignList = null;
	o.newList = null;
	o.delList = null;

	o = gWizObj.myModifyWiz;
	o.newSegs = null;
	o.delSegs = null;
	o.origSegs = null;

	var ctlrs = gSysObj.myCtlrs;
	var ctlr = null;
	var c;
	var c2;
	var chan;
	var pm;
	for (c=0; c<ctlrs.length; c++) {
		ctlr = ctlrs[c];
		CleanDevList(ctlr.logMgr.topMgr.myDevs);
		ctlr.logMgr.topMgr.myDevs = null;
		CleanDevList(ctlr.logMgr.secMgr.myDevs);
		ctlr.logMgr.secMgr.myDevs = null;
		pm = ctlr.phyMgr;
		for (c2=0; c2<pm.myChans.length; c2++) {
			pm.myChans[c2].myDevs = null;
		}
		for (c2=0; c2<pm.myRows.length; c2++) {
			CleanDevList(pm.myRows[c2].myDevs);
		}
		ctlr.phyMgr.myRows = null;
	}

}

function CleanDevList(inDevs)
{
	var i;
	var j;

	for(i=0; i<inDevs.length; i++) {
		dev = inDevs[i];
		for (j=0; j<dev.mySegs.length; j++) {
			dev.mySegs[j].protA = null;
		}
		dev.protA = null;
		dev.assignA = null;
		dev.compA = null;
		dev.rselSegs = null;
	}
}
*/

function DebugRescan()
{
	var f = parent.headerFrame;
	if (f && f.gIsLoaded) f.gRescanBtn.eClick();
	else setTimeout("DebugRescan()", 250);
}

function RegNow()
{
	gInfoBox.CloseRegBox();
	var w = window.open(gRegUrl, "adptRegWin");
	w.focus();

	if (gOptForm) {
		gOptForm.requestType.value = "updateReg";
		gPrevAction = gAction;
		gAction = gActRegister;
		gInfoBox.ReqSubmitting(gInfoBox.regMsgs, true);
		gSubmitReq = 1;
	}
}

function RegLater()
{
	gInfoBox.CloseRegBox();
}


//--------------------------------------
//	Init()
//--------------------------------------

var gBaseUrl = null;

var gDataFrame = null;
var gActionPollFreq = 5000;
var gPollFreq = gStdPollFreq;
var gDFLastTime = 0;
var gSubmitReq = 0;
var gCWSubmitReq = 1;
var gDWSubmitReq = 2;
var gSWSubmitReq = 3;
var gMWSubmitReq = 4;

var gIsLoaded = false;

var gWizDiv = null;
var gWizObj = null;

var gDetFrame = null;
var gDetForm = null;
var gDetDiv = null;
var gOptForm = null;

function Init()
{
	//var dt;
	//var t2;
	//var t1 = new Date();

	//document.body.onunload = TestUnload;

	InitInfoBox();

	var detT2;
	var detT1;

	gDetFrame = GetPageElement("detFrame");
	gDetFrame.style.visibility = "hidden";

	InitSysObj();

	//detT1 = new Date();
	//gWizDiv = GetWizDivObj("wizDiv");
	//gWizObj = GetWizObj("wiz", gWizDiv);
	//detT2 = new Date();
	//alert("Wizard initialization time: " + (detT2.getTime() - detT1.getTime()) + " ms");

	gDataFrame = parent.dataFrame;

	var ct = new Date();
	gDFLastTime = ct.getTime();
	ct = null;
	gBkgdTaskHandle = setInterval("BkgdTask()", gBkgdFreq);

	gCmdTipMgr.delay = optCmdTipDelay;
	gDevTipMgr.delay = optDevTipDelay;

	var obj = GetPageElement("initBox");
	obj.style.left = "-1000px";
	obj.style.visibility = "hidden";

	var obj = GetPageElement("sys0");
	obj.style.left = "5px";
	obj.style.top = "10px";

	gInfoBox.ShowRegBox();

	gIsLoaded = true;

	//setTimeout("DebugRescan()", 250);

	//t2 = new Date();
	//dt = t2.getTime() - t1.getTime();
	//alert("Javascript initialization time: " + dt + " ms");
}

