//--------------
// Miscellaneous
//--------------

var gSepChar = "^";

var gHintsOn = true;

var gActNone = 0;
var gActCreateLog = 1;

var gAction = gActNone;

var capUnits = ["bytes", "KB", "MB", "GB", "TB", "PB"];

function GetCapStr(inBlks)
{ 
	var str = "";

	if (!inBlks) {
		str = "0.00 bytes";
	}
	else if (inBlks == 1) {
		str = "512 bytes";
	}
	else {
		var unitIndex = 0;
		var tSize = parseFloat(inBlks) * 512;
		var tStr = "";

		while(tSize >= 1024) {
			unitIndex++;
			tSize /= 1024;
		} 

		if (tSize < 10) {	
			tSize = Math.round(tSize * 100);
			tStr = tSize.toString();
			str = tStr.charAt(0) + "." + tStr.charAt(1) + tStr.charAt(2);
		}
		else if (tSize < 100) {	
			tSize = Math.round(tSize * 10);
			tStr = tSize.toString();
			str = tStr.charAt(0) + tStr.charAt(1) + "." + tStr.charAt(2);
		}
		else {
			str = Math.round(tSize);
			if (str == 1024) {
				str = "1.00";
				unitIndex++;
			}
		}
		str += " " + capUnits[unitIndex];
	}
		
	return str;
	
}

function ToggleSecLevel(inObj)
{
	var i;
	var cList = gSysObj.myCtlrs;
	var iMax = cList.numItems;
	if (inObj.checked) {
		gShowSec = true;
		for (i=0; i < iMax; i++) {
			cList[i].logMgr.ShowSec();
		}
	}
	else {
		gShowSec = false;
		for (i=0; i < iMax; i++) {
			cList[i].logMgr.HideSec();
		}
	}

	return true;
}

//----------
// IconObj()
//----------

var gSelIcon = null;

var gHiOff = 0;
var gHiOn = 1;
var gHiDeep = 2;
var gHiMode = gHiOn;

var gIconYSize = 20;

function IconObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.mainImg = InitImgObj(this.children[0]);
	this.iselBkgd = InitVarHImg(this.children[1]);
	this.hiBkgd = InitVarHImg(this.children[2]);
	this.selBkgd = InitVarHImg(this.children[3]);
	this.statusImg = InitImgObj(this.children[4]);
	this.textDiv = InitDivObj(this.children[5]);

	leftPos = this.mainImg.xSize;
	topPos = (this.mainImg.ySize - this.textDiv.ySize) >> 1;
	this.textDiv.MoveTo(leftPos, topPos);

	this.hMouseOver = IconMouseOver;
	this.hMouseOut = IconMouseOut;
	this.hClick = IconClick;

	this.HideText = IconHideText;
	this.ShowText = IconShowText;

	this.ySize = this.mainImg.ySize;
	this.xSize = this.mainImg.xSize + this.textDiv.xSize;

	this.eRollDown = hIconRollDown;
	this.eRollUp = hIconRollUp;

	this.ShowText();
}

function InitIconObj(obj)
{
	if (obj) {
		obj.iconObj = IconObj;
		obj.iconObj();
	}

	return obj;
}

function IconClick()
{
	if (gSelIcon) {
		gSelIcon.selBkgd.Hide();
		if (gSelIcon.myOwner) {
			if (gSelIcon.myOwner.ClickOff) {
				gSelIcon.myOwner.ClickOff();
			}
		}
	}
	if (gSelIcon != this) {
		gSelIcon = this;
		gSelIcon.selBkgd.Show();
		if (gSelIcon.myOwner) {
			if (gSelIcon.myOwner.ClickOn) {
				gSelIcon.myOwner.ClickOn();
			}
		}
	}
	else {
		gSelIcon = null;
	}
	
	return false;
}

function IconMouseOver()
{
	if (gHiMode) {
		this.hiBkgd.Show();
		var owner = this.myOwner;
		if ((gHiMode == gHiDeep) && (gSelIcon != this) && owner.SegsHiOn) {
			owner.SegsHiOn();
			owner.CompsHiOn();
			if (owner.protList) {
				var i;
				var iMax = owner.protList.numItems;
				for (i=0; i < iMax; i++) {
					owner.protList[i].myIcon.hiBkgd.Show();
				}
			}
		}
	}

	return true;
}

function IconMouseOut()
{

	if (gHiMode) {
		this.hiBkgd.Hide();
		var owner = this.myOwner;
		if ((gHiMode == gHiDeep) && (gSelIcon != this) && owner.SegsHiOn) {
			owner.SegsHiOff();
			owner.CompsHiOff();
			if (owner.protList) {
				var i;
				var iMax = owner.protList.numItems;
				for (i=0; i < iMax; i++) {
					owner.protList[i].myIcon.hiBkgd.Hide();
				}
			}
		}
	}

	return true;
}

function hIconRollDown()
{
	if (this.phyMgr) {
		if (this.phyMgr.phyMode == gPhyFCap) {
			this.myOwner.fullSegs.Show();
		}
		else if (this.phyMgr.phyMode == gPhyRCap) {
			this.myOwner.relSegs.Show();
		}
		else {
			this.ShowText();
		}
	}
	else {
		this.ShowText();
	}
}

function hIconRollUp()
{
	if (this.phyMgr) {
		if (this.phyMgr.phyMode == gPhyFCap) {
			this.myOwner.fullSegs.Hide();
		}
		else if (this.phyMgr.phyMode == gPhyRCap) {
			this.myOwner.relSegs.Hide();
		}
		else {
			this.HideText();
		}
	}
	else {
		this.HideText();
	}
}

function IconHideText()
{
	this.xSize = this.mainImg.xSize;
	this.textDiv.Hide();
	this.iselBkgd.SetSize(this.xSize);
	this.hiBkgd.SetSize(this.xSize);
	this.selBkgd.SetSize(this.xSize);
}

function IconShowText()
{
	this.xSize = this.mainImg.xSize + this.textDiv.xSize;
	this.textDiv.Show();
	this.iselBkgd.SetSize(this.xSize);
	this.hiBkgd.SetSize(this.xSize);
	this.selBkgd.SetSize(this.xSize);
}

//--------------
// DevIconObj()
//--------------

function DevIconObj()
{
	this.iconObj = IconObj;
	this.iconObj();

	this.myTip = InitToolTip(this.children[6]);
	var leftPos = this.mainImg.xPos + (this.mainImg.xSize >> 1);
	var topPos = 0;
	if (this.myTip) {
		this.myTip.MoveTo(leftPos, topPos);
	}

	this.expImg = InitVisObj(this.children[7]);
	this.rselImg = InitVisObj(this.children[8]);

	this.baseClick = this.hClick;
	this.baseMouseOver = this.hMouseOver;
	this.baseMouseOut = this.hMouseOut;

	this.hClick = DevIconClick;
	this.hMouseOver = DevIconMouseOver;
	this.hMouseOut = DevIconMouseOut;
}


function InitDevIconObj(obj)
{
	if (obj) {
		obj.devIconObj = DevIconObj;
		obj.devIconObj();
	}

	return obj;
}

function DevIconClick()
{
	gDevTipMgr.Stop(this);

	if (gAction) {
		if (gWizObj.curWiz) {
			gWizObj.curWiz.eDevClick(this.myOwner);
		}
	}

	this.baseClick();

	return false;
}

function DevIconMouseOver()
{
	this.baseMouseOver();

	if (!this.textDiv.isShown) {
		gDevTipMgr.Start(this);
	}

	return true;
}

function DevIconMouseOut()
{
	this.baseMouseOut();

	gDevTipMgr.Stop(this);

	return true;
}


//--------------
// LogDevIconObj()
//--------------

function LogDevIconObj()
{
	this.devIconObj = DevIconObj;
	this.devIconObj();

	var ci = 9;
	this.logTypeImg = InitVisObj(this.children[ci++]);
	this.protImg = InitVisObj(this.children[ci++]);
	this.naImg = InitVisObj(this.children[ci++]);
}


function InitLogDevIconObj(obj)
{
	if (obj) {
		obj.logDevIconObj = LogDevIconObj;
		obj.logDevIconObj();
	}

	return obj;
}

//--------------
// PhyDevIconObj()
//--------------

function PhyDevIconObj()
{
	this.devIconObj = DevIconObj;
	this.devIconObj();

	var ci = 9;
	this.hsImg = InitVisObj(this.children[ci++]);
	this.naImg = InitVisObj(this.children[ci++]);
}


function InitPhyDevIconObj(obj)
{
	if (obj) {
		obj.phyDevIconObj = PhyDevIconObj;
		obj.phyDevIconObj();
	}

	return obj;
}

//-------------
// HeaderObj()
//-------------

function HeaderObj()
{
	this.visObj = VisObj;
	this.visObj();

	var miscDiv = this.children[0];
	this.myBkgd = InitImgObj(miscDiv.children[0]);
	this.myLogo = InitImgObj(miscDiv.children[1]);
	this.mySysIcon = InitImgObj(miscDiv.children[2]);
	this.mySysName = InitDivObj(miscDiv.children[3]);
	this.myLoadingDiv = InitDivObj(miscDiv.children[4]);

	this.ySize = 47;
	this.xSize = this.myBkgd.xSize;

	var leftPos = 0;
	var topPos = 0;

	this.myRescanBtn = InitBtnObj(miscDiv.children[5], 6, 6, gTipRight);
	leftPos = this.mySysName.xPos;
	topPos = this.myBkgd.yPos + this.myBkgd.ySize - this.myRescanBtn.myBtn.ySize;
	this.myRescanBtn.MoveTo(leftPos, topPos);

	this.myLogoutBtn = InitBtnObj(miscDiv.children[6], 6, 6, gTipRight);
	leftPos += this.myRescanBtn.myBtn.xSize + 12;
	this.myLogoutBtn.MoveTo(leftPos, topPos);

}

function GetHeaderObj(objName) {
	var obj = GetPageElement(objName);
	if (obj) {
		obj.headerObj = HeaderObj;
		obj.headerObj();
	}

	return obj;
}

//---------
// WizDivObj()
//---------

function WizDivObj()
{
	this.visObj = VisObj;
	this.visObj();

	var hintList = this.children[0].children;

	this.r50Active = InitTextBoxObj(hintList[0], 8, 9, 12);
	this.r0Hint = InitTextBoxObj(hintList[1], 8, 9, 12);
	this.r1Hint = InitTextBoxObj(hintList[2], 8, 9, 12);
	this.r5Hint = InitTextBoxObj(hintList[3], 8, 9, 12);
	this.r10Hint = InitTextBoxObj(hintList[4], 8, 9, 12);
	this.r50Hint = InitTextBoxObj(hintList[5], 8, 9, 12);
	this.svHint = InitTextBoxObj(hintList[6], 8, 9, 12);

	this.failReason = InitTextBoxObj(GetPageElement("createFailReason"), 8, 9, 12);
	this.failDetails = GetDivObj("createFailDetails");
}

function GetWizDivObj(objName)
{
	var obj = GetPageElement(objName, false);
	if (obj) {
		obj.wizDivObj = WizDivObj;
		obj.wizDivObj();
	}

	return obj;
}

//---------
// WizObj()
//---------

var gWizObj = null;
var gWizDiv = null;
var gWizDeltaY = 25;
var gWizDeltaX = 35;

function WizObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	this.myBkgd = InitVarVImg(this.children[0], 2, 0, 2);

	this.clipX = 383;
	this.tgtX = 383;
	this.clipY = 0;
	this.tgtY = 0;

	this.curCtlr = null;
	this.curWiz = null;

	this.myAdvBtn = InitAdvBtnObj(this.children[1], this);

	this.myBtns = InitVisObj(this.children[2]);
	var btnList = this.myBtns.children;
	this.myPrevBtn = InitBtnImg(btnList[0], 8, 8);
	this.myCancelBtn = InitBtnImg(btnList[1], 8, 8);
	this.myNextBtn = InitBtnImg(btnList[2], 8, 8);
	this.myFinishBtn = InitBtnImg(btnList[3], 8, 8);
	this.myReloadBtn = InitBtnImg(btnList[4], 8, 8);
	this.myRestoreBtn = InitBtnImg(btnList[5], 8, 8);
	this.myCloseBtn = InitBtnImg(btnList[6], 8, 8);
	this.myBtns.ySize = this.myPrevBtn.ySize;

	var leftPos = this.myPrevBtn.xSize + 20;
	this.myCancelBtn.MoveTo(leftPos, 0);
	this.myReloadBtn.MoveTo(leftPos, 0);
	this.myRestoreBtn.MoveTo(leftPos, 0);
	this.myCloseBtn.MoveTo(leftPos, 0);
	leftPos += this.myCancelBtn.xSize + 20;
	this.myNextBtn.MoveTo(leftPos, 0);
	this.myFinishBtn.MoveTo(leftPos, 0);

	this.myCreateWiz = GetCreateWizObj(this);

	this.OpenWiz = WizObjOpenWiz;
	this.CloseWiz = WizObjCloseWiz;
	this.eClosed = WizObjHClosed;
}

function GetWizObj(objName, inOwner)
{
	var obj = GetPageElement(objName, false);
	if (obj) {
		obj.wizObj = WizObj;
		obj.wizObj(inOwner);
	}

	return obj;
}

function WizObjOpenWiz(ctlr, wiz)
{
	this.curCtlr = ctlr;
	this.curWiz = wiz;
	gAction = wiz.myAction;

	if (ctlr.wizY == 0) {
		ctlr.InitWizPos();
	}
	gWizDiv.MoveTo(ctlr.wizX, ctlr.wizY);
	wiz.Show(ctlr);

	var ySize = wiz.ySize;
	var obj = this.myBkgd;
	obj.SetMidSize(ySize);
	ySize += obj.topSize + obj.btmSize;
	this.myAdvBtn.SetSize(ySize);
	topPos = ySize - obj.btmSize - 4 - this.myBtns.ySize;
	this.myBtns.MoveTo(wiz.btnX, topPos);
	this.tgtY = ySize;
}

function WizObjCloseWiz()
{
	if (this.curWiz) {
		this.curWiz.eCancel();
	}
}

function WizObjHClosed()
{
	gWizDiv.MoveTo(-1000, -1000);
	this.curWiz.Hide();
	this.curCtlr = null;
	this.curWiz = null;
	gAction = gActNone;
}


//-------------
// AdvBtnObj()
//-------------

function AdvBtnObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	this.myBkgd = InitVarVImg(this.children[0], 2, 0, 2);
	this.myOpenText = InitVisObj(this.children[1]);
	this.myCloseText = InitVisObj(this.children[2]);
	this.myTopDiv = InitVisObj(this.children[3]);
	this.myTopDiv.myOwner = this;

	this.xSize = this.myBkgd.xSize;
	this.ySize = this.myBkgd.ySize;

	this.isOpen = false;

	this.eClick = hAdvBtnClick;
	this.SetSize = AdvBtnSetSize;
}

function InitAdvBtnObj(obj, inOwner)
{
	if (obj) {
		obj.advBtnObj = AdvBtnObj;
		obj.advBtnObj(inOwner);
	}

	return obj;
}

function hAdvBtnClick()
{
	if (this.isOpen) {
		this.isOpen = false;
		this.myOwner.tgtX = 383;
	}
	else {
		this.isOpen = true;
		this.myOwner.tgtX = 745; //723;
	}
}

function AdvBtnSetSize(inSize)
{
	this.myBkgd.SetMidSize(inSize - 4);
	this.myTopDiv.style.clip = "rect(0," + this.xSize + "," + inSize + ",0)";
	var topPos = inSize - this.myOpenText.ySize;
	topPos >>= 1;
	this.myOpenText.MoveTo(0, topPos);
	this.myCloseText.MoveTo(0, topPos);
	this.ySize = inSize;
}

//----------------
// CreateWizObj()
//----------------

var gStrLimited = "limited";
var gStrDrivesSel = "drives selected";

var gMinRaidBlks = 4096;

var gCASubmitReq = false;

function CreateWizObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;
	this.curStep = 0;
	this.raidType = null;
	this.myAction = gActCreateLog;
	this.curSegs = new Array();
	this.capBlks = 0;
	this.blkLimit = 0;
	this.sumSegs = 0;
	this.minSeg = 0;
	this.prevRTindex = 100;
	this.numR5s = 0;

	this.myTitle = InitVisObj(this.children[0]);
	this.myTitle.MoveTo(6, 4);
	this.myStep1 = GetCreateStep1(this);
	this.myStep2 = GetCreateStep2(this);
	this.myStep3 = GetCreateStep3(this);
	this.myFinish = GetCreateFinish(this);

	this.myStatus = InitCreateStatusObj(this.children[1]);
	var leftPos = this.myTitle.xPos + this.myTitle.xSize;
	this.myStatus.MoveTo(leftPos, 2);
	this.capDiv = this.myStatus.textDiv;

	this.myForm = document.forms.createForm;

	var maxY = this.myStep1.ySize;
	if (this.myStep2.ySize > maxY) {
		maxY = this.myStep1.ySize;
	}

	this.btnX = this.myStep1.stepText.xPos;
	this.ySize = maxY + 4 + inOwner.myBtns.ySize + 4;

	this.ePrev = CreateWizPrev;
	this.eCancel = CreateWizCancel;
	this.eNext = CreateWizNext;
	this.eFinish = CreateWizFinish;
	this.eReload = CreateWizReload;
	this.eRestore = CreateWizRestore;
	this.eClose = CreateWizClose;

	this.eDevClick = CreateWizDevClick;
	this.eSegClick = CreateWizSegClick;

	this.SelRType = CreateSelRType;
	this.R5TypeClick = CWR5TypeClick;
	this.CapLimitClick = CWCapLimitClick;
	this.ToggleReadCache = CreateWizTogRdCache;

	this.VisShow = this.Show;
	this.Show = CreateWizShow;
	this.AddSeg = CreateWizAddSeg;
	this.RemSeg = CreateWizRemSeg;
	this.RecompSegs = CWRecompSegs;
	this.SetCap = CWSetCap;
	this.DeselAll = CWDeselAll;
	this.DeselAllBut1 = CWDeselAllBut1;
	this.DeselDups = CWDeselDups;
	this.DeselAllBlink = CWDeselAllBlink;
	this.BlinkLast = CWBlinkLast;
	this.Cleanup = CWCleanup;

}

function GetCreateWizObj(inOwner)
{
	var obj = GetPageElement("createWiz");
	if (obj) {
		obj.createWizObj = CreateWizObj;
		obj.createWizObj(inOwner);
	}

	return obj;
}

function CWCapLimitClick(inIndex, checkIt)
{
	if (checkIt) {
		this.myForm.captype[inIndex].checked = true;
	}
	if (inIndex == 0) {
		this.blkLimit = 0;
	}
	else {
		var t= 0;
		switch (parseInt(this.myForm.caplimitunits.value)) {
			case 10:
				t = 2048;
				break;
			case 20:
				t = 2097152;
				break;
			case 30:
				t = 2.1474836e9;
				break;
			case 40:
				t = 2.1990233e12;
				break;
		}
		var lim = parseFloat(this.myForm.caplimit.value);
		if (lim != lim) { // isNan()
			this.blkLimit = 0;
		}
		else {
			this.blkLimit = lim * t;
		}
	}

	this.SetCap();
}

function CWR5TypeClick(inIndex, checkIt)
{
	if (checkIt) {
		this.myForm.r5type[inIndex].checked = true;
	}
	this.SelRType(2, false);
}

function CreateSelRType(inIndex, checkIt)
{
	if (checkIt) {
		this.myForm.rtype[inIndex].checked = true;
	}
	var obj = this.myStatus;

	obj.raid0.Hide();
	obj.raid1.Hide();
	obj.raid10.Hide();
	obj.raid5.Hide();
	obj.raid50.Hide();
	obj.vol.Hide();

	if (inIndex == 5) {
		if (this.prevRTindex != 5) {
			this.DeselAll(); // Switch from non-RV to RV
		}
	}
	else if (this.prevRTindex == 5) {
		this.DeselAll(); // Switch from RV to non-RV
	}
	else if ((inIndex != 4) && (this.prevRTindex == 4)) {
		this.DeselDups(); // Switch from SPV to other
	}

	if (this.prevRTindex <= 5) {
		this.myStep2.rtInfo[this.prevRTindex].Hide();
		this.myStep2.clickInfo[this.prevRTindex].Hide();
	}
	this.myStep2.rtInfo[inIndex].Show();
	this.myStep2.clickInfo[inIndex].Show();

	if (inIndex != 2) {
		this.myStep2.r5Type.Hide();
	}
	else {
		this.myStep2.r5Type.Show();
	}

	if (inIndex < 3) {
		this.myStep1.ssNA.Hide();
		this.myStep1.ssChoice.Show();
	}
	else {
		this.myStep1.ssChoice.Hide();
		this.myStep1.ssNA.Show();
	}

	var s3 = this.myStep3;

	switch (inIndex) {
		case 0:
			obj.raid0.Show();
			this.raidType = "r0";
			this.minNumSegs = 2;
			s3.adv1.Hide();
			s3.adv2.Show();
			break;
		case 1:
			if (this.curSegs.numItems < 4) {
				obj.raid1.Show();
				this.raidType = "r1";
				this.minNumSegs = 2;
			}
			else {
				obj.raid10.Show();
				this.raidType = "r10";
				this.minNumSegs = 4;
			}
			s3.adv2.Hide();
			s3.adv1.Show();
			s3.buildDiv.style.display = "block";
			break;
		case 2:
			if (this.myForm.r5type[1].checked) {
				obj.raid50.Show();
				this.raidType = "r50";
				this.numR5s = parseInt(this.myForm.numr5.value);
				if (!this.numR5s) {
					this.numR5s = 2;
				}
				this.minNumSegs = this.numR5s * 3;
			}
			else {
				obj.raid5.Show();
				this.raidType = "r5";
				this.minNumSegs = 3;
			}
			s3.adv2.Hide();
			s3.adv1.Show();
			s3.buildDiv.style.display = "block";
			break;
		case 3:
			obj.vol.Show();
			this.raidType = "sv";
			this.minNumSegs = 1;
			this.DeselAllBut1();
			s3.adv1.Hide();
			s3.adv2.Show();
			break;
		case 4:
			obj.vol.Show();
			this.raidType = "spv";
			this.minNumSegs = 2;
			s3.adv1.Hide();
			s3.adv2.Show();
			break;
		case 5:
			obj.vol.Show();
			this.raidType = "rv";
			this.minNumSegs = 2;
			s3.adv2.Hide();
			s3.adv1.Show();
			s3.buildDiv.style.display = "none";
			break;
	}

	if ((this.raidType == "r5") && (this.curSegs.numItems >= 6)) {
		gWizDiv.r50Active.Show();
	}
	else {
		gWizDiv.r50Active.Hide();
	}

	this.prevRTindex = inIndex;

	this.SetCap();
}

function CWBlinkLast(inNum)
{
	if (inNum) {
		var iMax = this.curSegs.numItems;
		if (inNum > iMax) {
			inNum = iMax;
		}
		var numNoBlink = iMax - inNum;
		var i;
		var cs = this.curSegs;
		for (i=0; i < iMax; i++) {
			if (i < numNoBlink) {
				cs[i].StopBlink();
			}
			else {
				cs[i].Blink();
			}
		}
	}
}

function CreateWizTogRdCache()
{
	var obj = this.myForm.rdcache
	if (obj.checked) {
		obj.checked = false;
	}
	else {
		obj.checked = true;
	}
}

function CreateWizNext()
{
	if (this.curStep == 1) {
		if (!this.raidType) {
			alert("*** TEMP ALERT ***\nYou must select a RAID type.");
		}
		else {
			this.myStep1.Hide();
			this.myStep2.Show();
		}
	}
	else if (this.curStep == 2) {
		if (this.curSegs.numItems < this.minNumSegs) {
			alert("*** TEMP ALERT ***\nYou must select at least " + this.minNumSegs + " drive(s)");
		}
		else {
			this.DeselAllBlink();
			this.SetCap();
			this.myStep2.Hide();
			this.myStep3.Show();
			gWizDiv.r50Active.Hide();
		}
	}
	else {
		alert("*** TEMP ALERT ***\nInvalid Next Step");
	}
}

function CreateWizPrev()
{
	if (this.curStep == 2) {
		this.myStep2.Hide();
		this.myStep1.Show();
	}
	else if (this.curStep == 3) {
		this.myStep3.Hide();
		this.myStep2.Show();
		if ((this.raidType == "r5") && (this.curSegs.numItems >= 6)) {
			gWizDiv.r50Active.Show();
		}
	}
	else {
		alert("*** TEMP ALERT ***\nInvalid Previous Step");
	}
}

function CreateWizCancel()
{
	var bQuit = false;
	if (this.curStep == 100) {
		alert("***TEMP ALERT***\nYou cannot close Create Array when an array is being created in hardware.");
	}
	else {
		bQuit = confirm("Click 'OK' if you are sure you want to leave the array creation wizard");
		if (bQuit) {
			gWizObj.curCtlr.logMgr.myCreateBtn.myBtn.onImg.Hide();
			gWizObj.tgtY = 0;
			gWizObj.curWiz.DeselAll();
			this.Cleanup();
		}
	}

	return bQuit;
}

function CWCleanup()
{
	gWizDiv.r50Active.Hide();
	this.myStep1.ssChoice.Show();
	this.myStep1.ssNA.Hide();
	var i;
	var iMax = this.myStep2.rtInfo.length;
	for (i=0; i<iMax; i++) {
		this.myStep2.rtInfo[i].Hide();
		this.myStep2.clickInfo[i].Hide();
	}
	this.myStep3.adv1.Hide();
	this.myStep3.adv2.Hide();
}

function CreateWizClose()
{
	gWizObj.myCloseBtn.Hide();
	this.myFinish.subNo.Hide();
	gWizDiv.failReason.Hide();

	this.curStep = 10;
	gWizObj.curCtlr.logMgr.myCreateBtn.myBtn.onImg.Hide();
	gWizObj.tgtY = 0;
	gWizObj.curWiz.DeselAll();
	this.Cleanup();
}

function CreateWizFinish()
{
	this.curStep = 100;
	this.myStep3.Hide();
	gWizObj.myPrevBtn.Hide();
	gWizObj.myCancelBtn.Hide();
	gWizObj.myFinishBtn.Hide();
	this.myFinish.Show();

	var i;
	var iMax = this.curSegs.numItems;
	var compStr = "";
	for (i=0; i<iMax; i++) {
		seg = this.curSegs[i];
		compStr += "#" + seg.myOwner.smbeId + "," + seg.startBlock + "," + seg.numBlocks;
	}
	this.myForm.ctlrObj.value = gWizObj.curCtlr.smbeId;
	this.myForm.expandObj.value = 0;
	this.myForm.comps.value = compStr;
	this.myForm.spares.value = "";
	gCASubmitReq = true;
	/*
	alert("***TEMP ALERT***\nThe create array request has been submitted to the server.\n");

	gWizObj.curCtlr.logMgr.myCreateBtn.myBtn.onImg.Hide();
	gWizObj.curWiz.DeselAll();
	gWizObj.tgtY = 0;
	*/
}

function CreateWizReload()
{
	this.myFinish.hwYes.Hide();
	this.myFinish.hwNo.Hide();

	ReloadMain();
}

function CreateWizRestore()
{
	gWizDiv.failReason.Hide();
	this.myFinish.hwNo.Hide();
	this.myFinish.restoreDiv.Show();

	gDataFrame.location.replace(gBaseUrl + "?frame=data&action=restore");
}


function CreateWizShow(inCtlr)
{
	var obj = this.myStatus;
	obj.raid0.Hide();
	obj.raid1.Hide();
	obj.raid5.Hide();
	obj.vol.Hide();
	obj.textDiv.SetContent("");
	obj.raid10.Hide();
	obj.raid50.Hide();
	obj.prot.Hide();
	this.myForm.reset();
	this.myStep2.Hide();
	this.myStep3.Hide();
	this.myStep1.Show();
	this.raidType = null;
	this.blkLimit = 0;
	this.prevRTindex = 100;
	this.sumSegs = 0;
	this.minSeg = 0;
	this.minNumSegs = 0;
	this.VisShow();
}

function CreateWizDevClick(dev)
{
	var c = true;

	if (this.curStep > 2) {
		alert("***TEMP Reminder***\nYou must go to Step 1 or Step 2 to select drives.");
		return;
	}
	else if (dev.myCtlr != gWizObj.curCtlr) {
		alert("***TEMP Reminder***\nCreate array is in progress on another controller.\nYou must select drives on the active controller to include them in the array.");
		return;
	}

	if (dev.isLog) {
		if (this.raidType != "rv") {
			c = false;
		}
		/* TODO: implement "raidType" on logical device objects
		else if (!this.curSegs.numItems) {
			if ((dev.raidType != "r0") && (dev.raidType != "r1") && (dev.raidType != "r5")) {
				alert("***TEMP Reminder***\nRAID volumes can only be composed of RAID-0, RAID-1, and RAID-5 arrays.");
				c = false;
			}
		}
		else if (dev.raidType != this.curSegs[0].myOwner.raidType) {
			alert("***TEMP Reminder***\nRAID volumes must be composed of similar RAID type arrays. You have already selected one or more arrays of a different RAID type.");
			c = false;
		}
		*/
	}
	else if (this.raidType == "rv") {
		alert("***TEMP Reminder***\nYou must click array icons to create a RAID volume.");
		c = false;
	}
	else if (dev.isSpare) {
		c = confirm("Caution: You clicked a hot-spare device.\nIncluding the hot-spare in the array may cause other logical drives to no longer be protected by the hot-spare.  Click 'OK' if you are sure you want to include the hot-spare in the array.");
	}

	if (c) {
		var seg = dev.bigFree;
		if (!seg) {
			alert("*** TEMP ALERT ***\nThis drive has no free space");
		}
		else if (seg.numBlocks < gMinRaidBlks) {
			alert("*** TEMP ALERT ***\nThis drive does not have enough free space to use in an array.");
		}
		else {
			var rs = dev.rselSegs;
			if ((this.raidType == "sv") && (this.curSegs.numItems)) {
				var curSeg = this.curSegs[0];
				this.RemSeg(curSeg);
				if (curSeg != seg) {
					this.AddSeg(seg);
				}
			}
			else if (rs.numItems) {
				do {
					this.RemSeg(rs[0], true);
				} while (rs.numItems);
				this.RecompSegs();
			}
			else {
				this.AddSeg(seg);
			}

			this.SetCap();
		}
	}
}

function CreateWizSegClick(seg)
{
	var c = true;
	var dev = seg.myOwner;

	if (seg.segType != gSegUnused) {
		return;
	}
	else if (dev.myCtlr != gWizObj.curCtlr) {
		alert("***TEMP Reminder***\nCreate array is in progress on another controller.\nYou must select drives on the active controller to include them in the array.");
		return;
	}

	if (this.curStep > 2) {
		alert("***TEMP Reminder***\nYou must go to Step 1 or Step 2 to select segments.");
		c = false;
	}
	else if (dev.isSpare) {
		c = confirm("Caution: You clicked a hot-spare segment.\nIncluding the hot-spare in the array may cause other logical drives to no longer be protected by the hot-spare.  Click 'OK' if you are sure you want to include the hot-spare in the array.");
	}
	else if (this.raidType == "rv") {
		alert("***TEMP Reminder***\nYou must click array icons to create a RAID Volume");
		c = false;
	}

	if (c) {
		var curSeg = null;
		var rs = dev.rselSegs;
		if ((this.raidType == "sv") && (this.curSegs.numItems)) {
			curSeg = this.curSegs[0];
			this.RemSeg(curSeg);
		}
		else if (rs.numItems) {
			if (this.raidType != "spv") {
				curSeg = rs[0];
				this.RemSeg(curSeg);
			}
			else {
				for (i=0; i<rs.numItems; i++) {
					if (rs[i] == seg) {
						curSeg = seg;
						this.RemSeg(curSeg);
						break;
					}
				}
			}
		}
		if (curSeg != seg) {
			this.AddSeg(seg);
		}
		this.SetCap();
	}
	
}

function CreateWizAddSeg(seg)
{
	this.curSegs.Append(seg);

	if (this.prevRTindex == 2) {
		if ((this.raidType == "r5") && (this.curSegs.numItems == 6)) {
			gWizDiv.r50Active.Show();
		}
	}
	else if ((this.prevRTindex == 1) && (this.curSegs.numItems == 4)) {
		this.myStatus.raid1.Hide();
		this.myStatus.raid10.Show();
		this.raidType = "r10";
		this.minNumSegs = 4;
	}

	var dev = seg.myOwner;
	var iobj = dev.myIcon;
	dev.rselSegs.Append(seg);

	iobj.rselImg.Show();
	var vis = seg.fullSeg;
	if (vis) {
		vis.rselBkgd.Show();
		vis.rselBkgd.myRSelImg.Show();
	}
	vis = seg.relSeg;
	if (vis) {
		vis.rselBkgd.Show();
		vis.rselBkgd.myRSelImg.Show();
	}

	if (!this.minSeg) {
		this.minSeg = seg.numBlocks;
	}
	else if (seg.numBlocks < this.minSeg) {
		this.minSeg = seg.numBlocks;
	}
	this.sumSegs += seg.numBlocks;
}

function CreateWizRemSeg(seg, noRecomp)
{
	this.curSegs.Remove(seg);

	if (this.prevRTindex == 2) {
		if ((this.raidType == "r5") && (this.curSegs.numItems == 5)) {
			gWizDiv.r50Active.Hide();
		}
	}
	else if ((this.prevRTindex == 1) && (this.curSegs.numItems == 3)) {
		this.myStatus.raid10.Hide();
		this.myStatus.raid1.Show();
		this.raidType = "r1";
		this.minNumSegs = 2;
	}

	var dev = seg.myOwner;
	var iobj = dev.myIcon;
	seg.StopBlink();
	dev.rselSegs.Remove(seg);

	if (!dev.rselSegs.numItems) {
		iobj.rselImg.Hide();
	}
	var vis = seg.fullSeg;
	if (vis) {
		vis.rselBkgd.Hide();
		vis.rselBkgd.myRSelImg.Hide();
	}
	vis = seg.relSeg;
	if (vis) {
		vis.rselBkgd.Hide();
		vis.rselBkgd.myRSelImg.Hide();
	}

	if (!noRecomp) {
		this.RecompSegs();
	}

}

function CWRecompSegs()
{
	var i;
	var iMax = this.curSegs.numItems;
	this.minSeg = 0;
	this.sumSegs = 0;
	if (iMax) {
		var nb = this.curSegs[0].numBlocks;
		this.minSeg = nb;
		this.sumSegs = nb;
		for (i=1; i < iMax; i++) {
			nb = this.curSegs[i].numBlocks;
			this.sumSegs += nb;
			if (nb < this.minSeg) {
				this.minSeg = nb;
			}
		}
	}
}

function CWSetCap()
{
	var cs = this.curSegs;
	var ni = cs.numItems;
	var cap = 0;

	var i;

	if (ni >= this.minNumSegs) {
		var blinkNone = true;

		switch (this.raidType) {
			case "r0":
				cap = this.minSeg * ni;
				break;
			case "r1":
			case "r10":
				cap = this.minSeg * (ni >> 1);
				if (ni & 0x1) {
					this.BlinkLast(1);
					blinkNone = false;
				}
				break;
			case "r5":
				cap = this.minSeg * (ni - 1);
				break;
			case "r50":
				cap = this.minSeg * (ni - this.numR5s);
				var odd = ni % this.numR5s;
				if (odd) {
					this.BlinkLast(odd);
					blinkNone = false;
				}
				break;
			case "sv":
				cap = this.minSeg;
				break;
			case "spv":
				cap = this.sumSegs;
				break;
			case "rv":
				cap = this.sumSegs;
				break;
		}
		if (blinkNone) {
			for (i=0; i < ni; i++) {
				cs[i].StopBlink();
			}
		}
	}
	else {
		for (i=0; i < ni; i++) {
			cs[i].Blink();
		}
	}

	var qualStr = "";
	if (this.blkLimit && (cap > this.blkLimit)) {
		qualStr = "(" + gStrLimited + ")";
		cap = this.blkLimit;
	}
	this.capBlks = cap;
	var capStr = "<b>" + GetCapStr(cap) + "</b> " + qualStr + ", " + ni + " " + gStrDrivesSel;
	this.capDiv.SetContent(capStr);
}

function CWDeselAll()
{
	var cs = this.curSegs;
	while (cs.numItems) {
		this.RemSeg(cs[0], true);
	}
	this.minSeg = 0;
	this.sumSegs = 0;
}

function CWDeselAllBlink()
{
	var cs = this.curSegs;
	for (i=0; i < cs.numItems; i++) {
		if (cs[i].isBlinking) {
			do {
				this.RemSeg(cs[i], false);
			} while (i < cs.numItems);
		}
	}
	this.RecompSegs();
}

function CWDeselAllBut1()
{
	var cs = this.curSegs;
	if (cs.numItems) {
		while (cs.numItems > 1) {
			this.RemSeg(cs[0], true);
		}
		this.minSeg = cs[0].numBlocks;
		this.sumSegs = cs[0].numBlocks;
	}
}

function CWDeselDups()
{
	var cs = this.curSegs;
	var rs;
	var i;
	var dupFound;
	do {
		dupFound = false;
		for (i=0; i<cs.numItems; i++) {
			rs = cs[i].myOwner.rselSegs;
			if (rs.numItems > 1) {
				dupFound = true;
				while (rs.numItems > 1) {
					this.RemSeg(rs[0], true);
				}
				break;
			}
		}
	} while (dupFound);

	this.RecompSegs();
}

//----------------
// CreateStep1Obj()
//----------------

function CreateStep1Obj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	this.isInit = false;

	var obj = inOwner.myTitle;
	var leftPos = obj.xPos + 20;
	var topPos = obj.yPos + obj.ySize + 2;
	obj = InitVisObj(this.children[0]);
	this.stepText = obj;
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize;
	obj = InitVisObj(this.children[1]);
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize;
	this.ySize = topPos;

	obj = InitVisObj(this.children[2]);
	obj.MoveTo(370, 4);
	var i;
	var objList = obj.children;
	topPos = 0;
	for (i=0; i < objList.length; i++) {
		obj = InitVisObj(objList[i]);
		obj.MoveTo(0, topPos);
		topPos += obj.ySize;
		if ((i == 1) || (i == 2)) {
			topPos += 5;
		}
		else {
			topPos -= 3;
		}
	}

	this.ssChoice = GetVisObj("stripeChoice");
	this.ssNA = GetVisObj("stripeNA");

	this.VisShow = this.Show;
	this.Show = CreateStep1Show;
}

function GetCreateStep1(inOwner)
{
	var obj = GetPageElement("createStep1");
	if (obj) {
		obj.createStep1Obj = CreateStep1Obj;
		obj.createStep1Obj(inOwner);
	}

	return obj;
}

function CreateStep1Show()
{
	this.myOwner.curStep = 1;
	gWizObj.myPrevBtn.Hide();
	gWizObj.myCancelBtn.Show();
	gWizObj.myNextBtn.Show();
	gWizObj.myFinishBtn.Hide();
	this.VisShow();
}

//----------------
// CreateStep2Obj()
//----------------

function CreateStep2Obj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	var leftPos = inOwner.myStep1.stepText.xPos;
	var topPos = inOwner.myStep1.stepText.yPos;
	obj = InitVisObj(this.children[0]);
	this.stepText = obj;
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize + 3;
	obj = InitVisObj(this.children[1]);
	this.clickInfo = obj.children;
	var i;
	var iMax = obj.children.length;
	for (i=0; i < iMax; i++) {
		InitVisObj(obj.children[i]);
	}
	obj.MoveTo(leftPos, topPos);
	topPos += obj.children[1].ySize + 5;
	obj = InitVisObj(this.children[2]);
	this.rtInfo = obj.children;
	obj.MoveTo(leftPos, topPos);
	topPos += obj.children[2].ySize;
	this.ySize = topPos;
	iMax = obj.children.length;
	for (i=0; i < iMax; i++) {
		InitVisObj(obj.children[i]);
	}

	obj = InitVisObj(this.children[3]);
	obj.MoveTo(370, 4);

	this.r5Type = InitVisObj(obj.children[1]);

	this.VisShow = this.Show;
	this.Show = CreateStep2Show;
}

function GetCreateStep2(inOwner)
{
	var obj = GetPageElement("createStep2");
	if (obj) {
		obj.createStep2Obj = CreateStep2Obj;
		obj.createStep2Obj(inOwner);
	}

	return obj;
}

function CreateStep2Show()
{
	this.myOwner.curStep = 2;
	gWizObj.myPrevBtn.Show();
	gWizObj.myCancelBtn.Show();
	gWizObj.myNextBtn.Show();
	gWizObj.myFinishBtn.Hide();
	this.VisShow();
}

//----------------
// CreateStep3Obj()
//----------------

function CreateStep3Obj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	var leftPos = inOwner.myStep1.stepText.xPos;
	var topPos = inOwner.myStep1.stepText.yPos;
	obj = InitVisObj(this.children[0]);
	this.stepText = obj;
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize + 3;
	obj = InitVisObj(this.children[1]);
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize + 5;
	obj = InitVisObj(this.children[2]);
	obj.MoveTo(leftPos, topPos);
	topPos += obj.ySize;
	this.ySize = topPos;

	obj = InitVisObj(this.children[3]);
	this.adv1 = obj;
	this.buildDiv = InitVisObj(obj.children[0]);
	obj.MoveTo(370, 4);
	obj = InitBtnImg(obj.children[1].children[0], 8, 8);
	obj.myOwner = this;
	this.assignText = InitVisObj(this.adv1.children[1].children[1]);
	obj = InitVisObj(this.children[4]);
	this.adv2 = obj;
	obj.MoveTo(370, 4);

	this.VisShow = this.Show;
	this.Show = CreateStep3Show;
}

function GetCreateStep3(inOwner)
{
	var obj = GetPageElement("createStep3");
	if (obj) {
		obj.createStep3Obj = CreateStep3Obj;
		obj.createStep3Obj(inOwner);
	}

	return obj;
}

function CreateStep3Show()
{
	this.myOwner.curStep = 3;
	gWizObj.myPrevBtn.Show();
	gWizObj.myCancelBtn.Show();
	gWizObj.myNextBtn.Hide();
	gWizObj.myFinishBtn.Show();
	this.VisShow();
}

//----------------
// CreateFinishObj()
//----------------

function CreateFinishObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	var leftPos = inOwner.myStep1.stepText.xPos;
	var topPos = inOwner.myStep1.stepText.yPos;

	this.subReq = InitVisObj(this.children[0]);
	this.subReq.MoveTo(leftPos, topPos);

	this.subYes = InitVisObj(this.children[1]);
	this.subYes.MoveTo(leftPos, topPos);

	this.subNo = InitVisObj(this.children[2]);
	this.subNo.MoveTo(leftPos, topPos);

	this.hwYes = InitVisObj(this.children[3]);
	this.hwYes.MoveTo(leftPos, topPos);

	this.hwNo = InitVisObj(this.children[4]);
	this.hwNo.MoveTo(leftPos, topPos);

	this.restoreDiv = InitVisObj(this.children[5]);
	this.restoreDiv.MoveTo(leftPos, topPos);

	this.VisShow = this.Show;
	this.Show = CreateFinishShow;
}

function GetCreateFinish(inOwner)
{
	var obj = GetPageElement("createFinish");
	if (obj) {
		obj.createFinishObj = CreateFinishObj;
		obj.createFinishObj(inOwner);
	}

	return obj;
}

function CreateFinishShow()
{
	this.myOwner.curStep = 100;
	this.subReq.Show();
	this.subYes.Hide();
	this.subNo.Hide();
	this.hwYes.Hide();
	this.hwNo.Hide();
	this.restoreDiv.Hide();
	this.VisShow();
}

//----------------
// CreateStatusObj()
//----------------

function CreateStatusObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	this.textDiv = InitDivObj(this.children[0]);
	this.icon = InitVisObj(this.children[1]);
	this.raid0 = InitVisObj(this.children[2]);
	this.raid1 = InitVisObj(this.children[3]);
	this.raid5 = InitVisObj(this.children[4]);
	this.raid10 = InitVisObj(this.children[5]);
	this.raid50 = InitVisObj(this.children[6]);
	this.vol = InitVisObj(this.children[7]);
	this.prot = InitVisObj(this.children[8]);

	var topPos = (this.icon.ySize - this.textDiv.ySize) >> 1;
	this.textDiv.MoveTo(this.icon.xSize, topPos);
}

function InitCreateStatusObj(obj, inOwner)
{
	if (obj) {
		obj.createStatusObj = CreateStatusObj;
		obj.createStatusObj(inOwner);
	}

	return obj;
}

//---------
// SysObj()
//---------

var gSysObj = null;

function SysObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = null;
	this.indexNum = 0;

	this.myData = this.children[0];
	var dStr = this.myData.children[0].innerText.split(gSepChar);
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				gBaseUrl = dStr[i];
				break;
		}
	}

	this.myCtlrs = new Array();
	this.myCtlrs.myOwner = this;
	this.numCtlrs = 0;

	this.eSizeChange = hSysSizeChange;

	// Get all the controllers associated with this system
	var leftPos = 0;
	var topPos = 0;
	var i = 1;
	var ctlrObj = null;
	while (i < this.children.length) {
		ctlrObj = InitCtlrObj(this.children[i], this);
		if (ctlrObj) {
			this.myCtlrs.AppendOwn(ctlrObj);
			ctlrObj.MoveTo(leftPos, topPos);
			topPos += ctlrObj.ySize;
		}

		i++;
	}

	gOptDiv.MoveTo(gSysX, gSysY + topPos);

	this.ySize = topPos;
}

function InitSysObj(obj)
{
	if (obj) {
		obj.sysObj = SysObj;
		obj.sysObj();
	}

	return obj;
}

function GetSysObj(objName)
{
	return InitSysObj(GetPageElement(objName));
}

function hSysSizeChange(inCtlr, deltaY)
{
	var i;
	var obj;
	for (i = inCtlr.indexNum + 1; this.myCtlrs.IsValid(i); i++) {
		this.myCtlrs[i].MoveByY(deltaY);
	}

	this.ySize += deltaY;

	gOptDiv.MoveByY(deltaY);
}


//-----------
// CtlrObj()
//-----------

var gLogOnTop = false;
var gShowSec = false;

function CtlrObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.ySize = 20;

	this.myOwner = inOwner;
	this.indexNum = 0;

	this.myData = this.children[0];
	var dStr = this.myData.children[0].innerText.split(gSepChar);
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
		}
	}

	this.myExpImg = InitVisObj(this.children[1]);
	this.myExpImg.myOwner = this;
	this.myColImg = InitVisObj(this.children[2]);
	this.myColImg.myOwner = this;

	this.myIcon = InitIconObj(this.children[3]);
	this.myIcon.myOwner = this;
	this.myIcon.MoveTo(this.myColImg.xSize, 0);

	this.topContentPad = 4;
	this.btmContentPad = 10;
	this.myContent = InitVisObj(this.children[4]);
	this.myContent.MoveTo(this.myIcon.xPos, this.myIcon.ySize + this.topContentPad);

	this.phyMgr = InitPhyMgrObj(this.myContent.children[1], this);
	this.phyMgr.myOwner = this;
	this.phyMgr.isLog = false;

	this.logMgr = InitLogMgrObj(this.myContent.children[0], this);
	this.logMgr.myOwner = this;
	this.logMgr.isLog = true;

	if (gLogOnTop) {
		this.phyMgr.MoveTo(0, this.logMgr.ySize + 4);
		this.myContent.ySize = this.logMgr.ySize + this.phyMgr.ySize + 4;
	}
	else {
		this.logMgr.MoveTo(this.phyMgr.xSize - 1, 0);
		this.myContent.ySize = this.phyMgr.ySize;
		if (this.logMgr.ySize > this.myContent.ySize) {
			this.myContent.ySize = this.logMgr.ySize;
			this.phyMgr.myBkgd.SetMidSize(this.logMgr.myBkgdSize);
		}
		else {
			this.logMgr.myBkgd.SetMidSize(this.phyMgr.myBkgdSize);
		}
	}

	this.ySize = this.myIcon.ySize + this.topContentPad + this.myContent.ySize + this.btmContentPad;
	this.wizX = 0;
	this.wizY = 0;

	this.Expand = CtlrExpand;
	this.Collapse = CtlrCollapse;

	this.eSizeChange = hCtlrSizeChange;
	this.AdjustForWiz = CtlrAdjustForWiz;
	this.InitWizPos = CtlrInitWizPos;
	this.VisMoveByY = this.MoveByY;
	this.MoveByY = CtlrMoveByY;

	this.ClickOn = CtlrClickOn;
	this.ClickOff = CtlrClickOff;
}

function InitCtlrObj(obj, inOwner)
{
	if (obj) {
		obj.ctlrObj = CtlrObj;
		obj.ctlrObj(inOwner);
	}

	return obj;
}

function CtlrExpand()
{
	this.myExpImg.Hide();
	this.myColImg.Show();
	this.myContent.Show();
	if (gWizObj.curCtlr == this) {
		gWizDiv.MoveTo(this.wizX, this.wizY);
	}

	var deltaY = this.topContentPad + this.myContent.ySize + this.btmContentPad;
	this.myOwner.eSizeChange(this, deltaY);
}

function CtlrCollapse()
{
	this.myExpImg.Show();
	this.myColImg.Hide();
	this.myContent.Hide();
	if (gWizObj.curCtlr == this) {
		gWizDiv.MoveTo(-1000, -1000);
	}

	var deltaY = this.topContentPad + this.myContent.ySize + this.btmContentPad;
	this.myOwner.eSizeChange(this, -deltaY);
}

function hCtlrSizeChange(inMgr, deltaY)
{
	var deltaYSize = deltaY;

	if (gLogOnTop) {
		if (inMgr.isLog) {
			this.phyMgr.MoveByY(deltaY);
		}
	}
	else {
		deltaYSize = this.phyMgr.ySize;
		if (this.logMgr.ySize > deltaYSize) {
			deltaYSize = this.logMgr.ySize;
			this.phyMgr.myBkgd.SetMidSize(this.logMgr.myBkgdSize);
			this.logMgr.myBkgd.SetMidSize(this.logMgr.myBkgdSize);
		}
		else {
			this.phyMgr.myBkgd.SetMidSize(this.phyMgr.myBkgdSize);
			this.logMgr.myBkgd.SetMidSize(this.phyMgr.myBkgdSize);
		}
		deltaYSize -= this.myContent.ySize;
	}

	this.myContent.ySize += deltaYSize;
	this.ySize += deltaYSize;

	this.myOwner.eSizeChange(this, deltaYSize);
}

function CtlrAdjustForWiz(deltaY)
{
	var newMidSize = this.logMgr.myBkgd.midSize + deltaY;
	if (gLogOnTop) {
		this.logMgr.ySize += deltaY;
		this.logMgr.myContent.MoveByY(deltaY);
		this.logMgr.myBkgd.SetMidSize(newMidSize);
		this.phyMgr.MoveByY(deltaY);
	}
	else {
		this.logMgr.ySize += deltaY;
		this.phyMgr.ySize += deltaY;
		this.logMgr.myBkgdSize += deltaY;
		this.phyMgr.myBkgdSize += deltaY;
		this.logMgr.myContent.MoveByY(deltaY);
		this.phyMgr.myContent.MoveByY(deltaY);
		this.logMgr.myBkgd.SetMidSize(newMidSize);
		this.phyMgr.myBkgd.SetMidSize(newMidSize);
	}

	this.myContent.ySize += deltaY;
	this.ySize += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

}

function CtlrInitWizPos()
{
	var leftPos = this.myOwner.xPos + this.xPos;
	var topPos = this.myOwner.yPos + this.yPos;
	if (!gLogOnTop) {
		leftPos += this.myContent.xPos + this.phyMgr.xPos;
		topPos += this.myContent.yPos + this.phyMgr.yPos + this.phyMgr.myContent.yPos;
	}
	else {
		leftPos += this.myContent.xPos + this.logMgr.xPos;
		topPos += this.myContent.yPos + this.logMgr.yPos + this.logMgr.myContent.yPos;
	}

	this.wizX = leftPos;
	this.wizY = topPos;
}

function CtlrMoveByY(deltaY)
{
	this.VisMoveByY(deltaY);
	if (this.wizY) {
		this.wizY += deltaY;
		if (gWizObj.curCtlr == this) {
			gWizObj.MoveByY(deltaY);
		}
	}
}

function CtlrClickOn()
{
	ShowSelHdrBtns();
}


function CtlrClickOff()
{
	HideSelHdrBtns();
}


//-----------
// LogMgrObj()
//-----------

var gStartDebug = false;

function LogMgrObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	this.myTab = InitVarHText(this.children[1].children[0], 19, 19);
	this.myTab.MoveTo(0,0);
	var leftPos = this.myTab.xSize;
	var topPos = this.myTab.ySize - 2;

	this.myBkgd = InitVarVImg(this.children[0], 2, 0, 2);
	this.myBkgd.MoveTo(0, topPos);

	this.myCreateBtn = InitBtnObj(this.children[1].children[1], 6, 6);
	this.myCreateBtn.myOwner = this;
	this.myCreateBtn.MoveTo(leftPos, topPos);
	this.myCreateBtn.myBtn.hClick = ClickCreateLog;
	leftPos += this.myCreateBtn.xSize;

	this.myExpandBtn = InitBtnObj(this.children[1].children[2], 6, 6);
	this.myExpandBtn.myOwner = this;
	this.myExpandBtn.MoveTo(leftPos, topPos);
	leftPos += this.myExpandBtn.xSize;

	this.myDeleteBtn = InitBtnObj(this.children[1].children[3], 6, 6);
	this.myDeleteBtn.myOwner = this;
	this.myDeleteBtn.MoveTo(leftPos, topPos);
	leftPos += this.myDeleteBtn.xSize;

	this.xSize = this.myBkgd.xSize;

	this.myContent = InitVisObj(this.children[2]);
	leftPos = 7;
	topPos = this.myDeleteBtn.yPos + this.myDeleteBtn.ySize + 2;
	this.myContent.MoveTo(leftPos, topPos);

	leftPos = 0;
	topPos = 0;
	this.myTopDiv = InitLogRowMgr(this.myContent.children[0], this);
	this.myTopDiv.myOwner = this;
	topPos += this.myTopDiv.ySize + 8;

	this.mySecDiv = InitLogRowMgr(this.myContent.children[1], this);
	this.mySecDiv.myOwner = this;
	this.mySecDiv.indexNum = 1;
	this.mySecDiv.MoveTo(leftPos, topPos);
	this.mySecDiv.isShown = false;
	if (gShowSec == true) {
		this.mySecDiv.Show();
		topPos += this.mySecDiv.ySize + 8;
	}

	this.myContent.ySize = topPos;
	this.myBkgdSize = this.myContent.yPos - this.myBkgd.yPos + this.myContent.ySize - 2;
	this.myBkgd.SetMidSize(this.myBkgdSize);
	this.ySize = this.myBkgd.yPos + this.myBkgd.ySize;

	this.eSizeChange = hLogMgrSizeChange;
	this.ShowSec = LogMgrShowSec;
	this.HideSec = LogMgrHideSec;
	this.InitComps = LogMgrInitComps;

	this.InitComps(this.myTopDiv.myDevs);
	this.InitComps(this.mySecDiv.myDevs);

}

function InitLogMgrObj(obj, inOwner)
{
	if (obj) {
		obj.logMgrObj = LogMgrObj;
		obj.logMgrObj(inOwner);
	}

	return obj;
}

function hLogMgrSizeChange(inMgr, deltaY)
{
	this.ySize += deltaY;
	this.myContent.ySize += deltaY;
	this.myBkgdSize += deltaY;

	if (gLogOnTop) {
		this.myBkgd.SetMidSize(this.myBkgdSize);
	}

	this.myOwner.eSizeChange(this, deltaY);

	if (inMgr.indexNum == 0) {
		this.mySecDiv.MoveByY(deltaY);
	}
}

function LogMgrShowSec()
{
	if (!this.mySecDiv.isShown) {
		this.mySecDiv.Show();
		var deltaY = this.mySecDiv.ySize + 8;
		this.ySize += deltaY;
		this.myContent.ySize += deltaY;
		this.myBkgdSize += deltaY;
		this.myOwner.eSizeChange(this, deltaY);
	}
}

function LogMgrHideSec()
{
	if (this.mySecDiv.isShown) {
		var deltaY = this.mySecDiv.ySize + 8;
		this.ySize -= deltaY;
		this.myContent.ySize -= deltaY;
		this.myBkgdSize -= deltaY;
		this.myOwner.eSizeChange(this, -deltaY);
		this.mySecDiv.Hide();
	}
}

function LogMgrInitComps(inA)
{
	var i = 0;
	var j = 0;
	var segObj = null;

	// For each logical device...
	for (i=0; i < inA.numItems; i++) {
		// For each component entry...
		for (j=0; j < inA[i].myComps.numItems; j++) {
			segObj = GetPageElement(inA[i].myComps[j]);
			if (!segObj) {
				alert("Error: component " + inA[i].myComps[j] + " not found for device: " + inA[i].smbeId);
			}
			else {
				inA[i].myComps[j] = segObj;
				segObj.myParent = inA[i];
			}
		}
	}
}

function ClickCreateLog()
{
	gCmdTipMgr.Stop(this.myOwner);

	var logMgr = this.myOwner.myOwner;
	var ctlrObj = logMgr.myOwner;

	if (gAction == gActNone) {
		this.onImg.Show();
		gWizObj.OpenWiz(ctlrObj, gWizObj.myCreateWiz);
	}
	else if ((gAction == gActCreateLog) && (gWizObj.curCtlr == ctlrObj)) {
		gWizObj.CloseWiz();
	}
	else {
		alert("**TEMP ALERT**\nAnother action is in progress.\nYou cannot create an array on this controller at this time.");
	}
}


//-------------
// LogRowMgr()
//-------------

function LogRowMgr(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;
	this.indexNum = 0;

	var leftPos = 0;
	var topPos = 0;

	this.myHdr = InitVisObj(this.children[0]);
	topPos = (gIconYSize - this.myHdr.ySize) >> 1;
	this.myHdr.MoveTo(leftPos, topPos);
	topPos = gIconYSize;

	this.myNoDevs = InitVisObj(this.children[1]);
	var deltaY = (gIconYSize - this.myNoDevs.ySize) >> 1
	this.myNoDevs.MoveTo(16, topPos + deltaY);

	leftPos = -2;

	// Get the row objects
	this.myRows = new Array();
	this.myRows.myOwner = this;
	this.numActiveRows = 0;
	var child_A = this.children[2].children;
	var i = 0;
	var obj = null;
	for (i = 0; i < child_A.length; i++) {
		obj = InitRowObj(child_A[i]);
		this.myRows.AppendOwn(obj);
		obj.MoveTo(leftPos, topPos);
		topPos += obj.ySize;
	}

	// Get the device objects
	this.myDevs = new Array();
	this.myDevs.myOwner = this;
	child_A = this.children[3].children;
	i = 0;
	obj = null;
	for (i = 0; i < child_A.length; i++) {
		obj = InitLogDevObj(child_A[i]);
		obj.myCtlr = inOwner.myOwner;
		this.myDevs.AppendOwn(obj);
	}

	this.InitRows = LogInitRows;

	this.ySize = gIconYSize;
	if (this.myDevs.numItems == 0) {
		this.myNoDevs.Show();
		this.ySize += gIconYSize;
	}
	else {
		this.InitRows();
		this.ySize += this.numActiveRows * gIconYSize;
	}

	this.eSizeChange = hLogRowSizeChange;
}

function InitLogRowMgr(obj, inOwner)
{
	if (obj) {
		obj.logRowMgr = LogRowMgr;
		obj.logRowMgr(inOwner);
	}

	return obj;
}

function LogInitRows()
{
	var i;
	for (i = 0; this.myRows.IsValid(i); i++) {
		this.myRows[i].myDevs.RemoveAll();
	}

	var irow = 0;
	var cntPerRow = 0;
	var rowObj = null;
	for (i = 0; this.myDevs.IsValid(i); i++) {
		rowObj = this.myRows[irow];
		rowObj.AddDev(this.myDevs[i]);
		if (cntPerRow == 0) {
			rowObj.Show();
			this.numActiveRows++;
		}
		cntPerRow++;
		if (cntPerRow >= gDevsPerRow) {
			irow++;
			cntPerRow = 0;
		}
	}
}

function hLogRowSizeChange(inRow, deltaY)
{
	this.ySize += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	var i;
	var j;
	var rowObj;
	for (i = inRow.indexNum + 1; i < this.numActiveRows; i++) {
		rowObj = this.myRows[i];
		rowObj.MoveByY(deltaY);
		for (j = 0; j < rowObj.myDevs.numItems; j++) {
			rowObj.myDevs[j].MoveByY(deltaY);
		}
	}
}


//-----------
// PhyMgrObj()
//-----------

var gPhyText = 0;
var gPhyFCap = 1;
var gPhyRCap = 2;

var gPhyMgrA = new Array();

function PhyMgrObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;

	gPhyMgrA.Append(this);

	this.myTab = InitVarHText(this.children[1].children[0], 19, 19);
	this.myTab.MoveTo(0,0);
	var leftPos = this.myTab.xSize;
	var topPos = this.myTab.ySize - 2;

	this.myBkgd = InitVarVImg(this.children[0], 2, 0, 2);
	this.myBkgd.MoveTo(0, topPos);

	this.myViewDiv = InitVisObj(this.children[1].children[1]);
	leftPos += this.myViewDiv.xSize + 8;

	this.myTextBtn = InitBtnObj(this.children[1].children[2], 6, 6);
	this.myTextBtn.myOwner = this;
	this.myTextBtn.MoveTo(leftPos, topPos);
	this.myTextBtn.myBtn.hClick = ClickTextMode;
	leftPos += this.myTextBtn.xSize;

	this.myFCapBtn = InitBtnObj(this.children[1].children[3], 6, 6);
	this.myFCapBtn.myOwner = this;
	this.myFCapBtn.MoveTo(leftPos, topPos);
	this.myFCapBtn.myBtn.hClick = ClickFCapMode;
	leftPos += this.myFCapBtn.xSize;

	this.myRCapBtn = InitBtnObj(this.children[1].children[4], 6, 6);
	this.myRCapBtn.myOwner = this;
	this.myRCapBtn.MoveTo(leftPos, topPos);
	this.myRCapBtn.myBtn.hClick = ClickRCapMode;
	leftPos += this.myRCapBtn.xSize;

	this.phyMode = gPhyText;
	this.rowHintCntr = 1000;

	this.mySpareBtn = InitBtnObj(this.children[1].children[5], 6, 6);
	this.mySpareBtn.myOwner = this;
	var remSpace = this.myBkgd.xSize - 2 - leftPos;
	remSpace -= this.mySpareBtn.xSize;
	remSpace >>= 1;
	leftPos += remSpace;
	this.mySpareBtn.MoveTo(leftPos, topPos);

	remSpace = (this.myTextBtn.ySize - this.myViewDiv.ySize) >> 1;
	remSpace--;
	topPos += remSpace;
	leftPos = this.myTab.xSize + 4;
	this.myViewDiv.MoveTo(leftPos, topPos);

	this.xSize = this.myBkgd.xSize;

	this.myContent = this.children[2];
	this.myContent.visObj = VisObj;
	this.myContent.visObj();
	leftPos = 7;
	topPos = this.mySpareBtn.yPos + this.mySpareBtn.ySize + 2;
	this.myContent.MoveTo(leftPos, topPos);

	this.myChans = new Array();
	this.myChans.myOwner = this;
	leftPos = 0;
	topPos = 0;
	var i = 0;
	var chanObj = null;
	var numChans = this.myContent.children.length;
	for (i = 0; i < numChans; i++) {
		chanObj = InitChanObj(this.myContent.children[i], this);
		this.myChans.AppendOwn(chanObj);
		chanObj.MoveTo(leftPos, topPos);
		topPos += chanObj.ySize + 8;
	}

	this.myContent.ySize = topPos;
	this.myBkgdSize = this.myContent.yPos - this.myBkgd.yPos + this.myContent.ySize - 2;
	this.myBkgd.SetMidSize(this.myBkgdSize);
	this.ySize = this.myBkgd.yPos + this.myBkgd.ySize;

	this.eSizeChange = hPhyMgrSizeChange;
	this.SetPhyMode = PhyMgrSetPhyMode;
	this.RowHintsOff = PhyMgrRowHintsOff;

	/*
	this.myBkgd.SetMidSize(8 + topPos + 8);
	this.ySize = this.myBkgd.yPos + this.myBkgd.ySize - this.myTextModeBtn.yPos + 12;
	
	this.AdjustForWiz = PhyMgrAdjustForWiz;
	this.ClearAllChecks = PhyMgrClearAllChecks;
	*/
}

function InitPhyMgrObj(obj, inOwner)
{
	if (obj) {
		obj.phyMgrObj = PhyMgrObj;
		obj.phyMgrObj(inOwner);
	}

	return obj;
}

function hPhyMgrSizeChange(inChan, deltaY)
{
	this.ySize += deltaY;
	this.myContent.ySize += deltaY;
	this.myBkgdSize += deltaY;

	if (gLogOnTop) {
		this.myBkgd.SetMidSize(this.myBkgdSize);
	}

	this.myOwner.eSizeChange(this, deltaY);

	var i;
	for (i = inChan.indexNum + 1; i < this.myChans.numItems; i++) {
		this.myChans[i].MoveByY(deltaY);
	}
}

function ClickTextMode()
{
	gCmdTipMgr.Stop(this.myOwner);

	var phyMgr = this.myOwner.myOwner;

	phyMgr.myTextBtn.myBtn.onImg.Show();
	phyMgr.myFCapBtn.myBtn.onImg.Hide();
	phyMgr.myRCapBtn.myBtn.onImg.Hide();

	phyMgr.SetPhyMode(gPhyText);
}

function ClickFCapMode()
{
	gCmdTipMgr.Stop(this.myOwner);

	var phyMgr = this.myOwner.myOwner;

	phyMgr.myTextBtn.myBtn.onImg.Hide();
	phyMgr.myFCapBtn.myBtn.onImg.Show();
	phyMgr.myRCapBtn.myBtn.onImg.Hide();

	phyMgr.SetPhyMode(gPhyFCap);
}

function ClickRCapMode()
{
	gCmdTipMgr.Stop(this.myOwner);

	var phyMgr = this.myOwner.myOwner;

	phyMgr.myTextBtn.myBtn.onImg.Hide();
	phyMgr.myFCapBtn.myBtn.onImg.Hide();
	phyMgr.myRCapBtn.myBtn.onImg.Show();

	phyMgr.SetPhyMode(gPhyRCap);
}

function PhyMgrSetPhyMode(inMode)
{
	if (this.phyMode != inMode) {
		var i;
		var j;
		var k;
		var chan;
		var row;
		for (i=0; i < this.myChans.numItems; i++) {
			chan = this.myChans[i];
			for (j=0; j < chan.numActiveRows; j++) {
				row = chan.myRows[j];
				if (row.isRolledDown) {
					for (k=0; k < row.myDevs.numItems; k++) {
						if (inMode == gPhyFCap) {
							if (this.phyMode == gPhyText) {
								row.myDevs[k].myIcon.HideText();
							}
							else {
								row.myDevs[k].relSegs.Hide();
							}
							row.myDevs[k].fullSegs.Show();
						}
						else if (inMode == gPhyRCap) {
							if (this.phyMode == gPhyText) {
								row.myDevs[k].myIcon.HideText();
							}
							else {
								row.myDevs[k].fullSegs.Hide();
							}
							row.myDevs[k].relSegs.Show();
						}
						else {
							if (this.phyMode == gPhyFCap) {
								row.myDevs[k].fullSegs.Hide();
							}
							else {
								row.myDevs[k].relSegs.Hide();
							}
							row.myDevs[k].myIcon.ShowText();
						}
					}
				}
				else if (gHintsOn) {
					row.myHintImg.Show();
					this.rowHintCntr = 0;
				}
			}
		}

		this.phyMode = inMode;
	}

}

function PhyMgrRowHintsOff()
{
	var i;
	var j;
	var chan;
	for (i=0; i < this.myChans.numItems; i++) {
		chan = this.myChans[i];
		for (j=0; j < chan.numActiveRows; j++) {
			chan.myRows[j].myHintImg.Hide();
		}
	}
}

/*
function PhyMgrAdjustForWiz(deltaY)
{
	this.ySize += deltaY;

	//this.myBkgd.SetMidSize(this.myBkgd.midSize + deltaY);

	//this.myOwner.eSizeChange(this, deltaY);

	var i;
	for (i = 0; i < this.numChans; i++) {
		this.myChans[i].MoveByY(deltaY);
	}
}

function PhyMgrClearAllChecks()
{
	var i;
	var j;
	for (i = 0; i < this.numChans; i++) {
		for (j = 0; j < this.myChans[i].numDevs; j++) {
			this.myChans[i].myDevs[j].myIcon.rselIcon.Hide();
		}
	}
}
*/

//-------------
// ChanObj()
//-------------

function ChanObj(inOwner)
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = inOwner;
	this.indexNum = 0;

	this.myData = this.children[0];
	var dStr = this.myData.children[0].innerText.split(gSepChar);
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
		}
	}

	this.myIcon = InitIconObj(this.children[1]);
	this.myIcon.myOwner = this;

	var leftPos = -2;
	var topPos = this.myIcon.ySize;

	// Get the row objects
	this.myRows = new Array();
	this.myRows.myOwner = this;
	this.numActiveRows = 0;
	var child_A = this.children[2].children;
	var i = 0;
	var obj = null;
	for (i = 0; i < child_A.length; i++) {
		obj = InitRowObj(child_A[i]);
		this.myRows.AppendOwn(obj);
		obj.MoveTo(leftPos, topPos);
		topPos += obj.ySize;
	}

	// Get the device objects
	this.myDevs = new Array();
	this.myDevs.myOwner = this;
	child_A = this.children[3].children;
	i = 0;
	obj = null;
	for (i = 0; i < child_A.length; i++) {
		obj = InitPhyDevObj(child_A[i]);
		obj.myIcon.phyMgr = inOwner;
		obj.myCtlr = inOwner.myOwner;
		this.myDevs.AppendOwn(obj);
	}

	this.InitRows = ChanInitRows;
	this.InitRows();

	this.ySize = this.myIcon.ySize;
	if (this.numActiveRows) {
		this.ySize += this.numActiveRows * this.myRows[0].ySize;
	}

	this.eSizeChange = hChanSizeChange;
	this.ClickOn = ChanClickOn;
	this.ClickOff = ChanClickOff;
}

function InitChanObj(obj, inOwner)
{
	if (obj) {
		obj.chanObj = ChanObj;
		obj.chanObj(inOwner);
	}

	return obj;
}

function ChanInitRows()
{
	var i;
	for (i = 0; this.myRows.IsValid(i); i++) {
		this.myRows[i].myDevs.RemoveAll();
	}

	var irow = 0;
	var cntPerRow = 0;
	var rowObj = null;
	for (i = 0; this.myDevs.IsValid(i); i++) {
		rowObj = this.myRows[irow];
		rowObj.AddDev(this.myDevs[i]);
		if (cntPerRow == 0) {
			rowObj.Show();
			this.numActiveRows++;
		}
		cntPerRow++;
		if (cntPerRow >= gDevsPerRow) {
			irow++;
			cntPerRow = 0;
		}
	}
}

function hChanSizeChange(inRow, deltaY)
{
	this.ySize += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	var i;
	var j;
	var rowObj;
	for (i = inRow.indexNum + 1; i < this.numActiveRows; i++) {
		rowObj = this.myRows[i];
		rowObj.MoveByY(deltaY);
		for (j = 0; j < rowObj.myDevs.numItems; j++) {
			rowObj.myDevs[j].MoveByY(deltaY);
		}
	}
}

function ChanClickOn()
{
	ShowSelHdrBtns();
}


function ChanClickOff()
{
	HideSelHdrBtns();
}


//---------
// RowObj()
//---------

var gDevsPerRow = 8;

function RowObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = null;
	this.indexNum = 0;

	this.myDevs = new Array();

	this.isRolledDown = false;

	this.myUpImg = InitVisObj(this.children[0]);
	this.myUpImg.myOwner = this;

	this.myDnImg = InitVisObj(this.children[1]);
	this.myDnImg.myOwner = this;

	this.myHintImg = InitVisObj(this.children[2]);
	this.myHintImg.MoveTo(-this.myHintImg.xSize, 0);

	this.ySize = this.myUpImg.ySize;
	this.xSize = this.myUpImg.xSize;

	this.AddDev = RowObjAddDev;
	this.RollUp = RowObjRollUp;
	this.RollDown = RowObjRollDown;
}

function InitRowObj(obj)
{
	if (obj) {
		obj.rowObj = RowObj;
		obj.rowObj();
	}
	return obj;
}

function RowObjAddDev(inDev)
{
	var numDevs = this.myDevs.numItems;
	if (numDevs == 0) {
		inDev.MoveTo(this.xPos + this.myUpImg.xSize + 2, this.yPos);
	}
	else {
		var lastDev = this.myDevs[numDevs - 1];
		inDev.MoveTo(lastDev.xPos + lastDev.myIcon.xSize, this.yPos);
	}
	this.myDevs.Append(inDev);
	inDev.myRow = this;
	inDev.myIcon.myRow = this;
	inDev.myIcon.HideText();
}

function RowObjRollUp()
{
	this.myUpImg.Hide();
	this.myDnImg.Show();

	this.isRolledDown = false;

	var i;
	var leftPos = this.xPos + this.myUpImg.xSize + 2;
	var topPos = this.yPos;
	for (i = 0; this.myDevs.IsValid(i); i++) {
		this.myDevs[i].myIcon.eRollUp();
		this.myDevs[i].MoveTo(leftPos, topPos);
		leftPos += this.myDevs[i].myIcon.xSize;
	}
	this.xSize = leftPos - this.xPos;
	this.ySize = this.myUpImg.ySize;

	i = this.myDevs.numItems;
	if (i > 1) {
		var deltaY = (i - 1) * this.myDevs[0].ySize;
		this.myOwner.eSizeChange(this, -deltaY);
	}
}

function RowObjRollDown()
{
	this.myUpImg.Show();
	this.myDnImg.Hide();
	this.myHintImg.Hide();

	this.isRolledDown = true;

	var i;
	i = this.myDevs.numItems;
	if (i > 1) {
		var deltaY = (i - 1) * this.myDevs[0].ySize;
		this.myOwner.eSizeChange(this, deltaY);
	}

	var leftPos = this.xPos + this.myUpImg.xSize + 2;
	var topPos = this.yPos;
	for (i = 0; this.myDevs.IsValid(i); i++) {
		this.myDevs[i].myIcon.eRollDown();
		this.myDevs[i].MoveTo(leftPos, topPos);
		topPos += this.myDevs[i].myIcon.ySize;
	}
	this.xSize = this.myUpImg.xSize + 2;
	if (this.myDevs.numItems) {
		this.xSize += this.myDevs[0].myIcon.xSize;
	}
	this.ySize = topPos - this.yPos;
}

//-------------
// DevObj()
//-------------

function DevObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = null;
	this.indexNum = 0;

	this.myData = this.children[0];
	var dStr = this.myData.children[0].innerText.split(gSepChar);
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
			case 1:
				this.numBlocks = parseInt(dStr[i]);
				break;
			case 2:
				this.blockSize = parseInt(dStr[i]);
				break;
			case 3:
				this.isSpare = parseInt(dStr[i]);
				break;
		}
	}

	// Get identifiers of component segments
	this.myComps = new Array();
	dStr = this.children[2].innerText.split(gSepChar);
	// start at 1 to skip the meaningless first entry of zero
	for (i=1; i < dStr.length; i++) {
		this.myComps.Append(dStr[i]);
	}

	// Allocate the hot-spare lists
	this.protList = new Array();
	this.assignList = new Array();

	// Get the segment objects
	this.mySegs = new Array();
	this.mySegs.myOwner = this;
	this.bigFree = null;
	var segA = this.children[3].children;
	var segObj = null;
	this.numSegs = segA.length;
	for (i=0; i < segA.length; i++) {
		segObj = InitSegObj(segA[i]);
		this.mySegs.AppendOwn(segObj);
		if (segObj.segType == gSegUnused) {
			if (!this.bigFree) {
				this.bigFree = segObj;
			}
			else if (segObj.numBlocks > this.bigFree.numBlocks) {
				this.bigFree = segObj;
			}
		}
	}

	this.rselSegs = new Array();

	this.SegsISelOn = DevSegsISelOn;
	this.SegsISelOff = DevSegsISelOff;
	this.CompsISelOn = DevCompsISelOn;
	this.CompsISelOff = DevCompsISelOff;

	this.SegsHiOn = DevSegsHiOn;
	this.SegsHiOff = DevSegsHiOff;
	this.CompsHiOn = DevCompsHiOn;
	this.CompsHiOff = DevCompsHiOff;

	this.ClickOn = DevClickOn;
	this.ClickOff = DevClickOff;
}

function InitDevObj(obj)
{
	if (obj) {
		obj.devObj = DevObj;
		obj.devObj();
	}
	return obj;
}

function DevSegsISelOn()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.iselBkgd.Show();
			dev.SegsISelOn();
		}
	}
}

function DevSegsISelOff()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.iselBkgd.Hide();
			dev.SegsISelOff();
		}
	}
}

function DevCompsISelOn()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.iselBkgd.Show();
			dev.CompsISelOn();
		}
		if (seg.fullSeg) {
			seg.fullSeg.iselBkgd.Show();
		}
		if (seg.relSeg) {
			seg.relSeg.iselBkgd.Show();
		}
	}
}

function DevCompsISelOff()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.iselBkgd.Hide();
			dev.CompsISelOff();
		}
		if (seg.fullSeg) {
			seg.fullSeg.iselBkgd.Hide();
		}
		if (seg.relSeg) {
			seg.relSeg.iselBkgd.Hide();
		}
	}
}

function DevSegsHiOn()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.hiBkgd.Show();
			dev.SegsHiOn();
		}
	}
}

function DevSegsHiOff()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.hiBkgd.Hide();
			dev.SegsHiOff();
		}
	}
}

function DevCompsHiOn()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.hiBkgd.Show();
			dev.CompsHiOn();
		}
		if (seg.fullSeg) {
			seg.fullSeg.hiBkgd.Show();
		}
		if (seg.relSeg) {
			seg.relSeg.hiBkgd.Show();
		}
	}
}

function DevCompsHiOff()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.hiBkgd.Hide();
			dev.CompsHiOff();
		}
		if (seg.fullSeg) {
			seg.fullSeg.hiBkgd.Hide();
		}
		if (seg.relSeg) {
			seg.relSeg.hiBkgd.Hide();
		}
	}
}

function DevClickOn()
{
	this.myIcon.hiBkgd.Hide();

	this.SegsISelOn();
	this.CompsISelOn();

	if (gHiMode == gHiDeep) {
		this.SegsHiOff();
		this.CompsHiOff();
	}
	var i;
	var iMax = this.protList.numItems;
	for (i=0; i < iMax; i++) {
		this.protList[i].myIcon.iselBkgd.Show();
		if (gHiMode == gHiDeep) {
			this.protList[i].myIcon.hiBkgd.Hide();
		}
	}

	ShowSelHdrBtns();
}

function DevClickOff()
{
	this.myIcon.hiBkgd.Hide();

	this.SegsISelOff();
	this.CompsISelOff();
	var i;
	var iMax = this.protList.numItems;
	for (i=0; i < iMax; i++) {
		this.protList[i].myIcon.iselBkgd.Hide();
	}

	HideSelHdrBtns();
}

//------------
// LogDevObj()
//------------

function LogDevObj()
{
	this.devObj = DevObj;
	this.devObj();

	this.myIcon = InitLogDevIconObj(this.children[1]);
	this.myIcon.myOwner = this;
	this.ySize = this.myIcon.ySize;
	this.isLog = true; // ***TEMP - this should be logType set from server data

	this.SetStatus = LogDevSetStatus;

	// The list of assigned hot-spares
	this.myData = this.children[4];
	var dStr = this.myData.innerText.split(gSepChar);
	var i;
	for (i = 1; i < dStr.length; i++) {
		spObj = GetPageElement(dStr[i]);
		if (!spObj) {
			alert("Error: failed to get assigned spare, id: " + dStr[i]);
		}
		else {
			this.assignList.Append(spObj);
			spObj.assignList.Append(this);
		}
	}

	// The list of hot-spares protecting this logical device
	this.myData = this.children[5];
	dStr = this.myData.innerText.split(gSepChar);
	for (i = 1; i < dStr.length; i++) {
		spObj = GetPageElement(dStr[i]);
		if (!spObj) {
			alert("Error: failed to get protecting spare, id: " + dStr[i]);
		}
		else {
			this.protList.Append(spObj);
			spObj.protList.Append(this);
		}
	}
}

function InitLogDevObj(obj)
{
	if (obj) {
		obj.logDevObj = LogDevObj;
		obj.logDevObj();
	}
	return obj;
}


function LogDevSetStatus(inStatus)
{
	var str = "icon-empty.gif";
	var mstr = "icon-array.gif";

	switch (inStatus) {
		case "optimal":
			str = "icon-optimal.gif";
			break;
		case "failed":
			str = "icon-failed.gif";
			break;
		case "warn":
			str = "icon-warn.gif";
			break;
		case "smart":
			str = "icon-smart-warn.gif";
			break;
		case "create":
			str = "icon-create-request.gif";
			break;
		case "createfail":
			str = "icon-create-fail.gif";
			break;
		case "phantom":
			str = "icon-phantom.gif";
			break;
		case "flash":
			str = "icon-flash.gif";
			break;
		case "verify":
			str = "icon-verify.gif";
			break;
		case "offline":
			str = "icon-offline.gif";
			break;
		case "degraded":
			str = "icon-degraded.gif";
			break;
		case "build":
			str = "icon-empty.gif";
			mstr = "icon-build.gif";
			break;
		case "rebuild":
			str = "icon-degraded.gif";
			mstr = "icon-rebuild.gif";
			break;
	}

	this.myIcon.mainImg.SetUrl(gBaseUrl + "/images/" + mstr);
	this.myIcon.statusImg.SetUrl(gBaseUrl + "/images/" + str);
}

//------------
// PhyDevObj()
//------------

function PhyDevObj()
{
	this.devObj = DevObj;
	this.devObj();

	this.myIcon = InitPhyDevIconObj(this.children[1]);
	this.myIcon.myOwner = this;
	this.ySize = this.myIcon.ySize;

	this.fullSegs = InitVisObj(this.children[4]);
	this.relSegs = InitVisObj(this.children[5]);

	this.SetStatus = PhyDevSetStatus;

	var i;
	var segObj = null;
	var fLeft = this.myIcon.mainImg.xSize;
	var rLeft = fLeft;
	for (i = 0; i < this.mySegs.numItems; i++) {
		if (this.mySegs[i].fullSize) {
			segObj = InitVisSegObj(this.fullSegs.children[i]);
			this.mySegs[i].fullSeg = segObj;
			segObj.topDiv.mySeg = this.mySegs[i];
			segObj.myOwner = this.mySegs[i];
			segObj.MoveTo(fLeft, 0);
			segObj.SetMidSize(this.mySegs[i].fullSize);
			fLeft += this.mySegs[i].fullSize;
		}
		if (this.mySegs[i].relSize) {
			segObj = InitVisSegObj(this.relSegs.children[i]);
			this.mySegs[i].relSeg = segObj;
			segObj.topDiv.mySeg = this.mySegs[i];
			segObj.myOwner = this.mySegs[i];
			segObj.MoveTo(rLeft, 0);
			segObj.SetMidSize(this.mySegs[i].relSize);
			rLeft += this.mySegs[i].relSize;
		}
	}

}

function InitPhyDevObj(obj)
{
	if (obj) {
		obj.phyDevObj = PhyDevObj;
		obj.phyDevObj();
	}
	return obj;
}


function PhyDevSetStatus(inStatus)
{
	var str = "icon-empty.gif";

	switch (inStatus) {
		case "optimal":
			str = "icon-optimal.gif";
			break;
		case "failed":
			str = "icon-failed.gif";
			break;
		case "warn":
			str = "icon-warn.gif";
			break;
		case "smart":
			str = "icon-warn.gif";
			break;
		case "create":
			str = "icon-phantom.gif";
			break;
		case "createfail":
			str = "icon-phantom.gif";
			break;
		case "phantom":
			str = "icon-phantom.gif";
			break;
		case "flash":
			str = "icon-flash.gif";
			break;
		case "verify":
			str = "icon-verify.gif";
			break;
		case "format":
			str = "icon-format.gif";
			break;
	}

	this.myIcon.statusImg.SetUrl(gBaseUrl + "/images/" + str);
}

//-------------
// SegObj()
//-------------

var gSegUnused = 0;
var gSegUsed = 1;
var gSegReserved = 2;

function SegObj()
{
	this.myOwner = null;
	this.indexNum = 0;

	this.myData = this.children[0];
	var dStr = this.myData.innerText.split(gSepChar);
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
			case 1:
				this.startBlock = parseInt(dStr[i]);
				break;
			case 2:
				this.numBlocks = parseInt(dStr[i]);
				break;
			case 3:
				this.stripeSize = parseInt(dStr[i]);
				break;
			case 4:
				this.segType = parseInt(dStr[i]);
				break;
			case 5:
				this.fullSize = parseInt(dStr[i]);
				break;
			case 6:
				this.relSize = parseInt(dStr[i]);
				break;
		}
	}

	this.ClickOn = SegObjClickOn;
	this.ClickOff = SegObjClickOff;

	this.isBlinking = false;
	this.Blink = SegBlink;
	this.StopBlink = SegStopBlink;
}

function InitSegObj(obj)
{
	if (obj) {
		obj.segObj = SegObj;
		obj.segObj();
	}
	return obj;
}

function SegObjClickOn(inObj)
{
	this.fullSeg.hiBkgd.Hide();
	this.relSeg.hiBkgd.Hide();
	this.fullSeg.selBkgd.Show();
	this.relSeg.selBkgd.Show();

	this.myOwner.myIcon.selBkgd.Show();

	if (this.myParent) {
		this.myParent.myIcon.iselBkgd.Show();
		this.myParent.SegsISelOn();
	}

	if (gHiMode == gHiDeep) {
		this.myOwner.myIcon.hiBkgd.Hide();
		if (this.myParent) {
			this.myParent.myIcon.hiBkgd.Hide();
			this.myParent.SegsHiOff();
		}
	}

	ShowSelHdrBtns();
}

function SegObjClickOff(inObj)
{
	this.fullSeg.hiBkgd.Hide();
	this.relSeg.hiBkgd.Hide();
	this.fullSeg.selBkgd.Hide();
	this.relSeg.selBkgd.Hide();

	this.myOwner.myIcon.selBkgd.Hide();

	if (this.myParent) {
		this.myParent.myIcon.iselBkgd.Hide();
		this.myParent.SegsISelOff();
	}

	HideSelHdrBtns();
}

function SegBlink()
{
	if (!this.isBlinking) {
		this.isBlinking = true;

		gBlink.Append(this.myOwner.myIcon.rselImg);
		var vis = this.fullSeg;
		if (vis) {
			gBlink.Append(vis.rselBkgd.myRSelImg);
		}
		vis = this.relSeg;
		if (vis) {
			gBlink.Append(vis.rselBkgd.myRSelImg);
		}
	}
}

function SegStopBlink()
{
	if (this.isBlinking) {
		this.isBlinking = false;

		var vis = this.myOwner.myIcon.rselImg;
		gBlink.Remove(vis);
		vis.Show();
		vis = this.fullSeg;
		if (vis) {
			vis = vis.rselBkgd.myRSelImg;
			gBlink.Remove(vis);
			vis.Show();
		}
		vis = this.relSeg;
		if (vis) {
			vis = vis.rselBkgd.myRSelImg;
			gBlink.Remove(vis);
			vis.Show();
		}
	}
}


//-------------
// VisSegObj()
//-------------

function VisSegObj()
{
	this.visObj = VisObj;
	this.visObj();

	this.myOwner = null;
	this.indexNum = 0;

	this.midSize = 0;
	this.mainImg = InitVarSeg(this.children[0]);
	this.topDiv = InitVisObj(this.children[1]);
	this.topDiv.MoveTo(2, 0);
	this.topDiv.myOwner = this;
	this.iselBkgd = InitVarSeg(this.children[2]);
	this.hiBkgd = InitVarSeg(this.children[3]);
	this.selBkgd = InitVarSeg(this.children[4]);
	this.rselBkgd = InitRaidVarSeg(this.children[5]);

	this.myTip = InitToolTip(this.children[6]);

	this.SetMidSize = VSOSetMidSize;

	this.IconClick = IconClick;
	this.eClick = VisSegClick;
	this.eMouseOver = VisSegMouseOver;
	this.eMouseOut = VisSegMouseOut;
}

function InitVisSegObj(obj)
{
	if (obj) {
		obj.visSegObj = VisSegObj;
		obj.visSegObj();
	}
	return obj;
}

function VSOSetMidSize(inMidSize)
{
	this.midSize = inMidSize;
	this.mainImg.SetMidSize(inMidSize);
	this.iselBkgd.SetMidSize(inMidSize);
	this.hiBkgd.SetMidSize(inMidSize);
	this.selBkgd.SetMidSize(inMidSize);
	this.rselBkgd.SetMidSize(inMidSize);
	this.topDiv.style.clip = "rect(0," + inMidSize + "," + this.mainImg.ySize + ",0)";

	var leftPos = this.midSize >> 1;
	leftPos += 2;
	this.myTip.MoveTo(leftPos, 0);
}

function VisSegClick()
{
	gDevTipMgr.Stop(this);

	if (gAction) {
		if (gAction == gActCreateLog) {
			gWizObj.curWiz.eSegClick(this.myOwner);
		}
	}

	this.IconClick();
}

function VisSegMouseOver()
{
	if (gHiMode) {
		this.hiBkgd.Show();
		gDevTipMgr.Start(this);
		if ((gHiMode == gHiDeep) && (gSelIcon != this)) {
			var segObj = this.myOwner;
			segObj.myOwner.myIcon.hiBkgd.Show();
			if (segObj.myParent) {
				segObj.myParent.myIcon.hiBkgd.Show();
				segObj.myParent.SegsHiOn();
			}
		}
	}

	return true;
}

function VisSegMouseOut()
{
	if (gHiMode) {
		gDevTipMgr.Stop(this);
		this.hiBkgd.Hide();
		if ((gHiMode == gHiDeep) && (gSelIcon != this)) {
			var segObj = this.myOwner;
			segObj.myOwner.myIcon.hiBkgd.Hide();
			if (segObj.myParent) {
				segObj.myParent.myIcon.hiBkgd.Hide();
				segObj.myParent.SegsHiOff();
			}
		}
	}

	return true;
}

//-------------
// TipMgrObj()
//-------------

var gDevTipMgr = new TipMgrObj();
var gCmdTipMgr = new TipMgrObj();

function TipMgrObj()
{
	this.curObj = null;
	this.cntr = 0;
	this.delay = 0;

	this.Start = StartTip;
	this.Stop = StopTip;
	this.Check = CheckTip;
}

function CheckTip()
{
	if (this.cntr >= this.delay) {
		this.curObj.myTip.Show();
		this.curObj = null;
	}
	else {
		this.cntr++;
	}
}

function StartTip(inObj)
{
	if (!this.delay) {
		inObj.myTip.Show();
	}
	else if (this.delay < 100) {
		this.cntr = 0;
		this.curObj = inObj;
	}
}

function StopTip(inObj)
{
	inObj.myTip.Hide();
	this.curObj = null;
}

//---------------
// StatusUpdate()
//---------------

function StatusUpdate(inForm)
{
	var i;
	var iMax = inForm.elements.length;
	var str;
	var obj;
	for (i=0; i < iMax; i++) {
		str = inForm.elements[i].value.split(gSepChar);
		if (str.length) {
			if (str[0] == "statuschg") {
				obj = GetPageElement(str[1], true);
				if (obj) {
					if (obj.SetStatus) {
						obj.SetStatus(str[2]);
					}
				}
			}
			else if (str[0] == "create") {
				obj = gWizObj.curWiz;
				if (obj) {
					obj = obj.myFinish;
					if (obj) {
						if (str[1] == "accepted") {
							obj.subReq.Hide();
							obj.subYes.Show();
						}
						else if (str[1] == "rejected") {
							obj.subReq.Hide();
							if (str.length >= 3) {
								gWizDiv.failDetails.SetContent(str[2]);
							}
							else {
								gWizDiv.failDetails.SetContent("No details provided.");
							}
							obj.subNo.Show();
							gWizDiv.failReason.Show();
							gWizObj.myCloseBtn.Show();
						}
						else if (str[1] == "success") {
							obj.subYes.Hide();
							obj.hwYes.Show();
							gWizObj.myReloadBtn.Show();
						}
						else if (str[1] == "failed") {
							obj.subYes.Hide();
							obj.subReq.Hide();
							if (str.length >= 3) {
								gWizDiv.failDetails.SetContent(str[2]);
							}
							else {
								gWizDiv.failDetails.SetContent("No details provided.");
							}
							obj.hwNo.Show();
							gWizDiv.failReason.Show();
							gWizObj.myRestoreBtn.Show();
						}
						else if (str[1] == "restored") {
							ReloadMain();
						}
					}
				}
			}
		}
	}

	gPollCntr = 0;
}

//-------------
// DataInit()
//-------------

function DataInit(inDataForm)
{
	StatusUpdate(inDataForm);
}

