//--------------
// Miscellaneous
//--------------

var gSelObj = null;

var gSepChar = "^";

var gHintsOn = true;

var gHiOff = 0;
var gHiOn = 1;
var gHiDeep = 2;

var gActNone = 0;
var gActCreateLog = 1;
var gActDeleteLog = 2;
var gActSpare = 3;
var gActModifyLog = 4;
var gActRescan = 5;
var gActLogout = 6;

var gActPauseIO = 10;
var gActResumeIO = 11;
var gActAlarmEna = 12;
var gActAlarmDis = 13;
var gActAlarmSil = 14;
var gActAlarmTst = 15;
var gActBatRec = 16;
var gActLogProps = 17;
var gActTask = 18;
var gActEncSilence = 19;
var gActBlinkLED = 20;
var gActInvBlinkLED = 21;
var gActUnblinkAll = 22;
var gActEnConfig = 23;
var gActRegister = 24;
var gAction = 0;
var gPrevAction = 0;

var gCapUnits = null;

function GetCapStr(inBlks)
{ 
	var str = "";

	if (!inBlks) {
		str = "0.00 " + gCapUnits[0];;
	}
	else if (inBlks == 1) {
		str = "512 " + gCapUnits[0];
	}
	else {
		var unitIndex = 0;
		var tSize = parseFloat(inBlks) * 512;
		var tStr = "";

		while(tSize >= 1024) {
			unitIndex++;
			tSize /= 1024;
		} 

		if (tSize < 10) {	
			tSize = Math.round(tSize * 100);
			tStr = tSize.toString();
			str = tStr.charAt(0) + "." + tStr.charAt(1) + tStr.charAt(2);
		}
		else if (tSize < 100) {
			tSize = Math.round(tSize * 10);
			tStr = tSize.toString();
			str = tStr.charAt(0) + tStr.charAt(1) + "." + tStr.charAt(2);
		}
		else {
			str = Math.round(tSize);
			if (str == 1024) {
				str = "1.00";
				unitIndex++;
			}
		}
		str += " " + gCapUnits[unitIndex];
	}
		
	return str;
	
}

//--------------------------------------
//	ShowSelHdrBtns(), HideSelHdrBtns()
//--------------------------------------

function ShowSelHdrBtns()
{
	var hf = parent.headerFrame;
	if (hf) {
		if (hf.gIsLoaded) {
			hf.ShowSelBtns();
		}
	}
}

function HideSelHdrBtns(btnOff)
{
	var hf = parent.headerFrame;
	if (hf) {
		if (hf.gIsLoaded) {
			hf.HideSelBtns();
		}
	}
}


function CloseDetails(evt)
{
	var hf = parent.headerFrame;
	if (hf) {
		if (hf.gIsLoaded && hf.gCurHdrBtn) {
			hf.HdrBtnClick(hf.gCurHdrBtn, evt);
		}
	}

	return true;
}


//--------------------------------------
//	ShowDetail(), HideDetail()
//--------------------------------------

var gHdrBtnNum = 100;

function ShowDetail(btnNum)
{
	if (btnNum < 9) gHdrBtnNum = btnNum;
	if (gHdrBtnNum < 9) {
		gDetFrame.style.visibility = "inherit";
		ReloadDetails();
	}
}

function HideDetail(btnNum)
{
	if (gDetDiv) gDetDiv.style.visibility = "hidden";
	gDetFrame.style.visibility = "hidden";
	if (btnNum==1) if (gDetForm.optChange.value != "0") ReloadDetails();
	gHdrBtnNum = 100;
}


//--------------------------------------
//	IconObj()
//--------------------------------------

function NoMenu(evt)
{
	return false;
}

function IconObj(inOwner)
{
	this.myOwner = inOwner;

	var c;
	var o;
	var i = 0;

	if (this.childNodes) {
		c = this.childNodes;
		this.imgs = c[2].childNodes;
	}
	else {
		c = this.children;
		this.imgs = c[2].children;
	}

	this.bkgdDiv = c[1];
	this.bkgdColor = (gIsNS6) ? this.bkgdDiv.attributes.bkgdColor.value : this.bkgdDiv.style.borderColor;
	this.bColor = this.bkgdColor;

	this.iconType = parseInt(c[0].innerHTML);
	this.maxWidth = parseInt(c[0].style.width);

	c = this.imgs;
	for (i=0; i < c.length; i++) {
		c[i].Show = ObjShow;
		c[i].Hide = ObjHide;
	}
	i = 0;
	this.mainImg = c[i++];
	this.minWidth = this.mainImg.offsetWidth;
	this.ySize = this.mainImg.offsetHeight;
	this.isTextShown = false;

	//BRIAN - reactivated delayed tool-tips with on-demand initialization in StatusUpdate()
	this.eMouseOver = IconTipInit; // IconTipInit() was used when delayed tool-tip initialization was implemented
									 // However, if a task is active on an object the data frame will update the tool-tip content potentially before any mouseover has occurred
									 // thus, delayed tool-tips have been disabled for now on logical and physical device icons (channels & controllers don't have tool-tips anyway)
									 // For now the VisSeg() objects can still implement delayed tool-tip initialization
									 // Note that the data frame could hold off tool-tip updates but then the tool-tip would be out of sync when first shown (until the next data frame update)
	//this.eMouseOver = IconMouseOver;
	this.eMouseOut = IconMouseOut;

	if (this.iconType == 1) { // Controller or channel
		this.taskImg = c[i++];
		this.cstatusImg = c[i++];
		this.isTextShown = true;
		this.eClick = IconClick;
	}
	else if (this.iconType == 2) { // Physical drive
		this.hsImg = c[i++];
		this.hsSelImg = c[i++];
		this.delImg = c[i++];
		this.rselImg = c[i++];
		this.naImg = c[i++];
		this.taskImg = c[i++];
		this.BaseClick = IconClick;
		this.eClick = DevIconClick;
	}
	else if (this.iconType == 3) { // Logical drive
		this.logTypeImg = c[i++];
		this.protImg = c[i++];
		this.delImg = c[i++];
		this.rselImg = c[i++];
		this.naImg = c[i++];
		this.taskImg = c[i++];
		this.BaseClick = IconClick;
		this.eClick = DevIconClick;
		this.maxWidth += gDevBkgdLogExtra;
	}
	this.statusImg = c[i++];

	if (this.childNodes) {
		c = this.childNodes;
		this.myText = c[3].childNodes[1];
	}
	else {
		c = this.children;
		this.myText = c[3].children[1];
	}
	this.textDiv = c[3];
	this.topImg = c[4];
	this.topImg.myOwner = this;

	this.HiOn = IconHiOn;
	this.HiOff = IconHiOff;
	this.SelOn = IconSelOn;
	this.SelOff = IconSelOff;
	this.ISelOn = IconISelOn;
	this.ISelOff = IconISelOff;
	this.ProtOn = IconProtOn;
	this.ProtOff = IconProtOff;

	this.isBlinking = false;
	this.RSelOn = IconRSelOn;
	this.RSelOff = IconRSelOff;

	this.isDelOn = false;
	this.DelOn = IconDelOn;
	this.DelOff = IconDelOff;

	this.SetText = IconSetText;
	this.HideText = IconHideText;
	this.ShowText = IconShowText;

	this.myTip = null;
	if (c.length >= 6) {
		c = c[5];
		this.myTip = c;
		//BRIAN - reactivated delayed tool-tips with on-demand initialization in StatusUpdate()
		//c.toolTip = ToolTip;
		//c.toolTip(0);
	}
}

function IconSetText(inContent)
{
	this.myText.innerHTML = inContent;
}

function IconShowText()
{
	this.textDiv.style.visibility = "inherit";
	if (gIsIE4) this.textDiv.style.width = this.maxWidth - gIconWidth + "px";
	this.isTextShown = true;

	var w = this.maxWidth;
	this.topImg.width = w;
	this.style.width = w + "px";

	if (gIsNS6) w -= 2;
	this.bkgdDiv.style.width = w + "px";
}

function IconHideText()
{
	this.textDiv.style.visibility = "hidden";
	if (gIsIE4) this.textDiv.style.width = this.maxWidth - gIconWidth + "px";
	this.isTextShown = false;

	var w = this.minWidth;
	this.topImg.width = w;
	this.style.width = w + "px";

	if (gIsNS6) w -= 2;
	this.bkgdDiv.style.width = w + "px";
}

function DevIconClick(evt)
{
	if (gAction && gWizObj.curWiz) gWizObj.curWiz.eDevClick(this.myOwner);

	this.BaseClick(evt);

	return false;
}

function IconClick(evt)
{
	this.HiOff();
	if (this.myTip) gDevTipMgr.Stop(this);

	if (gSelObj) {
		gSelObj.myIcon.SelOff();
		gSelObj.ClickOff();
	}
	if (gSelObj != this.myOwner) {
		var prevSel = gSelObj;
		gSelObj = this.myOwner;
		gSelObj.myIcon.SelOn();
		if (prevSel) ShowDetail(0xff);
		else ShowSelHdrBtns();
		gSelObj.ClickOn();
	}
	else {
		gSelObj = null;
		HideSelHdrBtns();
	}
	
	return false;
}

function IconMouseOver(evt)
{
	if (gHiMode) this.HiOn();
	if (this.myTip && !this.isTextShown) gDevTipMgr.Start(this);
	return true;
}

function IconMouseOut(evt)
{
	this.HiOff();
	if (this.myTip) gDevTipMgr.Stop(this);
	return true;
}

function IconTipInit()
{
	this.eMouseOver = IconMouseOver;

	var t = this.myTip;

	if (t && !t.toolTip) {
		t.toolTip = ToolTip;
		t.toolTip(0);
	}

	this.eMouseOver();
}

var gHiObj = null; // gHiObj is used to reduce the occurrences of a sticky highlight effect when rapidly clicking & moving the mouse in IE

function IconHiOn() { gHiObj=this; this.bkgdDiv.style.borderColor="#ffa921"; }
function IconHiOff()
{
	if (gHiObj && gHiObj!=this) gHiObj.eMouseOut();
	gHiObj = null;
	this.bkgdDiv.style.borderColor = this.bColor;
}
function IconSelOn() { this.bkgdDiv.style.borderColor="#ffa921"; this.bkgdDiv.style.backgroundColor="#f9daa9"; this.bColor = "#ffa921"; }
function IconSelOff() { var bc=this.bkgdColor; this.bkgdDiv.style.borderColor=bc; this.bkgdDiv.style.backgroundColor=bc; this.bColor = bc; }
function IconISelOn() { this.bkgdDiv.style.borderColor="#e1d8a9"; this.bkgdDiv.style.backgroundColor="#e1d8a9"; this.bColor = "#e1d8a9"; }
function IconISelOff() { var bc=this.bkgdColor; this.bkgdDiv.style.borderColor=bc; this.bkgdDiv.style.backgroundColor=bc; this.bColor = bc; }
function IconProtOn() { this.bkgdDiv.style.borderColor="#adceff"; this.bkgdDiv.style.backgroundColor="#adceff"; this.bColor = "#adceff"; }
function IconProtOff() { var bc=this.bkgdColor; this.bkgdDiv.style.borderColor=bc; this.bkgdDiv.style.backgroundColor=bc; this.bColor = bc; }
function IconRSelOn() { this.rselImg.style.visibility = "inherit"; }
function IconRSelOff() { if (this.isBlinking) { gBlink.StopOff(this.rselImg); this.isBlinking = false; } else this.rselImg.style.visibility = "hidden"; }
function IconDelOn() { this.delImg.style.visibility = "inherit"; this.isDelOn = true; }
function IconDelOff() { this.delImg.style.visibility = "hidden"; this.isDelOn = false; }

//---------
// SysObj()
//---------

var gSysObj = null;

var gIconWidth = 0;
var gIconHeight = 0;
var gCtlrTopPad = 0;
var gCtlrBtmPad = 0;
var gChanPad = 0;
var gSecPad = 0;
var gDevBkgdWidth = 0;
var gDevBkgdLogExtra = 34;
var gNumCtlrs = 0;
var gCCMsg = "";
var gRegUrl = "";

function SysObj()
{
	var dStr;
	if (this.childNodes) {
		dStr = this.childNodes[0].childNodes[0].innerHTML.split(gSepChar);
		gCapUnits = this.childNodes[0].childNodes[1].innerHTML.split(gSepChar);
		this.myCtlrs = this.childNodes[1].childNodes;
	}
	else {
		dStr = this.children[0].children[0].innerHTML.split(gSepChar);
		gCapUnits = this.children[0].children[1].innerHTML.split(gSepChar);
		this.myCtlrs = this.children[1].children;
	}
	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				gBaseUrl = dStr[i];
				break;
			case 1:
				gIconWidth = parseInt(dStr[i]);
				break;
			case 2:
				gIconHeight = parseInt(dStr[i]);
				break;
			case 3:
				gCtlrTopPad = parseInt(dStr[i]);
				break;
			case 4:
				gCtlrBtmPad = parseInt(dStr[i]);
				break;
			case 5:
				gChanPad = parseInt(dStr[i]);
				break;
			case 6:
				gSecPad = parseInt(dStr[i]);
				break;
			case 7:
				gDevBkgdWidth = parseInt(dStr[i]);
				break;
			case 8:
				gNumCtlrs = parseInt(dStr[i]);
				break;
			case 9:
				gCCMsg = dStr[i];
				break;
			case 10:
				gRegUrl = dStr[i];
				break;
		}
	}

	this.eSizeChange = hSysSizeChange;

	var topPos = 0;
	// Initialize the controller objects
	if (!gNumCtlrs) this.myCtlrs = null;
	else {
		var c = this.myCtlrs;
		var cObj = null;
		for (i=0; i < c.length; i++) {
			cObj = c[i];
			cObj.ctlrObj = CtlrObj;
			cObj.ctlrObj(this, i);
			cObj.style.top = topPos + "px";
			cObj.yPos = topPos;
			topPos += cObj.ySize;
		}
	}

	this.ySize = topPos;

	this.ShowSecs = SysShowSecs;
	this.HideSecs = SysHideSecs;
	this.SetState = SysSetState;
	this.GetState = SysGetState;
}

function InitSysObj()
{
	gSysObj = GetPageElement("sys0");
	gSysObj.sysObj = SysObj;
	gSysObj.sysObj();
	gSysObj.SetState();
}

function SysShowSecs()
{
	var c = this.myCtlrs;
	if (!c) return;
	var i;
	for (i=0; i<c.length; i++) c[i].logMgr.ShowSecs();
}

function SysHideSecs()
{
	var c = this.myCtlrs;
	if (!c) return;
	var i;
	for (i=0; i<c.length; i++) c[i].logMgr.HideSecs();
}

function hSysSizeChange(inCtlr, deltaY)
{
	var i;
	var c = this.myCtlrs;
	if (!c) return;
	var cObj;
	var newY;
	for (i = inCtlr.indexNum + 1; i < c.length; i++) {
		cObj = c[i];
		newY = cObj.yPos + deltaY;
		cObj.style.top = newY + "px";
		cObj.yPos = newY;
		if (gWizObj && gWizObj.curCtlr == cObj) gWizDiv.style.top = gWizDiv.offsetTop + deltaY + "px";
	}

	this.ySize += deltaY;
}

function SysSetState()
{
	var c = this.myCtlrs;
	if (!c) return;
	var i;
	for (i=0; i<c.length; i++) c[i].SetState();
}

function SysGetState()
{
	var str = "";
	var c = this.myCtlrs;
	if (c) {
		var i;
		for (i=0; i<c.length; i++) {
			c[i].GetState();
			if (i) str += "^";
			str += c[i].uiState1;
			str += "^";
			str += c[i].uiState2;
		}
	}

	return str;
}


//-----------
// CtlrObj()
//-----------

var baa=1; //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.

function CtlrObj(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	var dStr;
	if (this.childNodes) {
		dStr = this.childNodes[0].childNodes[0].innerHTML.split(gSepChar);
		this.imgExp = this.childNodes[1];
		this.imgCol = this.childNodes[2];
		this.myIcon = this.childNodes[3];
		this.myContent = this.childNodes[4];
		this.logMgr = this.myContent.childNodes[0];
		this.phyMgr = this.myContent.childNodes[1];
	}
	else {
		dStr = this.children[0].children[0].innerHTML.split(gSepChar);
		this.imgExp = this.children[1];
		this.imgCol = this.children[2];
		this.myIcon = this.children[3];
		this.myContent = this.children[4];
		this.logMgr = this.myContent.children[0];
		this.phyMgr=GetPageElement("baa"+ baa++); //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.
	}

	var i;
	for (i=0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
			case 1:
				this.minSegSize = parseInt(dStr[i]);
				break;
			case 2:
				this.minArraySize = parseInt(dStr[i]);
				break;
			case 3:
				this.maxNumArrays = parseInt(dStr[i]);
				break;
			case 4:
				this.maxUsedSegs = parseInt(dStr[i]);
				break;
			case 5:
				this.ctlrFlags = parseInt(dStr[i]);
				break;
			case 6:
				this.ctlrFamily = parseInt(dStr[i]);
				break;
			case 7:
				this.showBattery = parseInt(dStr[i]);
				break;
			case 8:
				this.raidTypes = parseInt(dStr[i]);
				break;
			case 9:
				this.buildCaps = parseInt(dStr[i]);
				break;
			case 10:
				this.uiState1 = parseInt(dStr[i]);
				break;
			case 11:
				this.uiState2 = parseInt(dStr[i]);
				break;
		}
	}

	this.imgExp.myOwner = this;
	this.imgCol.myOwner = this;

	this.myIcon.iconObj = IconObj;
	this.myIcon.iconObj(this);

	this.logMgr.logMgrObj = LogMgrObj;
	this.logMgr.logMgrObj(this);

	this.phyMgr.phyMgrObj = PhyMgrObj;
	this.phyMgr.phyMgrObj(this);

	this.maxBkgd = this.phyMgr.bkgdHeight;
	this.myContent.ySize = this.phyMgr.ySize;
	if (this.logMgr.bkgdHeight > this.maxBkgd) {
		this.maxBkgd = this.logMgr.bkgdHeight;
		this.myContent.ySize = this.logMgr.ySize;
	}
	this.phyMgr.myBkgd.SetHeight(this.maxBkgd);
	this.logMgr.myBkgd.SetHeight(this.maxBkgd);
	this.myContent.ySize += gCtlrTopPad + gCtlrBtmPad;
	this.ySize = this.myIcon.ySize + this.myContent.ySize;

	this.wizX = this.myContent.offsetLeft + "px";
	this.wizY = this.myContent.offsetTop + this.phyMgr.myContent.offsetTop;

	this.Expand = CtlrExpand;
	this.Collapse = CtlrCollapse;

	this.eSizeChange = hCtlrSizeChange;
	this.AdjustForWiz = CtlrAdjustForWiz;
	this.SetWizPos = CtlrSetWizPos;

	this.ClickOn = CtlrClickOn;
	this.ClickOff = CtlrClickOff;

	this.isCollapsed = false;
	this.SetState = CtlrSetState;
	this.GetState = CtlrGetState;
}

function CtlrExpand()
{
	this.isCollapsed = false;
	this.imgExp.style.visibility = "hidden";
	this.imgCol.style.visibility = "inherit";
	this.myContent.style.visibility = "inherit";
	if (gWizObj && (gWizObj.curCtlr == this)) gWizDiv.style.left = this.wizX;

	this.myOwner.eSizeChange(this, this.myContent.ySize);
}

function CtlrCollapse()
{
	this.isCollapsed = true;
	this.imgCol.style.visibility = "hidden";
	this.myContent.style.visibility = "hidden";
	this.imgExp.style.visibility = "inherit";
	if (gWizObj && (gWizObj.curCtlr == this)) gWizDiv.style.left = "-1000px";

	this.myOwner.eSizeChange(this, -this.myContent.ySize);
}

function hCtlrSizeChange(inMgr, deltaY)
{
	var maxYSize = this.phyMgr.bkgdHeight;
	if (this.logMgr.bkgdHeight > maxYSize) maxYSize = this.logMgr.bkgdHeight;

	deltaY = maxYSize - this.maxBkgd;

	if (deltaY) {
		this.maxBkgd = maxYSize;
		this.phyMgr.myBkgd.SetHeight(maxYSize);
		this.logMgr.myBkgd.SetHeight(maxYSize);

		this.myContent.ySize += deltaY;
		this.ySize += deltaY;

		this.myOwner.eSizeChange(this, deltaY);
	}
}

function CtlrAdjustForWiz(deltaY)
{
	this.maxBkgd += deltaY;
	this.myContent.ySize += deltaY;
	this.ySize += deltaY;

	var mgr = this.logMgr;
	mgr.ySize += deltaY;
	mgr.bkgdHeight += deltaY;
	mgr.myContent.style.top = mgr.myContent.offsetTop + deltaY + "px";
	mgr.myBkgd.SetHeight(this.maxBkgd);

	mgr = this.phyMgr;
	mgr.ySize += deltaY;
	mgr.bkgdHeight += deltaY;
	mgr.myContent.style.top = mgr.myContent.offsetTop + deltaY + "px";
	mgr.myBkgd.SetHeight(this.maxBkgd);

	this.myOwner.eSizeChange(this, deltaY);
}

function CtlrSetWizPos(inWiz)
{
	inWiz.style.left = this.wizX;
	inWiz.style.top = this.offsetTop + this.wizY + "px";
}

function CtlrClickOn()
{
}


function CtlrClickOff()
{
}

function CtlrSetState()
{
	//alert("CtlrSetState(): this.uiState1=" + this.uiState1);
	//alert("CtlrSetState():this.uiState2=" + this.uiState2);
	if (this.uiState1 & 0x00000001) this.Collapse();

	var uis = (this.uiState1 >> 1) & 0x3;
	if (uis == 1) this.phyMgr.fcapBtn.eClick();
	else if (uis == 2) this.phyMgr.rcapBtn.eClick();

	var c = this.phyMgr.myChans;
	var i;
	var r;
	var ibit = 0x08;
	uis = this.uiState1;
	for (i=0; i<c.length; i++) {
		if (c[i].numDevs) {
			r = c[i].myRows;
			if (uis & ibit) r[0].eRollDown();
			ibit <<= 1;
			if (r.length >= 2) {
				if (uis & ibit) r[1].eRollDown();
			}
			ibit <<= 1;
		}
		else {
			ibit <<= 2;
		}
	}

	uis = this.uiState2;
	c = this.logMgr.topMgr;
	if (c.numDevs) {
		ibit = 0x01;
		r = c.myRows;
		for (i=0; i<r.length; i++) {
			if (uis & ibit) r[i].eRollDown();
			ibit <<= 1;
		}
	}
	c = this.logMgr.secMgr;
	if (c.numDevs) {
		ibit = 0x100;
		r = c.myRows;
		for (i=0; i<r.length; i++) {
			if (uis & ibit) r[i].eRollDown();
			ibit <<= 1;
		}
	}
}

function CtlrGetState()
{
	this.uiState1 = 0;
	this.uiState2 = 0;

	if (this.isCollapsed) this.uiState1 |= 0x00000001;
	this.uiState1 |= (this.phyMgr.phyMode & 0x3) << 1;

	var c = this.phyMgr.myChans;
	var i;
	var r;
	var ibit = 0x08;
	for (i=0; i<c.length; i++) {
		if (c[i].numDevs) {
			r = c[i].myRows;
			if (r[0].isRolledDown) this.uiState1 |= ibit;
			ibit <<= 1;
			if (r.length >= 2) {
				if (r[1].isRolledDown) this.uiState1 |= ibit
			}
			ibit <<= 1;
		}
		else {
			ibit <<= 2;
		}
	}

	c = this.logMgr.topMgr;
	if (c.numDevs) {
		ibit = 0x01;
		r = c.myRows;
		for (i=0; i<r.length; i++) {
			if (r[i].isRolledDown) this.uiState2 |= ibit;
			ibit <<= 1;
		}
	}
	c = this.logMgr.secMgr;
	if (c.numDevs) {
		ibit = 0x100;
		r = c.myRows;
		for (i=0; i<r.length; i++) {
			if (r[i].isRolledDown) this.uiState2 |= ibit;
			ibit <<= 1;
		}
	}
	//alert("CtlrGetState():this.uiState1=" + this.uiState1);
	//alert("CtlrGetState():this.uiState2=" + this.uiState2);
}


//----------------------------
// LogMgrObj()
//----------------------------

var aag=1; //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.

function LogMgrObj(inOwner)
{
	this.myOwner = inOwner;
	if (gIsIE4) this.style.zIndex=1000; //BRIAN: The LogMgr's mouse events get stolen by the PhyMgr without this in IE4.

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		this.myContent = c[1];
		this.topMgr = c[1].childNodes[0];
		this.secMgr = c[1].childNodes[1];
		c = c[0].childNodes;
	}
	else {
		c = this.children;
		this.myContent = c[1];
		this.topMgr = c[1].children[0];
		this.secMgr=GetPageElement("aag"+ aag++); //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.
		c = c[0].children;
	}
	
	this.myTab = c[1];
	this.myTab.devTabObj = DevTabObj;
	this.myTab.devTabObj();

	var topPos = this.myTab.ySize - 2 + "px";
	var leftPos = this.myTab.xSize + 4 + "px";

	var obj = c[0];
	this.myBkgd = obj;
	obj.frameObj = FrameObj;
	obj.frameObj();
	obj.style.top = topPos;

	this.xSize = gDevBkgdWidth+4+gDevBkgdLogExtra;
	obj.SetWidth(gDevBkgdWidth+gDevBkgdLogExtra);

	this.myBtns = c[2];
	this.myBtns.style.top = topPos;
	this.myBtns.style.left = leftPos;

	if (this.childNodes) c = c[2].childNodes;
	else c = c[2].children;
	leftPos = 8;

	obj = c[0];
	this.createBtn = obj;
	obj.btn2Obj = Btn2Obj;
	obj.btn2Obj();
	obj.myOwner = this;
	if (inOwner.ctlrFlags & 0x1000) {
		obj.style.visibility = "hidden";
	}
	else {
		obj.style.left = leftPos + "px";
		obj.eClick = hCreateBtnClick;
		leftPos += obj.xSize;
	}

	obj = c[1];
	this.modifyBtn = obj;
	if (inOwner.ctlrFlags & 0x200) {
		obj.btn2Obj = Btn2Obj;
		obj.btn2Obj();
		obj.myOwner = this;
		obj.style.left = leftPos + "px";
		obj.eClick = hModifyBtnClick;
		leftPos += obj.xSize;
	}
	else {
		obj.style.visibility = "hidden";
	}

	obj = c[2];
	this.deleteBtn = obj;
	obj.btn2Obj = Btn2Obj;
	obj.btn2Obj();
	obj.myOwner = this;
	obj.style.left = leftPos + "px";
	obj.eClick = hDeleteBtnClick;
	leftPos += obj.xSize + 30;

	if (this.childNodes) c = this.myContent.childNodes;
	else c = this.myContent.children;

	this.myContent.style.top = this.myTab.ySize + this.createBtn.ySize + "px";

	var h = this.createBtn.ySize;

	obj = this.topMgr;
	obj.logRowMgr = LogRowMgr;
	obj.logRowMgr(this, 0);
	h += obj.ySize;

	obj = this.secMgr;
	obj.logRowMgr = LogRowMgr;
	obj.logRowMgr(this, 1);
	if (gShowSec) h += obj.ySize;
	this.isSecShown = gShowSec;
	this.ShowSecs = LogMgrShowSecs;
	this.HideSecs = LogMgrHideSecs;

	this.bkgdHeight = h;
	this.ySize = h + this.myTab.ySize + 2;

	this.eSizeChange = hLogMgrSizeChange;
}

function hLogMgrSizeChange(inRowMgr, deltaY)
{
	this.ySize += deltaY;
	this.bkgdHeight += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	if (!inRowMgr.indexNum) this.secMgr.style.top = this.secMgr.offsetTop + deltaY + "px";
}

function LogMgrShowSecs()
{
	if (!this.isSecShown) {
		this.isSecShown = true;
		this.eSizeChange(this.secMgr, this.secMgr.ySize);
		this.secMgr.style.visibility = "inherit";
	}
}

function LogMgrHideSecs()
{
	if (this.isSecShown) {
		this.isSecShown = false;
		this.eSizeChange(this.secMgr, -this.secMgr.ySize);
		this.secMgr.style.visibility = "hidden";
	}
}

function hCreateBtnClick(evt)
{
	gCmdTipMgr.Stop(this);

	var logMgr = this.myOwner;
	var ctlrObj = logMgr.myOwner;

	if (gAction == gActNone) {
		this.SetOn();
		gWizObj.OpenWiz(ctlrObj, gWizObj.myCreateWiz);
	}
	else if ((gAction == gActCreateLog) && (gWizObj.curCtlr == ctlrObj)) {
		gWizObj.CloseWiz();
	}
	else {
		gInfoBox.Reminder(gInfoBox.cwAlerts[13]); //alert("**TEMP ALERT**\nAnother action is in progress.\nYou cannot create an array on this controller at this time.");
	}
}

function hModifyBtnClick(evt)
{
	gCmdTipMgr.Stop(this);

	var logMgr = this.myOwner;
	var ctlrObj = logMgr.myOwner;

	if (gAction == gActNone) {
		this.SetOn();
		gWizObj.OpenWiz(ctlrObj, gWizObj.myModifyWiz);
	}
	else if ((gAction == gActModifyLog) && (gWizObj.curCtlr == ctlrObj)) {
		gWizObj.CloseWiz();
	}
	else {
		gInfoBox.Reminder(gInfoBox.mwAlerts[13]); //alert("**TEMP ALERT**\nAnother action is in progress.\nYou cannot modify an array on this controller at this time.");
	}
}

function hDeleteBtnClick(evt)
{
	gCmdTipMgr.Stop(this);

	var logMgr = this.myOwner;
	var ctlrObj = logMgr.myOwner;

	if (gAction == gActNone) {
		this.SetOn();
		gWizObj.OpenWiz(ctlrObj, gWizObj.myDeleteWiz);
	}
	else if ((gAction == gActDeleteLog) && (gWizObj.curCtlr == ctlrObj)) {
		gWizObj.CloseWiz();
	}
	else {
		gInfoBox.Reminder(gInfoBox.dwAlerts[2]); //alert("**TEMP ALERT**\nAnother action is in progress.\nYou cannot delete arrays on this controller at this time.");
	}
}

//--------------------------------------
// LogRowMgr()
//--------------------------------------

var aaj=1; //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.

function LogRowMgr(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	var dStr;
	if (this.childNodes) {
		dStr = this.childNodes[0].childNodes[0].innerHTML.split(gSepChar);
		this.myRows = this.childNodes[3].childNodes;
	}
	else {
		dStr = this.children[0].children[0].innerHTML.split(gSepChar);
		var aj=GetPageElement("aaj"+ aaj++); //BRIAN: IE4's DOM descent is buggy and sometimes needs an explicitly identified node.
		this.myRows= aj.children; //BRIAN
	}

	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.numDevs = parseInt(dStr[i]);
				break;
			case 1:
				this.ySize = parseInt(dStr[i]);
				break;
		}
	}

	// Get the row objects
	this.myDevs = new Array();
	if (this.numDevs) {
		i = 0;
		var c = this.myRows;
		for (i=0; i<c.length; i++) {
			c[i].logMgr = inOwner;
			c[i].logRowObj = LogRowObj;
			c[i].logRowObj(this, i);
		}
	}
	else {
		this.myRows = null;
	}

	this.eSizeChange = hLogRowMgrSizeChange;
}

function hLogRowMgrSizeChange(inRow, deltaY)
{
	this.ySize += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	if (this.myRows) {
		var i;
		var c = this.myRows;
		for (i = inRow.indexNum + 1; i < c.length; i++) {
			c[i].style.top = c[i].offsetTop + deltaY + "px";
		}
	}
}


//--------------------------------------
// LogRowObj()
//--------------------------------------

function LogRowObj(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	this.isRolledDown = false;

	var imgs;
	var c;
	var i;
	var iMax;

	if (this.childNodes) {
		c = this.childNodes;
		imgs = c[1].childNodes;
		this.myDevs = c[2].childNodes;
	}
	else {
		c = this.children;
		imgs = c[1].children;
		this.myDevs = c[2].children;
	}

	this.growAmt = parseInt(c[0].innerHTML);

	c = this.myDevs;
	iMax = c.length;
	var ctlr = inOwner.myOwner.myOwner;
	var obj;
	for(i=0; i<iMax; i++) {
		obj = c[i];
		obj.devObj = DevObj;
		obj.devObj(this, i, null, null);
		inOwner.myDevs.Append(obj);
		obj.myCtlr = ctlr;
	}

	this.upImg = imgs[0];
	this.upImg.myOwner = this;

	this.dnImg = imgs[1];
	this.dnImg.myOwner = this;

	this.eRollUp = LogRowRollUp;
	this.eRollDown = LogRowRollDown;
}

function LogRowRollUp()
{
	this.upImg.style.visibility = "hidden";
	this.dnImg.style.visibility = "inherit";
	this.isRolledDown = false;

	var i;
	var c = this.myDevs;
	var iMax = c.length;
	var leftPos = 0;
	for (i=0; i<iMax; i++) {
		c[i].myIcon.HideText();
		c[i].style.top = "0px";
		c[i].style.left = leftPos + "px";
		leftPos += gIconWidth;
	}

	if (this.growAmt) this.myOwner.eSizeChange(this, -this.growAmt);
}

function LogRowRollDown()
{
	this.dnImg.style.visibility = "hidden";
	this.upImg.style.visibility = "inherit";
	this.isRolledDown = true;

	if (this.growAmt) this.myOwner.eSizeChange(this, this.growAmt);

	var i;
	var c = this.myDevs;
	var iMax = c.length;
	var topPos = 0;
	for (i=0; i<iMax; i++) {
		c[i].myIcon.ShowText();
		c[i].style.top = topPos + "px";
		c[i].style.left = "0px";
		topPos += gIconHeight;
	}
}


//----------------------------
// PhyMgrObj()
//----------------------------

//var gPhyText = 0;
//var gPhyFCap = 1;
//var gPhyRCap = 2;

var gRowHintsShown = false;

function PhyMgrObj(inOwner)
{
	this.myOwner = inOwner;

	var c = (this.childNodes) ? this.childNodes[0].childNodes : this.children[0].children;

	this.myTab = c[1];
	this.myTab.devTabObj = DevTabObj;
	this.myTab.devTabObj();

	var topPos = this.myTab.ySize - 2 + "px";
	var leftPos = this.myTab.xSize + 4 + "px";

	var obj = c[0];
	this.myBkgd = obj;
	obj.frameObj = FrameObj;
	obj.frameObj();
	obj.style.top = topPos;

	this.xSize = gDevBkgdWidth+4;
	obj.SetWidth(gDevBkgdWidth);

	this.myBtns = c[2];
	this.myBtns.style.top = topPos;
	this.myBtns.style.left = leftPos;

	if (this.childNodes) {
		c = c[2].childNodes;
		leftPos = c[0].childNodes[0].offsetWidth;
	}
	else {
		c = c[2].children;
		leftPos = c[0].children[0].offsetWidth;
	}
	this.myViewDiv = c[0];
	leftPos += 4;

	obj = c[1];
	this.textBtn = obj;
	obj.btn2Obj = Btn2Obj;
	obj.btn2Obj();
	obj.myOwner = this;
	obj.style.left = leftPos + "px";
	obj.eClick = hTextBtnClick;
	leftPos += obj.xSize;

	obj = c[2];
	this.fcapBtn = obj;
	obj.btn2Obj = Btn2Obj;
	obj.btn2Obj();
	obj.myOwner = this;
	obj.style.left = leftPos + "px";
	obj.eClick = hFCapBtnClick;
	leftPos += obj.xSize;

	obj = c[3];
	this.rcapBtn = obj;
	obj.btn2Obj = Btn2Obj;
	obj.btn2Obj();
	obj.myOwner = this;
	obj.style.left = leftPos + "px";
	obj.eClick = hRCapBtnClick;
	leftPos += obj.xSize + 30;

	obj = c[4];
	this.spareBtn = obj;
	if (inOwner.ctlrFlags & 0x6000) {
		obj.btn2Obj = Btn2Obj;
		obj.btn2Obj();
		obj.myOwner = this;
		var t = 232 - leftPos - obj.xSize;
		if (t < 0) {
			leftPos += (t < -20) ? -20 : t;
		}
		obj.style.left = leftPos + "px";
		obj.eClick = hSpareBtnClick;
	}
	else obj.style.visibility = "hidden";

	this.phyMode = 0;
	this.rowHintCntr = 1000;

	if (this.childNodes) {
		this.myContent = this.childNodes[1];
		c = this.myContent.childNodes;
	}
	else {
		this.myContent = this.children[1];
		c = this.myContent.children;
	}
	this.myContent.style.top = this.myTab.ySize + this.textBtn.ySize + "px";

	this.myRows = new Array();
	this.myChans = c;
	var i = 0;
	var h = this.textBtn.ySize;
	for (i=0; i<c.length; i++) {
		obj = c[i];
		obj.chanObj = ChanObj;
		obj.chanObj(this, i);
		h += obj.ySize;
	}

	this.bkgdHeight = h;
	this.ySize = h + this.myTab.ySize + 2;

	this.eSizeChange = hPhyMgrSizeChange;
	this.RowHintsOff = PhyMgrRowHintsOff;
}

function hPhyMgrSizeChange(inChan, deltaY)
{
	this.ySize += deltaY;
	this.bkgdHeight += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	var i;
	var c = this.myChans;
	for (i=inChan.indexNum + 1; i < c.length; i++) {
		c[i].style.top = c[i].offsetTop + deltaY + "px";
	}
}

function hSpareBtnClick()
{
	var phyMgr = this.myOwner;
	var ctlrObj = phyMgr.myOwner;

	if (gAction == gActNone) {
		this.SetOn();
		gWizObj.OpenWiz(ctlrObj, gWizObj.mySpareWiz);
	}
	else if ((gAction == gActSpare) && (gWizObj.curCtlr == ctlrObj)) {
		gWizObj.CloseWiz();
	}
	else {
		gInfoBox.Reminder(gInfoBox.swAlerts[5]); //alert("**TEMP ALERT**\nAnother action is in progress.\nYou cannot delete logical devices on this controller at this time.");
	}
}

function hTextBtnClick()
{
	gCmdTipMgr.Stop(this);

	var phyMgr = this.myOwner;

	if (phyMgr.phyMode != 0) {
		phyMgr.textBtn.SetOn();
		phyMgr.fcapBtn.SetOff();
		phyMgr.rcapBtn.SetOff();

		var i;
		var j;
		var jMax;
		var d;
		var r;
		var c = phyMgr.myRows;
		var hintsOn = false;
		if (c.numItems) { hintsOn = true; gRowHintsShown = true; phyMgr.rowHintCntr = 0; }
		for (i=0; i<c.numItems; i++) {
			r = c[i];
			r.phyMode = 0;
			if (r.isRolledDown) {
				r.fcapDiv.style.visibility = "hidden";
				r.rcapDiv.style.visibility = "hidden";
				d = r.myDevs;
				jMax = d.length;
				for (j=0; j<jMax; j++) d[j].myIcon.ShowText();
			}
			else if (hintsOn) gBlink.Start(r.hintImg);
		}
		phyMgr.phyMode = 0;
	}
}

function hFCapBtnClick()
{
	gCmdTipMgr.Stop(this);

	var phyMgr = this.myOwner;

	if (phyMgr.phyMode != 1) {
		phyMgr.textBtn.SetOff();
		phyMgr.fcapBtn.SetOn();
		phyMgr.rcapBtn.SetOff();

		var i;
		var j;
		var jMax;
		var d;
		var r;
		var c = phyMgr.myRows;
		var hintsOn = false;
		if (c.numItems) { hintsOn = true; gRowHintsShown = true; phyMgr.rowHintCntr = 0; }
		for (i=0; i<c.numItems; i++) {
			r = c[i];
			r.phyMode = 1;
			if (r.isRolledDown) {
				if (!phyMgr.phyMode) {
					d = r.myDevs;
					jMax = d.length;
					for (j=0; j<jMax; j++) d[j].myIcon.HideText();
				}
				r.fcapDiv.style.visibility = "inherit";
				r.rcapDiv.style.visibility = "hidden";
			}
			else if (hintsOn) gBlink.Start(r.hintImg);
		}
		phyMgr.phyMode = 1;
	}
}

function hRCapBtnClick()
{
	gCmdTipMgr.Stop(this);

	var phyMgr = this.myOwner;

	if (phyMgr.phyMode != 2) {
		phyMgr.textBtn.SetOff();
		phyMgr.fcapBtn.SetOff();
		phyMgr.rcapBtn.SetOn();

		var i;
		var j;
		var jMax;
		var d;
		var r;
		var hintsOn = false;
		var c = phyMgr.myRows;
		if (c.numItems) { hintsOn = true; gRowHintsShown = true; phyMgr.rowHintCntr = 0; }
		for (i=0; i<c.numItems; i++) {
			r = c[i];
			r.phyMode = 2;
			if (r.isRolledDown) {
				if (!phyMgr.phyMode) {
					d = r.myDevs;
					jMax = d.length;
					for (j=0; j<jMax; j++) d[j].myIcon.HideText();
				}
				r.fcapDiv.style.visibility = "hidden";
				r.rcapDiv.style.visibility = "inherit";
			}
			else if (hintsOn) gBlink.Start(r.hintImg);
		}
		phyMgr.phyMode = 2;
	}
}

function PhyMgrRowHintsOff()
{
	var i;
	var c = this.myRows;
	var iMax = c.numItems;
	for (i=0; i<iMax; i++) gBlink.StopOff(c[i].hintImg);
}

//--------------------------------------
//	DevTabObj()
//--------------------------------------

function DevTabObj()
{
	var w;
	var c;
	if (this.childNodes) {
		w = this.childNodes[1].childNodes[0].offsetWidth;
		c = this.childNodes[0].childNodes[0].childNodes;
	}
	else {
		w = this.children[1].children[0].offsetWidth;
		c = this.children[0].children[0].children;
		this.ySize = this.children[0].children[0].offsetHeight;
	}
	this.ySize = c[0].offsetHeight;
	this.xSize = c[0].offsetWidth + w + c[2].offsetWidth;
	c[1].width = w;
}

//--------------------------------------
// ChanObj()
//--------------------------------------

function ChanObj(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	var dStr;
	if (this.childNodes) {
		dStr = this.childNodes[0].childNodes[0].innerHTML.split(gSepChar);
		this.myIcon = this.childNodes[1];
		this.myRows = this.childNodes[2].childNodes;
	}
	else {
		dStr = this.children[0].children[0].innerHTML.split(gSepChar);
		this.myIcon = this.children[1];
		this.myRows = this.children[2].children;
	}

	var i = 0;
	for (i = 0; i < dStr.length; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
			case 1:
				this.numDevs = parseInt(dStr[i]);
				break;
			case 2:
				this.ySize = parseInt(dStr[i]);
				break;
			case 3:
				this.flags = parseInt(dStr[i]);
				break;
		}
	}

	this.myIcon.iconObj = IconObj;
	this.myIcon.iconObj(this);

	var leftPos = -2;
	var topPos = this.myIcon.ySize;

	// Get the row objects
	this.myDevs = new Array();
	if (this.numDevs) {
		i = 0;
		var c = this.myRows;
		for (i=0; i<c.length; i++) {
			c[i].phyRowObj = PhyRowObj;
			c[i].phyRowObj(this, i);
			c[i].phyMgr = inOwner;
			this.myOwner.myRows.Append(c[i]);
		}
	}
	else {
		this.myRows = null;
	}

	this.eSizeChange = hChanSizeChange;
	this.ClickOn = ChanClickOn;
	this.ClickOff = ChanClickOff;
}

function hChanSizeChange(inRow, deltaY)
{
	this.ySize += deltaY;

	this.myOwner.eSizeChange(this, deltaY);

	if (this.myRows) {
		var i;
		var c = this.myRows;
		for (i = inRow.indexNum + 1; i < c.length; i++) {
			c[i].style.top = c[i].offsetTop + deltaY + "px";
		}
	}
}

function ChanClickOn()
{
}


function ChanClickOff()
{
}


//--------------------------------------
// PhyRowObj()
//--------------------------------------

function PhyRowObj(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	this.isRolledDown = false;

	var imgs;
	var fcaps;
	var rcaps;
	var c;
	var i;
	var iMax;

	var ctlr = inOwner.myOwner.myOwner;
	if (this.childNodes) {
		c = this.childNodes;
		this.growAmt = parseInt(c[0].innerHTML);
		imgs = c[1].childNodes;
		this.fcapDiv = c[2];
		this.rcapDiv = c[3];
		this.myDevs = c[4].childNodes;

		fcaps = this.fcapDiv.childNodes;
		rcaps = this.rcapDiv.childNodes;
		c = this.myDevs;
		iMax = c.length;
		for(i=0; i<iMax; i++) {
			c[i].devObj = DevObj;
			c[i].devObj(this, i, fcaps[i].childNodes, rcaps[i].childNodes);
			c[i].myCtlr = ctlr;
		}
	}
	else {
		c = this.children;
		this.growAmt = parseInt(c[0].innerHTML);
		imgs = c[1].children;
		this.fcapDiv = c[2];
		this.rcapDiv = c[3];
		this.myDevs = c[4].children;

		fcaps = this.fcapDiv.children;
		rcaps = this.rcapDiv.children;
		c = this.myDevs;
		iMax = c.length;
		for(i=0; i<iMax; i++) {
			c[i].devObj = DevObj;
			c[i].devObj(this, i, fcaps[i].children, rcaps[i].children);
			c[i].myCtlr = ctlr;
		}
	}

	this.upImg = imgs[0];
	this.upImg.myOwner = this;

	this.dnImg = imgs[1];
	this.dnImg.myOwner = this;

	this.hintImg = imgs[2];

	this.phyMode = 0;

	this.eRollUp = RowObjRollUp;
	this.eRollDown = RowObjRollDown;
}

function RowObjRollUp()
{
	this.upImg.style.visibility = "hidden";
	this.dnImg.style.visibility = "inherit";
	this.isRolledDown = false;

	this.fcapDiv.style.visibility = "hidden";
	this.rcapDiv.style.visibility = "hidden";

	var i;
	var c = this.myDevs;
	var iMax = c.length;
	var leftPos = 0;
	for (i=0; i<iMax; i++) {
		c[i].myIcon.HideText();
		c[i].style.top = "0px";
		c[i].style.left = leftPos + "px";
		leftPos += gIconWidth;
	}

	if (this.growAmt) this.myOwner.eSizeChange(this, -this.growAmt);
}

function RowObjRollDown()
{
	this.dnImg.style.visibility = "hidden";
	this.upImg.style.visibility = "inherit";
	this.isRolledDown = true;

	if (this.phyMgr.rowHintCntr < 20) this.phyMgr.RowHintsOff();

	var d = this.phyMode;
	if (d == 1) this.fcapDiv.style.visibility = "inherit";
	else if (d == 2) this.rcapDiv.style.visibility = "inherit";

	if (this.growAmt) this.myOwner.eSizeChange(this, this.growAmt);

	var i;
	var c = this.myDevs;
	var iMax = c.length;
	var topPos = 0;
	for (i=0; i<iMax; i++) {
		if (!d) c[i].myIcon.ShowText();
		c[i].style.top = topPos + "px";
		c[i].style.left = "0px";
		topPos += gIconHeight;
	}
}

//--------------------------------------
// DevObj()
//--------------------------------------

function DevObj(inOwner, inIndex, fcapSegs, rcapSegs)
{
	this.myOwner = inOwner;
	this.indexNum = inIndex;

	var dStr;
	var a;
	var c;
	var obj;
	var i;
	var iMax;

	this.protA = new Array();
	this.assignA = new Array();
	this.compA = new Array();

	if (this.childNodes) {
		c = this.childNodes;
		if (c[0].childNodes.length > 1) {
			// List of arrays this hot-spare protects (skip the first bogus element)
			dStr = c[0].childNodes[1].innerHTML.split(gSepChar);
			iMax = dStr.length;
			a = this.protA;
			for (i=1; i<iMax; i++) a.Append(GetPageElement(dStr[i]));

			// List of arrays this hot-spare is assigned to (skip the first bogus element)
			dStr = c[0].childNodes[2].innerHTML.split(gSepChar);
			iMax = dStr.length;
			a = this.assignA;
			for (i=1; i<iMax; i++) {
				obj = GetPageElement(dStr[i]);
				obj.assignA.Append(this);
				a.Append(obj);
			}
		}
		dStr = c[0].childNodes[0].innerHTML.split(gSepChar);
		this.myIcon = c[1];
		this.mySegs = c[2].childNodes;
	}
	else { //BRIAN: IE4 now implemented.
		c = this.children;
		if (c[0].children.length > 1) {
			// List of arrays this hot-spare protects (skip the first bogus element)
			dStr = c[0].children[1].innerHTML.split(gSepChar);
			iMax = dStr.length;
			a = this.protA;
			for (i=1; i<iMax; i++) a.Append(GetPageElement(dStr[i]));

			// List of arrays this hot-spare is assigned to (skip the first bogus element)
			dStr = c[0].children[2].innerHTML.split(gSepChar);
			iMax = dStr.length;
			a = this.assignA;
			for (i=1; i<iMax; i++) {
				obj = GetPageElement(dStr[i]);
				obj.assignA.Append(this);
				a.Append(obj);
			}
		}
		dStr = c[0].children[0].innerHTML.split(gSepChar);
		this.myIcon = c[1];
		this.mySegs = c[2].children;
	}
	
	this.devType = 0;
	iMax = dStr.length;
	var ei = "i0";
	this.myEnc = null;
	for (i=0; i<iMax; i++) {
		switch (i) {
			case 0:
				this.smbeId = dStr[i];
				break;
			case 1:
				this.status = dStr[i];
				break;
			case 2:
				this.logType = dStr[i];
				break;
			case 3:
				this.isSpare = parseInt(dStr[i]);
				break;
			case 4:
				this.canArray = parseInt(dStr[i]);
				break;
			case 5:
				this.isSecLevel = parseInt(dStr[i]);
				break;
			case 6:
				this.protCriteria = parseInt(dStr[i]);
				break;
			case 7:
				this.numBlks = parseInt(dStr[i]);
				break;
			case 8:
				this.ssNum = parseInt(dStr[i]);
				break;
			case 9:
				this.devType = parseInt(dStr[i]);
				break;
			case 10:
				ei = dStr[i];
				break;
			case 11:
				this.aTask = parseInt(dStr[i]);
				break;
			case 12:
				this.dsName = dStr[i];
				break;
			case 13:
				this.isClusteredBus = parseInt(dStr[i]);
				break;
			case 14:
				this.numUsedSegs = parseInt(dStr[i]);
				break;
			case 15:
				this.hasPart = parseInt(dStr[i]);
				break;
		}
	}

	if (ei != "i0") {
		var e = GetPageElement(ei, true);
		if (e) {
			e.AddEncDev = DevAddEncDev;
			e.AddEncDev(this);
		}
	}
	if (typeof(this.encDevs)=="undefined") this.encDevs = null;

	// Initialize the icon object
	this.myIcon.iconObj = IconObj;
	this.myIcon.iconObj(this);

	this.rselSegs = new Array();
	this.mwOrigSeg = null;

	c = this.mySegs;
	iMax = c.length;
	this.bigFree = null;
	var mb = 0;
	for (i=0; i<iMax; i++) {
		obj = c[i];
		obj.segObj = SegObj;
		if (fcapSegs && !this.devType) obj.segObj(this, i, fcapSegs[i], rcapSegs[i]);
		else obj.segObj(this, i, null, null);
		if (obj.segType==0 && obj.numBlocks > mb) { this.bigFree = obj; mb = obj.numBlocks; }
	}
	this.SegsISelOn = DevSegsISelOn;
	this.SegsISelOff = DevSegsISelOff;
	this.CompsISelOn = DevCompsISelOn;
	this.CompsISelOff = DevCompsISelOff;
	this.EncISelOn = DevEncISelOn;
	this.EncISelOff = DevEncISelOff;

	this.CompsDelOn = DevCompsDelOn;
	this.CompsDelOff = DevCompsDelOff;
	this.CompsRSelOn = DevCompsRSelOn;
	this.CompsRSelOff = DevCompsRSelOff;
/*
	this.SegsHiOn = DevSegsHiOn;
	this.SegsHiOff = DevSegsHiOff;
	this.CompsHiOn = DevCompsHiOn;
	this.CompsHiOff = DevCompsHiOff;
*/
	this.ClickOn = DevClickOn;
	this.ClickOff = DevClickOff;

	this.AddEncDev = DevAddEncDev;
}

function DevAddEncDev(d)
{
	if ((typeof(this.encDevs)=="undefined") || (this.encDevs == null)) this.encDevs = new Array();
	this.encDevs.Append(d);
	d.myEnc = this;
}

function DevEncISelOn()
{
	if (this.encDevs) {
		var i;
		var d = this.encDevs;
		for (i=0; i<d.length; i++) d[i].myIcon.ISelOn();
	}
	if (this.myEnc) this.myEnc.myIcon.ISelOn();
}

function DevEncISelOff()
{
	if (this.encDevs) {
		var i;
		var d = this.encDevs;
		for (i=0; i<d.length; i++) d[i].myIcon.ISelOff();
	}
	if (this.myEnc) this.myEnc.myIcon.ISelOff();
}

function DevSegsISelOn()
{
	var i;
	var s = this.mySegs;
	var dev;
	for (i = 0; i < s.length; i++) {
		dev = s[i].myParent;
		if (dev) {
			dev.myIcon.ISelOn();
			dev.SegsISelOn();
		}
	}
}

function DevSegsISelOff()
{
	var i;
	var s = this.mySegs;
	var dev;
	for (i = 0; i < s.length; i++) {
		dev = s[i].myParent;
		if (dev) {
			dev.myIcon.ISelOff();
			dev.SegsISelOff();
		}
	}
}

function DevCompsISelOn()
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.ISelOn();
			dev.CompsISelOn();
		}
		if (seg.myIcon) seg.myIcon.ISelOn();
	}
}

function DevCompsISelOff()
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.ISelOff();
			dev.CompsISelOff();
		}
		if (seg.myIcon) seg.myIcon.ISelOff();
	}
}

function DevCompsDelOn()
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			if (dev.isSecLevel) dev.myIcon.DelOn();
			dev.CompsDelOn();
		}
		if (seg.myIcon) seg.myIcon.DelOn();
	}
}

function DevCompsDelOff()
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			if (dev.isSecLevel) dev.myIcon.DelOff();
			dev.CompsDelOff();
		}
		if (seg.myIcon) seg.myIcon.DelOff();
	}
}

function DevCompsRSelOn(inList)
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.RSelOn();
			dev.CompsRSelOn(inList);
		}
		if (seg.myIcon) {
			seg.myIcon.RSelOn();
			inList.Append(seg);
			seg.isMWOrig = true;
			dev.rselSegs.Append(seg);
			dev.mwOrigSeg = seg;
		}
	}
}

function DevCompsRSelOff()
{
	var i;
	var c = this.compA;
	var dev;
	var seg;
	for (i=0; i<c.numItems; i++) {
		seg = c[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.RSelOff();
			dev.CompsRSelOff();
		}
		if (seg.myIcon) {
			seg.myIcon.RSelOff();
			seg.isMWOrig = false;
			dev.rselSegs.numItems = 0;
			dev.mwOrigSeg = null;
		}
	}
}

/*
function DevSegsHiOn()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.hiBkgd.Show();
			dev.SegsHiOn();
		}
	}
}

function DevSegsHiOff()
{
	var i;
	var dev;
	for (i = 0; i < this.mySegs.numItems; i++) {
		dev = this.mySegs[i].myParent;
		if (dev) {
			dev.myIcon.hiBkgd.Hide();
			dev.SegsHiOff();
		}
	}
}

function DevCompsHiOn()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.hiBkgd.Show();
			dev.CompsHiOn();
		}
		if (seg.fullSeg) {
			seg.fullSeg.hiBkgd.Show();
		}
		if (seg.relSeg) {
			seg.relSeg.hiBkgd.Show();
		}
	}
}

function DevCompsHiOff()
{
	var i;
	var dev;
	var seg;
	for (i = 0; i < this.myComps.numItems; i++) {
		seg = this.myComps[i];
		dev = seg.myOwner;
		if (dev) {
			dev.myIcon.hiBkgd.Hide();
			dev.CompsHiOff();
		}
		if (seg.fullSeg) {
			seg.fullSeg.hiBkgd.Hide();
		}
		if (seg.relSeg) {
			seg.relSeg.hiBkgd.Hide();
		}
	}
}
*/

function DevClickOn()
{
	this.SegsISelOn();
	this.CompsISelOn();
	this.EncISelOn();

/*
	if (gHiMode == gHiDeep) {
		this.SegsHiOff();
		this.CompsHiOff();
	}
*/
	var i;
	var a = this.protA;
	var iMax = a.numItems;
	for (i=0; i<iMax; i++) {
		a[i].myIcon.ProtOn();
		if (gHiMode == gHiDeep) a[i].myIcon.HiOff();
	}
}

function DevClickOff()
{
	this.SegsISelOff();
	this.CompsISelOff();
	this.EncISelOff();

	var i;
	var a = this.protA;
	var iMax = a.numItems;
	for (i=0; i<iMax; i++) a[i].myIcon.ProtOff();
}

//--------------------------------------
// SegObj()
//--------------------------------------

function SegObj(inOwner, inIndex, fcapSeg, rcapSeg)
{
	this.myOwner = inOwner;
	this.myParent = null;
	this.myIndex = inIndex;
	this.devIcon = inOwner.myIcon;

	this.isMWOrig = false;

	this.protA = new Array();

	var c = (this.childNodes) ? this.childNodes : this.children;
	var dStr = c[0].innerHTML.split(gSepChar);
	
	var i;
	var iMax = dStr.length;
	for (i=0; i<iMax; i++) {
		switch (i) {
			case 0:
				this.smbeId = parseInt(dStr[i]);
				break;
			case 1:
				this.segType = parseInt(dStr[i]);
				break;
			case 2:
				this.startBlock = parseInt(dStr[i]);
				break;
			case 3:
				this.numBlocks = parseInt(dStr[i]);
				break;
			case 4:
				this.stripeSize = parseInt(dStr[i]);
				break;
			case 5:
				this.parentId = dStr[i];
				break;
		}
	}
	if (this.parentId != "i0") {
		this.myParent = GetPageElement(this.parentId);
		this.myParent.compA.Append(this);
	}

	if (c.length > 1) {
		dStr = c[1].innerHTML.split(gSepChar);
		iMax = dStr.length;
		var a = this.protA;
		var obj;
		for (i=1; i<iMax; i++) {
			obj = GetPageElement(dStr[i]);
			a.Append(obj);
			obj.protA.Append(this);
		}
	}

	this.myIcon = fcapSeg;
	this.fcapSeg = fcapSeg;
	this.rcapSeg = rcapSeg;
	if (fcapSeg) {
		var flen;
		var rlen;
		if (fcapSeg.childNodes) {
			flen = fcapSeg.childNodes.length;
			rlen = rcapSeg.childNodes.length;
		}
		else {
			flen = fcapSeg.children.length;
			rlen = rcapSeg.children.length;
		}
		if (flen>1) { //flen==1 occurs with phantom drives (no visSegObj)
			fcapSeg.visSegObj = VisSegObj;
			fcapSeg.visSegObj(this);
			fcapSeg.devIcon = inOwner.myIcon;
		}
		else {
			this.fcapSeg = null;
			this.myIcon = null;
		}

		if (rlen>1) { //rlen==1 occurs with phantom drives (no visSegObj)
			rcapSeg.visSegObj = VisSegObj;
			rcapSeg.visSegObj(this);
			rcapSeg.devIcon = inOwner.myIcon;
			rcapSeg.mirSeg = fcapSeg;
			fcapSeg.mirSeg = rcapSeg;
		}
		else this.rcapSeg = null;
	}

	this.ClickOn = SegClickOn;
	this.ClickOff = SegClickOff;

	this.isBlinking = false;
	this.StartBlink = SegStartBlink;
	this.StopBlink = SegStopBlink;
	this.SetMainImg = SegSetMainImg;
	this.SetISelImg = SegSetISelImg;
	this.SetSelImg = SegSetSelImg;
	this.SetTipContent = SegSetTipContent;
}

function SegSetMainImg(inImg)
{
	if (this.fcapSeg) {
		this.fcapSeg.cylImgs[0].src = inImg;
		if (this.rcapSeg) this.rcapSeg.cylImgs[0].src = inImg;
	}
}

function SegSetISelImg(inImg)
{
	if (this.fcapSeg) {
		this.fcapSeg.cylImgs[3].src = inImg;
		if (this.rcapSeg) this.rcapSeg.cylImgs[3].src = inImg;
	}
}

function SegSetSelImg(inImg)
{
	if (this.fcapSeg) {
		this.fcapSeg.cylImgs[4].src = inImg;
		if (this.rcapSeg) this.rcapSeg.cylImgs[4].src = inImg;
	}
}

function SegSetTipContent(inText)
{
	if (!this.fcapSeg) return;

	var t = this.fcapSeg.myTip;
	if (!t.toolTip) {
		t.toolTip = ToolTip;
		t.toolTip(3);
	}
	t.SetContent(inText);

	if (this.rcapSeg) {
		t = this.rcapSeg.myTip;
		if (!t.toolTip) {
			t.toolTip = ToolTip;
			t.toolTip(3);
		}
		t.SetContent(inText);
	}
}

function SegClickOn(inSeg)
{
	var o = this.myOwner;
	o.myIcon.SelOn();
	if (o.myEnc) o.myEnc.myIcon.ISelOn();

	if (this.myParent) {
		this.myParent.myIcon.ISelOn();
		this.myParent.SegsISelOn();
	}

	var i;
	var a = this.protA;
	var iMax = a.numItems;
	for (i=0; i<iMax; i++) {
		a[i].myIcon.ProtOn();
		if (gHiMode == gHiDeep) a[i].myIcon.HiOff();
	}
}

function SegClickOff(inSeg)
{
	var o = this.myOwner;
	o.myIcon.SelOff();
	if (o.myEnc) o.myEnc.myIcon.ISelOff();

	if (this.myParent) {
		this.myParent.myIcon.ISelOff();
		this.myParent.SegsISelOff();
	}

	var i;
	var a = this.protA;
	var iMax = a.numItems;
	for (i=0; i<iMax; i++) a[i].myIcon.ProtOff();
}

function SegStartBlink()
{
	if (!this.isBlinking) {
		this.isBlinking = true;
		this.devIcon.isBlinking = true;
		gBlink.Start(this.devIcon.rselImg);
		if (this.fcapSeg) gBlink.Start(this.fcapSeg.rselImg);
		if (this.rcapSeg) gBlink.Start(this.rcapSeg.rselImg);
	}
}

function SegStopBlink()
{
	if (this.isBlinking) {
		this.isBlinking = false;
		this.devIcon.isBlinking = false;
		gBlink.StopOn(this.devIcon.rselImg);
		if (this.fcapSeg) gBlink.StopOn(this.fcapSeg.rselImg);
		if (this.rcapSeg) gBlink.StopOn(this.rcapSeg.rselImg);
	}
}

//-------------------------------------
// VisSegObj()
//-------------------------------------

function VisSegObj(inOwner, inIndex)
{
	this.myOwner = inOwner;
	this.myIndex = inIndex;

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		this.cylImgs = c[0].childNodes;
		this.endImgs = c[1].childNodes;
		this.rselMid = c[0].childNodes[1].childNodes[0].childNodes[1];
		this.rselImg = c[3];
		this.iconDiv = c[2];
		this.myTip = c[4];
		c[5].myOwner = this;
		c[5].mySeg = inOwner;
		c = c[2].childNodes;
	}
	else {
		c = this.children;
		this.cylImgs = c[0].children;
		this.endImgs = c[1].children;
		this.rselMid = c[0].children[1].children[0].children[1];
		this.rselImg = c[3];
		this.iconDiv = c[2];
		this.myTip = c[4];
		c[5].myOwner = this;
		c[5].mySeg = inOwner;
		c = c[2].children;
	}
	this.isFullRSel = true;
	this.isTextShown = false;
	this.mirSeg = null;
	this.hsImg = c[0];
	this.delImg = c[1];
	this.sselImg = c[2];

	//this.myTip.toolTip = ToolTip;
	//this.myTip.toolTip(3);

	this.ProtOn = VisSegProtOn;
	this.ProtOff = VisSegProtOff;
	this.ISelOn = VisSegISelOn;
	this.ISelOff = VisSegISelOff;
	this.SelOn = VisSegSelOn;
	this.SelOff = VisSegSelOff;
	this.RSelOn = VisSegRSelOn;
	this.RSelOff = VisSegRSelOff;
	this.RSelWidth = VisSegRSelWidth;
	this.HiOn = VisSegHiOn;
	this.HiOff = VisSegHiOff;
	this.DelOn = VisSegDelOn;
	this.DelOff = VisSegDelOff;

	this.BaseClick = IconClick;
	this.eClick = VisSegClick;
	this.eMouseOver = VisSegTipInit;
	this.eMouseOut = IconMouseOut;
}

function VisSegClick(evt)
{
	if (gAction && gWizObj.curWiz) gWizObj.curWiz.eSegClick(this.myOwner);
	this.BaseClick(evt);
}

function VisSegTipInit()
{
	this.eMouseOver = IconMouseOver;

	var t = this.myTip;
	if (t && !t.toolTip) {
		t.toolTip = ToolTip;
		t.toolTip(3);
	}
	this.eMouseOver();
}
function VisSegProtOn()
{
	this.cylImgs[2].style.visibility = "inherit";
	this.endImgs[2].style.visibility = "inherit";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[2].style.visibility = "inherit";
		this.mirSeg.endImgs[2].style.visibility = "inherit";
	}
	this.devIcon.ProtOn();
}
function VisSegProtOff()
{
	this.cylImgs[2].style.visibility = "hidden";
	this.endImgs[2].style.visibility = "hidden";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[2].style.visibility = "hidden";
		this.mirSeg.endImgs[2].style.visibility = "hidden";
	}
	this.devIcon.ProtOff();
}

function VisSegISelOn()
{
	this.cylImgs[3].style.visibility = "inherit";
	this.endImgs[3].style.visibility = "inherit";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[3].style.visibility = "inherit";
		this.mirSeg.endImgs[3].style.visibility = "inherit";
	}
}
function VisSegISelOff()
{
	this.cylImgs[3].style.visibility = "hidden";
	this.endImgs[3].style.visibility = "hidden";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[3].style.visibility = "hidden";
		this.mirSeg.endImgs[3].style.visibility = "hidden";
	}
}

function VisSegSelOn()
{
	this.cylImgs[4].style.visibility = "inherit";
	this.endImgs[4].style.visibility = "inherit";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[4].style.visibility = "inherit";
		this.mirSeg.endImgs[4].style.visibility = "inherit";
	}
}
function VisSegSelOff()
{
	this.cylImgs[4].style.visibility = "hidden";
	this.endImgs[4].style.visibility = "hidden";
	if (this.mirSeg) {
		this.mirSeg.cylImgs[4].style.visibility = "hidden";
		this.mirSeg.endImgs[4].style.visibility = "hidden";
	}
}

function VisSegRSelOn()
{
	this.cylImgs[1].style.visibility = "inherit";
	this.rselImg.style.visibility = "inherit";
	if (this.isFullRSel) this.endImgs[1].style.visibility = "inherit";
	this.iconDiv.style.visibility = "hidden";
	var m = this.mirSeg;
	if (m) {
		m.cylImgs[1].style.visibility = "inherit";
		m.rselImg.style.visibility = "inherit";
		if (m.isFullRSel) m.endImgs[1].style.visibility = "inherit";
		m.iconDiv.style.visibility = "hidden";
	}
}
function VisSegRSelOff()
{
	this.cylImgs[1].style.visibility = "hidden";
	this.rselImg.style.visibility = "hidden";
	this.endImgs[1].style.visibility = "hidden";
	this.iconDiv.style.visibility = "inherit";
	var ib = this.myOwner.isBlinking;
	if (ib) gBlink.StopOff(this.rselImg);
	var m = this.mirSeg;
	if (m) {
		m.cylImgs[1].style.visibility = "hidden";
		m.rselImg.style.visibility = "hidden";
		if (m.isFullRSel) m.endImgs[1].style.visibility = "hidden";
		m.iconDiv.style.visibility = "inherit";
		if (ib) gBlink.StopOff(m.rselImg);
	}
}

function VisSegHiOn()
{
	gHiObj = this;
	this.cylImgs[5].style.visibility = "inherit";
	this.endImgs[5].style.visibility = "inherit";
}
function VisSegHiOff()
{
	if (gHiObj && gHiObj!=this) gHiObj.eMouseOut();
	gHiObj = null;
	this.cylImgs[5].style.visibility = "hidden";
	this.endImgs[5].style.visibility = "hidden";
}
function VisSegRSelWidth(inW)
{
	this.rselMid.width = inW;
	inW = 2 + (inW >> 1) - (gIconWidth >> 1);
	this.rselImg.style.left = inW + "px";
}

function VisSegDelOn()
{
	this.delImg.style.visibility = "inherit";
	if (this.mirSeg) this.mirSeg.delImg.style.visibility = "inherit";
}
function VisSegDelOff()
{
	this.delImg.style.visibility = "hidden";
	if (this.mirSeg) this.mirSeg.delImg.style.visibility = "hidden";
}
