Name: iANS
Summary: for Linux
Version: 3.0.2
Source: iANS-3.0.2.tar.gz
Release: 1
Vendor: Intel Corporation
License: Proprietary
ExclusiveOS: linux
Group: System Environment/Kernel
Requires: kernel                                                               
Provides: %{name} = %{version}-%{release}
URL: http://support.intel.com/support/go/linux/ans.htm
BuildRoot: /tmp/%{name}-%{version}-root

%description
This package contains the Intel(R) Advanced Network Services driver for Linux.
The driver provides advanced features including: Adapter Fault Tolerance,
Switch Fault Tolerance, Adaptive Load Balancing on transmit, IPv4 Receive
Load Balancing, FEC/GEC/802.3ad Link Aggregation, 802.3ac VLAN tagging,
Dynamic VLAN configuration with GVRP standard and Zero Copy support.

%prep
%setup

%build
mkdir -p %{buildroot}

SwitchRHKernel () {
	CFLAGS_EXTRA=""
	for K in $2 ; do
		if [ $K == $1 ] ; then
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=1"
		else
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=0"
		fi
	done
}

KV=$(uname -r)

KSP="/lib/modules/$KV/build
     /usr/src/linux-$KV
     /usr/src/linux-$(echo $KV | sed 's/-.*//')
     /usr/src/kernel-headers-$KV
     /usr/src/kernel-source-$KV
     /usr/src/linux-$(echo $KV | sed 's/\([0-9]*\.[0-9]*\)\..*/\1/')
     /usr/src/linux"

KSRC=$(for d in $KSP ; do [ -e $d/include/linux ] && echo $d; echo;  done)
KSRC=$(echo $KSRC | awk '{ print $1 }')

if [ -e $KSRC/include/linux/rhconfig.h ] ; then
	RHKL=$(grep 'BOOT_KERNEL_.* [01]' /boot/kernel.h | sed 's/.*BOOT_KERNEL_\(.*\) [01]/\1/')
	for K in $RHKL ; do
		if [ "$K" = "BIGMEM" ] ; then
			HAVE_BIGMEM=1
		fi
		if [ "$K" = "HUGEMEM" ] ; then
			HAVE_HUGEMEM=1
		fi
	done			
	for K in $RHKL ; do
		if [ "$K" = "ENTERPRISE" -a  "$HAVE_BIGMEM" ]; then
			continue
		fi
		if [ "$K" = "BIGMEM" -a "$HAVE_HUGEMEM" ]; then
			continue
		fi
		SwitchRHKernel $K "$RHKL"
		make -C src veryclean
		make -C src INSTALL_ROOT=%{buildroot} \
			MAN_DIR=%{_mandir} CFLAGS_EXTRA="$CFLAGS_EXTRA" install
	done
else
	make -C src veryclean
	make -C src INSTALL_ROOT=%{buildroot} MAN_DIR=%{_mandir} install
fi

%install
cd %{buildroot}
find . -name modules.* -exec rm -f {} \;
find . -type f -fprintf %{_builddir}/%{name}-%{version}/file.list "/%p\n"

%clean
rm -rf %{buildroot}

%files -f %{_builddir}/%{name}-%{version}/file.list
%defattr(-,root,root)
%doc LICENSE
%doc README
%doc ldistrib.txt
%doc file.list

%post
uname -r | grep BOOT || /sbin/depmod -aqs > /dev/null 2>&1 || true

%postun
uname -r | grep BOOT || /sbin/depmod -aqs > /dev/null 2>&1 || true
