#! /bin/bash

# v1.3

# Script for installing new modules

# get kernel version
KERNEL_VER=`uname -r`
KERNEL_MAJOR=`echo $KERNEL_VER | cut -d . -f1,2`
NO_ARCH="0"
BAD_ARCH="0"
BAD_MODULES="0"
SYS_ARCH=`arch`
CUR_DATE=`date +%F-%T`

# check for correct directory
NEWMOD_DIR=`ls | grep ^$KERNEL_VER$`
if [ -z $NEWMOD_DIR ]; then
	# exit if bad directory structure
	echo "This script requires the modules to be installed to be located in the $KERNEL_VER directory. NO MODULES were installed."
	exit
fi
if [ $NEWMOD_DIR = $KERNEL_VER ] && [ -d $NEWMOD_DIR ]; then
	cd $KERNEL_VER
	if [ $KERNEL_MAJOR = "2.6" ]; then
		# get list of modules
		MODULES=`ls *.ko`
	else
		MODULES=`ls *.o`
	fi
	for i in $MODULES;do
		# check kernel and arch vs each module echo message if any fail
		if [ $KERNEL_MAJOR = "2.6" ]; then
			MODULES_KERN_VER=`strings $i | grep vermagic | cut -d"=" -f2 | cut -d" " -f1`
		else
			MODULES_KERN_VER=`strings $i | grep kernel_version | head -1 | cut -d "=" -f2`
		fi
		DRIVER_ARCH=`file $i | cut -d"," -f2 | sed s/^" "//`
		case "$DRIVER_ARCH" in
			"AMD x86-64")
              			DRIVER_ARCH=x86_64
              			;;
			"Intel 80386")
              			DRIVER_ARCH=i686
              			;;
			"IA-64 (Intel 64 bit architecture)")
              			DRIVER_ARCH=ia64
              			;;
			"IA-64")
              			DRIVER_ARCH=ia64
              			;;
			*)
			echo "Driver arch for $i could not be deterimined"
			let NO_ARCH++
		esac
		if [ $DRIVER_ARCH != $SYS_ARCH ]; then
			echo "$i is compiled for $DRIVER_ARCH. System arch is $SYS_ARCH."
			let BAD_ARCH++
		fi
		if [ $KERNEL_VER != $MODULES_KERN_VER ]; then
			echo "Driver $i is built for $MODULES_KERN_VER and running kernel is $KERNEL_VER"
			let BAD_MODULES++
		fi
	done
	# exit without installing any modules if any tests failed
	if [[ $BAD_MODULES != "0" ]] || [[ $NO_ARCH != "0" ]] || [[ $BAD_ARCH != "0" ]]; then
		echo "NO MODULES were installed due to the problems listed above"
	exit
	fi
else
	# exit if bad directory structure
	echo "This script requires the modules to be installed to be located in the $KERNEL_VER directory. NO MODULES were installed."
	exit
fi
# make directory for to save original modules
mkdir -p /root/drivers.orig/$CUR_DATE >& /dev/null
# move original modules, install new ones
for i in $MODULES; do
	MODULES_DIR=`find /lib/modules/$KERNEL_VER/kernel -name $i -print | grep -v orig | sed s?$i??`
		if [ $MODULES_DIR ]; then
			mv -f /$MODULES_DIR/$i /root/drivers.orig/$CUR_DATE
			install -D -m 644 $i $MODULES_DIR/$i
			echo "$i installed in $MODULES_DIR"
		else
			MODULES_DIR=/lib/modules/$KERNEL_VER/kernel/drivers/addon
			mkdir -p $MODULES_DIR > /dev/null 2>&1
			install -D -m 644 $i $MODULES_DIR/$i
			echo "$i installed in $MODULES_DIR"
		fi
done
depmod -e $KERNEL_VER > /dev/null 2>&1
echo "New `echo $MODULES` modules installed and ready for loading"
