#include <linux/config.h>
#include <linux/version.h>
#include <linux/module.h>

#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/module.h>
#include <linux/errno.h>

#include <linux/mm.h>
#include <linux/vmalloc.h>
#include <linux/mman.h>
//#include <linux/wrapper.h>	//v26
#include <linux/slab.h>
#include <asm/io.h>
#include <asm/uaccess.h>	//v26

int wrap_register_chrdev(unsigned int major, const char *name,
		struct file_operations *fops);
int wrap_unregister_chrdev(unsigned int major, const char *name);

void wrap_mem_map_reserve(struct page *ptr);
void wrap_mem_map_unreserve(struct page *ptr);

int wrap_remap_page_range(struct vm_area_struct *vma, unsigned long from,
		unsigned long to, unsigned long size, pgprot_t prot);
struct page *wrap_virt_to_page(unsigned long addr);

void *wrap_kmalloc(size_t size, int nmemb);
void wrap_kfree(void *ptr);
int wrap_printk(const char *fmt, ...);
