//
// MOD2NTK Conversor [aka "Adapter" =] routines v0.1b
//
// Currently loads: M.K.,M!K!,FLT4 & 4CHM modules.
// [31 Instrument, 15 Instrument not supported]
//
// J. Arguelles
//

void LoadAmigaMod(void)
{
SongStop();
mess_box("Attempting to load the AMIGA-MOD module file...");

int t_hi;
int t_lo;

Sleep(1000);	
FILE *in;
in = fopen(name,"rb");

if (in!=NULL)
{

mess_box("Loading 'MOD' file -> Header");	

FreeAll();

for (int inicial=0;inicial<PBLEN;inicial+=6)
{
	*(RawPatterns+inicial)=121;//121
	*(RawPatterns+inicial+1)=255;//255
	*(RawPatterns+inicial+2)=255;//255
	*(RawPatterns+inicial+3)=255;//255
	*(RawPatterns+inicial+4)=0;//0
	*(RawPatterns+inicial+5)=0;//0
}

init_sample_bank();
Iniplayer();

fread(name, sizeof( char ), 20,in);

mess_box("Loading 'MOD' file -> Sample data");	

for (int swrite=1;swrite<32;swrite++)
{
SampleType[swrite][0]=1;
fread(&nameins[swrite], sizeof( char ), 19,in);
sprintf(SampleName[swrite][0], "%s ",nameins[swrite]);

// Jump 3 unhandled bytes for NTK samplename.
fseek(in,3,SEEK_CUR);

SampleNumSamples[swrite][0]=(int)fgetc(in)+(int)fgetc(in)*256;
SampleNumSamples[swrite][0]*=2;
fread(&Finetune[swrite][0], sizeof(char ),1,in);
Finetune[swrite][0]*=16;
CustomVol[swrite]=(float)fgetc(in)*0.015625f;
SampleVol[swrite][0]=1.0f;

SampleType[swrite][0]=0; // NO SAMPLE

// Calculate/Adapt AMIGA loop points to ntk LoopPoints:

LoopStart[swrite][0]=((int)fgetc(in)+(int)fgetc(in)*256)*2;
long Replen=((int)fgetc(in)+(int)fgetc(in)*256)*2;

if (Replen>2)
{
LoopEnd[swrite][0]=LoopStart[swrite][0]+Replen;
LoopType[swrite][0]=1;
}
else
{
LoopEnd[swrite][0]=SampleNumSamples[swrite][0]-1;
LoopType[swrite][0]=0;
}

if(LoopEnd[swrite][0]>=SampleNumSamples[swrite][0])
LoopEnd[swrite][0]=SampleNumSamples[swrite][0]-1;

// I dunno, but with some MOD files
// I have to dec 1 position [sample] to the
// start loop position to get correct looping points from MOD 
// to NTK songs when LoopEnd equals to SampleLen-1 [?]
// Maybe due to the NTK sampler archichecture.
/*
if(LoopEnd[swrite][0]==SampleNumSamples[swrite][0]-1)
{
LoopStart[swrite][0]--;
if (LoopStart[swrite][0]<0)LoopStart[swrite][0]=0;
}
*/

}// FOR

fread(&sLength, sizeof(unsigned char ), 1,in);
fgetc(in);

// PATTERN PROGRESSION;
nPatterns=1;

for (int tps=0;tps<128;tps++)
{
pSequence[tps]=fgetc(in);
if(pSequence[tps]>=nPatterns)nPatterns=pSequence[tps]+1;
patternLines[tps]=64;
}

// JUMP THE HEADER
fseek(in,4,SEEK_CUR);

mess_box("Loading 'MOD' file -> Converting patterns...");	

for (int pwrite=0;pwrite<nPatterns;pwrite++)
{
for (int li2=0;li2<64;li2++)
{
for (int pw2=0;pw2<4;pw2++)
{
int tmo=(pwrite*12288)+(li2*96)+(pw2*6);
int f_byte=fgetc(in);
int t_sample=f_byte/16;
int t_period=(f_byte-(t_sample*16))*256+(int)fgetc(in);
int t_byte=fgetc(in);
int t_sample2=t_byte/16;
int t_command=t_byte-(t_sample2*16);
t_sample=t_sample*16+t_sample2;
if (t_sample==0)t_sample=255;

int t_note=121;
int t_argu=fgetc(in);

//Period Conversion Table

switch(t_period)
{
case 1712: t_note=1;break;
case 1616: t_note=2;break;
case 1524: t_note=3;break;
case 1440: t_note=4;break;
case 1356: t_note=5;break;
case 1280: t_note=6;break;
case 1208: t_note=7;break;
case 1140: t_note=8;break;
case 1076: t_note=9;break;
case 1016: t_note=10;break;
case 960: t_note=11;break;
case 906: t_note=12;break;
case 856: t_note=13;break;
case 808: t_note=14;break;
case 762: t_note=15;break;
case 720: t_note=16;break;
case 678: t_note=17;break;
case 640: t_note=18;break;
case 604: t_note=19;break;
case 570: t_note=20;break;
case 538: t_note=21;break;
case 508: t_note=22;break;
case 480: t_note=23;break;
case 453: t_note=24;break;
case 428: t_note=25;break;
case 404: t_note=26;break;
case 381: t_note=27;break;
case 360: t_note=28;break;
case 339: t_note=29;break;
case 320: t_note=30;break;
case 302: t_note=31;break;
case 285: t_note=32;break;
case 269: t_note=33;break;
case 254: t_note=34;break;
case 240: t_note=35;break;
case 226: t_note=36;break;
case 214: t_note=37;break;
case 202: t_note=38;break;
case 190: t_note=39;break;
case 180: t_note=40;break;
case 170: t_note=41;break;
case 160: t_note=42;break;
case 151: t_note=43;break;
case 143: t_note=44;break;
case 135: t_note=45;break;
case 127: t_note=46;break;
case 120: t_note=47;break;
case 113: t_note=48;break;
case 107: t_note=49;break;
case 101: t_note=50;break;
case 95: t_note=51;break;
case 90: t_note=52;break;
case 85: t_note=53;break;
case 75: t_note=54;break;
case 71: t_note=55;break;
case 67: t_note=56;break;
case 63: t_note=57;break;
case 60: t_note=58;break;
case 56: t_note=59;break;
}

if (t_note!=121)t_note-=6;

*(RawPatterns+tmo)=t_note;
*(RawPatterns+tmo+1)=t_sample;

// Pattern effect adapter:

switch(t_command)
{
// SPEED [not accurate]
case 15:
	if(t_argu>31)t_command=240;
	else
	switch(t_argu){
	case 1:t_argu=16;break;
    case 2:t_argu=12;break;
	case 3:t_argu=8;break;
	case 4:t_argu=6;break;
	case 5:t_argu=5;break;
	case 6:t_argu=4;break;
	case 7:t_argu=3;break;
	case 8:t_argu=3;break;
	case 9:t_argu=3;break;
	case 10:t_argu=3;break;
	case 11:t_argu=3;break;
	case 12:t_argu=2;break;
	case 24:t_argu=1;break;}
break;

// GLIDE
case 3:
t_command=5;
break;

// VIBRATO [Not supported by NTK, ntk wansnt to sound like a violin :P ].
case 4:
t_command=0;
t_argu=0;
break;

// NO TREMOLO TOO
case 6:
t_command=0;
t_argu=0;
break;

// Volume Sliders

case 10:
if(t_argu>=16)
{
t_command=25; // Vol SlideUp
t_argu=(t_command-16)*2;
}
else
{
t_command=26; // Vol Slide Down
t_argu*=2;
}

break;

// Pattern Jump Amiga Mod stylee
case 13:

t_hi=t_argu/16;
t_lo=t_argu-t_hi*16;
t_argu=t_hi*10+t_lo;

break;

// EXX Special Effects [no full implementation of all Protracker MOD Exx commands]
case 14:
t_command=0;

// FINEVOLUME SLIDEUP.
if (t_argu>160 && t_argu<176)
{
	t_command=25;
	t_argu=t_argu-160;
}

// FINEVOLUME SLIDEDOWN.
if (t_argu>176 && t_argu<192)
{
	t_command=26;
	t_argu=t_argu-176;
}

// NOTE RETRIGGER
if (t_argu>144 && t_argu<160)
{
	t_command=14;
	t_argu=t_argu-144;
}

// NOTE CUT
if (t_argu>192 && t_argu<208)*(RawPatterns+tmo+2)=t_argu-48;
break;

// DEMOSYNCHRO SIGNAL???
case 8:
t_command=7;
break;

// VOLUME 
case 12:
t_command=3;
t_argu*=8;
if(t_argu>255)t_argu=255;
break;
}// Pattern FX adapter end.

*(RawPatterns+tmo+4)=t_command;
*(RawPatterns+tmo+5)=t_argu;
}
}
}

mess_box("Loading 'MOD' file -> Loading/converting sample data...");	

for (swrite=1;swrite<32;swrite++)
{
if(SampleNumSamples[swrite][0]>8)
{
SampleChannels[swrite][0]=1;
SampleType[swrite][0]=1;

// Reserving space for 16-Bit Signed Short Data.

RawSamples[swrite][0][0]=(short *)malloc((SampleNumSamples[swrite][0]*2));
for (int x=0;x<SampleNumSamples[swrite][0];x++)
*(RawSamples[swrite][0][0]+x)=(short)fgetc(in)*256;
}
else
SampleType[swrite][0]=0; // NO SAMPLE
}

//Track Properties:

// JEJE =] Stereo separation, with a little 'mono-feeling stuff added, no extrict panning:]'
TPan[0]=0.1f;
TPan[1]=0.9f;
TPan[2]=0.8f;
TPan[3]=0.2f;
ComputeStereo(0);
ComputeStereo(1);
ComputeStereo(2);
ComputeStereo(3);

BeatsPerMin=125;
TicksPerBeat=4;
mas_vol=0.75f;
Songtracks=4;
QUALITYPLAY=2; // <-----Hey, Amiga was in a great quality anyway! =]
AMIMODE=true;
fclose(in);

ped_track=0;
ped_patsam=1;
ped_row=0;
ped_line=0;
cPosition=0;
gui_track=0;
lchorus_counter=44100;
rchorus_counter=44100;
lchorus_counter2=44100-lchorus_delay;
rchorus_counter2=44100-rchorus_delay;
Initreverb();

Actualize_Sequencer();
Actualize_Patterned();
Actualize_Master(0);
if(userscreen!=8)
{userscreen=0;draw_mained();Actualize_Main_Ed();}
mess_box("[AMIGAMOD] NTK Level 0 Song File loaded [Standard 16 Channel Mod, No Effects, Low CPU usage]");
Actualize_Master(4);
}
else
{
mess_box("Module loading failed. (Probably: file not found)");
}

if (snamesel==1 || snamesel==4 || snamesel==5)
{
	snamesel=0;
	if(userscreen!=8)Actualize_Main_Ed();
}

}
void Actualize_303(char gode)
{

if (gode==1) /* Copy 303 surface */
S->copy(SKIN303,80,332,0,0,510,114);
}

void draw_303ed(void)
{
guiDial(112,309,64,16,"Track FX",200);
guiDial(178,309,64,16,"Midi/CSynth",200);
guiDial(244,309,64,16,"Master",200);
guiDial(310,309,64,16,"Sequencer",200);
guiDial(376,309,64,16,"Disk IO",200);
guiDial(442,309,64,16,"Track",200);
guiDial(508,309,64,16,"Instrument",200);
guiDial(574,309,64,16,"FX Setup",200);
guiDial(640,309,64,16,"Extend Edit",200);
guiDial(706,309,64,16,"303",100);
guiDial2("303s Gear");

guiDial(8,346,64,16,"Reset Pat.",200);
guiDial(8,364,64,16,"Clear Pat.",200);
guiDial(8,382,64,16,"Rnd.NoteOn",200);
guiDial(8,400,64,16,"Rand.Tones",200);
guiDial(8,418,64,16,"Rand.Flags",200);

S->endDraw();
S->copy(SKIN303,80,332,0,0,510,114);
Actualize_303ed(0);
}

void Actualize_303ed(char gode)
{
	S->endDraw();

	if(gode==0 || gode==1)number303(tb303[sl3].patternlength[tb303[sl3].selectedpattern],118,428);

	if(gode==0)
	{
	// Selected bassline
	if(sl3)
	{
	Skincopy(578,413,138,119,3,3);
	Skincopy(558,413,143,119,3,3);
	}
	else
	{
	Skincopy(558,413,138,119,3,3);
	Skincopy(578,413,143,119,3,3);
	}
	number303(tbEditStep+1,486,358);
	// Displaying pattern selection leds
	// Bank [A-D]
	int tbank303=tb303[sl3].selectedpattern/8;
	tbank303*=15;
	// Restoring background
	S->copy(SKIN303,86,398,6,66,65,80);
	// Light the bank
	S->copy(SKIN303,87+tbank303,398,16+tbank303,117,28+tbank303,130);
	// Displaying pattern selection leds
	// Pattern [1-8]
	int tpat303=tb303[sl3].selectedpattern-(tb303[sl3].selectedpattern/8)*8;
	// Restoring background
	S->copy(SKIN303,86,356,6,24,65,54);
	// Light the bank
	if(tpat303<4)
	{
	Skincopy(86+tpat303*15,356,75+tpat303*15,117,14,14);
	}
	else
	{
	tpat303-=4;
	Skincopy(86+tpat303*15,371,75+tpat303*15,132,14,14);
	}
	}

	if(gode==0 || gode==2)
	{
	// Displaying waveform switch
	if(tb303[sl3].waveform)
	Skincopy(180,344,137,135,13,8);
	else
	Skincopy(180,344,137,125,13,8);
	}

	// Draw 303 Knobs

	if(gode==0 || gode==3)knob1(229,348, tb303[sl3].tune/2);
	if(gode==0 || gode==4)knob1(262,348, tb303[sl3].cutoff/2);
	if(gode==0 || gode==5)knob1(295,348, tb303[sl3].resonance/2);
	if(gode==0 || gode==6)knob1(328,348, tb303[sl3].envmod/2);
	if(gode==0 || gode==7)knob1(361,348, tb303[sl3].decay/2);
	if(gode==0 || gode==8)knob1(394,348, tb303[sl3].accent/2);

	if(gode==0 || gode==9){
	// Restoring Notepad notebackground
	Skincopy(200,387,120,55,162,34);
	// Light Note
	switch(tb303[sl3].tone[tb303[sl3].selectedpattern][tbEditStep])
	{
	case 0:Skincopy(208,415,138,119,3,3);break;
	case 1:Skincopy(220,390,138,119,3,3);break;
	case 2:Skincopy(229,415,138,119,3,3);break;
	case 3:Skincopy(241,390,138,119,3,3);break;
	case 4:Skincopy(250,415,138,119,3,3);break;
	case 5:Skincopy(271,415,138,119,3,3);break;
	case 6:Skincopy(283,390,138,119,3,3);break;
	case 7:Skincopy(292,415,138,119,3,3);break;
	case 8:Skincopy(304,390,138,119,3,3);break;
	case 9:Skincopy(313,415,138,119,3,3);break;
	case 10:Skincopy(325,390,138,119,3,3);break;
	case 11:Skincopy(334,415,138,119,3,3);break;
	case 12:Skincopy(355,415,138,119,3,3);break;
	}
	}

	if(gode==0 || gode==10){
	// Light pause/note led
	if(tb303[sl3].flag[tb303[sl3].selectedpattern][tbEditStep].pause)
	{	
	Skincopy(402,393,138,119,3,3);
	Skincopy(439,393,143,119,3,3);
	}
	else
	{	
	Skincopy(402,393,143,119,3,3);
	Skincopy(439,393,138,119,3,3);
	}}

	if(gode==0 || gode==11)
	{
	// Light slide/off led
	if(tb303[sl3].flag[tb303[sl3].selectedpattern][tbEditStep].slide_flag)
	Skincopy(456,416,138,119,3,3);
	else
	Skincopy(456,416,143,119,3,3);
	}

	if(gode==0 || gode==12)
	{
	// Light accent/off led
	if(tb303[sl3].flag[tb303[sl3].selectedpattern][tbEditStep].accent_flag)
	Skincopy(431,416,138,119,3,3);
	else
	Skincopy(431,416,143,119,3,3);
	}

	if(gode==0 || gode==13)
	{
	// Transpose up flag
	if(tb303[sl3].flag[tb303[sl3].selectedpattern][tbEditStep].transposeup_flag)
	Skincopy(406,416,138,119,3,3);
	else
	Skincopy(406,416,143,119,3,3);
	}

	// Transpose down flag

	if(gode==0 || gode==14)
	{
	if(tb303[sl3].flag[tb303[sl3].selectedpattern][tbEditStep].transposedown_flag)
	Skincopy(381,416,138,119,3,3);
	else
	Skincopy(381,416,143,119,3,3);
	}

	// Volume

	if(gode==0 || gode==15)
	{
	Skincopy(529,357,449,25,19,88);
	int tb303v=f2i(tb303engine[sl3].tbVolume*74);
	Skincopy(531,430-tb303v,1,116,14,12);
	}

	if(gode==0 || gode==16)
	{
	// Light hpf led
	if(tb303engine[sl3].hpf)
	Skincopy(181,401,138,119,3,3);
	else
	Skincopy(181,401,143,119,3,3);
	}

}

void number303(unsigned char number,int x,int y)
{
	switch(number)
	{
	case 0:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,156,118,163,133);break;
	case 1:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,164,118,171,133);break;
	case 2:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,172,118,179,133);break;
	case 3:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,180,118,187,133);break;
	case 4:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,188,118,195,133);break;
	case 5:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,196,118,203,133);break;
	case 6:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,204,118,211,133);break;
	case 7:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,212,118,219,133);break;
	case 8:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,220,118,227,133);break;
	case 9:S->copy(SKIN303,x,y,156,118,163,133);S->copy(SKIN303,x+8,y,228,118,235,133);break;
	case 10:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,156,118,163,133);break;
	case 11:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,164,118,171,133);break;
	case 12:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,172,118,179,133);break;
	case 13:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,180,118,187,133);break;
	case 14:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,188,118,195,133);break;
	case 15:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,196,118,203,133);break;
	case 16:S->copy(SKIN303,x,y,164,118,171,133);S->copy(SKIN303,x+8,y,204,118,211,133);break;
	}
}

void Skincopy(int xd,int yd,int xs,int ys,int w,int h)
{
S->copy(SKIN303,xd,yd,xs,ys,xs+w,ys+h);
}

void knob1(int x, int y, unsigned char number)
{
if(number>62)number=62;
S->copy(KNOB1,x,y,number*25,0,number*25+24,24);
}

void LoadRebirthMod(void)
{
mess_box("Importing 303 data from .RBS Propellerhead's Rebith v2.0 song file...");
FILE *in;
in = fopen(name,"rb");

if (in!=NULL)
{

mess_box("Loading 'RBS' file -> 303Data");

fseek(in,1676,SEEK_SET);
fread(&tb303[0].enabled,sizeof (char),1,in);
fread(&tb303[0].selectedpattern,sizeof (char),1,in);
fread(&tb303[0].tune,sizeof (char),1,in);
fread(&tb303[0].cutoff,sizeof (char),1,in);
fread(&tb303[0].resonance,sizeof (char),1,in);
fread(&tb303[0].envmod,sizeof (char),1,in);
fread(&tb303[0].decay,sizeof (char),1,in);
fread(&tb303[0].accent,sizeof (char),1,in);
fread(&tb303[0].waveform,sizeof (char),1,in);

for(char rn=0;rn<32;rn++)
{
	fseek(in,1,SEEK_CUR);// Jump unhandled 'shuffle'

	fread(&tb303[0].patternlength[rn],sizeof (char),1,in);

	for(char rn2=0;rn2<16;rn2++)
	{
	fread(&tb303[0].tone[rn][rn2],sizeof (char),1,in);
	fread(&tb303[0].flag[rn][rn2],sizeof (char),1,in);
	tb303[0].flag[rn][rn2].pause=!tb303[0].flag[rn][rn2].pause;
	}
}

// Second bassline:

fseek(in,2782,SEEK_SET);
fread(&tb303[1].enabled,sizeof (char),1,in);
fread(&tb303[1].selectedpattern,sizeof (char),1,in);
fread(&tb303[1].tune,sizeof (char),1,in);
fread(&tb303[1].cutoff,sizeof (char),1,in);
fread(&tb303[1].resonance,sizeof (char),1,in);
fread(&tb303[1].envmod,sizeof (char),1,in);
fread(&tb303[1].decay,sizeof (char),1,in);
fread(&tb303[1].accent,sizeof (char),1,in);
fread(&tb303[1].waveform,sizeof (char),1,in);

for(rn=0;rn<32;rn++)
{
	fseek(in,1,SEEK_CUR);// Jump unhandled 'shuffle'

	fread(&tb303[1].patternlength[rn],sizeof (char),1,in);

	for(char rn2=1;rn2<16;rn2++)
	{
	fread(&tb303[1].tone[rn][rn2],sizeof (char),1,in);
	fread(&tb303[1].flag[rn][rn2],sizeof (char),1,in);
	tb303[1].flag[rn][rn2].pause=!tb303[1].flag[rn][rn2].pause;
	}
}

mess_box("Rebirth v2.0 303 Data loaded...");

if(userscreen==9){S->endDraw();Actualize_303ed(0);}

fclose(in);
}
else
{
mess_box("File load failed...");	
}

}