/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DKnob
extends JComponent {
    private static final float START = 225.0f;
    private static final float LENGTH = 270.0f;
    private static final float START_ANG = 3.926991f;
    private static final float LENGTH_ANG = 4.712389f;
    private static final float LENGTH_ANG_DIV10 = 0.47076812f;
    private static final float MULTIP = 57.295776f;
    private static final Color DEFAULT_FOCUS_COLOR = new Color(0x8080FF);
    private int SHADOWX = 1;
    private int SHADOWY = 1;
    private float DRAG_SPEED;
    private float CLICK_SPEED;
    private int size;
    private int middle;
    public static final int SIMPLE = 1;
    public static final int ROUND = 2;
    public static final int SIMPLE_MOUSE_DIRECTION = 3;
    private int dragType = 2;
    public static final int DEFAULT_WIDTH = 60;
    public static final int DEFAULT_HEIGHT = 45;
    private static final Dimension MIN_SIZE = new Dimension(40, 40);
    private static final Dimension PREF_SIZE = new Dimension(60, 45);
    private static final float MID_OFFSET = 0.0045454544f;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private Arc2D hitArc = new Arc2D.Float(2);
    private float ang = 3.926991f;
    private float val;
    private int dragpos = -1;
    private float startVal;
    private Color focusColor;
    private double lastAng;
    private int mWidth;
    private int mHeight;
    private String mValueAsString;

    public DKnob() {
        this(60, 45);
    }

    public DKnob(int aWidth, int aHeight) {
        this.mWidth = aWidth;
        this.mHeight = aHeight;
        this.DRAG_SPEED = 0.0075f;
        this.CLICK_SPEED = 0.01f;
        this.SHADOWX = 1;
        this.SHADOWY = 1;
        this.focusColor = DEFAULT_FOCUS_COLOR;
        this.setPreferredSize(PREF_SIZE);
        this.hitArc.setAngleStart(235.0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                DKnob.this.dragpos = me.getX() + me.getY();
                DKnob.this.startVal = DKnob.this.val;
                int xpos = DKnob.this.middle - me.getX();
                int ypos = DKnob.this.middle - me.getY();
                DKnob.this.lastAng = Math.atan2(xpos, ypos);
                DKnob.this.requestFocus();
            }

            public void mouseClicked(MouseEvent me) {
                DKnob.this.hitArc.setAngleExtent(-290.0);
                if (DKnob.this.hitArc.contains(me.getX(), me.getY())) {
                    DKnob.this.hitArc.setAngleExtent(57.295776f * (DKnob.this.ang - 3.926991f) - 10.0f);
                    if (DKnob.this.hitArc.contains(me.getX(), me.getY())) {
                        DKnob.this.decValue();
                    } else {
                        DKnob.this.incValue();
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent me) {
                float speed = DKnob.this.DRAG_SPEED;
                if ((me.getModifiersEx() & 0x1800) != 0) {
                    speed /= 10.0f;
                }
                if ((me.getModifiersEx() & 0x80) != 0) {
                    speed /= 10.0f;
                }
                if ((me.getModifiersEx() & 0x40) != 0) {
                    speed /= 10.0f;
                }
                if (DKnob.this.dragType == 1) {
                    float f = speed * (float)(me.getX() + me.getY() - DKnob.this.dragpos);
                    DKnob.this.setValue(DKnob.this.startVal + f);
                } else if (DKnob.this.dragType == 3) {
                    float f = speed * (float)(me.getX() + me.getY() - DKnob.this.dragpos);
                    DKnob.this.setValue(DKnob.this.startVal - f);
                } else if (DKnob.this.dragType == 2) {
                    int xpos = DKnob.this.middle - me.getX();
                    int ypos = DKnob.this.middle - me.getY();
                    double ang = Math.atan2(xpos, ypos);
                    double diff = DKnob.this.lastAng - ang;
                    DKnob.this.setValue((float)((double)DKnob.this.getValue() + diff / 4.71238899230957));
                    DKnob.this.lastAng = ang;
                }
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k == 39) {
                    DKnob.this.incValue();
                } else if (k == 37) {
                    DKnob.this.decValue();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DKnob.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                DKnob.this.mValueAsString = null;
                DKnob.this.repaint();
            }
        });
    }

    public void setDragType(int type) {
        this.dragType = type;
    }

    public int getDragType() {
        return this.dragType;
    }

    public boolean isFocusable() {
        return true;
    }

    private void incValue() {
        this.setValue(this.val + this.CLICK_SPEED);
    }

    private void decValue() {
        this.setValue(this.val - this.CLICK_SPEED);
    }

    public float getValue() {
        return this.val;
    }

    public void setValue(float val) {
        if (val < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        this.val = val;
        this.ang = 3.926991f - 4.712389f * val;
        this.repaint();
        this.fireChangeEvent();
    }

    public void setValueAsString(String aStrValue) {
        this.mValueAsString = aStrValue;
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void paint(Graphics g) {
        if (this.isEnabled()) {
            int width = this.mWidth;
            int height = this.mHeight;
            this.size = width - 22;
            int oSizeDiv2 = this.size / 2;
            int oOffset = 5;
            this.middle = oOffset + oSizeDiv2;
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setBackground(this.getParent().getBackground());
                g2d.addRenderingHints(AALIAS);
                this.hitArc.setFrame(4.0, 4.0, this.size + 12, this.size + 12);
            }
            for (float a2 = 3.926991f; a2 >= -0.785398f; a2 -= 0.47076812f) {
                int x = oOffset + oSizeDiv2 + (int)((double)(6 + oSizeDiv2) * Math.cos(a2));
                int y = oOffset + oSizeDiv2 - (int)((double)(6 + oSizeDiv2) * Math.sin(a2));
                g.drawLine(oOffset + oSizeDiv2, oOffset + oSizeDiv2, x, y);
            }
            if (this.hasFocus()) {
                g.setColor(this.focusColor);
            } else {
                g.setColor(Color.white);
            }
            g.fillOval(oOffset, oOffset, this.size, this.size);
            g.setColor(Color.gray);
            g.fillOval(oOffset + 4 + this.SHADOWX, oOffset + 4 + this.SHADOWY, this.size - 8, this.size - 8);
            g.setColor(Color.black);
            g.drawArc(oOffset, oOffset, this.size, this.size, 315, 270);
            g.fillOval(oOffset + 4, oOffset + 4, this.size - 8, this.size - 8);
            g.setColor(Color.white);
            double oCos = Math.cos(this.ang);
            double oSin = Math.sin(this.ang);
            int dx = (int)(2.0 * oSin);
            int dy = (int)(2.0 * oCos);
            int x = oOffset + oSizeDiv2 + (int)((double)oSizeDiv2 * oCos);
            int y = oOffset + oSizeDiv2 - (int)((double)oSizeDiv2 * oSin);
            int s2 = Math.max(this.size / 6, 6);
            g.setColor(Color.gray);
            g.drawOval(oOffset + s2, oOffset + s2, this.size - s2 * 2 - 1, this.size - s2 * 2 - 1);
            int[] xPoints = new int[]{oOffset + dx + oSizeDiv2, x + dx, x - dx, oOffset - dx + oSizeDiv2};
            int[] yPoints = new int[]{oOffset + dy + oSizeDiv2, y + dy, y - dy, oOffset - dy + oSizeDiv2};
            if ((double)this.val > 0.4954545455984771 && (double)this.val < 0.5045454544015229) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillPolygon(xPoints, yPoints, 4);
            g.fillOval(oOffset + oSizeDiv2 - 1, oOffset + oSizeDiv2 - 1, 2, 2);
            if (this.mValueAsString != null) {
                g.setColor(Color.white);
                g.drawString(this.mValueAsString, oSizeDiv2 - 5, height - 10);
            }
        }
    }
}

