/*
 * Decompiled with CFR 0.152.
 */
package com.frinika;

import com.frinika.VersionProperties;
import com.frinika.project.gui.ProjectFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class AboutDialog
extends JDialog {
    public static final char C = '\u00a9';
    public static final String MAIN_TITLE = "<html><center><b>Frinika version " + VersionProperties.getVersion() + " </b><br>" + "http://frinika.sourceforge.net<br><font color='#A0A0A0'><i>Build date: " + VersionProperties.getBuildDate() + "</i></font>" + "</html>";
    public static final String COPYRIGHT_NOTICE = "<html><center>Copyright \u00a9 " + VersionProperties.getCopyrightStart() + "-" + VersionProperties.getCopyrightEnd() + " The Frinika developers. All rights reserved<br>" + "This software is licensed under the GNU General Public License (GPL) version 2<br>" + "http://www.gnu.org/licenses/gpl.htm" + "</html>";
    public static final String CREDITS = "<html><h2>The team behind Frinika:</h2>Peter Johan Salomonsen - Initiative, sequencer, audiodriver, soft synths, tracker, maintenance and more<br>Jon Aakerstrom - Audiodriver, JACK integration<br>P.J. Leonard - Pianoroll, partview, overall GUI and sequence objects design and more<br>Karl Helgason - RasmusDSP, flexdock, jmod integration with Frinika and more<br>Toni (oc2pus@arcor.de) - Ant build scripts and Linux RPMs<br>Steve Taylor - Toot integration<br>Jens Gulden - Ghosts parts, Midi Tools menu, step recording, ctrl tools, scripting and more<br><br><b>Libraries:</b><br>JJack Copyright \u00a9 Jens Gulden<br>RasmusDSP Copyright \u00a9 Karl Helgason<br>Toot audio foundation - Steve Taylor<br>Tritonus Copyright \u00a9 by Florian Bomers and Matthias Pfisterer<br>launch4j - Cross-platform Java executable wrapper - http://launch4j.sourceforge.net/<br>jgoodies - Look and feel - https://looks.dev.java.net/<br>flexdock - Floating and dockable windows - https://flexdock.dev.java.net/<br>Java Sound MODules Library - http://jmod.dev.java.net<br>Rhino JavaScript engine - http://www.mozilla.org/rhino/<br>LZMA SDK - http://www.7-zip.org/sdk.html<br>jVorbisEnc - Zbigniew Sudnik - XIPHOPHORUS, http://www.xiph.org/<br>MRJ Adapter - http://homepage.mac.com/sroy/mrjadapter/<br><br><b>Other contributors:</b><br>Bob Lang - Bezier synth (http://www.cems.uwe.ac.uk/~lrlang/BezierSynth/index.html)<br>Edward H - GUI decoration patches<br>Artur Rataj (arturrataj@gmail.com) - Pianoroll patches<br>Thibault Aspe - French locale (http://thibault.aspe.free.fr/)<br><br></html>";
    private static final long serialVersionUID = 1L;
    int sel = 0;
    int ix = 0;

    public void showLicense() {
        JPanel panel = new JPanel();
        JTextComponent licenseAgreement = null;
        try {
            InputStream is = ClassLoader.getSystemResource("COPYING").openStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (is.available() > 0) {
                bos.write(is.read());
            }
            licenseAgreement = new JTextArea(new String(bos.toByteArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Couldn't find license agreement.. Exiting.");
            System.exit(0);
        }
        licenseAgreement.setEditable(false);
        ((JTextArea)licenseAgreement).setRows(20);
        JScrollPane licenseScrollPane = new JScrollPane(licenseAgreement, 22, 31);
        panel.add(licenseScrollPane);
        JOptionPane.showMessageDialog(this, panel, "License", 1, new ImageIcon(new BufferedImage(1, 1, 2)));
    }

    public void whitening(Container co) {
        Component[] comps = co.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JOptionPane) {
                comps[i].setBackground(Color.WHITE);
            }
            if (comps[i] instanceof JPanel) {
                comps[i].setBackground(Color.WHITE);
            }
            if (!(comps[i] instanceof Container)) continue;
            this.whitening((Container)comps[i]);
        }
    }

    public void showCredits() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel(CREDITS);
        JScrollPane scrollPane = new JScrollPane(label, 22, 31);
        label.setFont(label.getFont().deriveFont(11.0f).deriveFont(0));
        panel.add(label);
        JOptionPane op = new JOptionPane(panel, 1);
        op.setIcon(new ImageIcon(new BufferedImage(1, 1, 2)));
        JDialog dialog = op.createDialog(this, "Credits");
        dialog.setBackground(Color.WHITE);
        this.whitening(dialog);
        dialog.setVisible(true);
    }

    public void showSystemInfo() {
        Properties p = System.getProperties();
        Object[][] ss = new String[p.size()][2];
        int i = 0;
        for (Object o : new TreeSet<Object>(p.keySet())) {
            String s = (String)o;
            String value = p.getProperty(s);
            ss[i][0] = s;
            ss[i][1] = value;
            ++i;
        }
        JTable systemInfo = new JTable(ss, new String[]{"Entry", "Value"});
        systemInfo.setEnabled(false);
        JOptionPane.showMessageDialog(this, new JScrollPane(systemInfo), "System Info", 1, new ImageIcon(new BufferedImage(1, 1, 2)));
    }

    public AboutDialog(JFrame parent) {
        super(parent);
        this.setUndecorated(true);
        this.setModal(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.WHITE);
        ImageIcon welcome = new ImageIcon(ProjectFrame.class.getResource("/frinika.png"));
        JLabel label = new JLabel(welcome);
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        label.setFont(label.getFont().deriveFont(0));
        label.setText(MAIN_TITLE);
        label.setBorder(BorderFactory.createEmptyBorder(25, 5, 5, 5));
        panel.add((Component)label, "North");
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel contentpane = new JPanel();
        contentpane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        contentpane.setLayout(new BorderLayout());
        contentpane.add(panel);
        this.setContentPane(contentpane);
        JPanel buttonpanel = new JPanel();
        buttonpanel.setOpaque(false);
        JButton button = new JButton("License");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.showLicense();
            }
        });
        buttonpanel.add(button);
        button = new JButton("Credits");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.showCredits();
            }
        });
        buttonpanel.add(button);
        button = new JButton("System Info");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.showSystemInfo();
            }
        });
        buttonpanel.add(button);
        button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.setVisible(false);
            }
        });
        button.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(button);
        buttonpanel.add(button);
        panel.add((Component)buttonpanel, "Center");
        JPanel copyrightpanel = new JPanel();
        copyrightpanel.setOpaque(false);
        JLabel line = new JLabel(COPYRIGHT_NOTICE);
        line.setHorizontalTextPosition(0);
        line.setFont(line.getFont().deriveFont(10.0f).deriveFont(0));
        copyrightpanel.add(line);
        panel.add((Component)copyrightpanel, "South");
        this.setTitle("Welcome");
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        panel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.setVisible(false);
            }
        }, stroke, 2);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        if (gc == null) {
            gc = this.getGraphicsConfiguration();
        }
        Rectangle windowSize = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension size = this.getSize();
        Point parent_loc = this.getLocation();
        this.setLocation(parent_loc.x + windowSize.width / 2 - size.width / 2, parent_loc.y + windowSize.height / 2 - size.height / 2);
    }
}

