/*
 * Decompiled with CFR 0.152.
 */
package com.frinika;

import com.frinika.AboutDialog;
import com.frinika.project.gui.ProjectFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SplashDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    int sel = 0;
    int ix = 0;
    JProgressBar processbar = new JProgressBar();
    private static SplashDialog splash = null;
    int cloud_width;
    JLabel light_label;
    JLabel light_cloud1;
    JLabel light_cloud2;
    Thread animation;

    public JProgressBar getProgressBar() {
        return this.processbar;
    }

    public static SplashDialog getInstance() {
        if (splash == null) {
            splash = new SplashDialog();
        }
        return splash;
    }

    public static boolean isSplashVisible() {
        if (splash == null) {
            return false;
        }
        return splash.isVisible();
    }

    public static void showSplash() {
        SplashDialog splash = SplashDialog.getInstance();
        splash.setVisible(true);
        splash.animation.start();
    }

    public static void closeSplash() {
        if (splash == null) {
            return;
        }
        splash.setVisible(false);
        splash = null;
    }

    public static void main(String[] args) {
        SplashDialog.showSplash();
    }

    public SplashDialog() {
        BufferedImage mask;
        this.processbar.setMinimum(0);
        this.processbar.setMaximum(100);
        this.animation = new Thread(){
            boolean active = true;
            Runnable gui = new Runnable(){

                public void run() {
                    Point loc1 = SplashDialog.this.light_cloud1.getLocation();
                    --loc1.x;
                    if (loc1.x < -SplashDialog.this.cloud_width) {
                        loc1.x += 2 * SplashDialog.this.cloud_width;
                    }
                    SplashDialog.this.light_cloud1.setLocation(loc1);
                    Point loc2 = SplashDialog.this.light_cloud2.getLocation();
                    --loc2.x;
                    if (loc2.x < -SplashDialog.this.cloud_width) {
                        loc2.x += 2 * SplashDialog.this.cloud_width;
                    }
                    SplashDialog.this.light_cloud2.setLocation(loc2);
                    Point loc = SplashDialog.this.light_label.getLocation();
                    loc.x += 3;
                    if (loc.x > 350) {
                        loc.x = -400;
                    }
                    SplashDialog.this.light_label.setLocation(loc);
                    if (!SplashDialog.this.isVisible()) {
                        active = false;
                    }
                }
            };

            public void run() {
                while (this.active) {
                    this.gui.run();
                    try {
                        Thread.sleep(70L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.setUndecorated(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.WHITE);
        ImageIcon welcome = new ImageIcon(ProjectFrame.class.getResource("/frinika.png"));
        JLabel label = new JLabel(welcome);
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        label.setFont(label.getFont().deriveFont(0));
        label.setText(AboutDialog.MAIN_TITLE);
        label.setBorder(BorderFactory.createEmptyBorder(25, 5, 5, 5));
        panel.add((Component)label, "North");
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel contentpane = new JPanel();
        contentpane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        contentpane.setLayout(new BorderLayout());
        contentpane.add(panel);
        this.setContentPane(contentpane);
        panel.add(this.processbar);
        JPanel copyrightpanel = new JPanel();
        copyrightpanel.setOpaque(false);
        JLabel line = new JLabel(AboutDialog.COPYRIGHT_NOTICE);
        line.setHorizontalTextPosition(0);
        line.setFont(line.getFont().deriveFont(10.0f).deriveFont(0));
        copyrightpanel.add(line);
        panel.add((Component)copyrightpanel, "South");
        this.setTitle("Welcome");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        if (gc == null) {
            gc = this.getGraphicsConfiguration();
        }
        Rectangle windowSize = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension size = this.getSize();
        Point parent_loc = this.getLocation();
        this.setLocation(parent_loc.x + windowSize.width / 2 - size.width / 2, parent_loc.y + windowSize.height / 2 - size.height / 2);
        ImageIcon frinika_light = new ImageIcon(ProjectFrame.class.getResource("/frinika_light_gradient.png"));
        this.light_label = new JLabel(frinika_light);
        this.light_label.setLocation(-400, 60);
        this.light_label.setSize(frinika_light.getIconWidth(), frinika_light.getIconHeight());
        this.getLayeredPane().add((Component)this.light_label, JLayeredPane.MODAL_LAYER);
        ImageIcon frinika_cloud = new ImageIcon(ProjectFrame.class.getResource("/frinika_score.png"));
        this.cloud_width = frinika_cloud.getIconWidth();
        this.light_cloud1 = new JLabel(frinika_cloud);
        this.light_cloud1.setLocation(this.cloud_width, 75);
        this.light_cloud1.setSize(frinika_light.getIconWidth(), frinika_light.getIconHeight());
        this.getLayeredPane().add((Component)this.light_cloud1, JLayeredPane.MODAL_LAYER);
        this.light_cloud2 = new JLabel(frinika_cloud);
        this.light_cloud2.setLocation(0, 75);
        this.light_cloud2.setSize(frinika_light.getIconWidth(), frinika_light.getIconHeight());
        this.getLayeredPane().add((Component)this.light_cloud2, JLayeredPane.MODAL_LAYER);
        ImageIcon frinika_overscan = new ImageIcon(ProjectFrame.class.getResource("/frinika_overscan.png"));
        JLabel light_overscan = new JLabel(frinika_overscan);
        light_overscan.setLocation(22, 43);
        light_overscan.setSize(frinika_overscan.getIconWidth(), frinika_overscan.getIconHeight());
        this.getLayeredPane().add((Component)light_overscan, JLayeredPane.POPUP_LAYER);
        Point loc = this.getLocation();
        BufferedImage img = null;
        if (img == null) {
            JLabel border_panel = new JLabel();
            border_panel.setLocation(0, 0);
            border_panel.setSize(this.getSize());
            border_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
            border_panel.setOpaque(false);
            this.getLayeredPane().add((Component)border_panel, JLayeredPane.POPUP_LAYER);
            return;
        }
        Kernel kernel = new Kernel(3, 3, new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f});
        img = img.getSubimage(loc.x, loc.y, size.width, size.height);
        ConvolveOp co = new ConvolveOp(kernel);
        img = co.filter(img, null);
        img = co.filter(img, null);
        img = co.filter(img, null);
        img = new RescaleOp(0.08f, 230.4f, null).filter(img, null);
        BufferedImage bak = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = bak.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        try {
            mask = ImageIO.read(ProjectFrame.class.getResource("/frinika_mask.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int[] rgbData = new int[mask.getWidth()];
        int[] brgbData = new int[bak.getWidth()];
        int w = mask.getWidth();
        int bw = bak.getWidth();
        for (int i = 0; i < mask.getHeight(); ++i) {
            mask.getRGB(0, i, w, 1, rgbData, 0, 0);
            bak.getRGB(0, i + 43, bw, 1, brgbData, 0, 0);
            for (int j = 0; j < w; ++j) {
                int m = (rgbData[j] & 0xFF) * 0x1000000;
                brgbData[j + 22] = (brgbData[j + 22] & 0xFFFFFF) + m;
            }
            bak.setRGB(0, i + 43, bw, 1, brgbData, 0, 0);
        }
        JLabel border_panel = new JLabel(new ImageIcon(bak));
        border_panel.setLocation(0, 0);
        border_panel.setSize(this.getSize());
        border_panel.setBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.3f), 2));
        border_panel.setOpaque(false);
        this.getLayeredPane().add((Component)border_panel, JLayeredPane.POPUP_LAYER);
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BorderLayout());
        textpanel.setOpaque(false);
        label = new JLabel();
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        label.setFont(label.getFont().deriveFont(0));
        label.setText(AboutDialog.MAIN_TITLE);
        label.setBorder(BorderFactory.createEmptyBorder(25, 5, 5, 5));
        JPanel flowpanel = new JPanel();
        flowpanel.setLayout(new FlowLayout(1, 0, 0));
        flowpanel.setOpaque(false);
        flowpanel.add(label);
        textpanel.add((Component)flowpanel, "North");
        copyrightpanel = new JPanel();
        copyrightpanel.setOpaque(false);
        line = new JLabel(AboutDialog.COPYRIGHT_NOTICE);
        line.setHorizontalTextPosition(0);
        line.setFont(line.getFont().deriveFont(10.0f).deriveFont(0));
        flowpanel = new JPanel();
        flowpanel.setLayout(new FlowLayout(1, 0, 0));
        flowpanel.setOpaque(false);
        flowpanel.add(line);
        textpanel.add((Component)flowpanel, "South");
        textpanel.setSize(this.getSize().width, 140);
        textpanel.setLocation(0, this.getSize().height - 170);
        this.getLayeredPane().add((Component)textpanel, JLayeredPane.DRAG_LAYER);
    }

    public BufferedImage captureBackGround() {
        try {
            Robot rbt = new Robot();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            return rbt.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
        }
        catch (Exception ex) {
            return null;
        }
    }
}

