/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot.gui;

import com.frinika.audio.toot.MidiHashUtil;
import com.frinika.audio.toot.gui.ControlMapper;
import java.util.HashMap;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import uk.org.toot.swingui.controlui.ControlPanel;

public class MidiControlRouter
implements Receiver {
    static final int INIT = 1;
    static final int LEARNING = 1;
    static final int ACTIVE = 2;
    int mode = 1;
    HashMap<Long, ControlMapper> map;
    ShortMessage lastMessage = null;
    private ControlPanel focus;
    private MidiDevice dev;

    MidiControlRouter(MidiDevice dev) {
        this.dev = dev;
        this.map = new HashMap();
    }

    public void close() {
    }

    public void setLearning(ControlPanel focus) {
        this.focus = focus;
        this.mode = 1;
        System.out.println(" Learning to control using " + this.dev.getDeviceInfo().getName());
    }

    public void setActive() {
        this.mode = 2;
        if (this.lastMessage == null) {
            System.out.println(" Control not learnt yet !!! ");
        }
    }

    public void send(MidiMessage mess, long arg1) {
        if (mess.getStatus() >= 241) {
            return;
        }
        if (!(mess instanceof ShortMessage)) {
            return;
        }
        ShortMessage smsg = (ShortMessage)mess;
        switch (this.mode) {
            case 1: {
                System.out.println("ch cmd data1 data2: " + smsg.getChannel() + " " + smsg.getCommand() + " " + smsg.getData1() + " " + smsg.getData2());
                this.lastMessage = smsg;
                break;
            }
            case 2: {
                long key = MidiHashUtil.hashValue((ShortMessage)mess);
                ControlMapper mapper = this.map.get(key);
                if (mapper == null) {
                    return;
                }
                mapper.send(smsg, arg1);
            }
        }
    }

    public void assignMapper() {
        if (this.lastMessage == null || this.focus == null) {
            return;
        }
        long hash = MidiHashUtil.hashValue(this.lastMessage);
        ControlMapper mapper = this.map.get(hash);
        if (mapper == null) {
            System.out.println(" Creating new mapper ");
            this.map.put(hash, new ControlMapper(this.focus.getControl(), this.lastMessage));
        } else {
            System.out.println(" Reassigning existing ");
        }
        this.mode = 2;
    }
}

