/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot.gui;

import com.frinika.audio.toot.gui.MidiControlRouter;
import com.frinika.audio.toot.gui.MidiInDeviceSelectPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import uk.org.toot.swingui.controlui.ControlPanel;

public class MidiLearnFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    Hashtable<MidiDevice.Info, MidiControlRouter> map;
    ShortMessage lastMessage;
    MidiDevice dev = null;
    MidiInDeviceSelectPanel deviceSelector;
    ControlPanel focus;
    static MidiLearnFrame the;

    private MidiLearnFrame() {
        assert (the == null);
        this.map = new Hashtable();
        the = this;
        JPanel panel = new JPanel();
        this.setContentPane(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        this.deviceSelector = new MidiInDeviceSelectPanel();
        panel.add(this.deviceSelector);
        this.deviceSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MidiLearnFrame.this.dev = MidiLearnFrame.this.deviceSelector.getSelected();
            }
        });
        JPanel buts = new JPanel();
        panel.add(buts);
        buts.setLayout(new BoxLayout(buts, 0));
        JButton apply = new JButton("OK");
        buts.add(apply);
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MidiLearnFrame.this.dev = MidiLearnFrame.this.deviceSelector.getSelected();
                if (MidiLearnFrame.this.dev == null) {
                    return;
                }
                MidiControlRouter router = MidiLearnFrame.this.assignRouter(MidiLearnFrame.this.dev);
                router.assignMapper();
            }
        });
        JButton learn = new JButton("Learn");
        buts.add(learn);
        learn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MidiLearnFrame.this.dev = MidiLearnFrame.this.deviceSelector.getSelected();
                if (MidiLearnFrame.this.dev == null) {
                    return;
                }
                MidiControlRouter router = MidiLearnFrame.this.assignRouter(MidiLearnFrame.this.dev);
                router.setLearning(MidiLearnFrame.this.focus);
            }
        });
        this.pack();
        this.deviceSelector.setSelectedIndex(0);
    }

    static MidiLearnFrame the() {
        if (the == null) {
            the = new MidiLearnFrame();
        }
        return the;
    }

    void setFocus(ControlPanel focus1) {
        this.focus = focus1;
    }

    MidiControlRouter assignRouter(MidiDevice dev) {
        if (dev == null) {
            return null;
        }
        MidiControlRouter router = this.map.get(dev.getDeviceInfo());
        if (router == null) {
            router = new MidiControlRouter(dev);
            this.map.put(dev.getDeviceInfo(), router);
            if (!dev.isOpen()) {
                try {
                    dev.open();
                    dev.getTransmitter().setReceiver(router);
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
        }
        return router;
    }

    class ExitHandler
    implements Runnable {
        ExitHandler() {
        }

        public void run() {
            if (MidiLearnFrame.this.dev != null) {
                MidiLearnFrame.this.dev.close();
            }
        }
    }
}

