/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class LineOutTest {
    static Mixer.Info currentMixer = AudioSystem.getMixerInfo()[0];
    static final float sampleRate = 44100.0f;
    static AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, true);
    static DataLine.Info infoOut = new DataLine.Info(SourceDataLine.class, format);
    static int frameSize = format.getFrameSize();
    static SourceDataLine lineOut;

    public static void main(String[] args) {
        long deltaSizeFrames = 512L;
        long deltaNanos = (long)(1.0E9 * (double)deltaSizeFrames / 44100.0);
        System.out.println(" delta =" + LineOutTest.nf(deltaNanos));
        try {
            lineOut = (SourceDataLine)AudioSystem.getMixer(currentMixer).getLine(infoOut);
            lineOut.open(format);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        lineOut.start();
        int bufferSize = lineOut.getBufferSize();
        byte[] buf = new byte[bufferSize];
        lineOut.write(buf, 0, bufferSize);
        long t1 = System.nanoTime();
        long nanosTarget = t1 + deltaNanos;
        long availLast = lineOut.available();
        while (true) {
            long sleepNanos;
            if ((sleepNanos = nanosTarget - System.nanoTime()) > 0L) {
                try {
                    Thread.sleep(sleepNanos / 1000000L, (int)(sleepNanos % 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println(" Missed a block " + sleepNanos);
            }
            long t2 = System.nanoTime();
            long nanoGlitch = t2 - nanosTarget;
            long availNow = lineOut.available();
            long deltaAvail = availNow - availLast;
            System.out.println(LineOutTest.nf(nanoGlitch) + " " + deltaAvail + " ! " + (long)((double)((float)(t2 - t1) * 44100.0f * (float)frameSize * 2.0f) / 1.0E9));
            nanosTarget += deltaNanos;
            availLast = availNow;
            t1 = t2;
        }
    }

    static String nf(long nanos) {
        return String.format(" %6.3f mS", (double)nanos / 1000000.0);
    }
}

