/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.chart;

import com.frinika.chart.Chart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ChartPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    int barsPerLine = 4;
    int chordsPerBar = 4;
    int pad = 2;
    Chart chart;

    public ChartPanel(Chart chart2) {
        this.chart = chart2;
        this.setBackground(Color.white);
        AbstractTableModel dataModel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            public int getColumnCount() {
                return ChartPanel.this.barsPerLine;
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }

            public int getRowCount() {
                return 1 + ChartPanel.this.chart.getBars().size() / ChartPanel.this.barsPerLine;
            }

            public void setValueAt(Object value, int row, int col) {
                int n;
                int index = row * ChartPanel.this.barsPerLine + col;
                for (int i = n = ChartPanel.this.chart.getBars().size(); i <= index; ++i) {
                    ChartPanel.this.chart.appendBar();
                }
                ChartPanel.this.chart.setbarAt(index, (String)value);
            }

            public Object getValueAt(int row, int col) {
                int index = row * ChartPanel.this.barsPerLine + col;
                if (index < ChartPanel.this.chart.getBars().size()) {
                    return ChartPanel.this.chart.getBars().get(row * ChartPanel.this.barsPerLine + col).toString();
                }
                return "blank";
            }
        };
        this.setLayout(new BorderLayout());
        JTable table = new JTable(dataModel);
        JScrollPane scrollpane = new JScrollPane(table);
        this.add((Component)scrollpane, "Center");
    }

    public void update(Observable arg0, Object arg1) {
        this.repaint();
    }

    public void setChart(Chart chart2) {
        this.chart = chart2;
        this.repaint();
    }

    public Object getChart() {
        return this.chart;
    }
}

