/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.audio.AudioContext;
import com.frinika.audio.AudioInput;
import com.frinika.audio.Voice;
import com.frinika.audio.VoiceServer;
import javax.sound.sampled.TargetDataLine;

public class AudioMonitor {
    public static void main(String[] args) throws Exception {
        VoiceServer voiceServer = new AudioContext().getVoiceServer();
        final AudioInput input = new AudioInput(null);
        input.start();
        input.getLine().start();
        voiceServer.addTransmitter(new Voice(){
            byte[] inBuffer = null;

            public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
                if (this.inBuffer == null || this.inBuffer.length != buffer.length * 2) {
                    this.inBuffer = new byte[buffer.length * 2];
                }
                int numOfBytes = (endBufferPos - startBufferPos) * 2;
                input.getLine().read(this.inBuffer, 0, numOfBytes);
                TargetDataLine line = input.getLine();
                int n = 0;
                for (int i = startBufferPos; i < endBufferPos; ++i) {
                    short sample = (short)((0xFF & this.inBuffer[n + 1]) + (0xFF & this.inBuffer[n + 0]) * 256);
                    buffer[i] = (float)sample / 32768.0f;
                    n += 2;
                }
            }
        });
        Thread.sleep(100000L);
    }
}

