/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.audio.AudioContext;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.audio.VoiceServer;
import com.frinika.audio.voicetemplate.SynchronizedVoice;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.SongPositionListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioPlayBackExample {
    public static void main(String[] args) throws Exception {
        final VoiceServer voiceServer = new AudioContext().getVoiceServer();
        class AudioTestVoice
        extends SynchronizedVoice {
            AudioInputStream ais;
            boolean running = false;
            byte[] byteBuffer = null;

            public AudioTestVoice(VoiceServer voiceServer, int i) throws Exception {
                super(voiceServer, i);
                this.reopenStream();
            }

            void reopenStream() throws Exception {
                this.ais = AudioSystem.getAudioInputStream(new File("/home/pjl/samples/Sassy9.wav"));
            }

            public void setRunning(final boolean running) {
                this.voiceServer.interruptTransmitter(this, new VoiceInterrupt(){

                    public void doInterrupt() {
                        running = running;
                    }
                });
            }

            public void fillBufferSynchronized(int startBufferPos, int endBufferPos, float[] buffer) {
                if (!this.running) {
                    return;
                }
                if (this.byteBuffer == null || this.byteBuffer.length != buffer.length * 2) {
                    this.byteBuffer = new byte[buffer.length * 2];
                }
                if (this.getMissedFrames() != 0) {
                    try {
                        this.reopenStream();
                        this.ais.skip(this.getFramePos() * 4L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.ais.read(this.byteBuffer, startBufferPos * 2, (endBufferPos - startBufferPos) * 2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (int n = startBufferPos; n < endBufferPos; ++n) {
                    int n2 = n;
                    buffer[n2] = buffer[n2] + (float)((short)((0xFF & this.byteBuffer[n * 2 + 0]) + (0xFF & this.byteBuffer[n * 2 + 1]) * 256)) / 32768.0f;
                }
            }
        }
        final AudioTestVoice voice = new AudioTestVoice(voiceServer, 0);
        voiceServer.addTransmitter(voice);
        final ProjectContainer proj = new ProjectContainer();
        proj.getSequencer().addSongPositionListener(new SongPositionListener(){
            {
            }

            public void notifyTickPosition(long tick) {
                voice.setRunning(proj.getSequencer().isRunning());
                voice.setFramePos(proj.getSequencer().getMicrosecondPosition() * (long)voiceServer.getSampleRate() / 1000000L);
            }

            public boolean requiresNotificationOnEachTick() {
                return false;
            }
        });
        new ProjectFrame(proj);
    }
}

