/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

public class Fourier {
    private static final int MAX_BITS = 14;
    private static final int MAX_SAMPLE_SIZE = 16384;
    private static int[] reversedBits;
    private static int currentNumberOfBits;

    private static int numberOfBitsNeeded(int sampleSize) {
        if (sampleSize < 2 || sampleSize > 16384) {
            return 0;
        }
        if (sampleSize == 2) {
            return 1;
        }
        if (sampleSize == 4) {
            return 2;
        }
        if (sampleSize == 8) {
            return 3;
        }
        if (sampleSize == 16) {
            return 4;
        }
        if (sampleSize == 32) {
            return 5;
        }
        if (sampleSize == 64) {
            return 6;
        }
        if (sampleSize == 128) {
            return 7;
        }
        if (sampleSize == 256) {
            return 8;
        }
        if (sampleSize == 512) {
            return 9;
        }
        if (sampleSize == 1024) {
            return 10;
        }
        if (sampleSize == 2048) {
            return 11;
        }
        if (sampleSize == 4096) {
            return 12;
        }
        if (sampleSize == 8192) {
            return 13;
        }
        if (sampleSize == 16384) {
            return 14;
        }
        return 0;
    }

    public static int nextPowerOfTwo(int sampleSize) {
        if (sampleSize < 2 || sampleSize > 16384) {
            return 0;
        }
        if (sampleSize <= 2) {
            return 2;
        }
        if (sampleSize <= 4) {
            return 4;
        }
        if (sampleSize <= 8) {
            return 8;
        }
        if (sampleSize <= 16) {
            return 16;
        }
        if (sampleSize <= 32) {
            return 32;
        }
        if (sampleSize <= 64) {
            return 64;
        }
        if (sampleSize <= 128) {
            return 128;
        }
        if (sampleSize <= 256) {
            return 256;
        }
        if (sampleSize <= 512) {
            return 512;
        }
        if (sampleSize <= 1024) {
            return 1024;
        }
        if (sampleSize <= 2048) {
            return 2048;
        }
        if (sampleSize <= 4096) {
            return 4096;
        }
        if (sampleSize <= 8196) {
            return 8196;
        }
        if (sampleSize <= 16384) {
            return 16384;
        }
        return 0;
    }

    private static boolean isPowerOfTwo(int sampleSize) {
        return Fourier.numberOfBitsNeeded(sampleSize) != 0;
    }

    private static int powerOfTwo(int power) {
        int result = 1;
        for (int i = 1; i <= power; ++i) {
            result <<= 1;
        }
        return result;
    }

    private static int reverseBits(int index, int numberOfBits) {
        if (numberOfBits != currentNumberOfBits) {
            Fourier.setupReverseBitsTable(numberOfBits);
        }
        return reversedBits[index];
    }

    private static void setupReverseBitsTable(int numberOfBits) {
        int tableSize = Fourier.powerOfTwo(numberOfBits);
        currentNumberOfBits = numberOfBits;
        reversedBits = new int[tableSize];
        for (int index = 0; index < tableSize; ++index) {
            int ind = index;
            int rev = 0;
            for (int b = 0; b < numberOfBits; ++b) {
                rev <<= 1;
                rev += ind % 2;
                ind >>= 1;
            }
            Fourier.reversedBits[index] = rev;
        }
    }

    public static void fftBase(int numSamples, boolean inverseTransform, double[] realIn, double[] imagIn, double[] realOut, double[] imagOut) {
        int j;
        int i;
        double[] ar = new double[3];
        double[] ai = new double[3];
        double angleNumerator = Math.PI * 2;
        if (!Fourier.isPowerOfTwo(numSamples)) {
            System.out.println("Error in fft():  numSamples is not power of two");
            return;
        }
        if (inverseTransform) {
            angleNumerator = -angleNumerator;
        }
        int numBits = Fourier.numberOfBitsNeeded(numSamples);
        for (i = 0; i < numSamples; ++i) {
            j = Fourier.reverseBits(i, numBits);
            realOut[j] = realIn[i];
            imagOut[j] = imagIn[i];
        }
        int blockEnd = 1;
        for (int blockSize = 2; blockSize <= numSamples; blockSize <<= 1) {
            double deltaAngle = angleNumerator / (double)blockSize;
            double sm2 = Math.sin(-2.0 * deltaAngle);
            double sm1 = Math.sin(-deltaAngle);
            double cm2 = Math.cos(-2.0 * deltaAngle);
            double cm1 = Math.cos(-deltaAngle);
            double w = 2.0 * cm1;
            for (i = 0; i < numSamples; i += blockSize) {
                ar[2] = cm2;
                ar[1] = cm1;
                ai[2] = sm2;
                ai[1] = sm1;
                j = i;
                for (int n = 0; n < blockEnd; ++n) {
                    ar[0] = w * ar[1] - ar[2];
                    ar[2] = ar[1];
                    ar[1] = ar[0];
                    ai[0] = w * ai[1] - ai[2];
                    ai[2] = ai[1];
                    ai[1] = ai[0];
                    int k = j + blockEnd;
                    double tr = ar[0] * realOut[k] - ai[0] * imagOut[k];
                    double ti = ar[0] * imagOut[k] + ai[0] * realOut[k];
                    realOut[k] = realOut[j] - tr;
                    imagOut[k] = imagOut[j] - ti;
                    int n2 = j;
                    realOut[n2] = realOut[n2] + tr;
                    int n3 = j++;
                    imagOut[n3] = imagOut[n3] + ti;
                }
            }
            blockEnd = blockSize;
        }
        if (inverseTransform) {
            double denom = numSamples;
            i = 0;
            while (i < numSamples) {
                int n = i;
                realOut[n] = realOut[n] / denom;
                int n4 = i++;
                imagOut[n4] = imagOut[n4] / denom;
            }
        }
    }

    public static void frequencyFft(int numberOfSamples, double[] dataIn, double[] frequencies) {
        double[] realOut = new double[numberOfSamples];
        double[] imagOut = new double[numberOfSamples];
        double[] imagIn = Fourier.padToPowerOfTwo(numberOfSamples, null);
        Fourier.fftBase(numberOfSamples, false, dataIn, imagIn, realOut, imagOut);
        for (int bin = 0; bin < numberOfSamples; ++bin) {
            double fsq = realOut[bin] * realOut[bin] + imagOut[bin] * imagOut[bin];
            frequencies[bin] = Math.sqrt(fsq);
        }
    }

    public static void frequencyFft(int numberOfSamples, int[] dataIn, double[] frequencies) {
        double[] dDataIn = new double[numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            dDataIn[i] = dataIn[i];
        }
        Fourier.frequencyFft(numberOfSamples, dDataIn, frequencies);
    }

    public static double frequencyFromBin(int binNumber, int numberOfSamples, double samplingFrequency) {
        double n = numberOfSamples;
        double b = binNumber;
        double frequency = binNumber > numberOfSamples / 2 ? samplingFrequency * (b - n) / n : samplingFrequency * b / n;
        return frequency;
    }

    public static double[] padToPowerOfTwo(int numberOfSamples, double[] inData) {
        if (Fourier.isPowerOfTwo(numberOfSamples) && inData != null) {
            return inData;
        }
        int desiredSamples = Fourier.nextPowerOfTwo(numberOfSamples);
        double[] outData = new double[desiredSamples];
        if (inData == null) {
            for (int i = 0; i < desiredSamples; ++i) {
                outData[i] = 0.0;
            }
        } else {
            int i;
            for (i = 0; i < numberOfSamples; ++i) {
                outData[i] = inData[i];
            }
            for (i = numberOfSamples + 1; i < desiredSamples; ++i) {
                outData[i] = 0.0;
            }
        }
        return outData;
    }

    static {
        currentNumberOfBits = 0;
    }
}

