/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.audio.VoiceInterrupt;
import com.frinika.contrib.boblang.BezierPlayingNote;
import com.frinika.contrib.boblang.BezierSynth;
import com.frinika.contrib.boblang.FrinikaBezierSynth;
import com.frinika.synth.Oscillator;

public class FrinikaBezierVoice
extends Oscillator {
    BezierPlayingNote bezierPlayingNote;
    FrinikaBezierSynth synth;

    public FrinikaBezierVoice(FrinikaBezierSynth synth, int noteNumber) {
        super(synth);
        this.synth = synth;
        BezierSynth bezierSynth = new BezierSynth(noteNumber, synth.getBezierWaves().p);
        this.bezierPlayingNote = new BezierPlayingNote(bezierSynth, synth.getEnvelopeShaper(), noteNumber, 1);
    }

    public void release() {
        if (!this.triggeredRelease) {
            this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

                public void doInterrupt() {
                    FrinikaBezierVoice.this.release = true;
                    FrinikaBezierVoice.this.bezierPlayingNote.setRelease();
                }
            });
            this.triggeredRelease = true;
        }
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        this.bezierPlayingNote.getBuffer(this.synth.getPreOscillator().sampleBuffer, startBufferPos, endBufferPos);
        if (this.bezierPlayingNote.isFinished()) {
            this.synth.getAudioOutput().removeTransmitter(this);
        }
    }
}

