/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.global;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.ConfigDialog;
import com.frinika.global.ConfigDialogPanel;
import com.frinika.global.ConfigError;
import com.frinika.global.ConfigListener;
import com.frinika.gui.DefaultOptionsBinder;
import com.frinika.gui.util.FontChooser;
import com.frinika.gui.util.PresentationPanel;
import com.frinika.project.gui.ProjectFrame;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaConfig {
    public static boolean SETUP_DONE;
    public static Meta _SETUP_DONE;
    public static int TICKS_PER_QUARTER;
    public static Meta _TICKS_PER_QUARTER;
    public static int SEQUENCER_PRIORITY;
    public static Meta _SEQUENCER_PRIORITY;
    public static int AUDIO_BUFFER_LENGTH;
    public static Meta _AUDIO_BUFFER_LENGTH;
    public static String MIDIIN_DEVICES_LIST;
    public static Meta _MIDIIN_DEVICES_LIST;
    public static boolean DIRECT_MONITORING;
    public static Meta _DIRECT_MONITORING;
    public static boolean MULTIPLEXED_AUDIO;
    public static Meta _MULTIPLEXED_AUDIO;
    public static boolean BIG_ENDIAN;
    public static Meta _BIG_ENDIAN;
    public static int sampleRate;
    public static Meta _sampleRate;
    public static boolean JACK_AUTO_CONNECT;
    public static Meta _JACK_AUTO_CONNECT;
    public static boolean MAXIMIZE_WINDOW;
    public static Meta _MAXIMIZE_WINDOW;
    public static float MOUSE_NUMBER_DRAG_INTENSITY;
    public static Meta _MOUSE_NUMBER_DRAG_INTENSITY;
    public static Font TEXT_LANE_FONT;
    public static Meta _TEXT_LANE_FONT;
    public static File GROOVE_PATTERN_DIRECTORY;
    public static Meta _GROOVE_PATTERN_DIRECTORY;
    public static File SCRIPTS_DIRECTORY;
    public static Meta _SCRIPTS_DIRECTORY;
    public static File AUDIO_DIRECTORY;
    public static Meta _AUDIO_DIRECTORY;
    public static File SOUNDFONT_DIRECTORY;
    public static Meta _SOUNDFONT_DIRECTORY;
    public static String LAST_PROJECT_FILENAME;
    public static Meta _LAST_PROJECT_FILENAME;
    private static final String CONFIG_FILE_NAME = "FrinikaConfig.xml";
    private static final String META_PREFIX = "_";
    private static File userFrinikaDir;
    private static File configFile;
    private static final String DIRECTORY_SUFFIX = "_DIRECTORY";
    private static Map<String, Field> fieldsByName;
    private static Map<String, Field> metafieldsByName;
    private static Map<Field, Meta> metasByField;
    private static Collection<ConfigListener> listeners;
    private static JDialog showingDialog;
    private static JFrame showingDialogFrame;
    private static Properties properties;

    private static Map<Meta, Object> bindMap(ConfigDialogPanel d) {
        HashMap<Meta, Object> m = new HashMap<Meta, Object>();
        m.put(_AUDIO_BUFFER_LENGTH, d.spinnerBufferSize);
        m.put(_DIRECT_MONITORING, d.checkboxUseDirectMonitoring);
        m.put(_MULTIPLEXED_AUDIO, d.checkboxUseMultiplexedJavasoundServer);
        m.put(_JACK_AUTO_CONNECT, d.checkboxAutoconnectJack);
        m.put(_sampleRate, d.comboboxSampleRate);
        m.put(_TICKS_PER_QUARTER, d.spinnerTicksPerQuarter);
        m.put(_SEQUENCER_PRIORITY, d.spinnerSequencerPriority);
        m.put(_BIG_ENDIAN, d.checkboxBigEndian);
        m.put(_MAXIMIZE_WINDOW, d.checkboxOpenMaximizedWindow);
        m.put(_MOUSE_NUMBER_DRAG_INTENSITY, d.spinnerMouseDragSpeedSpinners);
        m.put(_TEXT_LANE_FONT, d.textfieldFontTextLane);
        m.put(_GROOVE_PATTERN_DIRECTORY, d.textfieldGroovePatternsDirectory);
        m.put(_SCRIPTS_DIRECTORY, d.textfieldScriptsDirectory);
        m.put(_AUDIO_DIRECTORY, d.textfieldAudioDirectory);
        m.put(_SOUNDFONT_DIRECTORY, d.textfieldSoundFontDirectory);
        m.put(_MIDIIN_DEVICES_LIST, null);
        m.put(_LAST_PROJECT_FILENAME, null);
        m.put(_SETUP_DONE, null);
        return m;
    }

    public static void showDialog(ProjectFrame frame) {
        if (showingDialog != null) {
            if (showingDialogFrame == frame) {
                showingDialog.show();
                showingDialog.toFront();
                return;
            }
            showingDialog.dispose();
        }
        showingDialogFrame = frame;
        showingDialog = FrinikaConfig.createDialog(frame);
        showingDialog.show();
    }

    protected static JDialog createDialog(ProjectFrame frame) {
        ConfigDialogPanel configDialogPanel = new ConfigDialogPanel(frame);
        Map<Meta, Object> m = FrinikaConfig.bindMap(configDialogPanel);
        Map<Field, Object> map = FrinikaConfig.convertMap(m);
        DefaultOptionsBinder optionsBinder = new DefaultOptionsBinder(map, properties);
        ConfigDialog d = new ConfigDialog(frame, optionsBinder);
        PresentationPanel presentationPanel = new PresentationPanel(configDialogPanel.tabbedPane);
        d.getContentPane().add((Component)presentationPanel, "Center");
        return d;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static void load() throws IOException {
        FileInputStream r = new FileInputStream(configFile);
        FrinikaConfig.load(r);
    }

    public static boolean store() {
        try {
            FileOutputStream w = new FileOutputStream(configFile);
            FrinikaConfig.save(w);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showConfirmDialog(null, "Error while saving configuration file.", "Error while saving.", 2, 0, null);
            return false;
        }
    }

    public static void storeAndQuit() {
        int answer;
        if (!FrinikaConfig.store() && (answer = JOptionPane.showConfirmDialog(null, "Exit anyway?", "Error while saving.", 2, 0, null)) != 0) {
            return;
        }
        System.exit(0);
    }

    public static void load(InputStream r) throws IOException {
        properties = new Properties();
        properties.loadFromXML(r);
        FrinikaConfig.loadFields(properties);
        for (String fieldname : fieldsByName.keySet()) {
            properties.remove(fieldname);
        }
    }

    public static void save(OutputStream w) throws IOException {
        Properties p = new Properties();
        for (Object key : properties.keySet()) {
            p.setProperty((String)key, properties.getProperty((String)key));
        }
        SETUP_DONE = true;
        FrinikaConfig.saveFields(p);
        p.storeToXML(w, "Frinika configuration");
    }

    public static void loadFields(Properties p) {
        for (Field field : fieldsByName.values()) {
            String name = field.getName();
            String prop = p.getProperty(name);
            if (prop == null) {
                System.out.println("no saved property for configuration option " + name + ", using default");
                continue;
            }
            Object o = FrinikaConfig.stringToValue(prop, name, field.getType());
            FrinikaConfig.setFieldValue(field, o);
        }
    }

    public static void saveFields(Properties p) {
        for (Field field : fieldsByName.values()) {
            String name = field.getName();
            Object o = FrinikaConfig.getFieldValue(field);
            String s = FrinikaConfig.valueToString(o, name, field.getType());
            if (s == null) continue;
            p.setProperty(name, s);
        }
    }

    public static void addConfigListener(ConfigListener l) {
        listeners.add(l);
    }

    public static void removeConfigListener(ConfigListener l) {
        listeners.remove(l);
    }

    public static void fireConfigurationChangedEvent(Meta meta) {
        ChangeEvent event = new ChangeEvent(meta);
        for (ConfigListener l : listeners) {
            l.configurationChanged(event);
        }
    }

    private static Field findField(String name) {
        Field field = fieldsByName.get(name);
        if (field == null) {
            throw new ConfigError("dynamic bind error: configuration field " + name + " does not exist.");
        }
        return field;
    }

    private static Map<Field, Object> convertMap(Object[][] bindMap) {
        HashMap<Field, Object> m = new HashMap<Field, Object>();
        for (int i = 0; i < bindMap.length; ++i) {
            Object[] pair = bindMap[i];
            Field field = FrinikaConfig.findField((String)pair[0]);
            Object component = pair[1];
            m.put(field, component);
        }
        return m;
    }

    private static Map<Field, Object> convertMap(Map<Meta, Object> map) {
        HashMap<Field, Object> m = new HashMap<Field, Object>();
        for (Map.Entry<Meta, Object> e : map.entrySet()) {
            Field field = e.getKey().getField();
            Object component = e.getValue();
            m.put(field, component);
        }
        return m;
    }

    public static Object getFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigError("dynamic bind error: IllegalAccessException on getField " + iae.getMessage());
        }
    }

    public static void setFieldValue(Field field, Object o) {
        Object oldValue;
        try {
            oldValue = field.get(null);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigError("dynamic bind error: IllegalAccessException on iitial get of setField " + iae.getMessage());
        }
        System.out.println("config: " + field.getName() + "=" + o);
        try {
            Meta meta;
            field.set(null, o);
            if (o instanceof File && field.getName().endsWith(DIRECTORY_SUFFIX)) {
                ((File)o).mkdirs();
            }
            if ((o != null && !o.equals(oldValue) || o == null && oldValue != null) && (meta = metasByField.get(field)) != null) {
                FrinikaConfig.fireConfigurationChangedEvent(meta);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ConfigError("dynamic bind error: IllegalAccessException on setField " + iae.getMessage());
        }
    }

    public static Object stringToValue(String prop, String name, Class type) {
        if (prop == null) {
            return null;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return Integer.parseInt(prop);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return Long.parseLong(prop);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return Double.parseDouble(prop);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(Float.parseFloat(prop));
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return Boolean.parseBoolean(prop);
        }
        if (File.class.isAssignableFrom(type)) {
            return new File(prop);
        }
        if (Font.class.isAssignableFrom(type)) {
            return FrinikaConfig.stringToFont(prop);
        }
        return prop;
    }

    public static String valueToString(Object o, String name, Class type) {
        if (o == null) {
            return null;
        }
        if (File.class.isAssignableFrom(type)) {
            return ((File)o).getAbsolutePath();
        }
        if (Font.class.isAssignableFrom(type)) {
            return FrinikaConfig.fontToString((Font)o);
        }
        return o.toString();
    }

    public static boolean isTrue(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return !(Math.abs(((Number)o).doubleValue()) < 1.0E-9);
        }
        String s = o.toString();
        return (s = s.trim().toLowerCase()).equals("true") || s.equals("yes");
    }

    public static Font stringToFont(String s) {
        int fontSize;
        StringTokenizer st = new StringTokenizer(s, ",", false);
        String fontName = "Helvetica";
        String fontSizeStr = "12";
        String fontStyleStr = "plain";
        if (st.hasMoreTokens()) {
            fontName = st.nextToken();
            if (st.hasMoreTokens()) {
                fontSizeStr = st.nextToken();
                if (st.hasMoreTokens()) {
                    fontStyleStr = st.nextToken();
                }
            }
        }
        try {
            fontSize = Integer.parseInt(fontSizeStr);
        }
        catch (NumberFormatException nfe) {
            fontSize = 12;
        }
        int fontStyle = 0;
        fontStyleStr = fontStyleStr.toLowerCase();
        if (fontStyleStr.indexOf("bold") != -1) {
            fontStyle |= 1;
        }
        if (fontStyleStr.indexOf("italic") != -1) {
            fontStyle |= 2;
        }
        return new Font(fontName, fontStyle, fontSize);
    }

    public static String fontToString(Font font) {
        int fontStyle = font.getStyle();
        String fontStyleStr = "";
        if ((fontStyle & 1) != 0) {
            fontStyleStr = fontStyleStr + "bold";
        }
        if ((fontStyle & 2) != 0) {
            fontStyleStr = fontStyleStr + "italic";
        }
        if (fontStyleStr.length() == 0) {
            fontStyleStr = "plain";
        }
        return font.getName() + "," + font.getSize() + "," + fontStyleStr;
    }

    public static String fileToString(File file) {
        String s;
        try {
            s = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            s = file.getAbsolutePath();
        }
        return s;
    }

    public static void pickDirectory(ProjectFrame frame, JTextField boundTextField) {
        FrinikaConfig.pickFile(frame, boundTextField, true);
    }

    public static void pickFile(ProjectFrame frame, JTextField boundTextField) {
        FrinikaConfig.pickFile(frame, boundTextField, false);
    }

    public static void pickFile(ProjectFrame frame, JTextField boundTextField, boolean directory) {
        String s = boundTextField.getText();
        File file = new File(s);
        JFileChooser fc = new JFileChooser(file);
        if (directory) {
            fc.setFileSelectionMode(1);
        }
        fc.showDialog(frame, "Choose");
        file = fc.getSelectedFile();
        if (file != null) {
            s = FrinikaConfig.fileToString(file);
            boundTextField.setText(s);
        }
    }

    public static void pickFont(ProjectFrame frame, JTextField boundTextField) {
        String s = boundTextField.getText();
        Font font = FrinikaConfig.stringToFont(s);
        if ((font = FontChooser.showDialog(frame, "Pick Font...", font)) != null) {
            s = FrinikaConfig.fontToString(font);
            boundTextField.setText(s);
        }
    }

    public static int getAudioBufferLength() {
        return AUDIO_BUFFER_LENGTH;
    }

    public static void setAudioBufferLength(int len) {
        FrinikaConfig.setFieldValue(FrinikaConfig.findField("AUDIO_BUFFER_LENGTH"), len);
    }

    public static boolean getDirectMonitoring() {
        return DIRECT_MONITORING;
    }

    public static void setDirectMonitoring(boolean dm) {
        _DIRECT_MONITORING.set(dm);
    }

    public static void setMultiplexedAudio(boolean multiplex) {
        _MULTIPLEXED_AUDIO.set(multiplex);
    }

    public static void setJackAutoconnect(boolean auto) {
        _JACK_AUTO_CONNECT.set(auto);
    }

    public static String lastProjectFile() {
        return LAST_PROJECT_FILENAME;
    }

    public static void setLastProjectFilename(String filename) {
        FrinikaConfig.setFieldValue(FrinikaConfig.findField("LAST_PROJECT_FILENAME"), filename);
    }

    public static void setMidiInDeviceList(Vector<String> list) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String o : list) {
            if (!first) {
                buf.append(";");
            }
            buf.append(o.toString());
            first = false;
        }
        System.out.println(buf);
        String s = buf.toString();
        FrinikaConfig.setFieldValue(FrinikaConfig.findField("MIDIIN_DEVICES_LIST"), s);
    }

    public static Vector<String> getMidiInDeviceList() {
        String buf = MIDIIN_DEVICES_LIST;
        if (buf == null) {
            buf = "";
        }
        String[] list = buf.split(";");
        Vector<String> vec = new Vector<String>();
        for (String str : list) {
            if (str.equals("")) continue;
            vec.add(str);
        }
        return vec;
    }

    public static Collection<String> getAvailableMidiInDevices() {
        MidiDevice.Info[] infos;
        ArrayList<String> a = new ArrayList<String>();
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxTransmitters() == 0) continue;
                String str = info.toString();
                a.add(str);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return a;
    }

    public static Collection<String> getAvailableAudioDevices() {
        List<String> list = FrinikaAudioSystem.getAudioServer().getAvailableOutputNames();
        return list;
    }

    static {
        String name;
        Field[] fields;
        SETUP_DONE = false;
        TICKS_PER_QUARTER = 128;
        SEQUENCER_PRIORITY = 0;
        AUDIO_BUFFER_LENGTH = 512;
        MIDIIN_DEVICES_LIST = "";
        DIRECT_MONITORING = false;
        MULTIPLEXED_AUDIO = false;
        BIG_ENDIAN = false;
        sampleRate = 44100;
        JACK_AUTO_CONNECT = false;
        MAXIMIZE_WINDOW = false;
        MOUSE_NUMBER_DRAG_INTENSITY = 2.0f;
        TEXT_LANE_FONT = new Font("Arial", 0, 8);
        GROOVE_PATTERN_DIRECTORY = new File(System.getProperty("user.home"), "frinika/groovepatterns/");
        SCRIPTS_DIRECTORY = new File(System.getProperty("user.home"), "frinika/scripts/");
        AUDIO_DIRECTORY = new File(System.getProperty("user.home"), "frinika/audio/");
        SOUNDFONT_DIRECTORY = new File(System.getProperty("user.home"), "frinika/soundfonts/");
        LAST_PROJECT_FILENAME = null;
        userFrinikaDir = new File(System.getProperty("user.home"), "frinika");
        configFile = new File(userFrinikaDir, CONFIG_FILE_NAME);
        showingDialog = null;
        showingDialogFrame = null;
        properties = new Properties();
        fieldsByName = new HashMap<String, Field>();
        metafieldsByName = new HashMap<String, Field>();
        metasByField = new HashMap<Field, Meta>();
        listeners = new ArrayList<ConfigListener>();
        for (Field f : fields = FrinikaConfig.class.getFields()) {
            if ((f.getModifiers() & 8) == 0) continue;
            name = f.getName();
            if (f.getType() == Meta.class) {
                if (!name.startsWith(META_PREFIX)) {
                    throw new ConfigError("meta-field '" + name + "' does not start with prefix " + META_PREFIX);
                }
                metafieldsByName.put(name, f);
                continue;
            }
            fieldsByName.put(name, f);
        }
        for (Map.Entry<String, Field> metafieldEntry : metafieldsByName.entrySet()) {
            String metafieldName = metafieldEntry.getKey();
            Field metafield = metafieldEntry.getValue();
            name = metafieldName.substring(META_PREFIX.length());
            Field field = fieldsByName.get(name);
            if (field == null) {
                throw new ConfigError("no corresponding option field '" + name + "' found for meta-field '" + metafieldName + "'");
            }
            Meta meta = new Meta(field);
            try {
                metafield.set(null, meta);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigError(iae);
            }
            metasByField.put(field, meta);
        }
        if (!userFrinikaDir.exists()) {
            System.out.println(" Creating frinka user settings directory  " + userFrinikaDir);
            if (!userFrinikaDir.mkdir()) {
                System.err.println(" Failed to create " + userFrinikaDir);
            }
        }
        try {
            FrinikaConfig.load();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Can't find file " + configFile.getAbsolutePath() + ". It will be created when you quit the program or change configuration options.");
        }
        catch (Exception e) {
            System.err.println("error loading configuration. defaults will be used where possible.");
            e.printStackTrace();
        }
        Map<Meta, Object> m = FrinikaConfig.bindMap(new ConfigDialogPanel(null));
        ArrayList<Field> boundFields = new ArrayList<Field>();
        for (Map.Entry<Meta, Object> e : m.entrySet()) {
            Meta meta = e.getKey();
            Object component = e.getValue();
            if (component != null && component instanceof JComponent && ((JComponent)component).getParent() == null) {
                throw new ConfigError("gui element bound to config option '" + meta.getName() + "' has no parent, type " + component.getClass().getName());
            }
            boundFields.add(meta.getField());
        }
        ArrayList<Field> allfields = new ArrayList<Field>(fieldsByName.values());
        allfields.removeAll(boundFields);
        int a = boundFields.size();
        int b = fieldsByName.size();
        if (a != b || !allfields.isEmpty()) {
            for (Field f : allfields) {
                System.err.println("unbound field: " + f.getName());
            }
            throw new ConfigError("there are fields which are not bound to gui elements (or to null), see above");
        }
    }

    public static class Meta {
        private Field field;

        Meta(Field field) {
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        public String getName() {
            return this.getField().getName();
        }

        public Class getType() {
            return this.getField().getType();
        }

        public Object get() {
            try {
                return this.getField().get(null);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigError(iae);
            }
        }

        public void set(Object o) {
            FrinikaConfig.setFieldValue(this.getField(), o);
        }
    }
}

