/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.global;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolbox {
    private Toolbox() {
    }

    public static String joinStrings(Collection<String> ss, String delim) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String s : ss) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    public static String joinStrings(String[] ss, String delim) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String s : ss) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    public static List<String> splitString(String s, String delim) {
        int pos;
        ArrayList<String> l = new ArrayList<String>();
        int start = 0;
        int d = delim.length();
        do {
            String ss = s.substring(start, (pos = s.indexOf(delim, start)) != -1 ? pos : s.length());
            if (pos != -1 || ss.length() > 0) {
                l.add(ss.trim());
            }
            start = pos + d;
        } while (pos != -1 && start < s.length());
        return l;
    }

    public static String firstWord(String s) {
        if ((s = s.trim()).length() == 0) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(s, " \t\n\r", false);
        String w = st.nextToken();
        return w;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return "";
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
    }

    public static String[] splitWords(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\r\n", false);
        int size = st.countTokens();
        String[] args = new String[size];
        for (int i = 0; i < size; ++i) {
            args[i] = st.nextToken();
        }
        return args;
    }

    public static void extractFromJar(File jarfile, String prefix, File targetDir) throws IOException {
        JarInputStream jar = new JarInputStream(new FileInputStream(jarfile));
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                String name = entry.getName();
                if (prefix == null || name.startsWith(prefix)) {
                    int hasRead;
                    int pos = name.lastIndexOf(File.separator);
                    String n = pos != -1 ? name.substring(pos + File.separator.length()) : name;
                    File outFile = new File(targetDir, n);
                    FileOutputStream out = new FileOutputStream(outFile);
                    System.out.print(name + " -> " + outFile.getAbsolutePath() + ", ");
                    byte[] b = new byte[10240];
                    int total = 0;
                    do {
                        if ((hasRead = jar.read(b)) > 0) {
                            out.write(b, 0, hasRead);
                        }
                        total += hasRead;
                    } while (hasRead > 0);
                    System.out.println(total + " bytes");
                    out.close();
                }
            }
            entry = jar.getNextJarEntry();
        }
        jar.close();
    }
}

