/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui;

import com.frinika.gui.OptionsDialog;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public abstract class AbstractDialogAction
extends AbstractAction {
    protected ProjectFrame frame;
    protected String actionId;
    protected OptionsDialog dialog;
    protected boolean canceled;

    public AbstractDialogAction(ProjectFrame frame, String actionId) {
        super(CurrentLocale.getMessage(actionId) + "...");
        this.frame = frame;
        this.actionId = actionId;
    }

    public void actionPerformed(ActionEvent e) {
        this.canceled = false;
        this.perform();
    }

    public void cancel() {
        this.canceled = true;
    }

    public void perform() {
        this.performPrepare();
        if (!this.canceled) {
            this.performDialog();
            if (!this.canceled) {
                this.performUndoable();
            }
        }
    }

    protected void performPrepare() {
    }

    protected void performDialog() {
        OptionsDialog dialog = this.getDialog();
        if (dialog != null) {
            dialog.show();
        }
        if (dialog.isCanceled()) {
            this.cancel();
        }
    }

    protected void performUndoable() {
        ProjectContainer project = this.frame.getProjectContainer();
        project.getEditHistoryContainer().mark(CurrentLocale.getMessage(this.actionId));
        this.performAction();
        project.getEditHistoryContainer().notifyEditHistoryListeners();
    }

    protected abstract void performAction();

    public OptionsDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        return this.dialog;
    }

    protected OptionsDialog createDialog() {
        JComponent content = this.createGUI();
        if (content != null) {
            OptionsDialog d = new OptionsDialog(this.frame, content, CurrentLocale.getMessage(this.actionId));
            return d;
        }
        return null;
    }

    public ProjectFrame getProjectFrame() {
        return this.frame;
    }

    protected abstract JComponent createGUI();
}

