/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.midi;

import com.frinika.midi.DrumMapperGUI;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.synth.Synth;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import rasmus.midi.provider.RasmusSynthesizer;

public class DrumMapper
implements MidiDevice,
MidiDeviceIconProvider {
    private static Icon icon = new ImageIcon(RasmusSynthesizer.class.getResource("/icons/frinika.png"));
    MidiDevice defaultDevice;
    Receiver defRecv;
    NoteMap[] noteMap = new NoteMap[128];
    MidiDevice.Info deviceInfo = new DrumMapperInfo();
    Receiver receiver;
    List<Receiver> receivers;

    public Icon getIcon() {
        if (icon.getIconHeight() > 16 || icon.getIconWidth() > 16) {
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            Graphics2D g = img.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            Image im = img.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(im);
        }
        return icon;
    }

    DrumMapper() {
        int i = 0;
        while (i < 128) {
            NoteMap n = this.noteMap[i] = new NoteMap();
            n.note = i++;
        }
        this.receiver = new Receiver(){

            public void send(MidiMessage message, long timeStamp) {
                try {
                    ShortMessage shm;
                    if (message instanceof ShortMessage && (shm = (ShortMessage)message).getCommand() == 144) {
                        int note = shm.getData1();
                        Receiver recv = DrumMapper.this.defRecv;
                        if (recv == null) {
                            return;
                        }
                        int noteByte = DrumMapper.this.noteMap[note].note;
                        shm.setMessage(shm.getCommand(), shm.getChannel(), noteByte, shm.getData2());
                        recv.send(shm, timeStamp);
                        return;
                    }
                    if (DrumMapper.this.defRecv != null) {
                        DrumMapper.this.defRecv.send(message, timeStamp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void close() {
            }
        };
        this.receivers = new ArrayList<Receiver>();
        this.receivers.add(this.receiver);
    }

    public void save(File file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" DRUM MAP SAVE ");
    }

    public void load(File file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" DRUM MAP LOAD ");
    }

    public int getMaxPolyphony() {
        return 0;
    }

    public MidiChannel[] getChannels() {
        return null;
    }

    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        return false;
    }

    public Soundbank getDefaultSoundbank() {
        return null;
    }

    public Instrument[] getAvailableInstruments() {
        return null;
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        return false;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.deviceInfo;
    }

    public void open() throws MidiUnavailableException {
    }

    public void close() {
    }

    public boolean isOpen() {
        return false;
    }

    public long getMicrosecondPosition() {
        return 0L;
    }

    public int getMaxReceivers() {
        return -1;
    }

    public int getMaxTransmitters() {
        return 0;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    public List getReceivers() {
        return this.receivers;
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return null;
    }

    public List getTransmitters() {
        return null;
    }

    public String toString() {
        return this.getDeviceInfo().toString();
    }

    public void instrumentNameChange(Synth synth, String instrumentName) {
    }

    public MidiDevice getDefaultMidiDevice() {
        return this.defaultDevice;
    }

    public void setDefaultMidiDevice(MidiDevice midiDevice) {
        if (this.defaultDevice != midiDevice) {
            if (this.defRecv != null) {
                this.defRecv.close();
            }
            try {
                midiDevice.open();
                this.defRecv = midiDevice.getReceiver();
                System.out.println(" Set default receiver " + this.defRecv);
                this.defaultDevice = midiDevice;
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        this.defaultDevice = midiDevice;
    }

    public JPanel getGUIPanel(ProjectFrame frame, MidiLane lane) {
        return new DrumMapperGUI(this, frame.getProjectContainer(), lane);
    }

    public NoteMap getNoteMap(int i) {
        return this.noteMap[i];
    }

    public void setMapping(int in, int out) {
        if (in < 0 || in > 127) {
            return;
        }
        if (out < 0 || out > 127) {
            return;
        }
        System.out.println(in + " --->" + out);
        this.noteMap[in].note = out;
    }

    public void setNoteMap(int[] noteMap2) {
        for (int i = 0; i < 128; ++i) {
            this.noteMap[i].note = noteMap2[i];
        }
    }

    public static class DrumMapperInfo
    extends MidiDevice.Info {
        DrumMapperInfo() {
            super("DrumMapper", "drpj.co.uk", "A MIDI drum mapper", "0.0.1");
        }
    }

    public class NoteMap {
        public int note;
    }
}

