/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.notation;

import com.frinika.localization.CurrentLocale;
import com.frinika.notation.NotationGraphics;
import com.frinika.notation.NotationHeader;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.DragViewTool;
import com.frinika.sequencer.gui.EraseTool;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.MyCursors;
import com.frinika.sequencer.gui.RectZoomTool;
import com.frinika.sequencer.gui.SelectTool;
import com.frinika.sequencer.gui.WriteTool;
import com.frinika.sequencer.gui.pianoroll.AudioFeedBack;
import com.frinika.sequencer.gui.pianoroll.DragEventListener;
import com.frinika.sequencer.gui.pianoroll.ItemPanelMultiEventListener;
import com.frinika.sequencer.gui.pianoroll.ItemPanelPartListener;
import com.frinika.sequencer.gui.selection.DragList;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.notation.ClefChange;
import com.frinika.sequencer.model.util.EventFilter;
import com.frinika.sequencer.model.util.EventsInPartsIterator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class NotationEditor
extends ItemPanel
implements EditHistoryListener,
EventFilter {
    private static double[] NOTE_DIFFLEN = new double[20];
    private static double NOTE_TRIPLET;
    Iterable<MultiEvent> notesOnScreen;
    Iterable<MultiEvent> notesInFocus;
    EditHistoryContainer editHistory;
    ItemPanelMultiEventListener multiEventListener;
    ItemPanelPartListener partListener;
    AudioFeedBack audioFeedBack;
    private NoteEvent newNote = null;
    int velocity = 100;
    int channel = 1;
    public NotationHeader header;
    NotationGraphics ng = new NotationGraphics();
    Font romanfont;
    Font romanfont2;
    double bar_zoomout_level = 0.1;
    Map<MidiLane, Integer> laneY = new HashMap<MidiLane, Integer>();
    Map<MidiLane, ClefChange> laneClef = new HashMap<MidiLane, ClefChange>();
    private static final long serialVersionUID = 1L;
    int noteItemHeight = 3;
    final Rectangle rectTmp = new Rectangle();

    public static void main(String[] args) {
        double tr = 1.0;
        int[] ret = NotationEditor.parseDurToNotationLength(tr);
        System.out.println(tr + " => " + ret[0] + " , " + ret[1] + " , " + ret[2]);
        tr = 0.6666666666666666;
        ret = NotationEditor.parseDurToNotationLength(tr);
        System.out.println(tr + " => " + ret[0] + " , " + ret[1] + " , " + ret[2]);
    }

    private static double calcDottedDiffLen(int i) {
        if (i < 1) {
            return 0.0;
        }
        if (i == 1) {
            return 1.0 - Math.log(1.5) / Math.log(4.0);
        }
        return NotationEditor.calcDottedDiffLen(i - 1) - Math.log(1.0 + 3.0 / (Math.pow(2.0, i) * 2.0 - 4.0)) / Math.log(4.0);
    }

    public static int[] parseDurToNotationLength(double tickdur) {
        int[] ret = new int[4];
        double loglen = 2.0 - Math.log(tickdur) / Math.log(2.0);
        int dur = (int)(loglen + (1.0 - NOTE_DIFFLEN[1]));
        int dotted = 0;
        double durmod = loglen - (double)dur;
        if (dur >= 1 && durmod >= NOTE_TRIPLET - 0.1 && durmod <= NOTE_TRIPLET + 0.1) {
            ret[0] = dur;
            ret[1] = dotted;
            ret[2] = 2;
            ret[3] = 3;
            return ret;
        }
        if (durmod >= NOTE_DIFFLEN[2]) {
            dotted = 1;
        } else if (durmod >= NOTE_DIFFLEN[3]) {
            dotted = 2;
        } else if (durmod >= NOTE_DIFFLEN[4]) {
            dotted = 3;
        }
        if (dotted != 0) {
            // empty if block
        }
        ret[0] = ++dur;
        ret[1] = dotted;
        return ret;
    }

    protected NotationEditor(ProjectFrame frame, ItemScrollPane scroller) {
        super(frame, scroller, true, true, 0.5, false);
        this.notesOnScreen = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                return new EventsInPartsIterator(NotationEditor.this.project.getPartSelection().getSelected(), (EventFilter)NotationEditor.this);
            }
        };
        this.notesInFocus = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                Part focus = (Part)NotationEditor.this.project.getPartSelection().getFocus();
                if (focus == null) {
                    return null;
                }
                return new EventsInPartsIterator((Part)NotationEditor.this.project.getPartSelection().getFocus(), (EventFilter)NotationEditor.this);
            }
        };
        this.project.getDragList().addDragEventListener(new DragEventListener(){

            public void update() {
                NotationEditor.this.repaintItems();
            }
        });
        this.sequencer = this.project.getSequencer();
        this.sequencer.addSongPositionListener(new SwingSongPositionListenerWrapper(this));
        this.audioFeedBack = new AudioFeedBack(this.project);
        this.multiEventListener = new ItemPanelMultiEventListener(this);
        this.partListener = new ItemPanelPartListener(this);
        this.project.getMultiEventSelection().addSelectionListener(this.multiEventListener);
        this.project.getPartSelection().addSelectionListener(this.partListener);
        FrinikaSequence seq = (FrinikaSequence)this.sequencer.getSequence();
        this.ticksPerBeat = seq.getResolution();
        this.editHistory = this.project.getEditHistoryContainer();
        this.editHistory.addEditHistoryListener(this);
        this.ng.setSize(30.0f);
        this.romanfont = new Font("Times new roman", 1, 16).deriveFont(this.ng.getGridSize() * 2.0f);
        this.romanfont2 = new Font("Times new roman", 0, 16).deriveFont(this.ng.getGridSize() * 1.8f);
        this.addComponentListener(this);
        this.makeTools();
        this.enableEvents(16L);
        this.setFocusable(true);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.grabFocus();
        }
        super.processMouseEvent(e);
    }

    void makeTools() {
        Cursor c = new Cursor(0);
        this.selectTool = new SelectTool(c);
        this.rectZoomTool = new RectZoomTool(c);
        this.writeTool = new WriteTool(MyCursors.getCursor("pencil"));
        this.eraseTool = new EraseTool(MyCursors.getCursor("eraser"));
        this.dragViewTool = new DragViewTool(MyCursors.getCursor("move"));
    }

    public boolean isBarTick(long tick) {
        int bar = this.project.getSequence().getResolution() * 4;
        return tick % (long)bar == 0L;
    }

    public long nextBarTick(long tick) {
        int bar = this.project.getSequence().getResolution() * 4;
        return tick - tick % (long)bar + (long)bar;
    }

    public long previousBarTick(long tick) {
        int bar = this.project.getSequence().getResolution() * 4;
        return tick - tick % (long)bar;
    }

    private long org_screenToTick(int x, boolean quantizeMe) {
        return super.screenToTickAbs(x, quantizeMe);
    }

    private int org_tickToScreen(long tick) {
        return (int)super.userToScreen(tick);
    }

    public MidiLane getLaneAtY(int y) {
        HashSet<Lane> selectedlanes = new HashSet<Lane>();
        Collection parts = this.project.getPartSelection().getSelected();
        for (Part part : parts) {
            if (selectedlanes.contains(part.getLane())) continue;
            selectedlanes.add(part.getLane());
        }
        this.ng.absoluteY(0.0f);
        List<Lane> lanes = this.project.getLanes();
        for (Lane lane : lanes) {
            if (!selectedlanes.contains(lane) || !(lane instanceof MidiLane)) continue;
            MidiLane midilane = (MidiLane)lane;
            this.ng.relativeLine(20.0f);
            if ((float)y < this.ng.getCurrentY()) {
                return midilane;
            }
            this.ng.relativeLine(-6.0f);
        }
        return null;
    }

    public ClefChange getClef(MidiLane lane) {
        MultiEvent event;
        MidiPart head = lane.getHeadPart();
        Object clef_event = null;
        Iterator iter = head.getMultiEvents().iterator();
        while (iter.hasNext() && (event = (MultiEvent)iter.next()).getStartTick() <= 0L) {
            if (!(event instanceof ClefChange)) continue;
            return (ClefChange)event;
        }
        return new ClefChange(head, 0L);
    }

    public long screenToTick(int x, boolean quantizeMe) {
        long b2;
        long blen;
        long b1;
        long tick = super.screenToTickAbs(x, false);
        double d = (double)(tick - (b1 = this.previousBarTick(tick))) / (1.0 - this.bar_zoomout_level) - ((double)(blen = (b2 = this.nextBarTick(tick)) - b1) * this.bar_zoomout_level + 0.5);
        if (d < 0.0) {
            d = 0.0;
        } else if (d > (double)blen) {
            d = blen;
        }
        tick = b1 + (long)d;
        if (quantizeMe) {
            double tt = tick;
            double quant = this.getSnapQuantization();
            if (quant < 0.0) {
                try {
                    throw new Exception(" SNAP TO BAR NOT IMPLEMENTED IN NOTATION ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return tick;
                }
            }
            tt = (double)Math.round(tt / this.getSnapQuantization()) * this.getSnapQuantization();
            tick = (long)tt;
        }
        return tick;
    }

    public double tickToScreen(long tick) {
        long b1 = this.previousBarTick(tick);
        long b2 = this.nextBarTick(tick);
        long blen = b2 - b1;
        tick = b1 + (long)((double)blen * this.bar_zoomout_level * 0.5 + (double)(tick - b1) * (1.0 - this.bar_zoomout_level));
        double x = super.userToScreen(tick);
        return x;
    }

    public void paintHeader(Graphics g, int scroll) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.DARK_GRAY);
        g2.fillRect(0, 0, 400, 20);
        g2.setColor(Color.BLACK);
        this.ng.setGraphics(g2);
        this.ng.absoluteY(20 - scroll);
        HashSet<Lane> selectedlanes = new HashSet<Lane>();
        Collection parts = this.project.getPartSelection().getSelected();
        for (Part part : parts) {
            if (selectedlanes.contains(part.getLane())) continue;
            selectedlanes.add(part.getLane());
        }
        this.laneY.clear();
        this.laneClef.clear();
        List<Lane> lanes = this.project.getLanes();
        for (Lane lane : lanes) {
            if (!selectedlanes.contains(lane) || !(lane instanceof MidiLane)) continue;
            MidiLane midilane = (MidiLane)lane;
            this.ng.absolute(0.0f);
            this.ng.relativeLine(14.0f);
            this.laneY.put(midilane, (int)this.ng.getCurrentY());
            this.laneClef.put(midilane, this.getClef(midilane));
            this.ng.drawStaff(this.header.getSize().width);
            this.ng.relative(1.0f);
            ClefChange clefevent = this.getClef(midilane);
            this.ng.drawClef(clefevent.clef_type, clefevent.clef_pos);
            g2.setFont(this.romanfont);
            g2.drawString(midilane.getName(), this.ng.getCurrentX(), this.ng.getCurrentY() - this.ng.getGridSize() * 6.5f);
            this.ng.relative(4.0f);
            this.ng.drawTimeSignature(0);
            this.ng.relative(3.0f);
            g2.setFont(this.romanfont2);
            this.ng.relative(3.0f);
        }
    }

    public int[] getNotationNotePos(ClefChange clef_event, int note) {
        int oct = note / 12 - 5;
        int not = note % 12;
        int n = 0;
        int a = 0;
        if (not == 0) {
            n = 0;
            a = 0;
        }
        if (not == 1) {
            n = 0;
            a = 100;
        }
        if (not == 2) {
            n = 1;
            a = 0;
        }
        if (not == 3) {
            n = 1;
            a = 100;
        }
        if (not == 4) {
            n = 2;
            a = 0;
        }
        if (not == 5) {
            n = 3;
            a = 0;
        }
        if (not == 6) {
            n = 3;
            a = 100;
        }
        if (not == 7) {
            n = 4;
            a = 0;
        }
        if (not == 8) {
            n = 4;
            a = 100;
        }
        if (not == 9) {
            n = 5;
            a = 0;
        }
        if (not == 10) {
            n = 5;
            a = 100;
        }
        if (not == 11) {
            n = 6;
            a = 0;
        }
        n += oct * 7;
        if (clef_event.clef_type == 7) {
            n -= 0 - (clef_event.clef_pos - 2);
        } else if (clef_event.clef_type == 0) {
            n -= -4 - (clef_event.clef_pos - 2);
        } else if (clef_event.clef_type == -7) {
            n -= -8 - (clef_event.clef_pos - 2);
        }
        int[] ret = new int[]{n, a};
        return ret;
    }

    public int getNoteFromPos(ClefChange clef_event, int n) {
        if (clef_event.clef_type == 7) {
            n += 0 - (clef_event.clef_pos - 2);
        } else if (clef_event.clef_type == 0) {
            n += -4 - (clef_event.clef_pos - 2);
        } else if (clef_event.clef_type == -7) {
            n += -8 - (clef_event.clef_pos - 2);
        }
        int oct = n / 7;
        if ((n -= oct * 7) < 0) {
            n += 7;
            --oct;
        }
        int not = 0;
        if (n == 0) {
            not = 0;
        }
        if (n == 1) {
            not = 2;
        }
        if (n == 2) {
            not = 4;
        }
        if (n == 3) {
            not = 5;
        }
        if (n == 4) {
            not = 7;
        }
        if (n == 5) {
            not = 9;
        }
        if (n == 6) {
            not = 11;
        }
        return not + (oct += 5) * 12;
    }

    protected void paintImageImpl(Rectangle clipRect, Graphics2D g) {
        int clip_min_x = clipRect.x - 500;
        if (clip_min_x < 0) {
            clip_min_x = 0;
        }
        int clip_max_x = clipRect.x + clipRect.width + 500;
        Graphics2D g2 = g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        g2.setColor(Color.BLACK);
        this.ng.setGraphics(g2);
        HashSet<Lane> selectedlanes = new HashSet<Lane>();
        Collection parts = this.project.getPartSelection().getSelected();
        for (Part part : parts) {
            if (selectedlanes.contains(part.getLane())) continue;
            selectedlanes.add(part.getLane());
        }
        this.ng.absoluteLine(0.0f);
        boolean newNoteAdded = true;
        if (this.newNote != null) {
            newNoteAdded = false;
        }
        int res = this.project.getSequence().getResolution();
        DragList dragList = this.project.getDragList();
        List<Lane> lanes = this.project.getLanes();
        for (Lane lane : lanes) {
            List nextitem;
            int x;
            if (!selectedlanes.contains(lane) || !(lane instanceof MidiLane)) continue;
            this.ng.absolute(0.0f);
            this.ng.relativeLine(14.0f);
            this.ng.drawStaff(clipRect.width + clipRect.x);
            long firsttick = this.org_screenToTick(clipRect.x, false);
            int max_x = clipRect.width + clipRect.x;
            long tt = firsttick;
            while ((x = this.org_tickToScreen(tt = this.nextBarTick(tt))) <= max_x) {
                this.ng.absoluteX(x);
                this.ng.drawBarLine();
            }
            MidiLane midilane = (MidiLane)lane;
            ClefChange clef_event = this.getClef(midilane);
            int id_count = 0;
            TreeSet<NoteEventTick> multiEventsTicks = new TreeSet<NoteEventTick>();
            block3: for (Part part : midilane.getParts()) {
                if (!(part instanceof MidiPart) || !this.project.getPartSelection().getSelected().contains(part)) continue;
                MidiPart midipart = (MidiPart)part;
                boolean startread = false;
                for (Comparable event : midipart.getMultiEvents()) {
                    if (!(event instanceof NoteEvent)) continue;
                    NoteEvent noteevent = (NoteEvent)event;
                    if (!dragList.isEmpty() && noteevent.isSelected()) {
                        noteevent = null;
                    }
                    if (noteevent == null) continue;
                    if (!newNoteAdded && noteevent.getStartTick() > this.newNote.getStartTick()) {
                        newNoteAdded = true;
                        NoteEventTick n = new NoteEventTick();
                        n.id = id_count++;
                        n.event = this.newNote;
                        n.tick = this.newNote.getStartTick();
                        n.status = 1;
                        multiEventsTicks.add(n);
                        n = new NoteEventTick();
                        n.id = id_count++;
                        n.event = this.newNote;
                        n.tick = this.newNote.getEndTick();
                        n.status = 0;
                        multiEventsTicks.add(n);
                    }
                    int x2 = (int)this.tickToScreen(noteevent.getStartTick());
                    if (!startread && x2 >= clip_min_x) {
                        startread = true;
                    }
                    if (!startread) continue;
                    NoteEventTick n = new NoteEventTick();
                    n.id = id_count++;
                    n.event = noteevent;
                    n.tick = noteevent.getStartTick();
                    n.status = 1;
                    multiEventsTicks.add(n);
                    if (noteevent.isDrumHit()) {
                        n.status = 2;
                    } else {
                        n = new NoteEventTick();
                        n.id = id_count++;
                        n.event = noteevent;
                        n.tick = noteevent.getEndTick();
                        n.status = 0;
                        multiEventsTicks.add(n);
                    }
                    if (x2 <= clip_max_x) continue;
                    continue block3;
                }
            }
            for (Item item : dragList) {
                NoteEvent noteevent = (NoteEvent)item;
                if (noteevent.getPart().getLane() != lane) continue;
                int x3 = (int)this.tickToScreen(noteevent.getStartTick());
                NoteEventTick n = new NoteEventTick();
                n.isdragged = true;
                n.id = id_count++;
                n.event = noteevent;
                n.tick = noteevent.getStartTick();
                n.status = 1;
                multiEventsTicks.add(n);
                if (noteevent.isDrumHit()) {
                    n.status = 2;
                    continue;
                }
                n = new NoteEventTick();
                n.isdragged = true;
                n.id = id_count++;
                n.event = noteevent;
                n.tick = noteevent.getEndTick();
                n.status = 0;
                multiEventsTicks.add(n);
            }
            this.ng.relative(1.0f);
            long max_tick = 0L;
            TreeMap tickslist = new TreeMap();
            for (NoteEventTick event : multiEventsTicks) {
                ArrayList<NoteEventTick> list = (ArrayList<NoteEventTick>)tickslist.get(event.tick);
                if (list == null) {
                    list = new ArrayList<NoteEventTick>();
                    tickslist.put(event.tick, list);
                }
                if (event.tick > max_tick) {
                    max_tick = event.tick;
                }
                list.add(event);
            }
            long m = 0L;
            m = this.screenToTick(clip_min_x, false);
            if (m < 0L) {
                m = 0L;
            }
            m -= m % (long)(res * 4);
            while (m < max_tick) {
                Comparable event;
                event = new NoteEventTick();
                ((NoteEventTick)event).tick = m;
                ((NoteEventTick)event).status = 2;
                ArrayList<MultiEvent> list = (ArrayList<MultiEvent>)tickslist.get(((NoteEventTick)event).tick);
                if (list == null) {
                    list = new ArrayList<MultiEvent>();
                    tickslist.put(((NoteEventTick)event).tick, list);
                }
                list.add((MultiEvent)event);
                m += (long)(res * 4);
            }
            this.ng.startNoteGroup();
            TreeMap<Integer, NoteEventTick> act = new TreeMap<Integer, NoteEventTick>();
            Iterator iter = tickslist.values().iterator();
            List list = nextitem = iter.hasNext() ? (List)iter.next() : null;
            while (nextitem != null) {
                NoteEventTick noteevent;
                NoteEventTick event;
                List curitem = nextitem;
                List list2 = nextitem = iter.hasNext() ? (List)iter.next() : null;
                if (this.isBarTick(((NoteEventTick)curitem.get((int)0)).tick)) {
                    this.ng.endNoteGroup();
                    this.ng.startNoteGroup();
                }
                this.ng.absoluteX((int)this.tickToScreen(((NoteEventTick)curitem.get((int)0)).tick));
                long tickdur = nextitem == null ? (long)res : ((NoteEventTick)nextitem.get((int)0)).tick - ((NoteEventTick)curitem.get((int)0)).tick;
                int[] ret = NotationEditor.parseDurToNotationLength((double)tickdur / (double)res);
                int dur = ret[0];
                int dotted = ret[1];
                int tuplet_a = ret[2];
                int tuplet_b = ret[3];
                boolean noteprinted = false;
                Iterator<Object> i$ = curitem.iterator();
                while (i$.hasNext()) {
                    noteevent = event = (NoteEventTick)i$.next();
                    if (noteevent.status == 0) {
                        act.remove(noteevent.event.getNote());
                    }
                    if (noteevent.status != 1) continue;
                    act.put(noteevent.event.getNote(), noteevent);
                }
                i$ = act.values().iterator();
                while (i$.hasNext()) {
                    noteevent = event = (NoteEventTick)i$.next();
                    if (noteevent.status != 1) continue;
                    noteprinted = true;
                    int note = noteevent.event.getNote();
                    int[] n_ret = this.getNotationNotePos(clef_event, note);
                    int n = n_ret[0];
                    int a = n_ret[1];
                    NotationGraphics.Note notegraphic = this.ng.drawNote(n - 2, dur);
                    notegraphic.dotted = dotted;
                    if (tuplet_a == 2 && tuplet_b == 3) {
                        notegraphic.color = Color.BLUE;
                    }
                    if (event.isdragged) {
                        notegraphic.color = Color.RED;
                    }
                    if (noteevent.event.isSelected()) {
                        notegraphic.color = Color.RED;
                    }
                    if (this.newNote != null && noteevent.event == this.newNote) {
                        notegraphic.color = Color.GRAY;
                    }
                    notegraphic.accidental = a;
                    if (noteevent.lastnote != null) {
                        this.ng.drawNoteTie(noteevent.lastnote, notegraphic);
                    }
                    noteevent.lastnote = notegraphic;
                }
                if (noteprinted || dur >= 8 || nextitem == null) continue;
                this.ng.drawRest(dur, dotted);
            }
            this.ng.endNoteGroup();
        }
    }

    public double getSnapQuantization() {
        return this.project.getPianoRollSnapQuantization();
    }

    public void setSnapQuantization(double quant) {
        this.project.setPianoRollSnapQuantization(quant);
        this.repaintItems();
    }

    public boolean isSnapQuantized() {
        return this.project.isPianoRollSnapQuantized();
    }

    public void setSnapQuantized(boolean b) {
        this.project.setPianoRollSnapQuantized(b);
    }

    public void setFocus(Item item) {
        this.project.getMultiEventSelection().setFocus((MultiEvent)item);
        this.project.getPartSelection().notifyListeners();
        this.repaintItems();
    }

    public void clientNotifySelectionChange() {
        this.project.getPartSelection().notifyListeners();
    }

    public void setTimeAtX(int x) {
        long tick = this.screenToTick(x, this.project.isPianoRollSnapQuantized());
        this.sequencer.setTickPosition(tick);
    }

    public void startDrag() {
        this.project.getDragList().startDrag(this.dragItem);
    }

    public void dragTo(Point p) {
        long tick;
        int dxDragged = p.x - this.xAnchor;
        int dyDragged = p.y - this.yAnchor;
        long dtick = this.org_screenToTick(dxDragged, this.project.isPianoRollSnapQuantized());
        int dpitch = 0;
        if (this.dragMode == 1) {
            dpitch = -dyDragged / this.noteItemHeight;
        }
        if (dtick == 0L && dpitch == 0) {
            return;
        }
        if (this.dragArmed) {
            this.startDrag();
        }
        this.dragArmed = false;
        DragList dragList = this.project.getDragList();
        if (dpitch != 0) {
            int pitlim = dpitch > 0 ? 0 : 127;
            for (Item it : dragList) {
                NoteEvent ev = (NoteEvent)it;
                int pitch = ev.getNote() + dpitch;
                if (dpitch > 0) {
                    pitlim = Math.max(pitch, pitlim);
                    continue;
                }
                pitlim = Math.min(pitch, pitlim);
            }
            if (dpitch > 0 && pitlim > 127) {
                dpitch -= pitlim - 127;
            } else if (dpitch < 0 && pitlim < 0) {
                dpitch -= pitlim;
            }
        }
        long dt = 0L;
        for (Item it : dragList) {
            NoteEvent ev = (NoteEvent)it;
            switch (this.dragMode) {
                case 1: {
                    tick = ev.getStartTick() + dtick;
                    int pitch = ev.getNote() + dpitch;
                    dt = Math.min(dt, tick);
                    ev.setStartTick(tick);
                    ev.setNote(pitch);
                    break;
                }
                case 2: {
                    long dur = ev.getDuration() + dtick;
                    dur = Math.max(1L, dur);
                    ev.setDuration(dur);
                    break;
                }
                case 3: {
                    long dur = ev.getDuration() - dtick;
                    long st = ev.getStartTick() + dtick;
                    dur = Math.max(1L, dur);
                    ev.setDuration(dur);
                    ev.setStartTick(st);
                    break;
                }
                default: {
                    System.err.println(" unknown dragmode " + this.dragMode);
                    try {
                        throw new Exception("WHY OH WHY ARE WE HERE NOW");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (dpitch == 0) continue;
            this.feedBack(ev);
        }
        if (dt != 0L) {
            for (Item it : dragList) {
                NoteEvent ev = (NoteEvent)it;
                tick = ev.getStartTick() - dt;
                ev.setStartTick(tick);
            }
        }
        this.project.getDragList().notifyDragEventListeners();
        this.project.getDragList().notifyFeedbackItemListeners();
        this.xAnchor += (int)((double)dtick * this.userToScreen);
        this.yAnchor -= dpitch * this.noteItemHeight;
    }

    public void endDrag() {
        if (this.dragArmed) {
            this.dragArmed = false;
            return;
        }
        this.project.getDragList().endDrag(this.controlIsDown);
    }

    public int getHoverStateAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (!(focusPart instanceof MidiPart)) {
            return 0;
        }
        int endTol = 20;
        int tol = 20;
        Iterable<MultiEvent> list = focusPart == null ? this.notesOnScreen : ((MidiPart)focusPart).getMultiEvents();
        for (MultiEvent e : list) {
            Rectangle rect;
            if (!(e instanceof NoteEvent) || !(rect = this.getItemBounds(e)).contains(p)) continue;
            return 1;
        }
        return 0;
    }

    public Item itemAt(Point p) {
        MultiEvent at = null;
        for (MultiEvent note : this.notesOnScreen) {
            if (!this.getItemBounds(note).contains(p)) continue;
            if (note.isSelected()) {
                return note;
            }
            if (at != null) continue;
            at = note;
        }
        return at;
    }

    protected void paintImageImplLabel(Graphics2D graphics) {
    }

    public void clientClearSelection() {
        this.project.getMultiEventSelection().clearSelection();
    }

    private Rectangle getItemBounds(Item it) {
        NoteEvent e = (NoteEvent)it;
        long tick = e.getStartTick();
        int x1 = (int)this.tickToScreen(tick);
        int pitch = e.getNote();
        int cy = this.laneY.get(e.getMidiPart().getLane());
        ClefChange clef = this.laneClef.get(e.getMidiPart().getLane());
        if (clef == null) {
            return null;
        }
        int[] n_ret = this.getNotationNotePos(clef, e.getNote());
        int n = n_ret[0] + 4;
        float grid = this.ng.getGridSize();
        float y = (float)cy - (float)n * grid * 0.5f;
        int noteItemWidth = (int)(grid * 1.2f);
        int noteItemHeight = (int)grid;
        int y1 = (int)y;
        int dd = noteItemHeight / 2 - 1;
        this.rectTmp.setBounds(x1, y1, noteItemWidth, noteItemHeight);
        return this.rectTmp;
    }

    public void selectInRect(Rectangle rect, boolean shift) {
        Vector<MultiEvent> addTmp = new Vector<MultiEvent>();
        Vector<MultiEvent> delTmp = new Vector<MultiEvent>();
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (!(focusPart instanceof MidiPart)) {
            return;
        }
        Iterable<MultiEvent> list = this.notesOnScreen;
        for (MultiEvent note : list) {
            if (!(note instanceof NoteEvent) || !rect.intersects(this.getItemBounds((NoteEvent)note))) continue;
            if (shift) {
                if (note.isSelected()) {
                    delTmp.add(note);
                    continue;
                }
                addTmp.add(note);
                continue;
            }
            addTmp.add(note);
        }
        this.project.getMultiEventSelection().removeSelected(delTmp);
        this.project.getMultiEventSelection().addSelected(addTmp);
        this.project.getMultiEventSelection().notifyListeners();
    }

    protected void writeReleasedAt(Point p) {
        if (this.newNote == null) {
            return;
        }
        this.newNote.getPart().add(this.newNote);
        this.project.getMultiEventSelection().setSelected(this.newNote);
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getMultiEventSelection().notifyListeners();
        this.newNote = null;
    }

    public synchronized void writeDraggedAt(Point p) {
        if (this.newNote == null) {
            return;
        }
        long tick = this.screenToTick(p.x, true);
        long tick1 = this.newNote.getStartTick();
        long tick2 = tick1 + this.newNote.getDuration();
        int pitch = this.screenToPitch((MidiLane)this.newNote.getMidiPart().getLane(), p.y);
        boolean doit = false;
        if (tick > tick2) {
            this.newNote.setDuration(tick - tick1);
            doit = true;
        } else if (tick < tick2 && tick > tick1) {
            this.newNote.setDuration(tick - tick1);
            doit = true;
        }
        if (pitch != this.newNote.getNote()) {
            doit = true;
            this.newNote.setNote(pitch);
            this.feedBack(this.newNote);
        }
        this.project.getDragList().notifyFeedbackItemListeners(this.newNote);
        if (doit) {
            this.repaintItems();
        }
    }

    protected synchronized void writePressedAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (focusPart == null || !(focusPart instanceof MidiPart)) {
            System.out.println(" Please slectect a part ");
            return;
        }
        long tick = this.screenToTick(p.x, true);
        int pitch = this.screenToPitch((MidiLane)focusPart.getLane(), p.y);
        assert (pitch > 0);
        assert (pitch < 128);
        this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.add_note"));
        this.newNote = new NoteEvent((MidiPart)focusPart, tick, pitch, this.velocity, this.channel, (long)this.project.getPianoRollSnapQuantization());
        this.feedBack(this.newNote);
        this.project.getDragList().notifyFeedbackItemListeners(this.newNote);
        this.repaintItems();
    }

    public int screenToPitch(MidiLane lane, int y) {
        Integer cy_o = this.laneY.get(lane);
        if (cy_o == null) {
            return 64;
        }
        int cy = cy_o;
        ClefChange clef = this.laneClef.get(lane);
        float grid = this.ng.getGridSize();
        int n = (int)(((float)cy - ((float)y - grid * 0.6f)) / (grid * 0.5f));
        int note = this.getNoteFromPos(clef, n -= 4);
        if (note < 0) {
            note = 0;
        }
        if (note > 127) {
            note = 127;
        }
        return note;
    }

    public void rightButtonPressedOnItem(int x, int y) {
    }

    public void feedBack(Item item) {
        this.audioFeedBack.select((NoteEvent)item);
    }

    public void clientAddToSelection(Item item) {
        this.project.getPartSelection().setFocus(((MultiEvent)item).getPart());
        this.project.getMultiEventSelection().addSelected((NoteEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    public void clientRemoveFromSelection(Item item) {
        this.project.getMultiEventSelection().removeSelected((NoteEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    public void erase(Item it) {
        NoteEvent note = (NoteEvent)it;
        this.editHistory.mark(CurrentLocale.getMessage("sequencer.pianoroll.erase_note"));
        note.getPart().remove(note);
        this.editHistory.notifyEditHistoryListeners();
    }

    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryEntries) {
        this.repaintItems();
    }

    public boolean isValidEvent(MultiEvent event) {
        return event instanceof NoteEvent;
    }

    public void repaintItems() {
        super.repaintItems();
        this.header.repaint();
    }

    public void dispose() {
        this.project.getMultiEventSelection().removeSelectionListener(this.multiEventListener);
        this.project.getPartSelection().removeSelectionListener(this.partListener);
        this.editHistory.removeEditHistoryListener(this);
    }

    static {
        for (int i = 0; i < 20; ++i) {
            NotationEditor.NOTE_DIFFLEN[i] = NotationEditor.calcDottedDiffLen(i);
        }
        NOTE_TRIPLET = 2.0 - Math.log(2.6666666666666665) / Math.log(2.0);
    }

    class NoteEventTick
    implements Comparable {
        boolean isdragged = false;
        int status;
        long tick;
        int id;
        NoteEvent event;
        NotationGraphics.Note lastnote;

        NoteEventTick() {
        }

        public int compareTo(Object o) {
            long t = this.tick - ((NoteEventTick)o).tick;
            if (t < 0L) {
                return -1;
            }
            if (t > 0L) {
                return 1;
            }
            return this.id - ((NoteEventTick)o).id;
        }
    }
}

