/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.ogg;

import biniu.ogg.Packet;
import biniu.ogg.Page;
import biniu.ogg.StreamState;
import biniu.vorbis.Block;
import biniu.vorbis.Comment;
import biniu.vorbis.DspState;
import biniu.vorbis.Info;
import biniu.vorbis.VorbisEnc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileWriter;

public class OggAudioFileWriter
extends AudioFileWriter {
    AudioFileFormat.Type oggtype = new AudioFileFormat.Type("OGG", "ogg");
    AudioFileFormat.Type[] empty = new AudioFileFormat.Type[0];
    AudioFileFormat.Type[] types = new AudioFileFormat.Type[1];

    public OggAudioFileWriter() {
        this.types[0] = this.oggtype;
    }

    public AudioFileFormat.Type[] getAudioFileTypes() {
        return this.types;
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFormat format = stream.getFormat();
        if ((stream = this.convertStream(stream)) == null) {
            return this.empty;
        }
        return this.types;
    }

    private AudioInputStream convertStream(AudioInputStream stream) {
        AudioFormat format = stream.getFormat();
        if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && format.getSampleSizeInBits() == 16 && !format.isBigEndian()) {
            return stream;
        }
        AudioFormat convformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), 2 * format.getChannels(), format.getSampleRate(), false);
        if (!AudioSystem.isConversionSupported(convformat, format)) {
            return null;
        }
        return AudioSystem.getAudioInputStream(convformat, stream);
    }

    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        boolean result;
        if (fileType != this.oggtype) {
            throw new IllegalArgumentException("Invalid file type.");
        }
        if ((stream = this.convertStream(stream)) == null) {
            throw new IOException("Invalid stream format.");
        }
        int READ = 1024;
        byte[] readbuffer = new byte[READ * 4 + 44];
        StreamState os = new StreamState();
        Page og = new Page();
        Packet op = new Packet();
        Info vi = new Info();
        Comment vc = new Comment();
        DspState vd = new DspState();
        Block vb = new Block(vd);
        boolean eos = false;
        VorbisEnc ve = new VorbisEnc();
        vi.init();
        AudioFormat format = stream.getFormat();
        int ret = ve.initVBR(vi, format.getChannels(), (int)format.getSampleRate(), 0.1f);
        if (ret != 0) {
            System.exit(1);
        }
        vc.init();
        vc.addTag("ENCODER", "encoder_example.c");
        vd.analysisInit(vi);
        vb.blockInit(vd);
        Random rand = new Random();
        os.init(rand.nextInt());
        Packet header = new Packet();
        Packet header_comm = new Packet();
        Packet header_code = new Packet();
        vd.analysisHeaderOut(vc, header, header_comm, header_code);
        os.packetIn(header);
        os.packetIn(header_comm);
        os.packetIn(header_code);
        while (!eos && (result = os.flush(og))) {
            try {
                out.write(og.header_base, og.header, og.header_len);
                out.write(og.body_base, og.body, og.body_len);
            }
            catch (IOException ioe) {}
        }
        boolean pos = false;
        while (!eos) {
            int bytes = 0;
            try {
                bytes = stream.read(readbuffer, 0, READ * 4);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (bytes == 0) {
                vd.analysisWrote(0);
            } else {
                float[][] buffer = vd.analysisBuffer(READ);
                int i = 0;
                int l = vd.pcm_current;
                while (i < bytes / 4) {
                    buffer[0][l] = (float)(readbuffer[i * 4 + 1] << 8 | 0xFF & readbuffer[i * 4]) / 32768.0f;
                    buffer[1][l] = (float)(readbuffer[i * 4 + 3] << 8 | 0xFF & readbuffer[i * 4 + 2]) / 32768.0f;
                    ++i;
                    ++l;
                }
                vd.analysisWrote(i);
            }
            while (vb.analysisBlockOut()) {
                vb.analysis(null);
                vb.bitrateAddBlock();
                while (vd.bitrateFlushPacket(op)) {
                    os.packetIn(op);
                    while (!eos && (result = os.pageOut(og))) {
                        try {
                            out.write(og.header_base, og.header, og.header_len);
                            out.write(og.body_base, og.body, og.body_len);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (!og.eos()) continue;
                        eos = true;
                    }
                }
            }
        }
        os.clear();
        vb.clear();
        vd.clear();
        vc.clear();
        vi.clear();
        System.out.println("Done.\n");
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        int ret;
        FileOutputStream fos = new FileOutputStream(out);
        try {
            ret = this.write(stream, fileType, fos);
        }
        finally {
            fos.close();
        }
        return ret;
    }
}

