/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project;

import com.frinika.midi.DrumMapper;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class DrumMapperDescriptor
extends MidiDeviceDescriptor {
    private static final long serialVersionUID = 1L;
    transient ProjectContainer project;
    MidiDeviceDescriptor target;
    int[] noteMap = new int[128];

    public DrumMapperDescriptor(SynthWrapper midiDevice, ProjectContainer proj) {
        super(midiDevice);
        assert (midiDevice.getRealDevice() instanceof DrumMapper);
        this.project = proj;
    }

    protected void installImp(ProjectContainer project) {
        super.installImp(project);
        this.project = project;
        System.out.println("Installing DRUMMAPER ");
        if (this.target != null) {
            this.target.install(project);
            ((DrumMapper)((SynthWrapper)this.midiDevice).getRealDevice()).setDefaultMidiDevice(this.target.getMidiDevice());
        }
        ((DrumMapper)((SynthWrapper)this.midiDevice).getRealDevice()).setNoteMap(this.noteMap);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        System.out.println("Saving DRUMMAPPER");
        DrumMapper mapper = (DrumMapper)((SynthWrapper)this.midiDevice).getRealDevice();
        for (int i = 0; i < 128; ++i) {
            DrumMapper.NoteMap map = mapper.getNoteMap(i);
            this.noteMap[i] = map.note;
        }
        this.target = this.project.getMidiDeviceDescriptor(mapper.getDefaultMidiDevice());
        out.defaultWriteObject();
    }
}

