/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project;

import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.synth.SynthRack;
import com.frinika.synth.settings.SynthSettings;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;

public class FrinikaSynthRackDescriptor
extends MidiDeviceDescriptor {
    private static final long serialVersionUID = 1L;
    SynthSettings synthSetup;

    public FrinikaSynthRackDescriptor(SynthWrapper midiDevice) {
        super(midiDevice);
    }

    public static void fixLaneProgramChange(ProjectContainer project, MidiDevice midiDevice) {
        for (Lane lane : project.getLanes()) {
            if (!MidiLane.class.isInstance(lane)) continue;
            MidiLane midiLane = (MidiLane)lane;
            System.out.println("MDCH: " + midiLane.getMidiDeviceIndex() + " " + midiLane.getStoredMidiChannel());
            if (midiLane.getMidiDeviceIndex() == null || midiLane.getStoredMidiChannel() <= -1 || project.getSequencer().listMidiOutDevices().get(midiLane.getMidiDeviceIndex()) != midiDevice) continue;
            midiLane.setProgram(midiLane.getStoredMidiChannel(), 0, 0);
        }
    }

    protected void installImp(ProjectContainer project) {
        this.midiDevice = new SynthWrapper(project, new SynthRack(null));
        ((SynthRack)((SynthWrapper)this.midiDevice).getRealDevice()).loadSynthSetup(this.synthSetup);
        try {
            project.loadMidiOutDevice(this);
            if (!this.synthSetup.hasProgramChangeEvent()) {
                FrinikaSynthRackDescriptor.fixLaneProgramChange(project, this.midiDevice);
            }
        }
        catch (MidiUnavailableException e) {
            System.out.println("Unable to install Frinika synthRack");
            e.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.synthSetup = ((SynthRack)((SynthWrapper)this.midiDevice).getRealDevice()).getSynthSetup();
        out.defaultWriteObject();
    }
}

