/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import com.frinika.SplashDialog;
import com.frinika.audio.toot.AudioInjector;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.audio.toot.MidiHub;
import com.frinika.global.ConfigListener;
import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.midi.DrumMapper;
import com.frinika.project.DrumMapperDescriptor;
import com.frinika.project.FrinikaSynthRackDescriptor;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.MidiDeviceDescriptorClass;
import com.frinika.project.SynthesizerDescriptor;
import com.frinika.project.TootMixerSerializer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.project.scripting.FrinikaScriptingEngine;
import com.frinika.project.settings.ProjectSettings;
import com.frinika.renderer.FrinikaRenderer;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.MidiResource;
import com.frinika.sequencer.converter.MidiSequenceConverter;
import com.frinika.sequencer.gui.clipboard.MyClipboard;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.gui.selection.DragList;
import com.frinika.sequencer.gui.selection.LaneSelection;
import com.frinika.sequencer.gui.selection.MidiSelection;
import com.frinika.sequencer.gui.selection.MultiEventSelection;
import com.frinika.sequencer.gui.selection.PartSelection;
import com.frinika.sequencer.gui.selection.SelectionFocusable;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryRecorder;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.ProjectLane;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.SoloManager;
import com.frinika.sequencer.model.SynthLane;
import com.frinika.sequencer.model.TextLane;
import com.frinika.sequencer.model.ViewableLaneList;
import com.frinika.sequencer.model.audio.BufferedRandomAccessFileManager;
import com.frinika.sequencer.model.tempo.TempoList;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;
import com.frinika.sequencer.model.util.TimeUtils;
import com.frinika.synth.SynthRack;
import com.frinika.synth.settings.SynthSettings;
import com.frinika.tools.ObjectInputStreamFixer;
import com.frinika.tools.ProgressBarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import uk.co.simphoney.audio.XAudioLane;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.mixer.AudioMixer;
import uk.org.toot.audio.mixer.AudioMixerStrip;
import uk.org.toot.audio.mixer.MixControls;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.MixerControlsFactory;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectContainer
implements EditHistoryRecorder<Lane>,
Serializable {
    private static final long serialVersionUID = 1L;
    TootMixerSerializer mixerSerializer;
    ProjectLane projectLane;
    transient MidiResource midiResource;
    transient SoloManager soloManager;
    transient FrinikaSequencer sequencer;
    transient FrinikaRenderer renderer;
    transient FrinikaSequence sequence = null;
    transient EditHistoryContainer editHistoryContainer;
    transient MultiEventSelection multiEventSelection;
    transient DragList dragList;
    transient PartSelection partSelection;
    transient LaneSelection laneSelection;
    transient MidiSelection midiSelection;
    transient SelectionFocusable selectionFocus;
    File projectFile = null;
    File audioDir = null;
    transient SynthRack audioSynthRack;
    float tempo = 100.0f;
    transient MidiEvent tempoEvent;
    transient MixerControls mixerControls;
    transient AudioServer audioServer;
    transient AudioMixer mixer;
    transient AudioInjector outputProcess;
    transient BufferedRandomAccessFileManager audioFileManager;
    transient AudioClient audioClient;
    FrinikaScriptingEngine scriptingEngine;
    @Deprecated
    List<SynthSettings> synthSettings;
    @Deprecated
    Vector<String> externalMidiDevices;
    List<MidiDeviceDescriptor> midiDeviceDescriptors = new ArrayList<MidiDeviceDescriptor>();
    transient HashMap<MidiDevice, Integer> midiDeviceIndex;
    transient HashMap<MidiDevice, MidiDeviceDescriptor> midiDeviceDescriptorMap = new HashMap();
    transient TimeSignatureList timeSignitureList;
    int ticksPerQuarterNote = FrinikaConfig.TICKS_PER_QUARTER;
    private TempoList tempoList;
    private double pianoRollSnapQuantization = 0.0;
    private double partViewSnapQuantization = 0.0;
    private boolean isPianoRollSnapQuantized = true;
    private boolean isPartViewSnapQuantized = true;
    private boolean saveReferencedData;
    private transient MyClipboard myClipboard;
    long endTick = 100000L;
    private transient int count = 1;
    private transient int pixelsPerRedraw;
    public transient int compression_level = 0;
    private transient TimeUtils timeUtils;
    private static Vector<MidiDevice> midiOutList = new Vector();

    public void removeStrip(String name) {
        this.mixerControls.removeStripControls(name);
    }

    public MixControls addMixerInput(AudioProcess audioProcess, String string) {
        AudioMixerStrip strip = null;
        MixControls x = null;
        try {
            AudioControlsChain controls;
            strip = this.getMixer().getStrip(string);
            if (strip == null) {
                controls = this.mixerControls.createStripControls(120, this.count++, string);
                strip = this.getMixer().getStrip(string);
            } else {
                controls = this.mixerControls.getStripControls(string);
            }
            strip.setInputProcess(audioProcess);
            x = (MixControls)controls.find(this.mixerControls.getMainBusControls().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x;
    }

    void createMixer() {
        if (this.mixerControls != null) {
            return;
        }
        try {
            this.mixerControls = new MixerControls("Mixer");
            MixerControlsFactory.createBusses((MixerControls)this.mixerControls, (int)2, (int)1);
            MixerControlsFactory.createBusStrips((MixerControls)this.mixerControls);
            this.audioServer = FrinikaAudioSystem.getAudioServer();
            List list = this.audioServer.getAvailableOutputNames();
            String outDev = FrinikaAudioSystem.configureServerOutput();
            if (outDev != null) {
                this.outputProcess = new AudioInjector((AudioProcess)this.audioServer.openAudioOutput(outDev, "output"));
                System.out.println("Using " + outDev + " as audio out device");
                this.mixer = new AudioMixer(this.mixerControls, this.audioServer);
                this.mixer.getMainBus().setOutputProcess((AudioProcess)this.outputProcess);
                this.audioClient = new ProjectAudioClient();
                FrinikaAudioSystem.installClient(this.audioClient);
            } else {
                this.message(" No output devices found ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" \n Sorry but I do not want to go on without an audio output device. \n Bye bye . . .  ");
            System.exit(1);
        }
    }

    public void injectIntoOutput(AudioProcess process) {
        if (this.outputProcess != null) {
            this.outputProcess.add(process);
        }
    }

    void defaultInit() {
        this.pixelsPerRedraw = 1;
        this.audioFileManager = new BufferedRandomAccessFileManager();
        this.myClipboard = MyClipboard.the();
        this.multiEventSelection = new MultiEventSelection(this);
        this.partSelection = new PartSelection(this);
        this.laneSelection = new LaneSelection(this);
        this.midiSelection = new MidiSelection(this);
        this.scriptingEngine = new FrinikaScriptingEngine(this);
        this.editHistoryContainer = new EditHistoryContainer();
        this.dragList = new DragList(this);
        this.soloManager = new SoloManager(this);
        this.createMixer();
    }

    public ProjectContainer() throws Exception {
        this.defaultInit();
        this.sequencer = new FrinikaSequencer();
        this.sequencer.open();
        this.renderer = new FrinikaRenderer(this);
        this.createSequencerPriorityListener();
        this.createSequence();
        System.out.println(this.sequence.getFrinikaTrackWrappers().size());
        this.projectLane = new ProjectLane(this);
        this.midiResource = new MidiResource(this.sequencer);
        this.tempoList = new TempoList(this.sequence.getResolution(), this);
        this.sequencer.setTempoList(this.tempoList);
        this.setTempoInBPM(100.0f);
    }

    private void createSequencerPriorityListener() {
        this.sequencer.setPlayerPriority(FrinikaConfig.SEQUENCER_PRIORITY);
        FrinikaConfig.addConfigListener(new ConfigListener(){

            public void configurationChanged(ChangeEvent event) {
                if (event.getSource() == FrinikaConfig._SEQUENCER_PRIORITY) {
                    ProjectContainer.this.sequencer.setPlayerPriority(FrinikaConfig.SEQUENCER_PRIORITY);
                }
            }
        });
    }

    private ProjectContainer(ProjectSettings project) throws Exception {
        this.defaultInit();
        System.out.println(" LOADING PROJECT ");
        ByteArrayInputStream sequenceInputStream = new ByteArrayInputStream(project.getSequence());
        this.sequencer = new FrinikaSequencer();
        this.sequencer.open();
        this.createSequencerPriorityListener();
        this.renderer = new FrinikaRenderer(this);
        this.sequence = new FrinikaSequence(MidiSequenceConverter.splitChannelsToMultiTrack(MidiSystem.getSequence(sequenceInputStream)));
        this.sequencer.setSequence(this.sequence);
        this.tempoList = new TempoList(this.sequence.getResolution(), this);
        this.tempoList.add(0L, this.tempo);
        this.sequencer.setTempoList(this.tempoList);
        try {
            this.setTempoInBPM(MidiSequenceConverter.findFirstTempo(this.sequence));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SynthRack synthRack = new SynthRack(null);
        synthRack.open();
        synthRack.loadSynthSetup(project.getSynthSettings());
        SynthWrapper midiDev = new SynthWrapper(this, synthRack);
        Vector<FrinikaTrackWrapper> origTracks = this.sequence.getFrinikaTrackWrappers();
        Vector<FrinikaTrackWrapper> tracks = new Vector<FrinikaTrackWrapper>(origTracks);
        this.projectLane = new ProjectLane(this);
        origTracks.removeAllElements();
        for (FrinikaTrackWrapper ftw : tracks) {
            MidiMessage msg = ftw.get(0).getMessage();
            if (msg instanceof ShortMessage) {
                ftw.setMidiDevice(midiDev);
                ftw.setMidiChannel(((ShortMessage)msg).getChannel());
                System.out.println(((ShortMessage)msg).getChannel() + " channel");
            }
            MidiLane lane = new MidiLane(ftw, this);
            if (ftw.getMidiChannel() > -1) {
                lane.setProgram(ftw.getMidiChannel(), 0, 0);
            }
            this.projectLane.addChildLane(lane);
            MidiPart part = new MidiPart(lane);
            long startTick = 0L;
            long endTick = Long.MAX_VALUE;
            part.importFromMidiTrack(startTick, endTick);
        }
        int ticks = (int)this.getSequence().getTickLength();
        this.endTick = Math.max(this.endTick, (long)ticks);
        this.addMidiOutDevice(midiDev);
        this.rebuildGUI();
    }

    public ProjectContainer(Sequence seq) throws Exception {
        this(seq, null);
    }

    public ProjectContainer(Sequence seq, MidiDevice midiDevice) throws Exception {
        this.defaultInit();
        System.out.println(" LOADING MIDI SEQUENCE ");
        this.sequencer = new FrinikaSequencer();
        this.sequencer.open();
        this.createSequencerPriorityListener();
        this.renderer = new FrinikaRenderer(this);
        if (seq.getDivisionType() == 0.0f) {
            this.ticksPerQuarterNote = seq.getResolution();
        } else {
            System.out.println("WARNING: The resolution type of the imported Sequence is not supported by Frinika");
        }
        this.sequence = new FrinikaSequence(MidiSequenceConverter.splitChannelsToMultiTrack(seq));
        this.sequencer.setSequence(this.sequence);
        Vector<FrinikaTrackWrapper> origTracks = this.sequence.getFrinikaTrackWrappers();
        Vector<FrinikaTrackWrapper> tracks = new Vector<FrinikaTrackWrapper>(origTracks);
        this.projectLane = new ProjectLane(this);
        origTracks.removeAllElements();
        for (FrinikaTrackWrapper ftw : tracks) {
            MidiEvent event;
            for (int i = 0; i < ftw.size(); ++i) {
                MidiMessage msg = ftw.get(i).getMessage();
                if (!(msg instanceof ShortMessage)) continue;
                ftw.setMidiChannel(((ShortMessage)msg).getChannel());
                System.out.println(((ShortMessage)msg).getChannel() + " channel");
                break;
            }
            MidiLane lane = new MidiLane(ftw, this);
            this.projectLane.addChildLane(lane);
            MidiPart part = new MidiPart(lane);
            long startTick = 0L;
            long endTick = Long.MAX_VALUE;
            part.importFromMidiTrack(startTick, endTick);
            for (int i = 0; i < ftw.size() && (event = ftw.get(i)).getTick() <= 0L; ++i) {
                MetaMessage meta;
                MidiMessage msg = event.getMessage();
                if (!(msg instanceof MetaMessage) || (meta = (MetaMessage)msg).getType() != 3 || meta.getLength() <= 0) continue;
                try {
                    String txt = new String(meta.getData());
                    lane.setName(txt);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        try {
            this.setTempoInBPM(MidiSequenceConverter.findFirstTempo(seq));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rebuildGUI();
        if (midiDevice != null) {
            try {
                midiDevice = new SynthWrapper(this, midiDevice);
                this.addMidiOutDevice(midiDevice);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                midiDevice = null;
            }
        }
        for (FrinikaTrackWrapper ftw : tracks) {
            if (midiDevice == null) continue;
            ftw.setMidiDevice(midiDevice);
        }
    }

    public static ProjectContainer loadProject(File file) throws Exception {
        ProjectContainer proj = file.exists() ? ProjectContainer.loadCompressedProject(file) : new ProjectContainer();
        proj.projectFile = file;
        return proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectContainer loadCompressedProject(File file) throws Exception {
        FileInputStream fileinputStream;
        ProjectContainer project = null;
        InputStream inputStream = new FileInputStream(file);
        byte[] magic = new byte[4];
        inputStream.read(magic);
        inputStream.close();
        if (magic[3] == 4 && magic[2] == 3 && magic[1] == 75 && magic[0] == 80) {
            fileinputStream = new FileInputStream(file);
            inputStream = fileinputStream;
            try {
                ZipInputStream zipi = new ZipInputStream(inputStream);
                zipi.getNextEntry();
                inputStream = zipi;
                inputStream = new BufferedInputStream(inputStream);
                project = ProjectContainer.loadProject(inputStream);
                project.compression_level = 1;
            }
            finally {
                fileinputStream.close();
            }
        }
        if (magic[0] == 76 && magic[1] == 90 && magic[2] == 77 && magic[3] == 97) {
            fileinputStream = new FileInputStream(file);
            inputStream = fileinputStream;
            try {
                inputStream.read(magic);
                InputStream inStream = inputStream;
                int propertiesSize = 5;
                byte[] properties = new byte[propertiesSize];
                if (inStream.read(properties, 0, propertiesSize) != propertiesSize) {
                    throw new Exception("input .lzma file is too short");
                }
                Decoder decoder = new Decoder();
                if (!decoder.SetDecoderProperties(properties)) {
                    throw new Exception("Incorrect stream properties");
                }
                long outSize = 0L;
                for (int i = 0; i < 8; ++i) {
                    int v = inStream.read();
                    if (v < 0) {
                        throw new Exception("Can't read stream size");
                    }
                    outSize |= (long)v << 8 * i;
                }
                File tempfile = File.createTempFile("lzma", "temp");
                FileOutputStream fos = new FileOutputStream(tempfile);
                try {
                    try {
                        if (!decoder.Code(inStream, fos, outSize)) {
                            throw new Exception("Can't decode stream");
                        }
                    }
                    finally {
                        fos.close();
                    }
                    inputStream = new FileInputStream(tempfile);
                    try {
                        project = ProjectContainer.loadProject(inputStream);
                        project.compression_level = 2;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                finally {
                    tempfile.delete();
                }
            }
            finally {
                fileinputStream.close();
            }
        }
        if (project == null) {
            fileinputStream = new FileInputStream(file);
            try {
                project = ProjectContainer.loadProject(fileinputStream);
            }
            finally {
                fileinputStream.close();
            }
        }
        return project;
    }

    public static ProjectContainer loadProject(InputStream inputStream) throws Exception {
        if (SplashDialog.isSplashVisible()) {
            SplashDialog splash = SplashDialog.getInstance();
            JProgressBar bar = splash.getProgressBar();
            bar.setMaximum(inputStream.available());
            inputStream = new ProgressBarInputStream(bar, inputStream);
        }
        ObjectInputStreamFixer in = new ObjectInputStreamFixer(inputStream);
        Object obj = in.readObject();
        if (SplashDialog.isSplashVisible()) {
            SplashDialog splash = SplashDialog.getInstance();
            JProgressBar bar = splash.getProgressBar();
            bar.setValue(bar.getMaximum());
        }
        if (obj instanceof ProjectSettings) {
            return new ProjectContainer((ProjectSettings)obj);
        }
        return (ProjectContainer)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProject(File file) throws IOException {
        int usecompression;
        if (this.mixerSerializer == null) {
            System.out.println(" Creating serialization for the mixer ");
            this.mixerSerializer = new TootMixerSerializer(this);
        }
        if ((usecompression = this.compression_level) == 2) {
            File tempfile = File.createTempFile("lzma", "temp");
            FileInputStream fis = null;
            try {
                FileOutputStream fos = new FileOutputStream(tempfile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                try {
                    oos.writeObject(this);
                }
                finally {
                    oos.close();
                    fos.close();
                }
                fis = new FileInputStream(tempfile);
                byte[] magic = new byte[]{76, 90, 77, 97};
                FileOutputStream outStream = new FileOutputStream(file);
                outStream.write(magic);
                FileInputStream inStream = fis;
                boolean eos = false;
                Encoder encoder = new Encoder();
                encoder.SetAlgorithm(2);
                encoder.SetDictionarySize(0x800000);
                encoder.SeNumFastBytes(128);
                encoder.SetMatchFinder(1);
                encoder.SetLcLpPb(3, 0, 2);
                encoder.SetEndMarkerMode(eos);
                encoder.WriteCoderProperties(outStream);
                long fileSize = tempfile.length();
                for (int i = 0; i < 8; ++i) {
                    outStream.write((int)(fileSize >>> 8 * i) & 0xFF);
                }
                encoder.Code(inStream, outStream, -1L, -1L, null);
                outStream.close();
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                tempfile.delete();
            }
        }
        if (usecompression == 1) {
            FileOutputStream fos = new FileOutputStream(file);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry(file.getName()));
            BufferedOutputStream bos = new BufferedOutputStream(zos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            bos.flush();
            zos.closeEntry();
            zos.finish();
            fos.close();
        } else {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
        }
        this.projectFile = file;
        this.editHistoryContainer.updateSavedPosition();
    }

    public List<Lane> getLanes() {
        return this.projectLane.getFamilyLanes();
    }

    public XAudioLane createXAudioLane() {
        XAudioLane lane = new XAudioLane(this);
        this.add(lane);
        return lane;
    }

    public AudioLane createAudioLane() {
        AudioLane lane = new AudioLane(this);
        this.add(lane);
        return lane;
    }

    public TextLane createTextLane() {
        TextLane lane = new TextLane(this);
        this.add(lane);
        return lane;
    }

    public FrinikaSequencer getSequencer() {
        return this.sequencer;
    }

    public void createSequence() {
        if (this.sequence == null) {
            try {
                if (this.ticksPerQuarterNote == 0) {
                    this.ticksPerQuarterNote = FrinikaConfig.TICKS_PER_QUARTER;
                }
                this.sequence = new FrinikaSequence(0.0f, this.ticksPerQuarterNote, 1);
                this.sequencer.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    public FrinikaSequence getSequence() {
        return this.sequence;
    }

    public FrinikaRenderer getRenderer() {
        return this.renderer;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public MultiEventSelection getMultiEventSelection() {
        return this.multiEventSelection;
    }

    public PartSelection getPartSelection() {
        return this.partSelection;
    }

    public LaneSelection getLaneSelection() {
        return this.laneSelection;
    }

    public MidiSelection getMidiSelection() {
        return this.midiSelection;
    }

    public FrinikaScriptingEngine getScriptingEngine() {
        return this.scriptingEngine;
    }

    public EditHistoryContainer getEditHistoryContainer() {
        return this.editHistoryContainer;
    }

    public void close() {
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.sequencer.close();
    }

    @Override
    public void add(Lane lane) {
        this.projectLane.addChildLane(lane);
        lane.onLoad();
        this.editHistoryContainer.push(this, 0, lane);
    }

    public void add(int index, Lane lane) {
        this.projectLane.addChildLane(index, lane);
        lane.onLoad();
        this.editHistoryContainer.push(this, 0, lane);
    }

    @Override
    public void remove(Lane lane) {
        this.projectLane.removeChildLane(lane);
        this.getEditHistoryContainer().push(this, 1, lane);
    }

    public ProjectLane getProjectLane() {
        return this.projectLane;
    }

    public SynthRack getSynthRack() {
        return this.audioSynthRack;
    }

    public MidiResource getMidiResource() {
        return this.midiResource;
    }

    public FrinikaTrackWrapper getTempoTrack() {
        return this.sequence.getFrinikaTrackWrappers().get(0);
    }

    public void setTempoInBPM(float tempo) {
        this.tempoList.add(0L, tempo);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int mdIndex = 0;
        this.midiDeviceIndex = new HashMap();
        this.synthSettings = null;
        this.externalMidiDevices = null;
        for (MidiDevice midiDev : this.sequencer.listMidiOutDevices()) {
            if (midiDev instanceof SynthRack) {
                ((SynthRack)midiDev).setSaveReferencedData(this.saveReferencedData);
            }
            if (midiDev instanceof SynthWrapper) {
                ((SynthWrapper)midiDev).setSaveReferencedData(this.saveReferencedData);
            }
            System.out.println(this.midiDeviceDescriptorMap.get(midiDev).getProjectName() + "(" + this.midiDeviceDescriptorMap.get(midiDev).getMidiDeviceName() + ") has index " + mdIndex);
            this.midiDeviceIndex.put(midiDev, mdIndex++);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.defaultInit();
        this.sequencer = new FrinikaSequencer();
        try {
            this.sequencer.open();
            this.midiResource = new MidiResource(this.sequencer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.renderer = new FrinikaRenderer(this);
        in.defaultReadObject();
        this.createSequence();
        if (this.synthSettings != null || this.externalMidiDevices != null) {
            if (this.midiDeviceDescriptors != null) {
                this.midiDeviceDescriptors.clear();
            } else {
                this.midiDeviceDescriptors = new ArrayList<MidiDeviceDescriptor>();
            }
            this.midiDeviceDescriptorMap = new HashMap();
            for (SynthSettings synthSetup : this.synthSettings) {
                SynthRack synthRack = new SynthRack(null);
                synthRack.loadSynthSetup(synthSetup);
                try {
                    SynthWrapper midiDevice = new SynthWrapper(this, synthRack);
                    this.addMidiOutDevice(midiDevice);
                    if (synthSetup.hasProgramChangeEvent()) continue;
                    FrinikaSynthRackDescriptor.fixLaneProgramChange(this, midiDevice);
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
            if (this.externalMidiDevices != null) {
                for (String name : this.externalMidiDevices) {
                    MidiDevice dev = MidiHub.getMidiOutDeviceByName(name);
                    if (dev == null) {
                        System.out.println(" Failed to find MidiDevice " + name);
                        continue;
                    }
                    SynthWrapper externMidi = new SynthWrapper(this, dev);
                    try {
                        externMidi.open();
                    }
                    catch (MidiUnavailableException e) {
                        System.out.println(" Failed to open MidiDevice " + name);
                        e.printStackTrace();
                    }
                    try {
                        this.addMidiOutDevice(externMidi);
                    }
                    catch (MidiUnavailableException e) {
                        System.out.println(" Failed to add MidiDevice " + name);
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.installMidiDevices();
        }
        this.validate();
        this.projectLane.onLoad();
        if (this.tempoList == null) {
            this.tempoList = new TempoList(this.sequence.getResolution(), this);
            this.tempoList.add(0L, this.tempo);
        }
        this.tempoList.reco();
        this.sequencer.setTempoList(this.tempoList);
        this.rebuildGUI();
    }

    public void installMidiDevices() {
        this.midiDeviceDescriptorMap = new HashMap();
        for (MidiDeviceDescriptor midiDeviceDescriptor : this.midiDeviceDescriptors) {
            System.out.println("Installing Midi device: " + midiDeviceDescriptor.getMidiDeviceName() + " as " + midiDeviceDescriptor.getProjectName());
            midiDeviceDescriptor.install(this);
        }
    }

    public void setSaveReferencedData(boolean saveReferencedData) {
        this.saveReferencedData = saveReferencedData;
    }

    public Integer getMidiDeviceIndex(MidiDevice midiDevice) {
        return this.midiDeviceIndex.get(midiDevice);
    }

    public SelectionFocusable getSelectionFocus() {
        return this.selectionFocus;
    }

    public void setSelectionFocus(SelectionFocusable focus) {
        this.selectionFocus = focus;
    }

    public MyClipboard clipBoard() {
        return this.myClipboard;
    }

    public void rebuildGUI() {
        ViewableLaneList list = new ViewableLaneList(this);
        list.rebuild();
        this.midiResource = new MidiResource(this.sequencer);
    }

    public double getPianoRollSnapQuantization() {
        return this.pianoRollSnapQuantization;
    }

    public double getPartViewSnapQuantization() {
        return this.partViewSnapQuantization;
    }

    public void setPianoRollSnapQuantization(double val) {
        this.pianoRollSnapQuantization = val;
    }

    public void setPartViewSnapQuantization(double val) {
        this.partViewSnapQuantization = val;
    }

    public boolean isPianoRollSnapQuantized() {
        return this.isPianoRollSnapQuantized;
    }

    public boolean isPartViewSnapQuantized() {
        return this.isPartViewSnapQuantized;
    }

    public void setPianoRollSnapQuantized(boolean val) {
        this.isPianoRollSnapQuantized = val;
    }

    public void setPartViewSnapQuantized(boolean val) {
        this.isPartViewSnapQuantized = val;
    }

    public long eventQuantize(long tick) {
        if (this.isPianoRollSnapQuantized) {
            tick = (long)(Math.rint((double)tick / this.pianoRollSnapQuantization) * this.pianoRollSnapQuantization);
        }
        return tick;
    }

    public long partQuantize(long tick) {
        if (this.isPartViewSnapQuantized) {
            tick = (long)(Math.rint((double)tick / this.partViewSnapQuantization) * this.partViewSnapQuantization);
        }
        return tick;
    }

    public long getEndTick() {
        return this.endTick;
    }

    public void setEndTick(long tick) {
        if (tick == this.endTick) {
            return;
        }
        this.endTick = tick;
        this.sequencer.notifySongPositionListeners();
    }

    public void validate() {
        this.validate(this.projectLane);
    }

    public void validate(Lane parent) {
        for (Part part : parent.getParts()) {
            assert (part.getLane() == parent);
            if (!(part instanceof MidiPart)) continue;
            MidiPart midiPart = (MidiPart)part;
            if (part.getStartTick() > part.getEndTick()) {
                System.out.println("Correcting invalid data " + part.getStartTick() + "-->" + part.getEndTick());
                part.setStartTick(part.getEndTick());
            }
            for (MultiEvent ev : midiPart.getMultiEvents()) {
                assert (ev.getPart() == part);
            }
        }
        for (Lane lane : parent.getChildren()) {
            this.validate(lane);
        }
    }

    public void resetEndTick() {
        this.setEndTick(this.projectLane);
    }

    private void setEndTick(Lane parent) {
        for (Part part : parent.getParts()) {
            assert (part.getLane() == parent);
            this.endTick = Math.max(this.endTick, part.getEndTick());
        }
        for (Lane lane : parent.getChildren()) {
            this.setEndTick(lane);
        }
    }

    public Vector<Lane> recordableLaneList() {
        Vector<Lane> list = new Vector<Lane>();
        this.addRecordableLanes(list, this.projectLane);
        return list;
    }

    private void addRecordableLanes(Vector<Lane> list, Lane parent) {
        for (Lane lane : parent.getChildren()) {
            if (lane instanceof RecordableLane) {
                list.add(lane);
            }
            this.addRecordableLanes(list, lane);
        }
    }

    public File getFile() {
        return this.projectFile;
    }

    public File getAudioDirectory() {
        if (this.audioDir != null) {
            return this.audioDir;
        }
        this.newAudioDirectory();
        return this.audioDir;
    }

    private void newAudioDirectory() {
        int index;
        File file = null;
        int count = 0;
        String base = "New";
        if (this.projectFile != null && (index = (base = this.projectFile.getName()).indexOf(46)) > 0) {
            base = base.substring(0, index);
        }
        file = new File(FrinikaConfig.AUDIO_DIRECTORY, base);
        while (file.exists()) {
            file = new File(FrinikaConfig.AUDIO_DIRECTORY, base + "_" + count++);
        }
        file.mkdirs();
        this.audioDir = file;
    }

    public MidiDeviceDescriptor addMidiOutDevice(MidiDevice midiDev) throws MidiUnavailableException {
        MidiDeviceDescriptor descriptor = null;
        if (midiDev instanceof SynthWrapper) {
            SynthWrapper synthWrapper = (SynthWrapper)midiDev;
            if (synthWrapper.getRealDevice().getClass().isAnnotationPresent(MidiDeviceDescriptorClass.class)) {
                try {
                    descriptor = (MidiDeviceDescriptor)synthWrapper.getRealDevice().getClass().getAnnotation(MidiDeviceDescriptorClass.class).value().newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                descriptor = synthWrapper.getRealDevice() instanceof SynthRack ? new FrinikaSynthRackDescriptor(synthWrapper) : (synthWrapper.getRealDevice() instanceof DrumMapper ? new DrumMapperDescriptor(synthWrapper, this) : (synthWrapper.getRealDevice() instanceof Synthesizer ? new SynthesizerDescriptor((Synthesizer)midiDev) : new MidiDeviceDescriptor(midiDev)));
            }
        }
        descriptor.setProjectName(midiDev.getDeviceInfo().getName());
        this.midiDeviceDescriptors.add(descriptor);
        SynthLane lane = this.createSynthLane(descriptor);
        if (midiDev instanceof SynthWrapper && ((SynthWrapper)midiDev).getAudioProcess() != null) {
            lane.attachAudioProcessToMixer();
        }
        this.loadMidiOutDevice(descriptor);
        return descriptor;
    }

    void loadMidiOutDevice(MidiDeviceDescriptor descriptor) throws MidiUnavailableException {
        this.midiDeviceDescriptorMap.put(descriptor.getMidiDevice(), descriptor);
        this.sequencer.addMidiOutDevice(descriptor.getMidiDevice());
        midiOutList.add(descriptor.getMidiDevice());
    }

    public static void closeAllMidiOutDevices() {
        for (MidiDevice dev : midiOutList) {
            System.out.println(" Closing " + dev);
            dev.close();
        }
    }

    public MidiDeviceDescriptor getMidiDeviceDescriptor(MidiDevice midiDevice) {
        return this.midiDeviceDescriptorMap.get(midiDevice);
    }

    public void removeMidiOutDevice(MidiDevice midiDevice) {
        this.midiDeviceDescriptors.remove(this.midiDeviceDescriptorMap.get(midiDevice));
        this.midiDeviceDescriptorMap.remove(midiDevice);
        this.sequencer.removeMidiOutDevice(midiDevice);
    }

    public List<MidiDeviceDescriptor> getMidiDeviceDescriptors() {
        return this.midiDeviceDescriptors;
    }

    public MixerControls getMixerControls() {
        return this.mixerControls;
    }

    public AudioServer getAudioServer() {
        return this.audioServer;
    }

    public AudioMixer getMixer() {
        return this.mixer;
    }

    public AudioInjector getOutputProcess() {
        return this.outputProcess;
    }

    public void message(String string) {
        ProjectFrame.staticMessage(this, string);
    }

    public SynthLane createSynthLane(MidiDeviceDescriptor desc) {
        SynthLane lane = new SynthLane(this, desc);
        this.add(lane);
        return lane;
    }

    public BufferedRandomAccessFileManager getAudioFileManager() {
        return this.audioFileManager;
    }

    public AudioClient getAudioClient() {
        return this.audioClient;
    }

    public MidiLane createMidiLane() {
        this.sequence.createTrack();
        MidiLane lane = new MidiLane(this.sequence.getFrinikaTrackWrappers().lastElement(), this);
        FrinikaTrackWrapper ftw = this.sequence.getFrinikaTrackWrappers().lastElement();
        ftw.setMidiChannel(0);
        this.add(lane);
        return lane;
    }

    public void createMidiLanesFromSequence(Sequence seq, MidiDevice midiDevice) {
        if (seq.getDivisionType() == 0.0f) {
            int ticksPerQuarterNote1 = seq.getResolution();
            System.out.println(" Project PPQ = " + this.ticksPerQuarterNote);
            System.out.println(" Midi    PPQ = " + ticksPerQuarterNote1);
        } else {
            System.out.println("WARNING: The resolution type of the imported Sequence is not supported by Frinika");
        }
        Sequence splitSeq = MidiSequenceConverter.splitChannelsToMultiTrack(seq);
        int nTrack = splitSeq.getTracks().length;
        System.out.println(" Adding " + nTrack + " tracks ");
        this.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.add_midi_lane"));
        for (int iTrack = 0; iTrack < nTrack; ++iTrack) {
            MidiEvent event;
            int chan = 0;
            Track track = splitSeq.getTracks()[iTrack];
            for (int i = 0; i < track.size(); ++i) {
                MidiMessage msg = track.get(i).getMessage();
                if (!(msg instanceof ShortMessage)) continue;
                chan = ((ShortMessage)msg).getChannel();
                break;
            }
            MidiLane lane = this.createMidiLane();
            lane.setMidiChannel(chan);
            MidiPart part = new MidiPart(lane);
            long startTick = 0L;
            long endTick = Long.MAX_VALUE;
            part.importFromMidiTrack(track, startTick, endTick);
            for (int i = 0; i < track.size() && (event = track.get(i)).getTick() <= 0L; ++i) {
                MetaMessage meta;
                MidiMessage msg = event.getMessage();
                if (!(msg instanceof MetaMessage) || (meta = (MetaMessage)msg).getType() != 3 || meta.getLength() <= 0) continue;
                try {
                    String txt = new String(meta.getData());
                    lane.setName(txt);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            part.commitEventsAdd();
        }
        this.rebuildGUI();
        if (midiDevice != null) {
            try {
                midiDevice = new SynthWrapper(this, midiDevice);
                this.addMidiOutDevice(midiDevice);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                midiDevice = null;
            }
        }
        this.getEditHistoryContainer().notifyEditHistoryListeners();
    }

    public DragList getDragList() {
        return this.dragList;
    }

    public int getPixelsPerRedraw() {
        return this.pixelsPerRedraw;
    }

    public void setPixelsPerRedraw(int i) {
        this.pixelsPerRedraw = i;
    }

    public double tickAtMicros(double micros) {
        return this.tempoList.getTickAtTime(micros / 1000000.0);
    }

    public double microsAtTick(double tick) {
        return 1000000.0 * this.tempoList.getTimeAtTick(tick);
    }

    public TempoList getTempoList() {
        if (this.tempoList == null) {
            System.out.println(" Creating a new tempo list ");
            this.tempoList = new TempoList(this.sequence.getResolution(), this);
            this.tempoList.add(0L, 100.0);
            this.sequencer.setTempoList(this.tempoList);
        }
        return this.tempoList;
    }

    public TimeSignatureList getTimeSignatureList() {
        if (this.timeSignitureList == null) {
            this.timeSignitureList = new TimeSignatureList();
            this.timeSignitureList.add(0, 4);
        }
        return this.timeSignitureList;
    }

    public int getTicksPerBeat() {
        return this.sequence.getResolution();
    }

    public TimeUtils getTimeUtils() {
        if (this.timeUtils == null) {
            this.timeUtils = new TimeUtils(this);
        }
        return this.timeUtils;
    }

    public double tickToSample(long tick) {
        double tt = this.tempoList.getTimeAtTick(tick);
        return tt * (double)this.audioServer.getSampleRate();
    }

    public SoloManager getSoloManager() {
        return this.soloManager;
    }

    class ProjectAudioClient
    implements AudioClient {
        double tick = 0.0;
        long framePtr = 0L;
        double sampleRate = FrinikaConfig.sampleRate;
        double ticksPerBuffer;

        ProjectAudioClient() {
        }

        public void work(int bufsize) {
            ProjectContainer.this.mixer.work(bufsize);
        }

        public void setEnabled(boolean b) {
            ProjectContainer.this.mixer.setEnabled(b);
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

