/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.mididevices.gui;

import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.mixer.MidiDeviceMixerPanel;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiDevice;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class MidiDevicesPanel
extends JPanel {
    JTabbedPane deviceTabs;
    ProjectContainer project;
    ProjectFrame projectFrame;

    public MidiDevicesPanel(final ProjectFrame projectFrame) {
        this.project = projectFrame.getProjectContainer();
        this.projectFrame = projectFrame;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        final JButton but = new JButton("New MIDI Out Device");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                projectFrame.addMidiDevices(popup);
                popup.show(but, 0, 0);
            }
        });
        topPanel.add(but);
        this.add((Component)topPanel, "North");
        this.deviceTabs = new JTabbedPane();
        this.updateDeviceTabs();
        this.add((Component)this.deviceTabs, "Center");
    }

    public void updateDeviceTabs() {
        this.deviceTabs.removeAll();
        for (MidiDevice midiDevice : this.project.getSequencer().listMidiOutDevices()) {
            String deviceTabName = this.project.getMidiDeviceDescriptor(midiDevice).getProjectName();
            this.deviceTabs.addTab(deviceTabName, ((SynthWrapper)midiDevice).getIcon(), new MidiDeviceMixerPanel(this, (SynthWrapper)midiDevice));
        }
    }

    public void remove(MidiDevice synthWrapper) {
        this.project.removeMidiOutDevice(synthWrapper);
        this.updateDeviceTabs();
    }

    public ProjectContainer getProject() {
        return this.project;
    }
}

