/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.scripting.gui;

import com.frinika.gui.AbstractDialog;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.project.scripting.DefaultFrinikaScript;
import com.frinika.project.scripting.FrinikaScript;
import com.frinika.project.scripting.FrinikaScriptingEngine;
import com.frinika.project.scripting.ScriptListener;
import com.frinika.project.scripting.gui.ScriptEditorInternalFrame;
import com.frinika.sequencer.gui.menu.ScriptingAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;

public class ScriptingDialog
extends JDialog
implements InternalFrameListener,
ScriptListener {
    public static final String INITIAL_JAVASCRIPT = "// add JavaScript here:\n\n";
    private static final String NL = System.getProperty("line.separator");
    private static final String PRESETS_DELIM = "###";
    ScriptEditorInternalFrame activeEditor;
    JMenu scriptingMenu;
    Point addNewPosition = new Point(20, 20);
    ProjectFrame frame;
    FrinikaScriptingEngine engine;
    private Map<String, FrinikaScript> presets;
    private JButton clearButton;
    private JPanel consoleButtonPanel;
    private JPanel consolePanel;
    private JScrollPane consoleScrollPane;
    private JTextArea consoleTextArea;
    private JDesktopPane desktopPane;
    private JMenu editMenu;
    private JFileChooser fileChooser;
    private JMenuItem fileCloseMenuItem;
    private JMenu fileMenu;
    private JMenuItem fileNewMenuItem;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileSaveAsMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JMenuBar menuBar;
    private JMenu presetMenu;
    private JMenuItem redoMenuItem;
    private JMenuItem runExecuteMenuItem;
    private JMenu runMenu;
    private JMenuItem runStopMenuItem;
    private JSplitPane splitPane;
    private JMenuItem undoMenuItem;
    private JMenu windowMenu;

    public ScriptingDialog(ProjectFrame frame, JMenu scriptingMenu) {
        super(frame, "Frinika " + CurrentLocale.getMessage("sequencer.project.scripting"), false);
        this.frame = frame;
        this.scriptingMenu = scriptingMenu;
        this.initComponents();
        this.consoleTextArea.setEditable(false);
        FileFilter ff = new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || file.getName().endsWith(".js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.fileChooser.setFileFilter(ff);
        this.engine = frame.getProjectContainer().getScriptingEngine();
        this.setSize(1000, 800);
        Collection<FrinikaScript> scripts = this.engine.getScripts();
        if (!scripts.isEmpty()) {
            for (FrinikaScript script : scripts) {
                ScriptEditorInternalFrame editor = this.openEditor(script);
                try {
                    editor.setIcon(true);
                }
                catch (PropertyVetoException pve) {}
            }
        } else {
            this.newEditor();
        }
        FrinikaScriptingEngine.addScriptListener(this);
        this.initPresetMenu();
        this.updateMenus();
        AbstractDialog.centerOnScreen(this);
    }

    public JMenu getScriptingMenu() {
        return this.scriptingMenu;
    }

    void updateMenus() {
        JMenuItem selfItem = this.scriptingMenu.getItem(0);
        this.scriptingMenu.removeAll();
        this.scriptingMenu.add(selfItem);
        Collection<FrinikaScript> scripts = this.frame.getProjectContainer().getScriptingEngine().getScripts();
        if (!scripts.isEmpty()) {
            for (FrinikaScript script : scripts) {
                JMenuItem item = new JMenuItem(new ScriptingAction(this.frame, script));
                if (script.getSource().equals(INITIAL_JAVASCRIPT)) continue;
                int l = this.scriptingMenu.getMenuComponentCount();
                if (l == 1) {
                    this.scriptingMenu.addSeparator();
                }
                this.scriptingMenu.add(item);
            }
        }
        this.windowMenu.removeAll();
        ButtonGroup bg = new ButtonGroup();
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        int count = 1;
        for (int i = frames.length - 1; i >= 0; --i) {
            ScriptEditorInternalFrame f = (ScriptEditorInternalFrame)frames[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(f.getTitle());
            if (count < 10) {
                item.setAccelerator(KeyStroke.getKeyStroke(48 + count++, 8));
            }
            bg.add(item);
            item.setSelected(f == this.getActiveEditor());
            item.addActionListener(new SourceActionListener<JInternalFrame>((JInternalFrame)f){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ((JInternalFrame)this.source).setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ((JInternalFrame)this.source).toFront();
                    ((JInternalFrame)this.source).requestFocus();
                }
            });
            this.windowMenu.add(item);
        }
    }

    ScriptEditorInternalFrame getActiveEditor() {
        return this.activeEditor;
    }

    FrinikaScript getActiveScript() {
        ScriptEditorInternalFrame editor = this.getActiveEditor();
        if (editor != null) {
            editor.update();
            return editor.getScript();
        }
        return null;
    }

    void newEditor() {
        DefaultFrinikaScript script = new DefaultFrinikaScript();
        script.setLanguage(1);
        script.setSource(INITIAL_JAVASCRIPT);
        ScriptEditorInternalFrame editor = this.openEditor(script);
        editor.toFront();
        this.activeEditor = editor;
    }

    void executeScript(FrinikaScript script) {
        FrinikaScriptingEngine.executeScript(script, this.frame, this);
    }

    void stopScript(FrinikaScript script) {
        FrinikaScriptingEngine.stopScript(script);
    }

    public void print(String s) {
        this.consoleTextArea.append(s);
        this.consoleTextArea.setCaretPosition(this.consoleTextArea.getDocument().getLength());
    }

    public void println(String s) {
        this.print(s + NL);
    }

    protected ScriptEditorInternalFrame openEditor(FrinikaScript script) {
        ScriptEditorInternalFrame editor = new ScriptEditorInternalFrame(script, this);
        editor.addInternalFrameListener(this);
        editor.setSize(600, 400);
        editor.setLocation(this.addNewPosition.x, this.addNewPosition.y);
        this.addNewPosition.x += 50;
        this.addNewPosition.y += 50;
        if (this.addNewPosition.x > 400) {
            this.addNewPosition.x = 20;
        }
        if (this.addNewPosition.y > 300) {
            this.addNewPosition.y = 20;
        }
        this.desktopPane.add(editor);
        editor.updateTitle();
        editor.setVisible(true);
        this.engine.addScript(script);
        this.updateMenus();
        return editor;
    }

    protected ScriptEditorInternalFrame findByFilename(String filename) {
        JInternalFrame[] f = this.desktopPane.getAllFrames();
        for (int i = 0; i < f.length; ++i) {
            try {
                DefaultFrinikaScript script = (DefaultFrinikaScript)((ScriptEditorInternalFrame)f[i]).getScript();
                if (!script.getFilename().equals(filename)) continue;
                return (ScriptEditorInternalFrame)f[i];
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    protected ScriptEditorInternalFrame findByScript(FrinikaScript script) {
        JInternalFrame[] f = this.desktopPane.getAllFrames();
        for (int i = 0; i < f.length; ++i) {
            try {
                FrinikaScript sc = ((ScriptEditorInternalFrame)f[i]).getScript();
                if (sc != script) continue;
                return (ScriptEditorInternalFrame)f[i];
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    public void scriptStarted(FrinikaScript script) {
    }

    public void scriptExited(FrinikaScript script, Object returnValue) {
        if (returnValue == null) {
            this.println("\nScript " + script.getName() + " exited with an error.\n");
        } else {
            this.println("Ok.");
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.activeEditor = (ScriptEditorInternalFrame)e.getInternalFrame();
        this.updateMenus();
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        if (this.activeEditor == e.getInternalFrame()) {
            this.activeEditor = null;
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        ScriptEditorInternalFrame f = (ScriptEditorInternalFrame)e.getInternalFrame();
        FrinikaScript script = f.getScript();
        this.engine.removeScript(script);
        FrinikaScriptingEngine.removeScriptListener(f);
        this.desktopPane.remove(f);
        this.desktopPane.validate();
        this.desktopPane.repaint();
        this.updateMenus();
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        ScriptEditorInternalFrame f = (ScriptEditorInternalFrame)e.getInternalFrame();
        if (f.hasBeenModifiedWithoutSaving() && !this.frame.confirm("Script has been modified without saving. Close?")) {
            return;
        }
        this.desktopPane.remove(f);
        f.dispose();
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.splitPane = new JSplitPane();
        this.desktopPane = new JDesktopPane();
        this.consolePanel = new JPanel();
        this.consoleScrollPane = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.consoleButtonPanel = new JPanel();
        this.clearButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileNewMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.fileOpenMenuItem = new JMenuItem();
        this.fileSaveMenuItem = new JMenuItem();
        this.fileSaveAsMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.fileCloseMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.runMenu = new JMenu();
        this.runExecuteMenuItem = new JMenuItem();
        this.runStopMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.presetMenu = new JMenu();
        this.splitPane.setDividerLocation(550);
        this.splitPane.setDividerSize(8);
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.desktopPane.setBackground(new Color(204, 204, 255));
        this.splitPane.setLeftComponent(this.desktopPane);
        this.consolePanel.setLayout(new BorderLayout());
        this.consoleTextArea.setColumns(20);
        this.consoleTextArea.setFont(new Font("DialogInput", 0, 12));
        this.consoleTextArea.setRows(5);
        this.consoleScrollPane.setViewportView(this.consoleTextArea);
        this.consolePanel.add((Component)this.consoleScrollPane, "Center");
        this.consoleButtonPanel.setLayout(new FlowLayout(2, 1, 1));
        this.clearButton.setMnemonic('l');
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.consoleButtonPanel.add(this.clearButton);
        this.consolePanel.add((Component)this.consoleButtonPanel, "South");
        this.splitPane.setRightComponent(this.consolePanel);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileNewMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileNewMenuItem.setMnemonic('N');
        this.fileNewMenuItem.setText("New");
        this.fileNewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.fileNewMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileNewMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileOpenMenuItem.setMnemonic('O');
        this.fileOpenMenuItem.setText("Open");
        this.fileOpenMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.fileOpenMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileSaveMenuItem.setMnemonic('S');
        this.fileSaveMenuItem.setText("Save");
        this.fileSaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.fileSaveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileSaveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileSaveAsMenuItem.setMnemonic('A');
        this.fileSaveAsMenuItem.setText("Save As...");
        this.fileSaveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.fileSaveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.fileCloseMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileCloseMenuItem.setMnemonic('C');
        this.fileCloseMenuItem.setText("Close");
        this.fileCloseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.fileCloseMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileCloseMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.undoMenuItem.setMnemonic('U');
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.redoMenuItem.setMnemonic('R');
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.menuBar.add(this.editMenu);
        this.runMenu.setMnemonic('R');
        this.runMenu.setText("Run");
        this.runExecuteMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.runExecuteMenuItem.setMnemonic('E');
        this.runExecuteMenuItem.setText("Execute");
        this.runExecuteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.runExecuteMenuItemActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runExecuteMenuItem);
        this.runStopMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 8));
        this.runStopMenuItem.setMnemonic('S');
        this.runStopMenuItem.setText("Stop");
        this.runStopMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptingDialog.this.runStopMenuItemActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runStopMenuItem);
        this.menuBar.add(this.runMenu);
        this.windowMenu.setMnemonic('W');
        this.windowMenu.setText("Window");
        this.menuBar.add(this.windowMenu);
        this.presetMenu.setMnemonic('P');
        this.presetMenu.setText("Presets");
        this.menuBar.add(this.presetMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.consoleTextArea.setText("");
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        this.frame.getProjectContainer().getEditHistoryContainer().getUndoMenuItem().doClick();
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        this.frame.getProjectContainer().getEditHistoryContainer().getRedoMenuItem().doClick();
    }

    private void fileNewMenuItemActionPerformed(ActionEvent evt) {
        this.newEditor();
    }

    private void fileOpenMenuItemActionPerformed(ActionEvent evt) {
        File file = this.requester(false);
        if (file != null) {
            try {
                String path = file.getCanonicalPath();
                ScriptEditorInternalFrame editor = this.findByFilename(path);
                if (editor == null) {
                    FrinikaScript script = this.engine.loadScript(file);
                    editor = this.openEditor(script);
                    editor.lastSaveTimestamp = file.lastModified();
                } else {
                    editor.toFront();
                }
            }
            catch (IOException ioe) {
                this.frame.error(ioe);
            }
        }
    }

    private void fileSaveMenuItemActionPerformed(ActionEvent evt) {
        ScriptEditorInternalFrame editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        DefaultFrinikaScript script = (DefaultFrinikaScript)editor.getScript();
        String filename = script.getFilename();
        if (filename != null) {
            try {
                File file = new File(filename);
                this.engine.saveScript(script, file);
                editor.lastSaveTimestamp = file.lastModified();
                editor.setDirty(false);
            }
            catch (IOException ioe) {
                this.frame.error(ioe);
                this.fileSaveAsMenuItemActionPerformed(evt);
            }
        } else {
            this.fileSaveAsMenuItemActionPerformed(evt);
        }
    }

    private void fileSaveAsMenuItemActionPerformed(ActionEvent evt) {
        ScriptEditorInternalFrame editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        FrinikaScript script = editor.getScript();
        File file = this.requester(true);
        if (file != null) {
            try {
                if (!file.exists() || this.frame.confirm("File " + file.getCanonicalPath() + " already exists. Overwrite?")) {
                    this.engine.saveScript(script, file);
                    editor.updateTitle();
                    editor.lastSaveTimestamp = file.lastModified();
                    editor.setDirty(false);
                }
            }
            catch (IOException ioe) {
                this.frame.error(ioe);
            }
        }
    }

    private void fileCloseMenuItemActionPerformed(ActionEvent evt) {
        this.hide();
    }

    private void runExecuteMenuItemActionPerformed(ActionEvent evt) {
        FrinikaScript script = this.getActiveScript();
        if (script != null) {
            this.executeScript(script);
        }
    }

    private void runStopMenuItemActionPerformed(ActionEvent evt) {
        FrinikaScript script = this.getActiveScript();
        if (script != null) {
            this.stopScript(script);
        }
    }

    private File requester(boolean save) {
        int result;
        File f = !save ? ((result = this.fileChooser.showOpenDialog(this)) == 0 ? this.fileChooser.getSelectedFile() : null) : ((result = this.fileChooser.showSaveDialog(this)) == 0 ? this.fileChooser.getSelectedFile() : null);
        return f;
    }

    private void initPresetMenu() {
        this.presets = new HashMap<String, FrinikaScript>();
        this.preset("Hello World", "// Hello World:\n\nprint(\"Hello\");\nprintln(\" World\");\n\n\ns = \"Hello\";\ns += \" World\";\nprintln(s);\n");
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/frinika/project/scripting/gui/presets.txt")));
            StringBuffer sb = new StringBuffer();
            String presetName = null;
            String line = r.readLine();
            String doubleDelim = "######";
            boolean separator = false;
            while (line != null) {
                if (line.indexOf(doubleDelim) != -1) {
                    separator = true;
                } else if (line.startsWith(PRESETS_DELIM)) {
                    if (presetName != null) {
                        this.preset(presetName, sb.toString());
                    }
                    if (separator) {
                        this.presetMenu.addSeparator();
                        separator = false;
                    }
                    presetName = line.substring(PRESETS_DELIM.length()).trim();
                    sb = new StringBuffer();
                } else {
                    sb.append(line);
                    sb.append(NL);
                }
                line = r.readLine();
            }
            if (presetName != null) {
                this.preset(presetName, sb.toString().trim() + NL);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void preset(final String name, final String source) {
        FrinikaScript script = new FrinikaScript(){

            public int getLanguage() {
                return 1;
            }

            public String getName() {
                return name;
            }

            public String getSource() {
                return source;
            }
        };
        this.presets.put(name, script);
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String n = ((JMenuItem)e.getSource()).getText();
                FrinikaScript script = (FrinikaScript)ScriptingDialog.this.presets.get(n);
                ScriptEditorInternalFrame f = ScriptingDialog.this.findByScript(script);
                if (f != null) {
                    f.toFront();
                    f.requestFocus();
                } else {
                    ScriptingDialog.this.openEditor(script);
                }
            }
        });
        this.presetMenu.add(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SourceActionListener<T>
    implements ActionListener {
        protected T source;

        SourceActionListener(T source) {
            this.source = source;
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }
}

