/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.scripting.javascript;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.project.scripting.FrinikaScriptingEngine;
import com.frinika.project.scripting.gui.ScriptingDialog;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.gui.menu.DeleteAction;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordAction;
import com.frinika.sequencer.gui.transport.RecordAction;
import com.frinika.sequencer.gui.transport.RewindAction;
import com.frinika.sequencer.gui.transport.StartAction;
import com.frinika.sequencer.gui.transport.StopAction;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.Ghost;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.SysexEvent;
import com.frinika.sequencer.model.TextLane;
import com.frinika.sequencer.model.TextPart;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptScope
extends ScriptableObject {
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_MIDI = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_TEXT = 4;
    private static final String TEXT_DELIM = "\n---\n";
    private Context context;
    private ProjectFrame frame;
    private ScriptingDialog dialog;
    private TimeUtils timeUtils;
    private Map<Object, Object> wrapperCache;
    public Object song;
    public Object selection;
    public Object[][] menu;
    public Object persistent;
    public Object global;

    public JavascriptScope(Context context, ProjectFrame frame, SortedSet<MultiEvent> events, ScriptingDialog dialog) {
        this.context = context;
        this.frame = frame;
        this.dialog = dialog;
        ProjectContainer p = frame.getProjectContainer();
        this.timeUtils = new TimeUtils(p);
        this.wrapperCache = new HashMap<Object, Object>();
        this.song = new Song(p);
        this.selection = new Selection(events);
        this.initMenu();
        this.persistent = new PropertiesWrapper(p.getScriptingEngine().getPersistentProperties());
        this.global = new PropertiesWrapper(){

            public void set(String variable, String value) {
                FrinikaScriptingEngine.globalPut(variable, value);
            }

            public String get(String variable) {
                return FrinikaScriptingEngine.globalGet(variable);
            }
        };
        context.initStandardObjects((ScriptableObject)this);
        this.exportField("song", this.song);
        this.exportField("selection", this.selection);
        this.exportField("menu", this.menu);
        this.exportField("persistent", this.persistent);
        this.exportField("global", this.global);
        this.exportField("MIDI", 1);
        this.exportField("AUDIO", 2);
        this.exportField("TEXT", 4);
        this.exportMethod("print", new Class[]{String.class});
        this.exportMethod("println", new Class[]{String.class});
        this.exportMethod("message", new Class[]{String.class});
        this.exportMethod("error", new Class[]{String.class});
        this.exportMethod("confirm", new Class[]{String.class});
        this.exportMethod("prompt", new Class[]{String.class});
        this.exportMethod("promptFile", new Class[]{String.class, String.class, Boolean.TYPE});
        this.exportMethod("time", new Class[]{String.class});
        this.exportMethod("formatTime", new Class[]{Integer.TYPE});
        this.exportMethod("_wait", new Class[]{Integer.TYPE});
        this.exportMethod("waitTicks", new Class[]{Integer.TYPE});
        this.exportMethod("type", new Class[]{String.class});
        this.exportMethod("typeName", new Class[]{Integer.TYPE});
        this.exportMethod("note", new Class[]{String.class});
        this.exportMethod("noteName", new Class[]{Integer.TYPE});
        this.exportMethod("fileRead", new Class[]{String.class});
        this.exportMethod("fileWrite", new Class[]{String.class, String.class});
        this.exportMethod("fileLen", new Class[]{String.class});
        this.exportMethod("fileExists", new Class[]{String.class});
        this.exportMethod("fileDelete", new Class[]{String.class});
        this.exportMethod("panic", new Class[0]);
        this.exportMethod("shellExecute", new Class[]{String.class, Boolean.TYPE});
    }

    public String getClassName() {
        return "JavascriptScope";
    }

    private void exportField(String fieldName, Object value) {
        Object variableJS = Context.javaToJS((Object)value, (Scriptable)this);
        ScriptableObject.putProperty((Scriptable)this, (String)fieldName, (Object)variableJS);
    }

    private void exportMethod(String methodName, Class[] parameterSignature) {
        try {
            Method m = JavascriptScope.class.getMethod(methodName, parameterSignature);
            while (methodName.charAt(0) == '_') {
                methodName = methodName.substring(1);
            }
            FunctionObject functionJS = new FunctionObject(methodName, (Member)m, (Scriptable)this);
            ScriptableObject.putProperty((Scriptable)this, (String)methodName, (Object)functionJS);
        }
        catch (NoSuchMethodException nse) {
            nse.printStackTrace();
        }
    }

    public void print(String s) {
        System.out.print(s);
        if (this.dialog != null) {
            this.dialog.print(s);
        }
    }

    public void println(String s) {
        if (s.equals("undefined")) {
            s = "";
        }
        System.out.println(s);
        if (this.dialog != null) {
            this.dialog.println(s);
        }
    }

    public void message(String s) {
        System.out.println(s);
        if (this.frame != null) {
            this.frame.message(s);
        }
    }

    public void error(String s) {
        System.err.println(s);
        if (this.frame != null) {
            this.frame.error(s);
        }
    }

    public boolean confirm(String s) {
        System.out.print(s);
        if (this.frame != null) {
            System.out.println("... Ok.");
            return this.frame.confirm(s);
        }
        System.out.println("... Cancel.");
        return false;
    }

    public String prompt(String s) {
        System.out.print(s);
        String r = this.frame != null ? this.frame.prompt(s) : null;
        System.out.println(" " + r);
        return r;
    }

    public String promptFile(String defaultFilename, String suffices, boolean saveMode) {
        String r;
        System.out.print("prompting for " + (saveMode ? "saving" : "loading") + ", default " + defaultFilename + ":");
        if (this.frame != null) {
            String[][] s = null;
            boolean directoryMode = false;
            if (suffices != null) {
                directoryMode = suffices.equals("<dir>");
                if (!directoryMode) {
                    StringTokenizer st = new StringTokenizer(suffices, ";", false);
                    int count = st.countTokens();
                    s = new String[count][2];
                    for (int i = 0; i < s.length; ++i) {
                        String suf = st.nextToken();
                        int space = suf.indexOf(32);
                        if (space == -1) {
                            s[i][0] = suf;
                            s[i][1] = "";
                            continue;
                        }
                        s[i][0] = suf.substring(0, space);
                        s[i][1] = suf.substring(space + 1);
                    }
                }
            } else {
                s = new String[0][0];
            }
            r = this.frame.promptFile(defaultFilename, s, saveMode, directoryMode);
        } else {
            r = null;
        }
        System.out.println(" " + r);
        return r;
    }

    public int time(String s) {
        if (s.indexOf(46) == -1) {
            s = "0." + s;
        }
        if (s.indexOf(58) == -1) {
            s = s + ":000";
        }
        return (int)this.timeUtils.barBeatTickToTick(s);
    }

    public String formatTime(int ticks) {
        return this.timeUtils.tickToBarBeatTick(ticks);
    }

    public void _wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitTicks(int ticks) {
        long ms = this.tick2ms(ticks);
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private int tick2ms(int tick) {
        float bpm = ((Song)this.song).getBeatsPerMinute();
        int ppq = ((Song)this.song).getTicksPerBeat();
        int ms = Math.round((float)tick / (float)ppq / bpm * 60000.0f);
        return ms;
    }

    public int type(String name) {
        if (name.equalsIgnoreCase("Midi")) {
            return 1;
        }
        if (name.equalsIgnoreCase("Audio")) {
            return 2;
        }
        if (name.equalsIgnoreCase("Text")) {
            return 4;
        }
        return 1;
    }

    public String typeName(int type) {
        switch (type) {
            case 1: {
                return "Midi";
            }
            case 2: {
                return "Audio";
            }
            case 4: {
                return "Text";
            }
        }
        return null;
    }

    public int note(String name) {
        return MidiStepRecordAction.parseNote(name);
    }

    public String noteName(int note) {
        return MidiStepRecordAction.formatNote(note);
    }

    public String fileRead(String filename) {
        try {
            int hasRead;
            FileReader in = new FileReader(filename);
            StringBuffer sb = new StringBuffer();
            char[] c = new char[1024];
            do {
                if ((hasRead = in.read(c)) <= 0) continue;
                sb.append(c, 0, hasRead);
            } while (hasRead == c.length);
            in.close();
            return sb.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public boolean fileWrite(String filename, String data) {
        try {
            FileWriter out = new FileWriter(filename);
            out.write(data);
            out.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int fileLen(String filename) {
        File file = new File(filename);
        return (int)file.length();
    }

    public boolean fileExists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public boolean fileDelete(String filename) {
        File file = new File(filename);
        return file.delete();
    }

    public void panic() {
        this.frame.getProjectContainer().getSequencer().panic();
    }

    public int shellExecute(String cmd, boolean fork) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            if (fork) {
                return 0;
            }
            return p.waitFor();
        }
        catch (Exception e) {
            this.frame.error(e);
            return -1;
        }
    }

    protected void initMenu() {
        JMenuBar menuBar = this.frame.getJMenuBar();
        Object[][] o = new Object[menuBar.getMenuCount()][];
        for (int i = 0; i < o.length; ++i) {
            final JMenu menu = menuBar.getMenu(i);
            ArrayList<JMenuItem> m = new ArrayList<JMenuItem>();
            for (int j = 0; j < menu.getMenuComponentCount(); ++j) {
                Component component = menu.getMenuComponent(j);
                if (!(component instanceof JMenuItem)) continue;
                m.add((JMenuItem)component);
            }
            o[i] = new Converter(m){

                protected Object createWrapper(Object javaObject) {
                    return new Menu((JMenuItem)javaObject, menu);
                }
            }.toArray();
        }
        this.menu = o;
    }

    private Object convert(Object javaObject, Object newWrapper) {
        Object wrapper = this.wrapperCache.get(javaObject);
        if (wrapper == null) {
            wrapper = newWrapper;
            this.wrapperCache.put(javaObject, wrapper);
        }
        return wrapper;
    }

    private static NoteEvent findNote(long tick, int note, MidiPart p) {
        SortedSet<MultiEvent> eventsAtTick = p.getMultiEventSubset(tick, tick + 1L);
        if (eventsAtTick != null && !eventsAtTick.isEmpty()) {
            for (MultiEvent e : eventsAtTick) {
                NoteEvent n;
                if (!(e instanceof NoteEvent) || (n = (NoteEvent)e).getNote() != note) continue;
                return n;
            }
        }
        return null;
    }

    private class Converter {
        private Collection c;

        Converter(Collection c, Class filterType) {
            if (filterType != null) {
                this.c = new ArrayList();
                for (Object o : c) {
                    if (!filterType.isAssignableFrom(o.getClass())) continue;
                    this.c.add(o);
                }
            } else {
                this.c = c;
            }
        }

        Converter(Collection c) {
            this(c, null);
        }

        Object[] toArray() {
            Object[] l = new Object[this.c.size()];
            int i = 0;
            for (Object q : this.c) {
                l[i++] = this.getWrapper(q);
            }
            return l;
        }

        private Object getWrapper(Object javaObject) {
            Object wrapper = JavascriptScope.this.wrapperCache.get(javaObject);
            if (wrapper == null && (wrapper = this.createWrapper(javaObject)) != javaObject) {
                JavascriptScope.this.wrapperCache.put(javaObject, wrapper);
            }
            return wrapper;
        }

        protected Object createWrapper(Object javaObject) {
            return javaObject;
        }
    }

    public class PropertiesWrapper {
        private Properties p;

        PropertiesWrapper() {
            this(null);
        }

        PropertiesWrapper(Properties properties) {
            this.p = properties;
        }

        public void set(String variable, String value) {
            this.p.put(variable, value);
        }

        public String get(String variable) {
            return this.p.getProperty(variable);
        }
    }

    public class Menu {
        private JMenuItem item;
        private JMenuItem menu;

        Menu(JMenuItem item, JMenu menu) {
            this.item = item;
            this.menu = menu;
        }

        public String getLabel() {
            return this.item.getText();
        }

        public String getMenuLabel() {
            return this.menu.getText();
        }

        public void execute() {
            this.item.doClick();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Selection {
        public int start;
        public int end;
        public int duration;
        public Object part;
        public Object lane;
        public Object[] notes;
        public Object[] controllers;
        public Object[] sysex;

        Selection(SortedSet<MultiEvent> p) {
            if (p != null && !p.isEmpty()) {
                MultiEvent first = p.first();
                MultiEvent last = p.last();
                this.start = (int)first.getStartTick();
                this.end = (int)last.getEndTick();
                this.duration = this.end - this.start;
                this.lane = new Lane(first.getPart().getLane());
                this.part = new Part(first.getPart(), (Lane)this.lane);
            } else {
                Collection partSelection = JavascriptScope.this.frame.getProjectContainer().getPartSelection().getSelected();
                if (!partSelection.isEmpty()) {
                    com.frinika.sequencer.model.Part prt = (com.frinika.sequencer.model.Part)partSelection.iterator().next();
                    this.start = (int)prt.getStartTick();
                    this.end = (int)prt.getEndTick();
                    this.duration = (int)prt.getDurationInTicks();
                    this.lane = new Lane(prt.getLane());
                    this.part = new Part(prt, (Lane)this.lane);
                } else {
                    Collection laneSelection = JavascriptScope.this.frame.getProjectContainer().getLaneSelection().getSelected();
                    if (!laneSelection.isEmpty()) {
                        com.frinika.sequencer.model.Lane ln = (com.frinika.sequencer.model.Lane)laneSelection.iterator().next();
                        this.start = 0;
                        this.end = (int)ln.rightTickForMove();
                        this.duration = this.end - this.start;
                        this.part = null;
                        this.lane = new Lane(ln);
                    }
                }
            }
            ArrayList<MultiEvent> n = new ArrayList<MultiEvent>();
            ArrayList<MultiEvent> c = new ArrayList<MultiEvent>();
            ArrayList<MultiEvent> s = new ArrayList<MultiEvent>();
            if (p != null) {
                for (MultiEvent e : p) {
                    if (e instanceof NoteEvent) {
                        n.add(e);
                        continue;
                    }
                    if (e instanceof ControllerEvent) {
                        c.add(e);
                        continue;
                    }
                    if (!(e instanceof SysexEvent)) continue;
                    s.add(e);
                }
            }
            this.notes = new Object[n.size()];
            n.toArray(this.notes);
            this.controllers = new Object[c.size()];
            c.toArray(this.controllers);
            this.sysex = new Object[s.size()];
            s.toArray(this.sysex);
        }
    }

    public class Part {
        private com.frinika.sequencer.model.Part p;
        private int type;
        public Object lane;

        Part(com.frinika.sequencer.model.Part p, Lane parent) {
            this.p = p;
            this.lane = parent;
            this.type = p instanceof MidiPart ? 1 : (p instanceof AudioPart ? 2 : (p instanceof TextPart ? 4 : 1));
        }

        public int getType() {
            return this.type;
        }

        public boolean isGhost() {
            return this.p instanceof Ghost;
        }

        public void remove() {
            JavascriptScope.this.frame.getProjectContainer().getPartSelection().setSelected(this.p);
            new DeleteAction(JavascriptScope.this.frame.getProjectContainer()).actionPerformed(null);
        }

        public int getStartTick() {
            return (int)this.p.getStartTick();
        }

        public void setStartTick(int tick) {
            this.p.setStartTick(tick);
        }

        public int getEndTick() {
            return (int)this.p.getEndTick();
        }

        public void setEndTick(int tick) {
            this.p.setEndTick(tick);
        }

        public int getDuration() {
            return (int)this.p.getDurationInTicks();
        }

        public void setDuration(int tick) {
            this.setEndTick(this.getStartTick() + tick);
        }

        public Object[] getNotes() {
            if (this.type == 1) {
                return new Converter(((MidiPart)this.p).getMultiEvents(), NoteEvent.class).toArray();
            }
            return null;
        }

        public Object[] getControllers() {
            if (this.type == 1) {
                return new Converter(((MidiPart)this.p).getMultiEvents(), ControllerEvent.class).toArray();
            }
            return null;
        }

        public void insertNote(int note, int tick, int duration, int velocity) {
            if (this.type == 1) {
                ProjectContainer project = JavascriptScope.this.frame.getProjectContainer();
                project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.add_note"));
                NoteEvent newNote = new NoteEvent((MidiPart)this.p, (long)tick, note, velocity, ((MidiPart)this.p).getMidiChannel(), (long)duration);
                ((MidiPart)this.p).add(newNote);
                project.getEditHistoryContainer().notifyEditHistoryListeners();
            }
        }

        public void removeNote(int note, int tick) {
            if (this.type == 1) {
                ProjectContainer project = JavascriptScope.this.frame.getProjectContainer();
                project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.add_note"));
                NoteEvent delNote = JavascriptScope.findNote(tick, note, (MidiPart)this.p);
                if (delNote != null) {
                    ((MidiPart)this.p).remove(delNote);
                }
                project.getEditHistoryContainer().notifyEditHistoryListeners();
            }
        }

        public int getMidiChannel() {
            if (this.type == 1) {
                return ((MidiPart)this.p).getMidiChannel();
            }
            return -1;
        }

        public String getText() {
            if (this.type == 4) {
                return ((TextPart)this.p).getText();
            }
            return null;
        }

        public void setText(String text) {
            if (this.type == 4) {
                ((TextPart)this.p).setText(text);
            }
        }
    }

    public class Lane {
        private com.frinika.sequencer.model.Lane l;
        private int type;

        Lane(com.frinika.sequencer.model.Lane l) {
            this.l = l;
            this.type = l instanceof MidiLane ? 1 : (l instanceof AudioLane ? 2 : (l instanceof TextLane ? 4 : 1));
        }

        public int getType() {
            return this.type;
        }

        public int getIndex() {
            return JavascriptScope.this.frame.getProjectContainer().getLanes().indexOf(this.l);
        }

        public String getName() {
            return this.l.getName();
        }

        public void setName(String name) {
            this.l.setName(name);
        }

        public Object[] getParts() {
            return new Converter(this.l.getParts()){

                protected Object createWrapper(Object o) {
                    return new Part((com.frinika.sequencer.model.Part)o, Lane.this);
                }
            }.toArray();
        }

        public Object newPart(int startTick, int duration) {
            return this.newPartOfType(startTick, duration, this.type);
        }

        public Object newPartOfType(int startTick, int duration, int type) {
            com.frinika.sequencer.model.Part part;
            ProjectContainer project = JavascriptScope.this.frame.getProjectContainer();
            if (JavascriptScope.this.typeName(type) == null) {
                type = this.getType();
            }
            if (type == 1) {
                part = new MidiPart();
            } else if (type == 2) {
                part = new AudioPart();
            } else if (type == 4) {
                part = new TextPart((TextLane)this.l);
            } else {
                JavascriptScope.this.frame.error("cannot create new part, unknown type " + type);
                return null;
            }
            project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.lane.add_part"));
            part.setStartTick(startTick);
            part.setEndTick(startTick + duration);
            this.l.add(part);
            project.getEditHistoryContainer().notifyEditHistoryListeners();
            return JavascriptScope.this.convert(part, new Part(part, (Lane)JavascriptScope.this.convert(this.l, new Lane(this.l))));
        }

        public Object getPart(int startTick) {
            Object[] parts = this.getParts();
            for (int i = 0; i < parts.length; ++i) {
                if (startTick != ((Part)parts[i]).getStartTick()) continue;
                return parts[i];
            }
            return null;
        }

        public void remove() {
            JavascriptScope.this.frame.getProjectContainer().getLaneSelection().setSelected(this.l);
            new DeleteAction(JavascriptScope.this.frame.getProjectContainer()).actionPerformed(null);
        }

        public int getMidiChannel() {
            if (this.type == 1) {
                return ((MidiLane)this.l).getMidiChannel();
            }
            return -1;
        }

        public void setMute(boolean b) {
            if (this.type == 1) {
                ((MidiLane)this.l).setMute(b);
            }
        }

        public boolean isMute() {
            if (this.type == 1) {
                return ((MidiLane)this.l).isMute();
            }
            return false;
        }

        public void setSolo(boolean b) {
            if (this.type == 1) {
                ((MidiLane)this.l).setSolo(b);
            }
        }

        public boolean isSolo() {
            if (this.type == 1) {
                return ((MidiLane)this.l).isSolo();
            }
            return false;
        }

        public void setLooped(boolean b) {
            if (this.type == 1) {
                ((MidiLane)this.l).getPlayOptions().looped = b;
            }
        }

        public boolean isLooped() {
            if (this.type == 1) {
                return ((MidiLane)this.l).getPlayOptions().looped;
            }
            return false;
        }

        public void setRecording(boolean b) {
            if (this.type == 1) {
                ((MidiLane)this.l).setRecording(b);
            }
        }

        public boolean isRecording() {
            if (this.type == 1) {
                return ((MidiLane)this.l).isRecording();
            }
            return false;
        }

        public String getText(String delim) {
            if (this.type == 4) {
                return ((TextLane)this.l).getAllText(delim);
            }
            return null;
        }

        public String getText() {
            return this.getText(JavascriptScope.TEXT_DELIM);
        }

        public void setText(String text, String delim) {
            if (this.type == 4) {
                ((TextLane)this.l).setAllText(text, delim);
            }
        }

        public void setText(String text) {
            if (this.type == 4) {
                ((TextLane)this.l).setAllText(text, JavascriptScope.TEXT_DELIM);
            }
        }
    }

    public class Song {
        private ProjectContainer p;

        Song(ProjectContainer p) {
            this.p = p;
        }

        public Object[] getSystemLanes() {
            return new Converter(this.p.getProjectLane().getFamilyLanes()){

                protected Object createWrapper(Object o) {
                    return new Lane((com.frinika.sequencer.model.Lane)o);
                }
            }.toArray();
        }

        public Object[] getLanes() {
            return new Converter(this.p.getProjectLane().getChildren()){

                protected Object createWrapper(Object o) {
                    return new Lane((com.frinika.sequencer.model.Lane)o);
                }
            }.toArray();
        }

        public Object[] getMidiLanes() {
            return new Converter(this.p.getLanes(), MidiLane.class){

                protected Object createWrapper(Object o) {
                    return new Lane((com.frinika.sequencer.model.Lane)o);
                }
            }.toArray();
        }

        public Object[] getAudioLanes() {
            return new Converter(this.p.getLanes(), AudioLane.class){

                protected Object createWrapper(Object o) {
                    return new Lane((com.frinika.sequencer.model.Lane)o);
                }
            }.toArray();
        }

        public Object[] getTextLanes() {
            return new Converter(this.p.getLanes(), TextLane.class){

                protected Object createWrapper(Object o) {
                    return new Lane((com.frinika.sequencer.model.Lane)o);
                }
            }.toArray();
        }

        public String getFilename() {
            File file = this.p.getProjectFile();
            if (file != null && file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        public int getTicksPerBeat() {
            return this.p.getSequence().getResolution();
        }

        public float getBeatsPerMinute() {
            return this.p.getSequencer().getTempoInBPM();
        }

        public void setPosition(int tick) {
            JavascriptScope.this.frame.getProjectContainer().getSequencer().setTickPosition(tick);
        }

        public int getPosition() {
            return (int)JavascriptScope.this.frame.getProjectContainer().getSequencer().getTickPosition();
        }

        public void play() {
            new StartAction(JavascriptScope.this.frame).actionPerformed(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playUntil(final int tick) {
            Object object;
            FrinikaSequencer sequencer = JavascriptScope.this.frame.getProjectContainer().getSequencer();
            long current = sequencer.getTickPosition();
            if ((long)tick <= current) {
                return;
            }
            final Object lock = new Object();
            SongPositionListener spl = new SongPositionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void notifyTickPosition(long t) {
                    FrinikaSequencer sequencer = JavascriptScope.this.frame.getProjectContainer().getSequencer();
                    if (t >= (long)tick) {
                        sequencer.stop();
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                }

                public boolean requiresNotificationOnEachTick() {
                    return true;
                }
            };
            sequencer.addSongPositionListener(spl);
            this.play();
            try {
                object = lock;
                synchronized (object) {
                    lock.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            object = sequencer;
            synchronized (object) {
                sequencer.removeSongPositionListener(spl);
            }
        }

        public void stop() {
            new StopAction(JavascriptScope.this.frame).actionPerformed(null);
        }

        public void rewind() {
            new RewindAction(JavascriptScope.this.frame).actionPerformed(null);
        }

        public void record() {
            new RecordAction(JavascriptScope.this.frame).actionPerformed(null);
        }

        public void save() {
            File file = this.p.getProjectFile();
            if (file != null) {
                try {
                    this.p.saveProject(file);
                }
                catch (Throwable t) {
                    JavascriptScope.this.frame.error(t);
                }
            }
        }

        public void saveAs(String filename) {
            File file = new File(filename);
            if (file != null && file.isFile()) {
                try {
                    this.p.saveProject(file);
                }
                catch (Throwable t) {
                    JavascriptScope.this.frame.error(t);
                }
            } else {
                JavascriptScope.this.frame.error("Invalid filename for saving '" + filename + "'.");
            }
        }

        public void open(String filename) {
            try {
                new ProjectFrame(ProjectContainer.loadProject(new File(filename)));
            }
            catch (Throwable t) {
                JavascriptScope.this.frame.error(t);
            }
        }

        public void createNew() {
            try {
                new ProjectFrame(new ProjectContainer());
            }
            catch (Exception e) {
                JavascriptScope.this.frame.error(e);
            }
        }

        public Object newLane(String name, int type) {
            com.frinika.sequencer.model.Lane lane;
            ProjectContainer project = JavascriptScope.this.frame.getProjectContainer();
            switch (type) {
                case 1: {
                    project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.add_midi_lane"));
                    lane = project.createMidiLane();
                    break;
                }
                case 2: {
                    project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.add_audio_lane"));
                    lane = project.createAudioLane();
                    break;
                }
                case 4: {
                    project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.add_text_lane"));
                    lane = project.createTextLane();
                    break;
                }
                default: {
                    JavascriptScope.this.frame.error("cannot create new lane, unknown type " + type);
                    return null;
                }
            }
            lane.setName(name);
            project.getEditHistoryContainer().notifyEditHistoryListeners();
            return JavascriptScope.this.convert(lane, new Lane(lane));
        }

        public Object getLane(String name) {
            Object[] lanes = this.getSystemLanes();
            for (int i = 0; i < lanes.length; ++i) {
                if (!name.equals(((Lane)lanes[i]).getName())) continue;
                return lanes[i];
            }
            return null;
        }
    }
}

