/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.renderer.MidiPacket;
import com.frinika.renderer.MidiPacketProvider;
import com.frinika.renderer.MidiPacketsRenderer;
import com.frinika.renderer.MidiRenderFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class CachedRender {
    File cache;
    MidiPacketProvider provider;
    MidiRenderFactory factory;
    MidiPacketsRenderer render = null;
    float samplerate;
    int channels;
    int rendermode;
    RandomAccessFile raf;
    int headersize = 13;
    int packetsize = -1;
    boolean file_checked = false;
    byte[] byteBuffer = null;
    FloatBuffer floatBuffer;
    boolean dirty_rendered = false;
    byte[] emptybuffer = new byte[2048];

    public CachedRender(File cache, MidiPacketProvider provider, MidiRenderFactory factory, float samplerate, int channels, int rendermode) {
        Arrays.fill(this.emptybuffer, (byte)0);
        this.cache = cache;
        this.provider = provider;
        this.factory = factory;
        this.samplerate = samplerate;
        this.channels = channels;
        this.rendermode = rendermode;
        try {
            this.raf = new RandomAccessFile(cache, "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.raf = null;
        }
    }

    public void checkFile(int packetsize) {
        this.packetsize = packetsize;
        try {
            boolean fileok = false;
            if (this.raf.length() >= 13L) {
                this.raf.seek(0L);
                byte[] magic = new byte[4];
                this.raf.read(magic);
                int version = this.raf.readInt();
                boolean bigendian = this.raf.readBoolean();
                int read_packetsize = this.raf.readInt();
                if (new String(magic, "lain1").equals("MRCF") && version == 1 && bigendian == ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) && read_packetsize == packetsize) {
                    fileok = true;
                }
            }
            if (!fileok) {
                this.raf.setLength(0L);
                this.raf.write(new String("MRCF").getBytes("latin1"));
                this.raf.writeInt(1);
                this.raf.writeBoolean(ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
                this.raf.writeInt(packetsize);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getPacket(int index, float[] buffer, int start, int end) {
        MidiPacket packet;
        if (!this.file_checked) {
            this.packetsize = (end - start) * 4;
            ++this.packetsize;
            this.packetsize += 4;
            ++this.packetsize;
            this.checkFile(this.packetsize);
            this.file_checked = false;
            ByteBuffer bytebuffer = ByteBuffer.allocate((end - start) * 4).order(ByteOrder.nativeOrder());
            this.byteBuffer = bytebuffer.array();
            this.floatBuffer = bytebuffer.asFloatBuffer();
        }
        int packet_chekcsum = (packet = this.provider.get(index)) == null ? 0 : packet.checksum();
        boolean eof_packet = packet == null;
        long packet_offset = (long)this.headersize + (long)this.packetsize * (long)index;
        boolean packetfound = false;
        if (this.rendermode != 2) {
            try {
                if (this.raf.length() >= packet_offset + (long)this.packetsize) {
                    this.raf.seek(packet_offset);
                    byte status = this.raf.readByte();
                    int read_checksum = this.raf.readInt();
                    boolean eof = this.raf.readBoolean();
                    if (!(eof && this.render != null || status == 0)) {
                        boolean bl = packetfound = read_checksum == packet_chekcsum;
                    }
                }
                if (packetfound) {
                    if (this.render != null) {
                        this.render.close();
                        this.render = null;
                    }
                    if (this.rendermode == 1) {
                        Arrays.fill(buffer, start, end, 0.0f);
                        return;
                    }
                    System.out.println("read packet : " + packet_chekcsum);
                    this.raf.read(this.byteBuffer);
                    this.floatBuffer.position(0);
                    this.floatBuffer.get(buffer, start, end);
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                packetfound = false;
            }
        }
        if (this.render == null) {
            if (eof_packet) {
                Arrays.fill(buffer, start, end, 0.0f);
                return;
            }
            this.render = new MidiPacketsRenderer(this.factory, this.samplerate, this.channels, packet);
            this.dirty_rendered = index != 0;
        }
        System.out.println("render packet : " + packet_chekcsum);
        this.render.render(packet, buffer, start, end);
        try {
            if (this.raf.length() < packet_offset) {
                this.raf.seek(this.raf.length());
                while (this.raf.length() < packet_offset) {
                    if (packet_offset - this.raf.length() > 2048L) {
                        this.raf.write(this.emptybuffer);
                        continue;
                    }
                    this.raf.write(this.emptybuffer, 0, (int)(packet_offset - this.raf.length()));
                }
            }
            this.raf.seek(packet_offset);
            if (this.dirty_rendered) {
                this.raf.writeByte(2);
            } else {
                this.raf.writeByte(1);
            }
            this.raf.writeInt(packet_chekcsum);
            this.raf.writeBoolean(eof_packet);
            this.floatBuffer.position(0);
            this.floatBuffer.put(buffer, start, end);
            this.raf.write(this.byteBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.render != null) {
            this.render.close();
        }
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

