/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaSequence
extends Sequence {
    Vector<FrinikaTrackWrapper> frinikaTrackWrappers = new Vector();
    transient FrinikaSequencer sequencer;

    public FrinikaSequence(Sequence sequence) throws InvalidMidiDataException {
        super(sequence.getDivisionType(), sequence.getResolution());
        for (Track track : sequence.getTracks()) {
            FrinikaTrackWrapper trackWrapper = new FrinikaTrackWrapper(track);
            trackWrapper.setSequence(this);
            this.tracks.add(track);
            this.frinikaTrackWrappers.add(trackWrapper);
        }
    }

    public FrinikaSequence(float divisionType, int resolution, int tracks) throws InvalidMidiDataException {
        super(divisionType, resolution);
        for (int n = 0; n < tracks; ++n) {
            this.createTrack();
        }
    }

    @Override
    public Track createTrack() {
        Track track = super.createTrack();
        FrinikaTrackWrapper trackWrapper = new FrinikaTrackWrapper(track);
        this.frinikaTrackWrappers.add(trackWrapper);
        trackWrapper.setSequence(this);
        return track;
    }

    public FrinikaTrackWrapper createFrinikaTrack() {
        Track track = super.createTrack();
        FrinikaTrackWrapper trackWrapper = new FrinikaTrackWrapper(track);
        this.frinikaTrackWrappers.add(trackWrapper);
        trackWrapper.setSequence(this);
        return trackWrapper;
    }

    public Vector<FrinikaTrackWrapper> getFrinikaTrackWrappers() {
        return this.frinikaTrackWrappers;
    }

    public FrinikaSequencer getSequencer() {
        return this.sequencer;
    }

    void setSequencer(FrinikaSequencer sequencer) {
        this.sequencer = sequencer;
    }

    public Sequence export() throws InvalidMidiDataException {
        Sequence newSeq = new Sequence(this.getDivisionType(), this.getResolution());
        for (FrinikaTrackWrapper ftw : this.frinikaTrackWrappers) {
            if (ftw.getMidiChannel() == -1) continue;
            Track track = newSeq.createTrack();
            for (int n = 0; n < ftw.size(); ++n) {
                MidiEvent sourceMidiEvent = ftw.get(n);
                MidiMessage msg = sourceMidiEvent.getMessage();
                if (msg instanceof ShortMessage) {
                    ShortMessage shm = (ShortMessage)msg;
                    ShortMessage nshm = new ShortMessage();
                    nshm.setMessage(shm.getCommand(), ftw.getMidiChannel(), shm.getData1(), shm.getData2());
                    msg = nshm;
                }
                MidiEvent newEvent = new MidiEvent(msg, sourceMidiEvent.getTick());
                track.add(newEvent);
            }
        }
        return newSeq;
    }
}

