/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencerPlayer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.SequencerListener;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.TempoChangeListener;
import com.frinika.sequencer.gui.RecordingDialog;
import com.frinika.sequencer.midi.MidiMessageListener;
import com.frinika.sequencer.midi.MonitorReceiver;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MidiPlayOptions;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.PitchBendEvent;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.tempo.TempoList;
import com.frinika.synth.SynthRack;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaSequencer
implements Sequencer {
    private FrinikaSequence sequence;
    private FrinikaSequencerPlayer player = new FrinikaSequencerPlayer(this);
    private int loopCount;
    private long loopStartPoint;
    private long loopEndPoint;
    private float bpm = 100.0f;
    private boolean recording;
    private final List<Transmitter> transmitters = new ArrayList<Transmitter>();
    private final List<Receiver> receivers = new ArrayList<Receiver>();
    private final List<SongPositionListener> songPositionListeners = new ArrayList<SongPositionListener>();
    private final ArrayList<SequencerListener> sequencerListeners = new ArrayList();
    private final Collection<MidiMessageListener> midiMessageListeners = new HashSet<MidiMessageListener>();
    private final HashMap<MidiDevice, Transmitter> midiOutDeviceTransmitters = new HashMap();
    private final List<MidiDevice> midiOutDevices = new ArrayList<MidiDevice>();
    private final ArrayList<SongPositionListener> intenseSongPositionListeners = new ArrayList();
    private final ArrayList<TempoChangeListener> tempoChangeListeners = new ArrayList();
    private final HashSet<RecordableLane> recordingLanes = new HashSet();
    private Vector<Vector<MultiEvent>> recordingTakes = new Vector();
    private Vector<MultiEvent> currentRecordingTake = new Vector();
    private RecordingDialog recordingTakeDialog = null;
    private final HashSet<FrinikaTrackWrapper> soloFrinikaTrackWrappers = new HashSet();
    private final HashMap<FrinikaTrackWrapper, MidiPlayOptions> frinikaTrackWrappersMidiPlayOptions = new HashMap();
    private Transmitter transmitter;
    HashMap<Integer, NoteEvent> pendingNoteEvents = new HashMap();
    int lastLoopCount;
    private Receiver receiver = new MonitorReceiver(this.midiMessageListeners, new Receiver(){

        void addEventToRecordingTracks(ChannelEvent event) {
            FrinikaSequencer.this.currentRecordingTake.add(event);
        }

        public void send(MidiMessage message, long timeStamp) {
            long tick = FrinikaSequencer.this.player.getRealTimeTickPosition();
            for (RecordableLane rlane : FrinikaSequencer.this.recordingLanes) {
                if (!(rlane instanceof MidiLane)) continue;
                MidiLane lane = (MidiLane)rlane;
                MidiDevice dev = lane.getMidiDevice();
                MidiPlayOptions po = lane.getPlayOptions();
                if (po.muted || dev == null || !(message instanceof ShortMessage)) continue;
                ShortMessage shm = (ShortMessage)message;
                try {
                    int cmd = shm.getCommand();
                    int chn = lane.getMidiChannel();
                    int dat1 = shm.getData1();
                    int dat2 = shm.getData2();
                    ShortMessage throughShm = new ShortMessage();
                    if (cmd == 144 || cmd == 128) {
                        dat1 = FrinikaSequencerPlayer.applyPlayOptionsNote(po, dat1);
                        dat2 = FrinikaSequencerPlayer.applyPlayOptionsVelocity(po, dat2);
                        throughShm.setMessage(cmd, chn, dat1, dat2);
                        dev.getReceiver().send(throughShm, -1L);
                        continue;
                    }
                    throughShm.setMessage(cmd, chn, dat1, dat2);
                    dev.getReceiver().send(throughShm, -1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (FrinikaSequencer.this.recording) {
                if (FrinikaSequencer.this.player.getLoopCount() > FrinikaSequencer.this.lastLoopCount) {
                    FrinikaSequencer.this.newRecordingTake();
                    FrinikaSequencer.this.lastLoopCount = FrinikaSequencer.this.player.getLoopCount();
                }
                if (message instanceof ShortMessage) {
                    ShortMessage shm = (ShortMessage)message;
                    if (shm.getCommand() == 144 || shm.getCommand() == 128) {
                        if (shm.getCommand() == 128 || shm.getData2() == 0) {
                            NoteEvent noteEvent = FrinikaSequencer.this.pendingNoteEvents.get(shm.getChannel() << 8 | shm.getData1());
                            if (noteEvent != null) {
                                noteEvent.setDuration(tick - noteEvent.getStartTick());
                                FrinikaSequencer.this.pendingNoteEvents.remove(shm.getChannel() << 8 | shm.getData1());
                                this.addEventToRecordingTracks(noteEvent);
                            }
                        } else {
                            FrinikaSequencer.this.pendingNoteEvents.put(shm.getChannel() << 8 | shm.getData1(), new NoteEvent((FrinikaTrackWrapper)null, tick, shm.getData1(), shm.getData2(), shm.getChannel(), 0L));
                        }
                    } else if (shm.getCommand() == 176) {
                        this.addEventToRecordingTracks(new ControllerEvent((FrinikaTrackWrapper)null, tick, shm.getData1(), shm.getData2()));
                    } else if (shm.getCommand() == 224) {
                        this.addEventToRecordingTracks(new PitchBendEvent((FrinikaTrackWrapper)null, tick, (shm.getData1() | shm.getData2() << 7) & Short.MAX_VALUE));
                    }
                }
            }
        }

        public void close() {
        }
    });

    public FrinikaSequencer() {
        this.receivers.add(this.receiver);
    }

    @Override
    public void setSequence(Sequence sequence) throws InvalidMidiDataException {
        this.sequence = (FrinikaSequence)sequence;
    }

    @Override
    public void setSequence(InputStream stream) throws IOException, InvalidMidiDataException {
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void start() {
        for (SequencerListener listener : this.sequencerListeners) {
            listener.beforeStart();
        }
        this.player.start();
        for (SequencerListener listener : this.sequencerListeners) {
            listener.start();
        }
    }

    @Override
    public void stop() {
        if (this.recording) {
            this.newRecordingTake();
            this.recording = false;
        }
        this.player.stop();
        ArrayList list = (ArrayList)this.sequencerListeners.clone();
        for (SequencerListener listener : list) {
            listener.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.player.isRunning();
    }

    final void newRecordingTake() {
        if (this.currentRecordingTake.size() > 0) {
            this.recordingTakes.add(this.currentRecordingTake);
            if (this.recordingTakeDialog != null) {
                this.recordingTakeDialog.notifyNewTake(this.recordingTakes.size() - 1);
                if (this.recordingTakes.size() > 1) {
                    this.recordingTakeDialog.setVisible(true);
                }
            }
        }
        this.currentRecordingTake = new Vector();
    }

    public int getNumberOfTakes() {
        return this.recordingTakes.size();
    }

    public void deployTake(int[] takeNumbers) {
        Vector<MidiPart> parts = new Vector<MidiPart>();
        for (RecordableLane lane : this.recordingLanes) {
            if (lane instanceof MidiLane) {
                MidiPart part = new MidiPart((MidiLane)lane);
                parts.add(part);
            }
            if (!(lane instanceof AudioLane)) continue;
            try {
                throw new Exception(" CAN NOT DEPLOY AUDIO YET");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int[] arr$ = takeNumbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer takeNo = arr$[i$];
            for (MultiEvent event : this.recordingTakes.get(takeNo)) {
                for (MidiPart part : parts) {
                    try {
                        part.add((MultiEvent)event.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (MidiPart part : parts) {
            part.setBoundsFromEvents();
        }
        this.recordingTakes.clear();
        if (this.recordingTakeDialog != null) {
            this.recordingTakeDialog.dispose();
            this.recordingTakeDialog = null;
        }
    }

    public Vector<MultiEvent> getRecordingTake(int takeNo) {
        return this.recordingTakes.get(takeNo);
    }

    @Override
    public void startRecording() {
        this.pendingNoteEvents.clear();
        this.lastLoopCount = 0;
        this.recording = true;
        this.player.setLatencyCompensationInMillis(FrinikaAudioSystem.getOutputLatencyMillis());
        this.start();
    }

    @Override
    public void stopRecording() {
        this.stop();
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void recordEnable(Track track, int channel) {
    }

    public void recordEnable(RecordableLane lane) {
        this.recordingLanes.add(lane);
    }

    @Override
    public void recordDisable(Track track) {
    }

    public boolean isRecording(RecordableLane lane) {
        return this.recordingLanes.contains(lane);
    }

    public void recordDisable(RecordableLane lane) {
        this.recordingLanes.remove(lane);
    }

    @Override
    public float getTempoInBPM() {
        return this.bpm;
    }

    @Override
    public void setTempoInBPM(float bpm) {
        this.bpm = bpm;
        this.notifyTempoChangeListeners();
    }

    @Override
    public float getTempoInMPQ() {
        return 0.0f;
    }

    @Override
    public void setTempoInMPQ(float mpq) {
    }

    @Override
    public void setTempoFactor(float factor) {
    }

    @Override
    public float getTempoFactor() {
        return 0.0f;
    }

    @Override
    public long getTickLength() {
        return 0L;
    }

    public long getTicksLooped() {
        return this.player.getTicksLooped();
    }

    @Override
    public long getTickPosition() {
        return this.player.getTickPosition();
    }

    @Override
    public void setTickPosition(long tick) {
        this.player.setTickPosition(tick);
    }

    @Override
    public long getMicrosecondLength() {
        return 0L;
    }

    @Override
    public long getMicrosecondPosition() {
        return this.player.getMicroSecondPosition();
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
    }

    @Override
    public void setMasterSyncMode(Sequencer.SyncMode sync) {
    }

    @Override
    public Sequencer.SyncMode getMasterSyncMode() {
        return null;
    }

    @Override
    public Sequencer.SyncMode[] getMasterSyncModes() {
        return null;
    }

    @Override
    public void setSlaveSyncMode(Sequencer.SyncMode sync) {
    }

    @Override
    public Sequencer.SyncMode getSlaveSyncMode() {
        return null;
    }

    @Override
    public Sequencer.SyncMode[] getSlaveSyncModes() {
        return null;
    }

    @Override
    public void setTrackMute(int track, boolean mute) {
    }

    @Override
    public boolean getTrackMute(int track) {
        return false;
    }

    @Override
    public void setTrackSolo(int track, boolean solo) {
    }

    @Override
    public boolean getTrackSolo(int track) {
        return false;
    }

    @Override
    public boolean addMetaEventListener(MetaEventListener listener) {
        return false;
    }

    @Override
    public void removeMetaEventListener(MetaEventListener listener) {
    }

    @Override
    public int[] addControllerEventListener(ControllerEventListener listener, int[] controllers) {
        return null;
    }

    @Override
    public int[] removeControllerEventListener(ControllerEventListener listener, int[] controllers) {
        return null;
    }

    @Override
    public void setLoopStartPoint(long tick) {
        this.loopStartPoint = tick;
        this.notifySongPositionListeners(this.player.getTickPosition());
    }

    @Override
    public long getLoopStartPoint() {
        return this.loopStartPoint;
    }

    @Override
    public void setLoopEndPoint(long tick) {
        this.loopEndPoint = tick;
        this.notifySongPositionListeners(this.player.getTickPosition());
    }

    @Override
    public long getLoopEndPoint() {
        return this.loopEndPoint;
    }

    @Override
    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return null;
    }

    @Override
    public void open() throws MidiUnavailableException {
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public int getMaxReceivers() {
        return 0;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.transmitter;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.transmitters;
    }

    public void addMidiOutDevice(final MidiDevice midiDevice) throws MidiUnavailableException {
        Transmitter transmitter = new Transmitter(){
            Receiver receiver;
            {
                this.receiver = midiDevice.getReceiver();
            }

            public void setReceiver(Receiver receiver) {
                this.receiver = receiver;
            }

            public Receiver getReceiver() {
                return this.receiver;
            }

            public void close() {
            }
        };
        this.midiOutDeviceTransmitters.put(midiDevice, transmitter);
        this.midiOutDevices.add(midiDevice);
        this.transmitters.add(transmitter);
    }

    public void removeMidiOutDevice(MidiDevice midiDevice) {
        this.transmitters.remove(this.midiOutDeviceTransmitters.get(midiDevice));
        this.midiOutDeviceTransmitters.remove(midiDevice);
        this.midiOutDevices.remove(midiDevice);
    }

    public List<MidiDevice> listMidiOutDevices() {
        return this.midiOutDevices;
    }

    public void addSequencerListener(SequencerListener sequencerListener) {
        this.sequencerListeners.add(sequencerListener);
    }

    public void removeSequencerListener(SequencerListener sequencerListener) {
        this.sequencerListeners.remove(sequencerListener);
    }

    public void addSongPositionListener(SongPositionListener songPositionListener) {
        if (songPositionListener.requiresNotificationOnEachTick()) {
            this.intenseSongPositionListeners.add(songPositionListener);
        } else {
            this.songPositionListeners.add(songPositionListener);
        }
    }

    public void removeSongPositionListener(SongPositionListener songPositionListener) {
        if (songPositionListener.requiresNotificationOnEachTick()) {
            this.intenseSongPositionListeners.remove(songPositionListener);
        } else {
            this.songPositionListeners.remove(songPositionListener);
        }
    }

    public final void notifySongPositionListeners() {
        this.notifySongPositionListeners(this.getTickPosition());
    }

    public void addTempoChangeListener(TempoChangeListener listener) {
        this.tempoChangeListeners.add(listener);
    }

    public void removeTempoChangeListener(TempoChangeListener listener) {
        this.tempoChangeListeners.remove(listener);
    }

    final void notifyTempoChangeListeners() {
        for (TempoChangeListener listener : this.tempoChangeListeners) {
            listener.notifyTempoChange(this.bpm);
        }
    }

    final void notifyIntenseSongPositionListeners(long tick) {
        for (SongPositionListener listener : this.intenseSongPositionListeners) {
            listener.notifyTickPosition(tick);
        }
    }

    final void notifyAllSongPositionListeners(long tick) {
        this.notifyIntenseSongPositionListeners(tick);
        this.notifySongPositionListeners(tick);
    }

    final void notifySongPositionListeners(long tick) {
        for (SongPositionListener listener : this.songPositionListeners) {
            listener.notifyTickPosition(tick);
        }
    }

    public Collection<FrinikaTrackWrapper> getSoloFrinikaTrackWrappers() {
        return this.soloFrinikaTrackWrappers;
    }

    public void setSolo(MidiLane lane, boolean solo) {
        if (solo) {
            this.soloFrinikaTrackWrappers.add(lane.getTrack());
        } else {
            this.soloFrinikaTrackWrappers.remove(lane.getTrack());
        }
    }

    public void setRecordingTakeDialog(RecordingDialog dialog) {
        this.recordingTakeDialog = dialog;
    }

    public void panic() {
        this.player.notesOff(true);
        byte[] data = new byte[]{-16, 67, 16, 76, 0, 0, 127, 0, -9};
        SysexMessage mess = new SysexMessage();
        try {
            mess.setMessage(data, data.length);
        }
        catch (InvalidMidiDataException e1) {
            e1.printStackTrace();
        }
        for (MidiDevice midiDev : this.listMidiOutDevices()) {
            if (midiDev instanceof SynthRack) continue;
            try {
                midiDev.getReceiver().send(mess, -1L);
            }
            catch (MidiUnavailableException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean isSolo(RecordableLane lane) {
        return this.soloFrinikaTrackWrappers.contains(((MidiLane)lane).getTrack());
    }

    public MidiPlayOptions getPlayOptions(FrinikaTrackWrapper track) {
        MidiPlayOptions opt = this.frinikaTrackWrappersMidiPlayOptions.get(track);
        if (opt == null) {
            return new MidiPlayOptions();
        }
        return opt;
    }

    public void setPlayOptions(FrinikaTrackWrapper track, MidiPlayOptions opt) {
        this.frinikaTrackWrappersMidiPlayOptions.put(track, opt);
    }

    public void addMidiMessageListener(MidiMessageListener l) {
        this.midiMessageListeners.add(l);
    }

    public void removeMidiMessageListener(MidiMessageListener l) {
        this.midiMessageListeners.remove(l);
    }

    public void sendMidiMessage(MidiMessage msg, FrinikaTrackWrapper trackWrapper) throws InvalidMidiDataException, MidiUnavailableException {
        this.player.sendMidiMessage(msg, trackWrapper);
    }

    public void setRealtime(boolean realtime) {
        this.player.setRealtime(realtime);
    }

    public boolean getRealtime() {
        return this.player.getRealtime();
    }

    public void nonRealtimeNextTick() {
        if (!this.player.getRealtime()) {
            this.player.timerEvent();
        }
    }

    public void setTempoList(TempoList tl) {
        this.player.setTempoList(tl);
    }

    public void setPlayerPriority(int prio) {
        this.player.priorityRequested = prio;
    }
}

