/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SequencerListener;
import com.frinika.synth.envelope.MidiVolume;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioServer;

public class SampleBasedMetronome
implements AudioProcess,
SequencerListener {
    float[] sampleData;
    float level = 0.0f;
    boolean active = false;
    ProjectContainer project;
    int metSamplePos = 0;
    long framePtr = 0L;
    private int doClick = 0;

    public SampleBasedMetronome(ProjectContainer project) throws Exception {
        this.project = project;
        FrinikaSequencer sequencer = project.getSequencer();
        AudioServer audioServer = project.getAudioServer();
        sequencer.addSequencerListener(this);
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(ClassLoader.getSystemResource("sounds/metronome1.wav"));
            this.sampleData = new float[(int)stream.getFrameLength()];
            int index = 0;
            byte[] frame = new byte[2];
            int b = stream.read(frame);
            while (b != -1) {
                this.sampleData[index++] = (float)(frame[1] * 256 + (frame[0] & 0xFF)) / 32768.0f;
                b = stream.read(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.project.getSequencer().removeSequencerListener(this);
    }

    public void setVelocity(int velocity) {
        if (velocity > 0) {
            this.active = true;
            this.level = MidiVolume.midiVolumeToAmplitudeRatio(velocity);
            this.doClick = 4;
        } else {
            this.active = false;
        }
    }

    long nextClick() {
        double bpSec = (double)this.project.getSequencer().getTempoInBPM() / 60.0;
        double fs = this.project.getAudioServer().getSampleRate();
        double samplesPerClick = fs / bpSec;
        long nClick = (this.framePtr + (long)samplesPerClick - 1L) / (long)samplesPerClick;
        return (long)((double)nClick * samplesPerClick);
    }

    public int processAudio(AudioBuffer buffer) {
        if (!this.active) {
            return 0;
        }
        if (this.doClick <= 0 && !this.project.getSequencer().isRunning()) {
            return 0;
        }
        int size = buffer.getSampleCount();
        int start = 0;
        long nextClick = this.nextClick();
        if (this.metSamplePos >= this.sampleData.length) {
            --this.doClick;
            if (this.framePtr + (long)size < nextClick) {
                this.framePtr += (long)size;
                return 0;
            }
            start = (int)(nextClick - this.framePtr);
            this.metSamplePos = 0;
        }
        float[] left = buffer.getChannel(0);
        float[] right = buffer.getChannel(1);
        this.framePtr += (long)start;
        int n = start;
        while (n < size && this.metSamplePos < this.sampleData.length) {
            if (this.framePtr == nextClick) {
                this.metSamplePos = 0;
            }
            int n2 = n;
            left[n2] = left[n2] + this.sampleData[this.metSamplePos] * this.level;
            int n3 = n++;
            right[n3] = right[n3] + this.sampleData[this.metSamplePos++] * this.level;
            ++this.framePtr;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    long getFramePos() {
        FrinikaSequencer sequencer = this.project.getSequencer();
        AudioServer audioServer = this.project.getAudioServer();
        return (long)((float)sequencer.getMicrosecondPosition() * audioServer.getSampleRate() / 1000000.0f);
    }

    public void beforeStart() {
        this.framePtr = this.getFramePos();
    }

    public void start() {
    }

    public void stop() {
    }
}

