/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.gui.EditTool;
import com.frinika.sequencer.gui.ExtendingRangeModel;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.Snapable;
import com.frinika.sequencer.gui.StrechyRectangle;
import com.frinika.sequencer.gui.ToolAdapter;
import com.frinika.sequencer.model.tempo.TempoList;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ConcurrentModificationException;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class ItemPanel
extends JPanel
implements SongPositionListener,
ComponentListener,
Snapable {
    public static final int OVER_NOTHING = 0;
    public static final int OVER_ITEM_MIDDLE = 1;
    public static final int OVER_ITEM_RIGHT = 2;
    public static final int OVER_ITEM_LEFT = 3;
    protected static final int OVER_ITEM_TOP = 4;
    public static final int OVER_ENVELOPE_LEFT = 5;
    public static final int OVER_ENVELOPE_RIGHT = 6;
    public static final int OVER_ENVELOPE_GAIN = 7;
    static Cursor[] cursors = new Cursor[8];
    private static final long serialVersionUID = 1L;
    private boolean rightButtonPressed;
    private Graphics itemGraphics;
    private Graphics timeGraphics;
    boolean ignoreRepaint = false;
    private Image itemImage;
    Rectangle itemViewRect = new Rectangle();
    protected Rectangle lastItemViewRect = new Rectangle();
    StrechyRectangle selectRect = null;
    protected int ticksPerBeat;
    public double userToScreen = 0.5;
    protected boolean timeBased = false;
    private Image timeImage;
    protected JToolBar toolBar;
    protected int xAnchor = 0;
    int xCursor = -1;
    private double xFractLeftStaticWindow = 0.1;
    private double xFractRightStaticWindow = 0.9;
    protected int yAnchor = 0;
    StrechyRectangle zoomRect = null;
    protected ItemScrollPane scroller;
    private boolean followSong = true;
    protected FrinikaSequencer sequencer;
    protected boolean dragArmed;
    private boolean dirty;
    protected int dragMode;
    protected ProjectContainer project;
    boolean hasTimeLine;
    private int timePanelHeight;
    private boolean canScrollY;
    protected ToolAdapter selectTool;
    protected ToolAdapter eraseTool;
    protected ToolAdapter writeTool;
    protected ToolAdapter dragViewTool;
    protected ToolAdapter rectZoomTool;
    protected ToolAdapter tool;
    private ToolAdapter prevTool;
    private ToolAdapter origTool;
    Polygon leftMarker;
    int[] xLMarker = new int[]{0, (int)((double)Layout.timePanelHeight * 0.6), 0};
    int[] yMarker = new int[]{0, 0, (int)((double)Layout.timePanelHeight * 0.6)};
    Polygon rightMarker;
    int[] xRMarker = new int[]{0, -this.xLMarker[1], 0};
    long startLoopTime;
    long endLoopTime;
    protected Item dragItem = null;
    protected boolean controlIsDown = true;
    protected boolean altIsDown = true;
    ExtendingRangeModel xRangeModel = new ExtendingRangeModel();
    DefaultBoundedRangeModel yRangeModel = new DefaultBoundedRangeModel();
    private double endTimeOrTick = -1.0;
    TimeUtils timeUtil;
    protected boolean isChanging = false;
    protected ProjectFrame frame;
    private int previousCursor;
    static Rectangle dirtyRect;

    protected ItemPanel(ProjectFrame project, ItemScrollPane scroller, boolean hasTimeLine, boolean canScrollY, double ticksToScreen, boolean sampleBased) {
        super(false);
        this.userToScreen = ticksToScreen;
        this.timeBased = sampleBased;
        this.timeUtil = new TimeUtils(project.getProjectContainer());
        this.canScrollY = canScrollY;
        this.hasTimeLine = hasTimeLine;
        if (hasTimeLine) {
            this.timePanelHeight = Layout.timePanelHeight;
        }
        this.project = project.getProjectContainer();
        this.frame = project;
        this.scroller = scroller;
        this.selectRect = new StrechyRectangle(this);
        this.zoomRect = new StrechyRectangle(this);
        this.addComponentListener(this);
        if (hasTimeLine) {
            this.leftMarker = new Polygon(this.xLMarker, this.yMarker, 3);
            this.rightMarker = new Polygon(this.xRMarker, this.yMarker, 3);
        }
        this.startLoopTime = project.getProjectContainer().getSequencer().getLoopStartPoint();
        this.endLoopTime = project.getProjectContainer().getSequencer().getLoopEndPoint();
        this.validateEndTick();
        this.setToolTipText("");
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isTimeLineEvent(event)) {
            return CurrentLocale.getMessage("sequencer.itempanel.timeline.loopmarkers.tooltip");
        }
        return null;
    }

    public ItemScrollPane getScroller() {
        return this.scroller;
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public synchronized void componentResized(ComponentEvent arg0) {
        Dimension newSize = this.getSize();
        newSize.height = Math.max(0, newSize.height - this.timePanelHeight);
        newSize.width = Math.max(0, newSize.width);
        if (newSize.height == 0 || newSize.width == 0) {
            this.itemImage = null;
            this.itemGraphics = null;
        } else {
            this.itemImage = this.createImage(newSize.width, newSize.height);
            this.itemGraphics = this.itemImage.getGraphics();
        }
        if (newSize.width != 0 && this.hasTimeLine) {
            this.timeImage = this.createImage(newSize.width, this.timePanelHeight);
            this.timeGraphics = this.timeImage.getGraphics();
        }
        this.itemViewRect.setSize(newSize);
        this.paintImages();
        this.repaint();
    }

    public void componentShown(ComponentEvent arg0) {
    }

    protected abstract void writePressedAt(Point var1);

    protected abstract void writeReleasedAt(Point var1);

    public abstract void dragTo(Point var1);

    public abstract void endDrag();

    public Rectangle getVirtualScreenRect() {
        return this.itemViewRect;
    }

    public abstract Item itemAt(Point var1);

    public int mapX(int x) {
        return x + this.itemViewRect.x;
    }

    public void map(Point point) {
        point.x += this.itemViewRect.x;
        point.y += this.itemViewRect.y;
        if (this.hasTimeLine) {
            point.y -= Layout.timePanelHeight;
        }
    }

    Rectangle mapRect(Rectangle screenRect) {
        Rectangle rect = new Rectangle(screenRect);
        rect.x += this.itemViewRect.x;
        rect.y += this.itemViewRect.y;
        if (this.hasTimeLine) {
            rect.y -= Layout.timePanelHeight;
        }
        return rect;
    }

    public synchronized void notifyTickPosition(long tick) {
        block15: {
            double userTime = this.timeBased ? this.project.getTempoList().getTimeAtTick(tick) : (double)tick;
            int pixPerRedraw = 1;
            if (this.sequencer.isRunning()) {
                if (!this.isShowing()) {
                    return;
                }
                pixPerRedraw = this.project.getPixelsPerRedraw();
                if (pixPerRedraw <= 0) {
                    return;
                }
            } else {
                this.validateEndTick();
            }
            double scrX = this.userToScreen(userTime);
            int x = (int)(scrX / (double)pixPerRedraw) * pixPerRedraw;
            long st = this.project.getSequencer().getLoopStartPoint();
            long et = this.project.getSequencer().getLoopEndPoint();
            if (x == this.xCursor) {
                if (!this.hasTimeLine) {
                    return;
                }
                if (st == this.startLoopTime && et == this.endLoopTime) {
                    return;
                }
            }
            this.previousCursor = this.xCursor;
            this.xCursor = x;
            if (st == this.startLoopTime && et == this.endLoopTime) {
                if (this.followSong) {
                    try {
                        int x2;
                        if (this.scrollToContain(x)) break block15;
                        Rectangle tR = this.getBounds();
                        ItemPanel.dirtyRect.y = tR.y;
                        ItemPanel.dirtyRect.height = tR.height;
                        int x1 = this.previousCursor - this.itemViewRect.x;
                        if (x1 >= 0 && x1 < tR.x + tR.width) {
                            ItemPanel.dirtyRect.x = x1;
                            ItemPanel.dirtyRect.width = 1;
                            this.repaint(dirtyRect);
                        }
                        if ((x2 = x - this.itemViewRect.x) >= 0 && x2 < tR.x + tR.width) {
                            ItemPanel.dirtyRect.x = x2;
                            ItemPanel.dirtyRect.width = 1;
                            this.repaint(dirtyRect);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.repaint();
                }
            } else {
                this.endLoopTime = et;
                this.startLoopTime = st;
                this.repaintItems();
            }
        }
    }

    public synchronized boolean scrollToContain(int x) {
        double posFract = (double)(x - this.itemViewRect.x) / (double)this.itemViewRect.width;
        boolean jumped = false;
        int xLeft = 0;
        if (posFract < 0.0 || posFract > this.xFractRightStaticWindow) {
            xLeft = (int)((double)x - (double)this.itemViewRect.width * this.xFractLeftStaticWindow);
            if (xLeft < 0) {
                xLeft = 0;
            }
            jumped = true;
        }
        if (jumped) {
            this.scroller.setX(xLeft);
            this.paintImages();
            this.repaint();
        }
        return jumped;
    }

    private synchronized void drawCursor(Graphics g, int xt) {
        int x = xt - this.itemViewRect.x;
        int y1 = 0;
        int h = this.getHeight() - 1;
        int y2 = y1 + h;
        g.setColor(Color.PINK);
        g.drawLine(x, y1, x, y2);
    }

    public synchronized void copyImageToScreen(Graphics g) {
        if (this.ignoreRepaint) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.itemImage != null) {
            g.drawImage(this.itemImage, 0, this.timePanelHeight, null);
        }
        if (this.hasTimeLine && this.timeImage != null) {
            g.drawImage(this.timeImage, 0, 0, null);
        }
        if (this.zoomRect.isActive()) {
            g.setColor(Color.GREEN);
            g2.draw(this.zoomRect);
        }
        if (this.selectRect.isActive()) {
            g.setColor(Color.BLUE);
            g2.draw(this.selectRect);
        }
    }

    protected abstract void paintImageImpl(Rectangle var1, Graphics2D var2);

    protected synchronized void paintImages() {
        if (this.ignoreRepaint) {
            return;
        }
        if (this.itemViewRect.isEmpty()) {
            return;
        }
        this.paintItemImage_(this.itemViewRect);
        if (this.hasTimeLine) {
            this.paintTimeImage_(this.itemViewRect.x, this.itemViewRect.width);
        }
    }

    private synchronized void paintItemImage_(Rectangle visibleRect) {
        this.itemGraphics.translate(-this.itemViewRect.x, -this.itemViewRect.y);
        this.paintImageImpl(visibleRect, (Graphics2D)this.itemGraphics);
        this.itemGraphics.translate(this.itemViewRect.x, this.itemViewRect.y);
        this.paintImageImplLabel((Graphics2D)this.itemGraphics);
    }

    protected abstract void paintImageImplLabel(Graphics2D var1);

    private void paintTimeImage_(int x, int width) {
        assert (this.hasTimeLine);
        this.timeGraphics.translate(-this.itemViewRect.x, 0);
        this.paintTimeImpl(x, width, (Graphics2D)this.timeGraphics);
        this.timeGraphics.translate(this.itemViewRect.x, 0);
    }

    public void paintTimeImpl(int xClip, int widthClip, Graphics g1) {
        if (this.timeBased) {
            this.paintTimeImplUser(xClip, widthClip, g1);
        } else {
            this.paintTimeImplTick(xClip, widthClip, g1);
        }
    }

    private void paintTimeImplTick(int xClip, int widthClip, Graphics g1) {
        assert (this.hasTimeLine);
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.BLACK);
        Rectangle b = new Rectangle();
        b.x = this.itemViewRect.x;
        b.y = 0;
        b.height = this.timePanelHeight;
        b.width = this.itemViewRect.width;
        g.fill(b);
        int w = b.width + 400;
        int x = Math.max(0, b.x - 200);
        int y = b.y;
        int h = b.height;
        int charHeight = this.timePanelHeight - 5;
        int y1 = Math.max(y, charHeight);
        double step = this.getSnapQuantization() / (double)this.ticksPerBeat;
        TimeSignatureList ts = this.project.getTimeSignatureList();
        assert (x >= 0);
        double beat1 = this.screenToTickAbs(x, true) / (long)this.ticksPerBeat;
        double beat2 = this.screenToTickAbs(x + w, true) / (long)this.ticksPerBeat;
        TimeSignatureList.QStepIterator iter = this.project.getTimeSignatureList().createQStepIterator(beat1, beat2, step);
        g.setColor(Color.WHITE);
        boolean drawlines = y1 < y + h;
        boolean drawNumber = y < charHeight;
        boolean drawSub = drawlines && this.userToScreen((long)(step * (double)this.ticksPerBeat)) > 5.0;
        boolean drawBeat = drawlines && this.userToScreen(this.ticksPerBeat) > 5.0;
        int minSpace = 50;
        int xlast = -2 * minSpace;
        while (iter.hasNext()) {
            iter.next();
            double beat = iter.getBeat();
            boolean isBar = iter.isBar();
            int x1 = (int)this.userToScreen((long)(beat * (double)this.ticksPerBeat));
            if (!isBar || x1 - xlast <= minSpace) continue;
            g.setColor(Color.WHITE);
            g.drawString(String.valueOf(iter.getBar()), x1, charHeight - 2);
            xlast = x1;
            g.drawLine(x1, y1, x1, y1 + 3);
        }
        long xStart = (int)this.userToScreen(this.startLoopTime);
        long xEnd = (int)this.userToScreen(this.endLoopTime);
        if (xStart > (long)x && xStart < (long)(x + w)) {
            g.setColor(Color.YELLOW);
            g.translate(xStart, 0.0);
            g.fill(this.leftMarker);
            g.translate(-xStart, 0.0);
        }
        if (xEnd > (long)x && xEnd < (long)(x + w)) {
            g.setColor(Color.YELLOW);
            g.translate(xEnd, 0.0);
            g.fill(this.rightMarker);
            g.translate(-xEnd, 0.0);
        }
    }

    public void paintTimeImplUser(int xClip, int widthClip, Graphics g1) {
        assert (this.hasTimeLine);
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.BLACK);
        Rectangle b = new Rectangle();
        b.x = this.itemViewRect.x;
        b.y = 0;
        b.height = this.timePanelHeight;
        b.width = this.itemViewRect.width;
        g.fill(b);
        int w = b.width + 400;
        int x = Math.max(0, b.x - 200);
        int y = b.y;
        int h = b.height;
        int charHeight = this.timePanelHeight - 5;
        int y1 = Math.max(y, charHeight);
        double step = this.getSnapQuantization() / (double)this.ticksPerBeat;
        TimeSignatureList ts = this.project.getTimeSignatureList();
        TempoList tl = this.project.getTempoList();
        assert (x >= 0);
        double beat1 = this.screenToTickAbs(x, true) / (long)this.ticksPerBeat;
        double beat2 = this.screenToTickAbs(x + w, true) / (long)this.ticksPerBeat;
        TimeSignatureList.QStepIterator iter = this.project.getTimeSignatureList().createQStepIterator(beat1, beat2, step);
        g.setColor(Color.WHITE);
        boolean drawlines = y1 < y + h;
        boolean drawNumber = y < charHeight;
        boolean drawSub = true;
        boolean drawBeat = true;
        int minSpace = 50;
        int xlast = -2 * minSpace;
        while (iter.hasNext()) {
            iter.next();
            double beat = iter.getBeat();
            boolean isBar = iter.isBar();
            int x1 = (int)this.userToScreen(tl.getTimeAtTick(beat * (double)this.ticksPerBeat));
            if (!isBar || x1 - xlast <= minSpace) continue;
            g.setColor(Color.WHITE);
            g.drawString(String.valueOf(iter.getBar()), x1, charHeight - 2);
            xlast = x1;
            g.drawLine(x1, y1, x1, y1 + 3);
        }
        long xStart = (int)this.userToScreen(tl.getTimeAtTick(this.startLoopTime));
        long xEnd = (int)this.userToScreen(tl.getTimeAtTick(this.endLoopTime));
        if (xStart > (long)x && xStart < (long)(x + w)) {
            g.setColor(Color.YELLOW);
            g.translate(xStart, 0.0);
            g.fill(this.leftMarker);
            g.translate(-xStart, 0.0);
        }
        if (xEnd > (long)x && xEnd < (long)(x + w)) {
            g.setColor(Color.YELLOW);
            g.translate(xEnd, 0.0);
            g.fill(this.rightMarker);
            g.translate(-xEnd, 0.0);
        }
    }

    public synchronized void scaleX(double fact) {
        Rectangle vr = this.itemViewRect;
        this.userToScreen *= fact;
        vr.x = (int)((double)vr.x * fact);
        this.xCursor = (int)((double)this.sequencer.getTickPosition() * this.userToScreen);
        this.rebuildXScrollBars();
        this.repaintItems();
    }

    public long screenToTickAbs(int x, boolean quantizeMe) {
        double tt = (double)x / this.userToScreen;
        if (this.timeBased) {
            tt = this.project.getTempoList().getTickAtTime(tt);
        }
        if (quantizeMe) {
            double quant = this.getSnapQuantization();
            if (quant > 0.0) {
                tt = (double)((long)(tt / this.getSnapQuantization())) * this.getSnapQuantization();
            } else {
                double beat = tt / (double)this.project.getTicksPerBeat();
                TimeSignatureList.TimeSignatureEvent ev = this.project.getTimeSignatureList().getEventAtBeat((int)beat);
                int nBar = (int)((beat - (double)ev.beat + (double)ev.beatsPerBar / 2.0) / (double)ev.beatsPerBar);
                tt = (ev.beat + nBar * ev.beatsPerBar) * this.project.getTicksPerBeat();
            }
        }
        return (long)tt;
    }

    public long screenToTickRel(int x, int dx, boolean quantizeMe) {
        assert (!this.timeBased);
        double tt = (double)dx / this.userToScreen;
        if (quantizeMe) {
            double quant = this.getSnapQuantization();
            if (quant > 0.0) {
                tt = (double)Math.round(tt / this.getSnapQuantization()) * this.getSnapQuantization();
            } else {
                double beat = (double)x / this.userToScreen / (double)this.project.getTicksPerBeat();
                TimeSignatureList.TimeSignatureEvent ev = this.project.getTimeSignatureList().getEventAtBeat((int)beat);
                quant = ev.beatsPerBar * this.project.getTicksPerBeat();
                tt = (double)Math.round(tt / quant) * quant;
            }
        }
        return (long)tt;
    }

    public abstract double getSnapQuantization();

    public abstract boolean isSnapQuantized();

    protected synchronized void scrollItemImageX() {
        int dx = this.itemViewRect.x - this.lastItemViewRect.x;
        if (Math.abs(dx) > this.lastItemViewRect.width) {
            this.dirty = true;
            this.repaintItems();
            return;
        }
        Rectangle exposedRect = new Rectangle(this.itemViewRect);
        if (dx > 0) {
            this.itemGraphics.copyArea(dx, 0, this.itemViewRect.width - dx - 1, this.itemViewRect.height, -dx, 0);
        } else {
            this.itemGraphics.copyArea(0, 0, this.itemViewRect.width + dx - 1, this.itemViewRect.height, -dx, 0);
        }
        if (dx > 0) {
            int xOld = exposedRect.x;
            exposedRect.x = this.lastItemViewRect.x + this.lastItemViewRect.width - 1;
            exposedRect.width -= exposedRect.x - xOld;
        } else {
            exposedRect.width = -dx;
        }
        this.paintItemImage_(exposedRect);
        if (this.hasTimeLine) {
            this.paintTimeImage_(exposedRect.x, exposedRect.width);
        }
    }

    protected synchronized void scrollItemImageY() {
        int dy = this.itemViewRect.y - this.lastItemViewRect.y;
        if (Math.abs(dy) > this.lastItemViewRect.height) {
            this.paintItemImage_(this.itemViewRect);
            return;
        }
        Rectangle exposedRect = new Rectangle(this.itemViewRect);
        if (dy > 0) {
            this.itemGraphics.copyArea(0, dy, this.itemViewRect.width, this.itemViewRect.height - dy - 1, 0, -dy);
        } else {
            this.itemGraphics.copyArea(0, 0, this.itemViewRect.width, this.itemViewRect.height + dy - 1, 0, -dy);
        }
        if (dy > 0) {
            int yOld = exposedRect.y;
            exposedRect.y = this.lastItemViewRect.y + this.lastItemViewRect.height - 1;
            exposedRect.height -= exposedRect.y - yOld;
        } else {
            exposedRect.height = -dy;
        }
        this.paintItemImage_(exposedRect);
    }

    public void scrollRectToVisible(Rectangle r) {
        System.err.println("scrollToVisibleRect not allow for ItemPanel");
    }

    public Point scrollToContian(Point p) {
        int dx = p.x - (this.itemViewRect.x + this.itemViewRect.width);
        if (dx > 0) {
            if (this.xRangeModel.getMaximum() < p.x) {
                this.xRangeModel.setMaximum(p.x);
            }
            this.xRangeModel.setValue(this.itemViewRect.x + dx - 1);
        } else if (p.x > 0) {
            dx = p.x - this.itemViewRect.x;
            if (dx < 0) {
                this.xRangeModel.setValue(this.itemViewRect.x + dx + 1);
            } else {
                dx = 0;
            }
        } else {
            dx = 0;
        }
        int dy = p.y - (this.itemViewRect.y + this.itemViewRect.height);
        if (dy > 0) {
            if (p.y < this.yRangeModel.getMaximum()) {
                this.yRangeModel.setValue(this.itemViewRect.y + dy - 1);
            } else {
                dy = 0;
            }
        } else if (p.y > 0) {
            dy = p.y - this.itemViewRect.y;
            if (dy < 0) {
                this.yRangeModel.setValue(this.itemViewRect.y + dy + 1);
            } else {
                dy = 0;
            }
        } else {
            dy = 0;
        }
        long endTimeOrTick2 = (long)((double)(this.itemViewRect.x + this.itemViewRect.width) / this.userToScreen);
        if ((double)endTimeOrTick2 > this.endTimeOrTick) {
            this.endTimeOrTick = endTimeOrTick2;
        }
        return new Point(dx, dy);
    }

    public abstract void clientClearSelection();

    public abstract void selectInRect(Rectangle var1, boolean var2);

    public void setIgnoreRepaints(boolean yes) {
        this.ignoreRepaint = yes;
    }

    public synchronized void setX(int xNew) {
        if (this.isChanging) {
            return;
        }
        if (xNew == this.itemViewRect.x) {
            return;
        }
        this.itemViewRect.x = xNew;
        this.paintImages();
        this.repaint();
    }

    public synchronized void setY(int yNew) {
        if (this.isChanging) {
            return;
        }
        if (!this.canScrollY) {
            return;
        }
        if (yNew == this.itemViewRect.y) {
            return;
        }
        this.itemViewRect.y = yNew;
        this.paintImages();
        this.repaint();
    }

    public double userToScreen(double userTIme) {
        return userTIme * this.userToScreen;
    }

    public void zoomIn() {
        this.scaleX(1.25);
    }

    public void zoomOut() {
        this.scaleX(0.8);
    }

    public void zoomToRect(Rectangle rect) {
        if (rect.width <= 0) {
            return;
        }
        Rectangle vr = this.itemViewRect;
        double scale = (double)vr.width / (double)rect.width;
        double tt = this.userToScreen * scale;
        if (tt > 5.0) {
            tt = 5.0;
        }
        this.userToScreen = tt;
        vr.x = (int)((double)rect.x * scale);
        this.rebuildXScrollBars();
        this.dirty = true;
        this.repaintItems();
    }

    protected void rebuildXScrollBars() {
        double endTime2 = this.project.getEndTick();
        if (this.timeBased) {
            endTime2 = this.project.getTempoList().getTimeAtTick(endTime2);
        }
        endTime2 *= this.userToScreen;
        if ((double)(this.scroller.horizScroll.getMaximum() - this.scroller.horizScroll.getVisibleAmount()) < endTime2) {
            this.scroller.horizScroll.setMaximum((int)endTime2 + this.itemViewRect.width);
        }
        this.scroller.horizScroll.setVisibleAmount(this.itemViewRect.width);
        this.scroller.horizScroll.setValue(this.itemViewRect.x);
    }

    public void setRightButton(boolean buttonState) {
        this.rightButtonPressed = buttonState;
    }

    public boolean isRightButtonPressed() {
        return this.rightButtonPressed;
    }

    public void followSong(boolean b) {
        this.followSong = b;
        if (b) {
            this.scrollToContain(this.xCursor);
        }
    }

    public boolean isFollowSong() {
        return this.followSong;
    }

    public abstract void setTimeAtX(int var1);

    public boolean requiresNotificationOnEachTick() {
        return false;
    }

    public boolean pointInTimeLine(int y) {
        if (!this.hasTimeLine) {
            return false;
        }
        return y <= this.timePanelHeight;
    }

    public void setToolBar(ItemRollToolBar bar) {
        this.toolBar = bar;
    }

    public void armDrag(Point p, Item item) {
        this.dragArmed = true;
        this.dragItem = item;
        this.xAnchor = p.x;
        this.yAnchor = p.y;
    }

    public abstract void rightButtonPressedOnItem(int var1, int var2);

    public abstract void clientAddToSelection(Item var1);

    public abstract void clientRemoveFromSelection(Item var1);

    public abstract void erase(Item var1);

    public void repaintItems() {
        this.dirty = true;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (this.dirty) {
            this.paintImages();
            this.dirty = false;
        }
        this.copyImageToScreen(g);
        this.drawCursor(g, this.xCursor);
    }

    public void rectZoomFinished() {
        ((ItemRollToolBar)this.toolBar).rectZoomFinished();
    }

    public abstract int getHoverStateAt(Point var1);

    public void setDragMode(int mode) {
        this.dragMode = mode;
        this.setCursor(cursors[mode]);
    }

    public ProjectContainer getProjectContainer() {
        return this.project;
    }

    public ProjectFrame getProjectFrame() {
        return this.frame;
    }

    public void setTool(String name) {
        this.tool = this.getTool(name);
        if (this.tool == this.prevTool) {
            return;
        }
        this.removeMouseListener(this.prevTool);
        this.removeMouseMotionListener(this.prevTool);
        if (this.tool == null) {
            return;
        }
        this.addMouseListener(this.tool);
        this.addMouseMotionListener(this.tool);
        this.setCursor(this.tool.getCursor());
        if (this.prevTool instanceof EditTool) {
            this.origTool = this.prevTool;
        }
        this.prevTool = this.tool;
    }

    public ToolAdapter getTool(String name) {
        if (name.equals("origtool")) {
            return this.origTool;
        }
        if (name.equals("select")) {
            return this.selectTool;
        }
        if (name.equals("erase")) {
            return this.eraseTool;
        }
        if (name.equals("write")) {
            return this.writeTool;
        }
        if (name.equals("magrect")) {
            return this.rectZoomTool;
        }
        if (name.equals("dragview")) {
            return this.dragViewTool;
        }
        if (name.equals("dragview")) {
            return this.dragViewTool;
        }
        try {
            throw new Exception(" Unknown tool " + name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeDraggedAt(Point p) {
    }

    public abstract void setSnapQuantization(double var1);

    public void feedBack(Item item) {
    }

    boolean isTimeLineEvent(MouseEvent e) {
        if (this.pointInTimeLine(e.getY())) {
            int x = this.mapX(e.getX());
            if (e.getButton() == 1) {
                if (e.isAltDown() || e.isShiftDown() && e.isControlDown()) {
                    this.setRightMarkAt(x);
                } else if (e.isControlDown()) {
                    this.setLeftMarkAt(x);
                } else {
                    this.setTimeAtX(x);
                }
            }
            return true;
        }
        return false;
    }

    private void setRightMarkAt(int x) {
        long tick = this.screenToTickAbs(x, this.isSnapQuantized());
        this.sequencer.setLoopEndPoint(tick);
    }

    private void setLeftMarkAt(int x) {
        long tick = this.screenToTickAbs(x, this.isSnapQuantized());
        this.sequencer.setLoopStartPoint(tick);
    }

    public abstract void setSnapQuantized(boolean var1);

    public void setControlState(boolean b) {
        this.controlIsDown = b;
    }

    public void setDirty() {
        this.dirty = true;
    }

    void validateEndTick() {
        double endTimeOrTick2 = this.project.getEndTick();
        if (this.timeBased) {
            endTimeOrTick2 = this.project.getTempoList().getTimeAtTick(endTimeOrTick2);
        }
        this.xRangeModel.setExtent(this.itemViewRect.width);
        this.xRangeModel.setMaximum((int)(endTimeOrTick2 * this.userToScreen));
        this.endTimeOrTick = endTimeOrTick2;
    }

    public abstract void setFocus(Item var1);

    public void ignorePartWarp(boolean b) {
    }

    public abstract void clientNotifySelectionChange();

    public ExtendingRangeModel getXRangeModel() {
        return this.xRangeModel;
    }

    public DefaultBoundedRangeModel getYRangeModel() {
        return this.yRangeModel;
    }

    public void setAltState(boolean b) {
        this.altIsDown = b;
    }

    static {
        ItemPanel.cursors[0] = new Cursor(0);
        ItemPanel.cursors[1] = new Cursor(13);
        ItemPanel.cursors[2] = new Cursor(11);
        ItemPanel.cursors[3] = new Cursor(10);
        ItemPanel.cursors[4] = new Cursor(8);
        ItemPanel.cursors[5] = new Cursor(6);
        ItemPanel.cursors[6] = new Cursor(7);
        ItemPanel.cursors[7] = new Cursor(8);
        dirtyRect = new Rectangle();
    }
}

