/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.clipboard;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOfMyClipboard {
    CType cType;
    private static final Class EVENT = null;
    Vector<Selectable> copy;
    ProjectContainer project;
    long leftTickOfCopy;
    long rightTickOfCopy;
    private int leftColumnOfCopy;

    public CopyOfMyClipboard(ProjectContainer project) {
        this.project = project;
    }

    public void copy(Collection<Selectable> list, long selectionStartTick, int selectionLeftColumn) {
        this.copy(list);
        this.leftTickOfCopy = selectionStartTick;
        this.leftColumnOfCopy = selectionLeftColumn;
        System.out.println("Left tracker column of copy: " + this.leftColumnOfCopy);
    }

    public void copy(Collection<? extends Selectable> collection) {
        this.copy = this.deepCopy(collection, null);
        this.leftTickOfCopy = Long.MAX_VALUE;
        this.rightTickOfCopy = Long.MIN_VALUE;
        this.leftColumnOfCopy = 0;
        if (this.copy.elementAt(0) instanceof Part) {
            this.cType = CType.PART;
        }
        if (this.copy.elementAt(0) instanceof MultiEvent) {
            this.cType = CType.EVENT;
        }
        for (Selectable it : this.copy) {
            if (it == null) continue;
            this.leftTickOfCopy = Math.min(this.leftTickOfCopy, it.leftTickForMove());
            this.rightTickOfCopy = Math.max(this.rightTickOfCopy, it.rightTickForMove());
        }
        System.out.println("Left tick of copy: " + this.leftTickOfCopy);
    }

    public void paste() {
        this.paste(this.project.getSequencer().getTickPosition(), 0, false);
    }

    public void paste(long tickDest, int selectionLeftColumn, boolean trackerOverrideSnap) {
        if (this.copy == null || this.copy.size() == 0) {
            System.out.println(" Nothing in the paste buffer to paste!");
            return;
        }
        long dTick = tickDest - this.leftTickOfCopy;
        long tNew = -1L;
        MidiPart srcPart = null;
        Part dstPart = null;
        if (this.cType == CType.EVENT) {
            if (!trackerOverrideSnap) {
                dTick = this.project.eventQuantize(dTick);
            }
            srcPart = ((MultiEvent)this.copy.elementAt(0)).getPart();
            dstPart = (Part)this.project.getPartSelection().getFocus();
            if (dstPart == null) {
                System.out.println(" Please set part focus before paste operation");
                return;
            }
        } else if (this.cType == CType.PART) {
            dTick = this.project.partQuantize(dTick);
        }
        Vector<Selectable> paste = this.deepCopy(this.copy, dstPart);
        int deltaTrackerColumn = selectionLeftColumn - this.leftColumnOfCopy;
        System.out.println("Paste selectionLeftColumn: " + selectionLeftColumn + " leftColumnOfCopy:" + this.leftColumnOfCopy + " deltaTrackerColumn: " + deltaTrackerColumn);
        for (Selectable it : paste) {
            if (it instanceof MultiEvent) {
                MultiEvent evt = (MultiEvent)it;
                if (evt.getTrackerColumn() != null) {
                    evt.setTrackerColumn(evt.getTrackerColumn() + deltaTrackerColumn);
                } else {
                    evt.setTrackerColumn(selectionLeftColumn);
                }
            }
            it.deepMove(dTick);
            it.addToModel();
        }
        if (this.cType == CType.EVENT) {
            this.project.getMultiEventSelection().setSelectedX(paste);
        } else if (this.cType == CType.PART) {
            this.project.getPartSelection().setSelectedX(paste);
        }
    }

    private Vector<Selectable> deepCopy(Collection<? extends Selectable> collection, Selectable newParent) {
        Vector<Selectable> ret = new Vector<Selectable>();
        for (Selectable selectable : collection) {
            Selectable itClone = selectable.deepCopy(newParent);
            ret.add(itClone);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CType {
        PART,
        EVENT;

    }
}

