/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.clipboard;

import com.frinika.clipboard.ClipboardAccess;
import com.frinika.localization.CurrentLocale;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.clipboard.MultiEventClipboardData;
import com.frinika.sequencer.gui.clipboard.MultiEventDataFlavor;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEventClipboard {
    double quantization = 1.0;
    private static final MultiEventClipboard defaultMultiEventClipboard = new MultiEventClipboard();

    public static MultiEventClipboard getDefaultMultiEventClipboard() {
        return defaultMultiEventClipboard;
    }

    public void copy(Collection<MultiEvent> multiEvents, long referenceTick) {
        final MultiEventClipboardData multiEventClipBoardData = new MultiEventClipboardData(referenceTick, multiEvents);
        System.out.println(" CLIPBOARD COPY ");
        ClipboardAccess.getClipboard().setContents(new Transferable(){

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{new MultiEventDataFlavor()};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return true;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return multiEventClipBoardData;
            }
        }, new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    private void pasteOrig(MidiPart destinationGroup, long destinationReferenceTick) {
        System.out.println(" CLIPBOARD PASTE ORIG ");
        try {
            MultiEventClipboardData data = (MultiEventClipboardData)ClipboardAccess.getClipboard().getContents(null).getTransferData(new MultiEventDataFlavor());
            destinationGroup.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.menu.edit.lcase.paste"));
            destinationGroup.getLane().getProject().getMultiEventSelection().clearSelection();
            for (MultiEvent event : data.getClonedMultiEvents()) {
                event.setStartTick(event.getStartTick() + destinationReferenceTick);
                destinationGroup.add(event);
                destinationGroup.getLane().getProject().getMultiEventSelection().addSelected(event);
                destinationGroup.getLane().getProject().getMultiEventSelection().notifyListeners();
            }
            destinationGroup.getEditHistoryContainer().notifyEditHistoryListeners();
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void paste(MidiPart destinationGroup, EditHistoryContainer history, long destinationReferenceTick, FrinikaSequencer sequencer) {
        if (sequencer == null || destinationGroup != null) {
            this.pasteOrig(destinationGroup, destinationReferenceTick);
            return;
        }
        try {
            MultiEventClipboardData data = (MultiEventClipboardData)ClipboardAccess.getClipboard().getContents(null).getTransferData(new MultiEventDataFlavor());
            long startTick = Long.MAX_VALUE;
            for (MultiEvent event : data.getClonedMultiEvents()) {
                long tickOn = event.getStartTick();
                if (tickOn >= startTick) continue;
                startTick = tickOn;
            }
            long deltaTick = sequencer.getTickPosition() - startTick;
            destinationReferenceTick = (long)(Math.floor((double)deltaTick / this.quantization) * this.quantization);
            history.mark(CurrentLocale.getMessage("sequencer.menu.edit.lcase.paste"));
            data.getClonedMultiEvents().iterator().next().getPart().getLane().getProject().getMultiEventSelection().clearSelection();
            for (MultiEvent event : data.getClonedMultiEvents()) {
                event.setStartTick(event.getStartTick() + destinationReferenceTick);
                event.getPart().add(event);
                event.getPart().getLane().getProject().getMultiEventSelection().addSelected(event);
                assert (false);
            }
            history.notifyEditHistoryListeners();
            assert (false);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setQuantization(double quantization) {
        this.quantization = quantization;
    }
}

