/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import uk.co.simphoney.audio.midi.AudioPartToMidi;

public class AudioPartToMidiAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;

    public AudioPartToMidiAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.audiopart_to_midi"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent arg0) {
        Thread t = new Thread(){

            public void run() {
                Part part = (Part)AudioPartToMidiAction.this.project.getProjectContainer().getPartSelection().getFocus();
                if (part == null || !(part instanceof AudioPart)) {
                    return;
                }
                MidiPart midiPart = null;
                try {
                    midiPart = AudioPartToMidi.process((AudioPart)part);
                    AudioPartToMidiAction.this.project.getProjectContainer().getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.audiopart_to_midi"));
                    MidiLane lane = AudioPartToMidiAction.this.project.getProjectContainer().createMidiLane();
                    lane.add(midiPart);
                    AudioPartToMidiAction.this.project.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
                    AudioPartToMidiAction.this.project.getProjectContainer().getPartSelection().notifyListeners();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }
}

