/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.WavFileFilter;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.Lane;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ImportAudioAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;

    public ImportAudioAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.import_audio"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent arg0) {
        Lane lane = (Lane)this.project.getProjectContainer().getLaneSelection().getFocus();
        boolean allowMulti = false;
        if (!(lane instanceof AudioLane)) {
            this.project.infoMessage("Creating new AudioLane before importing!");
            allowMulti = true;
        }
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.file.import_audio.dialogtitle"));
            chooser.setFileFilter(new WavFileFilter());
            if (!allowMulti) {
                if (chooser.showOpenDialog(null) == 0) {
                    File wavFile = chooser.getSelectedFile();
                    long milliSecPos = this.project.getProjectContainer().getSequencer().getMicrosecondPosition();
                    System.out.println(" milli sec pos = " + milliSecPos);
                    if (wavFile.exists()) {
                        new AudioPart(lane, wavFile, milliSecPos);
                    }
                }
            } else {
                chooser.setMultiSelectionEnabled(allowMulti);
                if (chooser.showOpenDialog(null) == 0) {
                    File[] wavFiles = chooser.getSelectedFiles();
                    long milliSecPos = this.project.getProjectContainer().getSequencer().getMicrosecondPosition();
                    System.out.println(" milli sec pos = " + milliSecPos);
                    for (File wavFile : wavFiles) {
                        System.out.println(" Importing:" + wavFile);
                        if (wavFile.exists()) {
                            this.project.getProjectContainer().getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.import_audio"));
                            AudioLane lane1 = this.project.getProjectContainer().createAudioLane();
                            System.out.println(" created lane  ");
                            new AudioPart(lane1, wavFile, milliSecPos);
                            this.project.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
                        }
                        System.out.println(" OK ");
                    }
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

