/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.gui.OptionsEditor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.RepeatAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RepeatActionEditor
extends JPanel
implements OptionsEditor {
    private RepeatAction action;
    private TimeSelector timeSelector;
    private JCheckBox ghostsCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSpinner repeatSpinner;
    private ButtonGroup repeatTicksButtonGroup;
    private JRadioButton repeatTicksSelectionRadioButton;
    private JRadioButton repeatTicksTimeSelectorRadioButton;
    private JPanel timeSelectorPanel;

    public RepeatActionEditor(RepeatAction action, ProjectContainer project) {
        this.action = action;
        this.initComponents();
        this.timeSelector = new TimeSelector(action.repeatTicks, project, TimeFormat.BEAT_TICK);
        this.timeSelectorPanel.add(this.timeSelector);
        this.refresh();
    }

    public void refresh() {
        this.repeatTicksSelectionRadioButton.setText("length of selection: " + this.timeSelector.formatString(this.action.selectionLength));
        if (!this.action.selectionSupportsGhosts) {
            this.ghostsCheckBox.setSelected(false);
        }
        this.ghostsCheckBox.setEnabled(this.action.selectionSupportsGhosts);
        this.repeatSpinner.requestFocus();
    }

    public void update() {
        if (this.repeatTicksSelectionRadioButton.isSelected()) {
            this.action.repeatTicks = this.action.selectionLength;
        } else if (this.repeatTicksTimeSelectorRadioButton.isSelected()) {
            this.action.repeatTicks = this.timeSelector.getTicks();
        }
    }

    private void initComponents() {
        this.repeatTicksButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.repeatSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.repeatTicksTimeSelectorRadioButton = new JRadioButton();
        this.timeSelectorPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.repeatTicksSelectionRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.ghostsCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Repeat");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.repeatSpinner.setModel(new SpinnerNumberModel(this.action.repeat, 1, 999, 1));
        this.repeatSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RepeatActionEditor.this.repeatSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.repeatSpinner, gridBagConstraints);
        this.jLabel2.setText("times, every");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.repeatTicksButtonGroup.add(this.repeatTicksTimeSelectorRadioButton);
        this.repeatTicksTimeSelectorRadioButton.setSelected(true);
        this.repeatTicksTimeSelectorRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.repeatTicksTimeSelectorRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.repeatTicksTimeSelectorRadioButton, gridBagConstraints);
        this.timeSelectorPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.timeSelectorPanel, gridBagConstraints);
        this.jPanel1.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.repeatTicksButtonGroup.add(this.repeatTicksSelectionRadioButton);
        this.repeatTicksSelectionRadioButton.setText("length of selection: 4.0:000");
        this.repeatTicksSelectionRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.repeatTicksSelectionRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.repeatTicksSelectionRadioButton, gridBagConstraints);
        this.jPanel2.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.ghostsCheckBox.setSelected(this.action.ghost);
        this.ghostsCheckBox.setText("create ghosts");
        this.ghostsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ghostsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.ghostsCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RepeatActionEditor.this.ghostsCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 3, 0, 0);
        this.add((Component)this.ghostsCheckBox, gridBagConstraints);
    }

    private void repeatSpinnerStateChanged(ChangeEvent evt) {
        this.action.repeat = (Integer)this.repeatSpinner.getValue();
    }

    private void ghostsCheckBoxStateChanged(ChangeEvent evt) {
        this.action.ghost = this.ghostsCheckBox.isSelected();
    }
}

