/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.tempo.TempoList;
import com.frinika.sequencer.model.tempo.TempoListListener;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TempoListEditAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;
    private TempoList list;
    private TimeUtils timeUtil;
    JFrame frame;

    public TempoListEditAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.edit_tempolist"), ProjectFrame.getIconResource("tempolist.png"));
        this.project = project;
        this.list = project.getProjectContainer().getTempoList();
        this.timeUtil = project.getProjectContainer().getTimeUtils();
    }

    public void actionPerformed(ActionEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TempoListEditAction.this.frame == null) {
                    TempoListEditAction.this.frame = new JFrame();
                    AbstractTableModel dataModel = new AbstractTableModel(){
                        int tick;
                        double bpm;
                        TempoListListener listener = new TempoListListener(){

                            public void notifyTempoListChange() {
                                this.fireTableDataChanged();
                            }
                        };
                        {
                            TempoListEditAction.this.list.addTempoListListener(this.listener);
                        }

                        public int getColumnCount() {
                            return 3;
                        }

                        public int getRowCount() {
                            TempoListEditAction.this.list.reco();
                            return TempoListEditAction.this.list.size() + 1;
                        }

                        public Object getValueAt(int row, int col) {
                            if (row >= TempoListEditAction.this.list.size()) {
                                return "";
                            }
                            TempoList.MyTempoEvent ev = TempoListEditAction.this.list.elementAt(row);
                            if (col == 0) {
                                return TempoListEditAction.this.timeUtil.tickToBarBeatTick(ev.getTick());
                            }
                            if (col == 1) {
                                return ev.getTime();
                            }
                            if (col == 2) {
                                return ev.getBPM();
                            }
                            assert (false);
                            return "";
                        }

                        public boolean isCellEditable(int row, int col) {
                            if (row == 0 && col == 0) {
                                return false;
                            }
                            return col == 0 || col == 2;
                        }

                        public void setValueAt(Object value, int row, int col) {
                            boolean newE = row >= TempoListEditAction.this.list.size();
                            TempoList.MyTempoEvent ev = null;
                            ev = !newE ? TempoListEditAction.this.list.elementAt(row) : TempoListEditAction.this.list.elementAt(TempoListEditAction.this.list.size() - 1);
                            this.tick = (int)ev.getTick();
                            this.bpm = ev.getBPM();
                            try {
                                if (col == 0) {
                                    this.tick = (int)TempoListEditAction.this.timeUtil.barBeatTickToTick((String)value);
                                } else if (col == 2) {
                                    this.bpm = Double.parseDouble((String)value);
                                }
                                if (!newE) {
                                    TempoListEditAction.this.list.remove(ev.getTick(), ev.getTick() + 1L);
                                }
                                TempoListEditAction.this.list.add(this.tick, this.bpm);
                                TempoListEditAction.this.list.reco();
                                TempoListEditAction.this.list.notifyListeners();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.fireTableDataChanged();
                        }
                    };
                    JTable table = new JTable(dataModel);
                    table.getColumnModel().getColumn(0).setWidth(50);
                    table.getColumnModel().getColumn(1).setWidth(15);
                    table.getColumnModel().getColumn(2).setWidth(15);
                    table.getColumnModel().getColumn(0).setHeaderValue("Bar.Beat:Tick");
                    table.getColumnModel().getColumn(1).setHeaderValue("Time");
                    table.getColumnModel().getColumn(2).setHeaderValue("BPM");
                    JScrollPane scrollpane = new JScrollPane(table);
                    TempoListEditAction.this.frame.setContentPane(scrollpane);
                    TempoListEditAction.this.frame.setTitle("Tempo List");
                    TempoListEditAction.this.frame.pack();
                }
                TempoListEditAction.this.frame.setVisible(true);
            }
        });
    }

    static /* synthetic */ ProjectFrame access$200(TempoListEditAction x0) {
        return x0.project;
    }
}

