/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.OptionsDialog;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.AbstractMidiAction;
import com.frinika.sequencer.gui.menu.midi.MidiInsertControllersActionEditor;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.PitchBendEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiInsertControllersAction
extends AbstractMidiAction {
    protected Collection<ControllerFunction> availableFunctions;
    int controller = 7;
    long start;
    long length = 512L;
    long resolution = 16L;
    ControllerFunction function;

    public MidiInsertControllersAction(ProjectFrame frame) {
        super(frame, "sequencer.midi.insert_controllers");
        this.initControllerFunctions();
        this.function = this.availableFunctions.iterator().next();
    }

    private void initControllerFunctions() {
        this.availableFunctions = new ArrayList<ControllerFunction>();
        this.availableFunctions.add(new Linear());
        this.availableFunctions.add(new Triangle());
        this.availableFunctions.add(new Saw());
        this.availableFunctions.add(new Sine());
        this.availableFunctions.add(new Square());
    }

    public Collection<ControllerFunction> getAvailableControllerFunctions() {
        return this.availableFunctions;
    }

    @Override
    public void performAction() {
        block11: {
            block12: {
                block10: {
                    if (this.controller <= 0) break block10;
                    this.removeAllControllers(this.getMidiPart(), this.controller, this.start, this.length);
                    int lastVal = -1;
                    for (long x = 0L; x < this.length; x += this.resolution) {
                        int val = this.function.value(x);
                        if (this.controller != 64) {
                            if (val < 0) {
                                val = 0;
                            } else if (val > 127) {
                                val = 127;
                            }
                        }
                        if (val != lastVal) {
                            this.insertController(this.getMidiPart(), this.start + x, this.controller, val);
                        }
                        lastVal = val;
                    }
                    break block11;
                }
                if (this.controller != 0) break block12;
                super.performAction();
                break block11;
            }
            if (this.controller != -1) break block11;
            for (long x = 0L; x < this.length; x += this.resolution) {
                int val = this.function.value(x);
                if (val < 0) {
                    val = 0;
                } else if (val > 127) {
                    val = 127;
                }
                this.insertNote(this.getMidiPart(), this.start + x, val, (int)this.resolution - 1, 100);
            }
        }
    }

    @Override
    public void modifyNoteEvent(NoteEvent note) {
        long st = note.getStartTick();
        if (st >= this.start && st < this.start + this.length) {
            long x = st - this.start;
            int val = this.function.value(x);
            if (val < 0) {
                val = 0;
            } else if (val > 127) {
                val = 127;
            }
            note.setVelocity(val);
        }
    }

    private void insertController(MidiPart part, long tick, int controller, int value) {
        if (controller == 64) {
            PitchBendEvent c = new PitchBendEvent(part, tick, value);
            part.add(c);
        } else {
            ControllerEvent c = new ControllerEvent(part, tick, controller, value);
            part.add(c);
        }
    }

    private void insertNote(MidiPart part, long tick, int note, int duration, int velocity) {
        NoteEvent n = new NoteEvent(part, tick, note, 100, part.getMidiChannel(), (long)duration);
        part.add(n);
    }

    private void removeAllControllers(MidiPart part, int ctrl, long start, long length) {
        for (MultiEvent evt : new ArrayList<MultiEvent>(part.getMultiEvents())) {
            long st;
            if (!(evt instanceof ControllerEvent) || (st = evt.getStartTick()) < start || st > start + length || ((ControllerEvent)evt).getControlNumber() != ctrl) continue;
            part.remove(evt);
        }
    }

    @Override
    protected JComponent createGUI() {
        return new MidiInsertControllersActionEditor(this.frame, this);
    }

    @Override
    protected OptionsDialog createDialog() {
        OptionsDialog d = new OptionsDialog(this.frame, this.createGUI(), CurrentLocale.getMessage(this.actionId)){

            public void repack() {
            }
        };
        d.pack();
        d.setSize(d.getWidth() + 250, d.getHeight() + 50);
        return d;
    }

    private static JSpinner spinner(int dflt, int min, int max, ChangeListener l) {
        JSpinner s = new JSpinner(new SpinnerNumberModel(dflt, min, max, 1));
        s.addChangeListener(l);
        return s;
    }

    class Square
    extends AbstractCyclicControllerFunction {
        Square() {
            super(CurrentLocale.getMessage("sequencer.midi.controllerfunction.square"));
        }

        public int value(long x) {
            return this.min + (int)((x + this.shift) / this.phase % 2L) * (this.max - this.min);
        }

        public int iconValue(int x, int width, int height) {
            return x / 8 % 2 != 0 ? height - height / 4 : height / 4;
        }
    }

    class Sine
    extends AbstractCyclicControllerFunction {
        Sine() {
            super(CurrentLocale.getMessage("sequencer.midi.controllerfunction.sine"));
        }

        public int value(long x) {
            double amplitude = (double)(this.max - this.min) / 2.0;
            double center = (double)this.min + amplitude;
            double sin = Math.sin((double)(x + this.shift) * 2.0 * Math.PI / (double)this.phase + 4.71238898038469);
            int val = (int)Math.round(sin * amplitude + center);
            return val;
        }

        public int iconValue(int x, int width, int height) {
            int h = height / 2;
            int y = (int)Math.round(Math.sin((double)((float)x / 3.0f) + 5.497787143782138) * (double)h * 0.75) + h;
            return y;
        }
    }

    class Saw
    extends AbstractCyclicControllerFunction {
        Saw() {
            super(CurrentLocale.getMessage("sequencer.midi.controllerfunction.saw"));
        }

        public int value(long x) {
            int ph = (int)((x + this.shift) % this.phase);
            int diff = this.max - this.min;
            int val = Math.round((float)this.min + (float)(diff * ph) / (float)this.phase);
            return val;
        }

        public int iconValue(int x, int width, int height) {
            return x * 2 % height;
        }
    }

    class Triangle
    extends AbstractCyclicControllerFunction {
        Triangle() {
            super(CurrentLocale.getMessage("sequencer.midi.controllerfunction.triangle"));
        }

        public int value(long x) {
            int diff = this.max - this.min;
            int ph = (int)((x + this.shift) % this.phase);
            int val = Math.round((float)((this.max + diff - this.min) * ph) / (float)this.phase) + this.min;
            if (val > this.max) {
                int d = val - this.max;
                val = this.max - d;
            }
            return val;
        }

        public int iconValue(int x, int width, int height) {
            int y = x * 4 % (height * 2);
            int d = y - height;
            if (d > 0) {
                y = height - d;
            }
            return y;
        }
    }

    class Linear
    extends AbstractCyclicControllerFunction {
        Linear() {
            super(CurrentLocale.getMessage("sequencer.midi.controllerfunction.linear"));
        }

        public int value(long x) {
            return this.min + Math.round((float)((long)(this.max - this.min) * x) / (float)MidiInsertControllersAction.this.length);
        }

        public int iconValue(int x, int width, int height) {
            return x * height / width;
        }

        public void createGUIExtra(JPanel panel) {
        }
    }

    abstract class AbstractCyclicControllerFunction
    extends AbstractControllerFunction {
        int min;
        int max;
        long phase;
        long shift;

        protected AbstractCyclicControllerFunction(String name) {
            super(name);
            this.min = 0;
            this.max = 127;
            this.phase = 1024L;
            this.shift = 0L;
        }

        public JComponent createGUI() {
            JPanel panel = new JPanel(new FlowLayout());
            panel.add(new JLabel("Between"));
            panel.add(MidiInsertControllersAction.spinner(this.min, 0, 127, new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ((SpinnerNumberModel)((JSpinner)e.getSource()).getModel()).setMaximum(Integer.valueOf(MidiInsertControllersAction.this.controller == 64 ? 16383 : 127));
                    AbstractCyclicControllerFunction.this.min = (Integer)((JSpinner)e.getSource()).getValue();
                }
            }));
            panel.add(new JLabel("and"));
            panel.add(MidiInsertControllersAction.spinner(this.max, 0, 127, new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ((SpinnerNumberModel)((JSpinner)e.getSource()).getModel()).setMaximum(Integer.valueOf(MidiInsertControllersAction.this.controller == 64 ? 16383 : 127));
                    AbstractCyclicControllerFunction.this.max = (Integer)((JSpinner)e.getSource()).getValue();
                }
            }));
            this.createGUIExtra(panel);
            return panel;
        }

        protected void createGUIExtra(JPanel panel) {
            panel.add(new JPanel());
            panel.add(new JLabel("Interval"));
            final TimeSelector phaseTimeSelector = new TimeSelector(this.phase, MidiInsertControllersAction.this.frame.getProjectContainer(), TimeFormat.BAR_BEAT_TICK);
            phaseTimeSelector.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AbstractCyclicControllerFunction.this.phase = phaseTimeSelector.getTicks();
                }
            });
            panel.add(phaseTimeSelector);
            panel.add(new JLabel("Shift"));
            final TimeSelector shiftTimeSelector = new TimeSelector(this.shift, MidiInsertControllersAction.this.frame.getProjectContainer(), TimeFormat.BAR_BEAT_TICK);
            phaseTimeSelector.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AbstractCyclicControllerFunction.this.shift = shiftTimeSelector.getTicks();
                }
            });
            panel.add(shiftTimeSelector);
        }
    }

    public abstract class AbstractControllerFunction
    implements ControllerFunction {
        protected String name;

        protected AbstractControllerFunction() {
        }

        protected AbstractControllerFunction(String name) {
            this();
            this.setName(name);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon(int width, int height) {
            return new ControllerFunctionIcon(this, width, height);
        }
    }

    public class ControllerFunctionIcon
    implements Icon {
        private ControllerFunction function;
        private int width;
        private int height;

        public ControllerFunctionIcon(ControllerFunction function, int width, int height) {
            this.function = function;
            this.width = width;
            this.height = height;
        }

        public int getIconHeight() {
            return this.width;
        }

        public int getIconWidth() {
            return this.height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int v = this.f(0);
            g.setColor(Color.black);
            for (int i = 1; i < this.width; ++i) {
                int newV = this.f(i);
                g.drawLine(x + i - 1, y + this.height - v, x + i, y + this.height - newV);
                v = newV;
            }
        }

        private int f(int x) {
            return this.function.iconValue(x + this.height / 8, this.width, this.height - this.height / 4);
        }
    }

    public static interface ControllerFunction {
        public String getName();

        public Icon getIcon(int var1, int var2);

        public JComponent createGUI();

        public int value(long var1);

        public int iconValue(int var1, int var2, int var3);
    }
}

