/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.sequencer.gui.menu.midi.MidiTransposeAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MidiTransposeActionEditor
extends JPanel {
    private MidiTransposeAction action;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSpinner notesSpinner;
    private JSpinner octaveSpinner;

    public MidiTransposeActionEditor(MidiTransposeAction action) {
        this.action = action;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.octaveSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.notesSpinner = new JSpinner();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Octaves");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.octaveSpinner.setModel(new SpinnerNumberModel(this.action.transpose / 12, -12, 12, 1));
        this.octaveSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiTransposeActionEditor.this.octaveSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.octaveSpinner, gridBagConstraints);
        this.jLabel2.setText("Notes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.notesSpinner.setModel(new SpinnerNumberModel(this.action.transpose % 12, -96, 96, 1));
        this.notesSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiTransposeActionEditor.this.notesSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.notesSpinner, gridBagConstraints);
    }

    private void octaveSpinnerStateChanged(ChangeEvent evt) {
        this.updateAction();
    }

    private void notesSpinnerStateChanged(ChangeEvent evt) {
        this.updateAction();
    }

    private void updateAction() {
        int octave = (Integer)this.octaveSpinner.getValue();
        int note = (Integer)this.notesSpinner.getValue();
        this.action.transpose = octave * 12 + note;
    }
}

