/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.mixer;

import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.renderer.MidiRender;
import com.frinika.renderer.MidiRenderFactory;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import com.frinika.sequencer.gui.mixer.MidiDeviceMixerPanel;
import com.sun.media.sound.AudioSynthesizer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Icon;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthWrapper
implements Synthesizer,
MidiRenderFactory,
MidiDeviceIconProvider {
    MidiDevice midiDevice;
    MidiDeviceMixerPanel gui;
    AudioProcess synthVoice = null;
    MidiChannel[] midiChannels = new MidiChannel[16];
    Receiver receiver;
    private volatile AudioProcess render_audioprocess;
    private volatile boolean supress_audio;
    Icon icon;

    public SynthWrapper(ProjectContainer project, MidiDevice midiDevice) {
        for (int n = 0; n < this.midiChannels.length; ++n) {
            final int channelNo = n;
            this.midiChannels[n] = new MidiChannel(){
                int channel;
                boolean mute;
                {
                    this.channel = channelNo;
                    this.mute = false;
                }

                public void noteOn(int noteNumber, int velocity) {
                }

                public void noteOff(int noteNumber, int velocity) {
                }

                public void noteOff(int noteNumber) {
                }

                public void setPolyPressure(int noteNumber, int pressure) {
                }

                public int getPolyPressure(int noteNumber) {
                    return 0;
                }

                public void setChannelPressure(int pressure) {
                }

                public int getChannelPressure() {
                    return 0;
                }

                public void controlChange(int controller, int value) {
                    ShortMessage shm = new ShortMessage();
                    try {
                        shm.setMessage(176, this.channel, controller, value);
                        SynthWrapper.this.sendMidiMessage(shm, -1L);
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                }

                public int getController(int controller) {
                    return 0;
                }

                public void programChange(int program) {
                }

                public void programChange(int bank, int program) {
                }

                public int getProgram() {
                    return 0;
                }

                public void setPitchBend(int bend) {
                }

                public int getPitchBend() {
                    return 0;
                }

                public void resetAllControllers() {
                }

                public void allNotesOff() {
                }

                public void allSoundOff() {
                }

                public boolean localControl(boolean on) {
                    return false;
                }

                public void setMono(boolean on) {
                }

                public boolean getMono() {
                    return false;
                }

                public void setOmni(boolean on) {
                }

                public boolean getOmni() {
                    return false;
                }

                public void setMute(boolean mute) {
                    this.mute = mute;
                }

                public boolean getMute() {
                    return this.mute;
                }

                public void setSolo(boolean soloState) {
                }

                public boolean getSolo() {
                    return false;
                }
            };
        }
        this.receiver = new Receiver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void send(MidiMessage message, long timeStamp) {
                try {
                    if (!(message instanceof ShortMessage)) {
                        SynthWrapper.this.sendMidiMessage(message, timeStamp);
                        return;
                    }
                    ShortMessage shm = (ShortMessage)message;
                    int channel = shm.getChannel();
                    if (SynthWrapper.this.midiChannels[channel].getMute()) {
                        return;
                    }
                    SynthWrapper.this.sendMidiMessage(message, timeStamp);
                    if (shm.getCommand() == 144) {
                        return;
                    }
                    if (shm.getCommand() == 176) {
                        if (SynthWrapper.this.gui != null && shm.getData1() == 7) {
                            SynthWrapper.this.gui.mixerSlots[channel].setVolume(shm.getData2());
                            return;
                        }
                        if (SynthWrapper.this.gui == null) return;
                        if (shm.getData1() != 10) return;
                        SynthWrapper.this.gui.mixerSlots[channel].setPan(shm.getData2());
                        return;
                    }
                    if (shm.getCommand() != 224) return;
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }

            public void close() {
                try {
                    SynthWrapper.this.midiDevice.getReceiver().close();
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
        };
        this.render_audioprocess = null;
        this.supress_audio = false;
        this.midiDevice = midiDevice;
        if (midiDevice instanceof AudioSynthesizer) {
            try {
                AudioFormat.Encoding PCM_FLOAT = new AudioFormat.Encoding("PCM_FLOAT");
                AudioFormat format = new AudioFormat(PCM_FLOAT, 44100.0f, 32, 2, 8, 44100.0f, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
                AudioSynthesizer audosynth = (AudioSynthesizer)midiDevice;
                final AudioInputStream ais = audosynth.openStream(format, null);
                System.out.println("PCM_FLOAT Encoding used!");
                this.synthVoice = new AudioProcess(){
                    byte[] streamBuffer = null;
                    float[] floatArray = null;
                    FloatBuffer floatBuffer = null;

                    public void close() {
                    }

                    public void open() {
                    }

                    public int processAudio(AudioBuffer buffer) {
                        float[] left;
                        if (buffer == null) {
                            return 0;
                        }
                        if (this.streamBuffer == null || this.streamBuffer.length != buffer.getSampleCount() * 8) {
                            ByteBuffer bytebuffer = ByteBuffer.allocate(buffer.getSampleCount() * 8).order(ByteOrder.nativeOrder());
                            this.streamBuffer = bytebuffer.array();
                            this.floatArray = new float[buffer.getSampleCount() * 2];
                            this.floatBuffer = bytebuffer.asFloatBuffer();
                        }
                        if (SynthWrapper.this.supress_audio) {
                            left = buffer.getChannel(0);
                            float[] right = buffer.getChannel(1);
                            Arrays.fill(left, 0, buffer.getSampleCount(), 0.0f);
                            Arrays.fill(right, 0, buffer.getSampleCount(), 0.0f);
                        } else {
                            try {
                                ais.read(this.streamBuffer, 0, buffer.getSampleCount() * 8);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            this.floatBuffer.position(0);
                            this.floatBuffer.get(this.floatArray);
                            left = buffer.getChannel(0);
                            float[] right = buffer.getChannel(1);
                            for (int n = 0; n < buffer.getSampleCount() * 2; n += 2) {
                                left[n / 2] = this.floatArray[n];
                                right[n / 2] = this.floatArray[n + 1];
                            }
                        }
                        AudioProcess r_proc = SynthWrapper.this.render_audioprocess;
                        if (r_proc != null) {
                            r_proc.processAudio(buffer);
                        }
                        return 0;
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                midiDevice.open();
            }
            catch (MidiUnavailableException e1) {
                e1.printStackTrace();
            }
        }
        if (midiDevice instanceof Mixer) {
            try {
                midiDevice.open();
                final TargetDataLine line = (TargetDataLine)((Mixer)((Object)midiDevice)).getLine(new Line.Info(TargetDataLine.class));
                AudioFormat.Encoding PCM_FLOAT = new AudioFormat.Encoding("PCM_FLOAT");
                AudioFormat format = new AudioFormat(PCM_FLOAT, 44100.0f, 32, 2, 8, 44100.0f, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
                line.open(format);
                System.out.println("PCM_FLOAT Encoding used!");
                this.synthVoice = new AudioProcess(){
                    byte[] streamBuffer = null;
                    float[] floatArray = null;
                    FloatBuffer floatBuffer = null;

                    public void close() {
                    }

                    public void open() {
                    }

                    public int processAudio(AudioBuffer buffer) {
                        float[] left;
                        if (buffer == null) {
                            return 0;
                        }
                        if (this.streamBuffer == null || this.streamBuffer.length != buffer.getSampleCount() * 8) {
                            ByteBuffer bytebuffer = ByteBuffer.allocate(buffer.getSampleCount() * 8).order(ByteOrder.nativeOrder());
                            this.streamBuffer = bytebuffer.array();
                            this.floatArray = new float[buffer.getSampleCount() * 2];
                            this.floatBuffer = bytebuffer.asFloatBuffer();
                        }
                        if (SynthWrapper.this.supress_audio) {
                            left = buffer.getChannel(0);
                            float[] right = buffer.getChannel(1);
                            Arrays.fill(left, 0, buffer.getSampleCount(), 0.0f);
                            Arrays.fill(right, 0, buffer.getSampleCount(), 0.0f);
                        } else {
                            line.read(this.streamBuffer, 0, buffer.getSampleCount() * 8);
                            this.floatBuffer.position(0);
                            this.floatBuffer.get(this.floatArray);
                            left = buffer.getChannel(0);
                            float[] right = buffer.getChannel(1);
                            for (int n = 0; n < buffer.getSampleCount() * 2; n += 2) {
                                left[n / 2] = this.floatArray[n];
                                right[n / 2] = this.floatArray[n + 1];
                            }
                        }
                        AudioProcess r_proc = SynthWrapper.this.render_audioprocess;
                        if (r_proc != null) {
                            r_proc.processAudio(buffer);
                        }
                        return 0;
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AudioProcess getAudioProcess() {
        return this.synthVoice;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    @Override
    public List<Receiver> getReceivers() {
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        receivers.add(this.receiver);
        for (Receiver recv : this.midiDevice.getReceivers()) {
            try {
                if (recv == this.midiDevice.getReceiver()) continue;
                receivers.add(recv);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return receivers;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.midiDevice.getTransmitter();
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.midiDevice.getTransmitters();
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.midiDevice.getDeviceInfo();
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.midiDevice.open();
    }

    @Override
    public void close() {
        this.midiDevice.close();
    }

    @Override
    public boolean isOpen() {
        return this.midiDevice.isOpen();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.midiDevice.getMicrosecondPosition();
    }

    @Override
    public int getMaxReceivers() {
        return this.midiDevice.getMaxReceivers();
    }

    @Override
    public int getMaxTransmitters() {
        return this.midiDevice.getMaxTransmitters();
    }

    @Override
    public int getMaxPolyphony() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getMaxPolyphony();
        }
        return 0;
    }

    @Override
    public long getLatency() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getLatency();
        }
        return 0L;
    }

    @Override
    public MidiChannel[] getChannels() {
        return this.midiChannels;
    }

    @Override
    public VoiceStatus[] getVoiceStatus() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getVoiceStatus();
        }
        return null;
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).isSoundbankSupported(soundbank);
        }
        return false;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).loadInstrument(instrument);
        }
        return false;
    }

    @Override
    public void unloadInstrument(Instrument instrument) {
        if (this.midiDevice instanceof Synthesizer) {
            ((Synthesizer)this.midiDevice).unloadInstrument(instrument);
        }
    }

    @Override
    public boolean remapInstrument(Instrument from, Instrument to) {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).remapInstrument(from, to);
        }
        return false;
    }

    @Override
    public Soundbank getDefaultSoundbank() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getDefaultSoundbank();
        }
        return null;
    }

    @Override
    public Instrument[] getAvailableInstruments() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getAvailableInstruments();
        }
        return null;
    }

    @Override
    public Instrument[] getLoadedInstruments() {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).getLoadedInstruments();
        }
        return null;
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).loadAllInstruments(soundbank);
        }
        return false;
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
        if (this.midiDevice instanceof Synthesizer) {
            ((Synthesizer)this.midiDevice).unloadAllInstruments(soundbank);
        }
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        if (this.midiDevice instanceof Synthesizer) {
            return ((Synthesizer)this.midiDevice).loadInstruments(soundbank, patchList);
        }
        return false;
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
        if (this.midiDevice instanceof Synthesizer) {
            ((Synthesizer)this.midiDevice).unloadInstruments(soundbank, patchList);
        }
    }

    public String toString() {
        return this.midiDevice.getDeviceInfo().toString();
    }

    void sendMidiMessage(MidiMessage message, long timestamp) {
        try {
            this.midiDevice.getReceiver().send(message, timestamp);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    public MidiDevice getRealDevice() {
        return this.midiDevice;
    }

    public void setSaveReferencedData(boolean saveReferencedData) {
        try {
            Method setName = this.midiDevice.getClass().getMethod("setSaveReferencedData", Boolean.TYPE);
            setName.invoke((Object)this.midiDevice, saveReferencedData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRenderable() {
        if (!(this.midiDevice instanceof Synthesizer)) {
            return false;
        }
        if (!(this.midiDevice instanceof Mixer)) {
            return false;
        }
        if (!(this.midiDevice instanceof Cloneable)) {
            return false;
        }
        try {
            if (this.midiDevice.getClass().getMethod("clone", new Class[0]) == null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setRenderAudioProcess(AudioProcess audioprocess) {
        this.render_audioprocess = audioprocess;
    }

    public void setSupressAudio(boolean supress_audio) {
        this.supress_audio = supress_audio;
    }

    @Override
    public MidiRender getRender(float samplerate, int channels) {
        Receiver recv;
        TargetDataLine line;
        Synthesizer midiDevice;
        if (!(this.midiDevice instanceof Synthesizer)) {
            return null;
        }
        if (!(this.midiDevice instanceof Mixer)) {
            return null;
        }
        if (!(this.midiDevice instanceof Cloneable)) {
            return null;
        }
        try {
            midiDevice = (Synthesizer)this.midiDevice.getClass().getMethod("clone", new Class[0]).invoke((Object)this.midiDevice, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Mixer mixer = (Mixer)((Object)midiDevice);
        try {
            line = (TargetDataLine)((Mixer)((Object)midiDevice)).getLine(new Line.Info(TargetDataLine.class));
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return null;
        }
        AudioFormat.Encoding PCM_FLOAT = new AudioFormat.Encoding("PCM_FLOAT");
        AudioFormat format = new AudioFormat(PCM_FLOAT, samplerate, 32, channels, 4 * channels, (float)(4 * channels) * samplerate, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        try {
            line.open(format);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return null;
        }
        try {
            midiDevice.open();
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
        }
        try {
            recv = midiDevice.getReceiver();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return null;
        }
        byte[] dummy = new byte[8];
        line.read(dummy, 0, dummy.length);
        MidiRender render = new MidiRender(){
            TargetDataLine f_line;
            MidiDevice f_dev;
            Receiver f_recv;
            byte[] streamBuffer;
            FloatBuffer floatBuffer;
            boolean first;
            {
                this.f_line = line;
                this.f_dev = midiDevice;
                this.f_recv = recv;
                this.streamBuffer = null;
                this.floatBuffer = null;
                this.first = true;
            }

            public void send(MidiMessage message) {
                this.f_recv.send(message, -1L);
            }

            public int read(float[] buffer, int from, int to) {
                if (buffer == null) {
                    return 0;
                }
                int len = to - from;
                if (this.streamBuffer == null || this.streamBuffer.length != len * 4) {
                    ByteBuffer bytebuffer = ByteBuffer.allocate(len * 4).order(ByteOrder.nativeOrder());
                    this.streamBuffer = bytebuffer.array();
                    this.floatBuffer = bytebuffer.asFloatBuffer();
                }
                line.read(this.streamBuffer, 0, len * 4);
                this.floatBuffer.position(0);
                this.floatBuffer.get(buffer, from, len);
                return len;
            }

            public void close() {
                this.f_line.close();
                midiDevice.close();
            }
        };
        return render;
    }

    @Override
    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        this.icon = ProjectFrame.getMidiDeviceIcon(this.midiDevice);
        return this.icon;
    }

    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        if (this.midiDevice instanceof SoundbankReader) {
            return ((SoundbankReader)((Object)this.midiDevice)).getSoundbank(file);
        }
        return MidiSystem.getSoundbank(file);
    }
}

