/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.partview.AudioLaneView;
import com.frinika.sequencer.gui.partview.LaneHeaderPanel;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.gui.partview.MidiVoiceView;
import com.frinika.sequencer.gui.partview.ProjectView;
import com.frinika.sequencer.gui.partview.SynthLaneView;
import com.frinika.sequencer.gui.partview.TextLaneView;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MenuPlugable;
import com.frinika.sequencer.model.MenuPlugin;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.ProjectLane;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.SoloManager;
import com.frinika.sequencer.model.SynthLane;
import com.frinika.sequencer.model.TextLane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class LaneHeaderItem
extends JPanel
implements Observer,
MenuPlugable {
    private static final long serialVersionUID = 1L;
    JButton close = new JButton();
    JTextField voice;
    JButton mutate = new JButton();
    MyButton mute;
    MyButton solo;
    MyButton prerender;
    MyButton looped;
    MyButton record;
    MeterPanel meterPanel;
    Color selectedColor;
    Color defaultColor;
    boolean selected = false;
    Lane lane;
    LaneView voiceView;
    private boolean notify = true;
    ProjectFrame frame;
    Color voice_selected_background;
    Color voice_unselected_background;
    JLabel midiLaneLabel;
    SoloManager soloManager;
    LaneHeaderPanel parent;
    static MenuPlugin menuPlugin = null;
    static double dBmax = 20.0 * Math.log10(1.0);
    static double dBmin = dBmax - 40.0;
    static double dBrange = dBmax - dBmin;

    public LaneHeaderItem(final ProjectFrame frame, final LaneHeaderPanel parent, final Lane lane, int index) {
        Lane al;
        this.lane = lane;
        this.parent = parent;
        this.soloManager = frame.getProjectContainer().getSoloManager();
        if (lane instanceof SynthLane) {
            float[] rgb = this.getBackground().getRGBColorComponents(new float[3]);
            rgb[0] = (float)((double)rgb[0] * 0.95);
            rgb[1] = (float)((double)rgb[1] * 0.95);
            rgb[2] = (float)((double)rgb[2] * 0.95);
            this.setBackground(new Color(rgb[0], rgb[1], rgb[2]));
        }
        this.defaultColor = this.getBackground();
        this.selectedColor = Color.PINK;
        this.frame = frame;
        if (lane instanceof MidiLane) {
            this.voiceView = new MidiVoiceView((MidiLane)lane, frame);
        } else if (lane instanceof AudioLane) {
            this.voiceView = new AudioLaneView((AudioLane)lane);
            al = (AudioLane)lane;
            ((AudioLane)al).getMixerControls().getSoloControl().addObserver((Observer)this);
            ((AudioLane)al).getMixerControls().getMuteControl().addObserver((Observer)this);
        } else if (lane instanceof TextLane) {
            this.voiceView = new TextLaneView((TextLane)lane, frame);
        } else if (lane instanceof ProjectLane) {
            this.voiceView = new ProjectView(frame.getProjectContainer().getProjectLane());
        } else if (lane instanceof SynthLane) {
            this.voiceView = new SynthLaneView(lane);
            al = (SynthLane)lane;
            if (((SynthLane)al).getMixerControls() != null) {
                ((SynthLane)al).getMixerControls().getSoloControl().addObserver((Observer)this);
                ((SynthLane)al).getMixerControls().getMuteControl().addObserver((Observer)this);
            }
        } else {
            this.voiceView = new LaneView(lane);
        }
        if (lane instanceof RecordableLane) {
            this.meterPanel = new MeterPanel();
        }
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.ipadx = 4;
        Icon icon = lane.getIcon();
        JLabel label = new JLabel(icon);
        this.add((Component)label, c);
        if (lane instanceof MidiLane) {
            this.midiLaneLabel = label;
            this.midiLaneLabel.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    if (((MidiLane)lane).isDrumLane()) {
                        ((MidiLane)lane).setType(1);
                    } else {
                        ((MidiLane)lane).setType(2);
                    }
                    LaneHeaderItem.this.repaint();
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        c.ipady = 0;
        c.ipadx = 4;
        c.weightx = 1.0;
        this.voice = new JTextField(lane.getName(), 8);
        this.voice_selected_background = this.voice.getBackground();
        this.voice.setBackground(this.getBackground());
        this.voice_unselected_background = this.voice.getBackground();
        this.voice.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        this.voice.setMargin(insets);
        this.voice.setToolTipText("Click to select this lane");
        this.setToolTipText("Click to select this lane");
        this.voice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                lane.setName(LaneHeaderItem.this.voice.getText());
                if (LaneHeaderItem.this.notify) {
                    lane.getProject().getLaneSelection().setSelected(lane);
                    lane.getProject().getLaneSelection().notifyListeners();
                }
                LaneHeaderItem.this.voice.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            }
        });
        this.voice.setToolTipText(CurrentLocale.getMessage("laneheader.tooltip.voice_name"));
        this.voice.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (LaneHeaderItem.this.notify) {
                    lane.getProject().getLaneSelection().setSelected(lane);
                    lane.getProject().getLaneSelection().notifyListeners();
                }
            }

            public void focusLost(FocusEvent e) {
                lane.setName(LaneHeaderItem.this.voice.getText());
                LaneHeaderItem.this.voice.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            }
        });
        this.voice.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LaneHeaderItem.this.voice.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    return;
                }
                if (e.getButton() == 3) {
                    LaneHeaderItem.this.showContextMenu(e.getX(), e.getY());
                    e.consume();
                    return;
                }
                frame.getProjectContainer().getLaneSelection().clearSelection();
                frame.getProjectContainer().getLaneSelection().addSelected(lane);
                frame.getProjectContainer().getLaneSelection().notifyListeners();
                LaneHeaderItem.this.grabFocus();
            }
        });
        this.setFocusable(true);
        Color bordercolor = UIManager.getColor("Panel.background").darker();
        if (index == 0) {
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, bordercolor));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, bordercolor));
        }
        c.insets = new Insets(0, 0, 0, 1);
        c.fill = 2;
        this.add((Component)this.voice, c);
        c.fill = 0;
        if (lane instanceof MidiLane) {
            this.prerender = new MyButton("P", Color.BLUE);
            this.prerender.setMargin(insets);
            this.prerender.setToolTipText("Pre-render this voice");
            this.prerender.setFocusable(false);
            this.prerender.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean bl = ((MidiLane)lane).getPlayOptions().preRendered = !((MidiLane)lane).getPlayOptions().preRendered;
                    if (LaneHeaderItem.this.notify) {
                        lane.getProject().getLaneSelection().setSelected(lane);
                        lane.getProject().getLaneSelection().notifyListeners();
                    }
                    frame.repaintViews();
                    LaneHeaderItem.this.setState();
                }
            });
        }
        if (lane instanceof MidiLane) {
            this.looped = new MyButton("L", Color.YELLOW);
            this.looped.setMargin(insets);
            this.looped.setToolTipText("Loop this voice");
            this.looped.setFocusable(false);
            this.looped.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean bl = ((MidiLane)lane).getPlayOptions().looped = !((MidiLane)lane).getPlayOptions().looped;
                    if (LaneHeaderItem.this.notify) {
                        lane.getProject().getLaneSelection().setSelected(lane);
                        lane.getProject().getLaneSelection().notifyListeners();
                    }
                    frame.repaintViews();
                    LaneHeaderItem.this.setState();
                }
            });
        }
        if (lane instanceof RecordableLane) {
            this.mute = new MyButton("M", Color.ORANGE);
            this.mute.setMargin(insets);
            this.mute.setToolTipText("Mute this voice");
            this.mute.setFocusable(false);
            this.mute.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RecordableLane rl = (RecordableLane)((Object)lane);
                    LaneHeaderItem.this.soloManager.toggleMute(rl);
                    if (LaneHeaderItem.this.notify) {
                        lane.getProject().getLaneSelection().setSelected(lane);
                        lane.getProject().getLaneSelection().notifyListeners();
                    }
                    parent.repaint();
                }
            });
            this.solo = new MyButton("S", Color.GREEN);
            this.solo.setMargin(insets);
            this.solo.setToolTipText("Solo this voice");
            this.solo.setFocusable(false);
            this.solo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RecordableLane rl = (RecordableLane)((Object)lane);
                    LaneHeaderItem.this.soloManager.toggleSolo(rl);
                    if (LaneHeaderItem.this.notify) {
                        lane.getProject().getLaneSelection().setSelected(lane);
                        lane.getProject().getLaneSelection().notifyListeners();
                    }
                    parent.repaint();
                }
            });
            this.record = lane instanceof SynthLane ? new MyButton("P", Color.BLUE) : new MyButton("R", Color.RED);
            this.record.setMargin(insets);
            this.record.setFocusable(false);
            this.record.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RecordableLane rl;
                    rl.setRecording(!(rl = (RecordableLane)((Object)lane)).isRecording());
                    if (LaneHeaderItem.this.notify) {
                        lane.getProject().getLaneSelection().setSelected(lane);
                        lane.getProject().getLaneSelection().notifyListeners();
                    }
                    LaneHeaderItem.this.setState();
                }
            });
            c.weightx = 0.0;
            if (lane instanceof MidiLane) {
                this.add((Component)this.looped, c);
            }
            if (lane instanceof MidiLane) {
                this.add((Component)this.prerender, c);
            }
            boolean show_msr = true;
            if (lane instanceof SynthLane && !((SynthLane)lane).isSynthesizer()) {
                show_msr = false;
            }
            if (show_msr) {
                this.add((Component)this.record, c);
                this.add((Component)this.mute, c);
                this.add((Component)this.solo, c);
            }
        }
        if (this.meterPanel != null) {
            c.anchor = 13;
            c.fill = 3;
            c.insets = new Insets(2, 2, 2, 2);
            c.ipadx = 0;
            c.ipady = 0;
            c.weighty = 1.0;
            this.add((Component)this.meterPanel, c);
        }
    }

    public static void setPluginRightButtonMenu(MenuPlugin menuPlugin) {
        LaneHeaderItem.menuPlugin = menuPlugin;
    }

    public void showContextMenu(int x, int y) {
        if (menuPlugin == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        menuPlugin.initContextMenu(popup, this);
        popup.show(this, x, y);
    }

    public void paintComponent(Graphics g) {
        this.setState();
        super.paintComponent(g);
    }

    void setState() {
        this.notify = false;
        if (!this.voice.hasFocus()) {
            this.voice.setText(this.lane.getName());
            this.voice.setCaretPosition(0);
        }
        if (this.lane.isSelected()) {
            if (!this.selected) {
                this.setBackground(this.voice_selected_background);
                this.voice.setBackground(this.voice_selected_background);
                this.selected = true;
            }
        } else if (this.selected) {
            this.setBackground(this.defaultColor);
            this.voice.setBackground(this.voice_unselected_background);
            if (this.voice.hasFocus()) {
                this.grabFocus();
            }
            this.selected = false;
        }
        if (this.lane instanceof RecordableLane) {
            RecordableLane rl = (RecordableLane)((Object)this.lane);
            this.record.draw(rl.isRecording());
            this.mute.draw(rl.isMute(), this.soloManager.isMute(rl));
            this.solo.draw(this.soloManager.isSolo(rl));
            if (this.lane instanceof MidiLane) {
                this.looped.draw(((MidiLane)this.lane).getPlayOptions().looped);
            }
            if (this.lane instanceof MidiLane) {
                this.prerender.draw(((MidiLane)this.lane).getPlayOptions().preRendered);
            }
        }
        if (this.lane instanceof MidiLane) {
            this.midiLaneLabel.setIcon(this.lane.getIcon());
            this.midiLaneLabel.validate();
        }
        this.notify = true;
    }

    public void updateMeter() {
        if (this.meterPanel == null) {
            return;
        }
        Graphics g = this.meterPanel.getGraphics();
        if (g == null) {
            return;
        }
        RecordableLane r = (RecordableLane)((Object)this.lane);
        double val = r.getMonitorValue();
        double dBval = 20.0 * Math.log10(val + 1.0E-40);
        double fact = (dBval - dBmin) / dBrange;
        if (val >= 1.0) {
            this.meterPanel.updateMeter(fact, Color.RED);
        } else {
            this.meterPanel.updateMeter(fact, Color.GREEN);
        }
    }

    public void update(Observable o, Object arg) {
        this.repaint();
    }

    public Lane getLane() {
        return this.lane;
    }

    class MyButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private Color onCol;
        private Color userOnCol;

        MyButton(String t, Color onCol) {
            super(t);
            this.onCol = onCol.brighter();
            this.userOnCol = onCol;
        }

        void draw(boolean on) {
            if (on) {
                this.setBackground(this.userOnCol);
            } else {
                this.setBackground(LaneHeaderItem.this.defaultColor);
            }
        }

        void draw(boolean on, boolean userOn) {
            if (userOn) {
                this.setBackground(this.userOnCol);
            } else if (on) {
                this.setBackground(this.onCol);
            } else {
                this.setBackground(LaneHeaderItem.this.defaultColor);
            }
        }
    }

    class MeterPanel
    extends JPanel {
        double val = 0.0;
        Color color = null;
        int redcount = 0;

        MeterPanel() {
        }

        public Dimension getMaximumSize() {
            return new Dimension(3, 200);
        }

        public Dimension getPreferredSize() {
            return new Dimension(3, 200);
        }

        void updateMeter(double val, Color col) {
            this.val = val;
            if (this.color == null || col == Color.RED) {
                this.color = col;
            }
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.val <= 0.0) {
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, w, h);
            } else {
                int h2 = (int)((1.0 - this.val) * (double)h);
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, w, h2);
                if ((this.redcount + 1) % 4 != 0) {
                    g.setColor(this.color);
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, h2, w, h);
            }
            if (this.color == Color.RED) {
                ++this.redcount;
                if (this.redcount > 20) {
                    this.color = null;
                    this.redcount = 0;
                }
            } else {
                this.color = null;
            }
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, w - 1, h - 1);
        }
    }
}

