/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.partview.LaneHeaderItem;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.EditHistoryRecordableAction;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.LaneTreeListener;
import com.frinika.sequencer.model.ViewableLaneList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class LaneHeaderPanel
extends JPanel
implements ComponentListener,
AdjustmentListener,
EditHistoryListener,
LaneTreeListener {
    private static final long serialVersionUID = 1L;
    PartView partView;
    int preferredWidth = 200;
    ProjectFrame project;
    ViewableLaneList visibleLanes;
    private Timer timer;

    public LaneHeaderPanel(PartView partView, ProjectFrame project) {
        this.partView = partView;
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.preferredWidth, 1000));
        this.visibleLanes = new ViewableLaneList(project.getProjectContainer());
        this.rebuild();
        this.rePositionItems();
        this.addComponentListener(this);
        project.getProjectContainer().getEditHistoryContainer().addEditHistoryListener(this);
        this.timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LaneHeaderPanel.this.updateMeters();
            }
        });
        this.timer.start();
    }

    private void updateMeters() {
        if (!this.isVisible()) {
            return;
        }
        for (Component comp : this.getComponents()) {
            assert (comp instanceof LaneHeaderItem);
            LaneHeaderItem item = (LaneHeaderItem)comp;
            item.updateMeter();
        }
    }

    void dispose() {
        this.removeComponentListener(this);
        this.project.getProjectContainer().getEditHistoryContainer().removeEditHistoryListener(this);
    }

    void rebuild() {
        this.removeAll();
        this.visibleLanes.rebuild();
        int i = 0;
        for (Lane lane : this.visibleLanes) {
            LaneHeaderItem c = new LaneHeaderItem(this.partView.getProjectFrame(), this, lane, i);
            c.setSize(new Dimension(this.getWidth(), lane.getHeight() * Layout.getLaneHeightScale()));
            this.add(c);
            ++i;
        }
        this.validate();
        this.repaint();
    }

    void rePositionItems() {
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        int widthOld = this.getComponent(0).getWidth();
        int widthNew = this.getWidth();
        int yRef = Layout.timePanelHeight - this.partView.getVirtualScreenRect().y;
        for (Component comp : this.getComponents()) {
            assert (comp instanceof LaneHeaderItem);
            int h = ((LaneHeaderItem)comp).lane.getDisplayH();
            comp.setBounds(0, yRef, widthNew, h);
            yRef += h;
        }
        this.validate();
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.rePositionItems();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        System.out.println("SHWON");
        this.timer.start();
    }

    public void componentHidden(ComponentEvent e) {
        this.timer.stop();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.rePositionItems();
    }

    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryActions) {
        boolean doit = false;
        for (EditHistoryAction e : edithistoryActions) {
            EditHistoryRecordable r;
            if (!(e instanceof EditHistoryRecordableAction) || !((r = ((EditHistoryRecordableAction)e).getRecordable()) instanceof Lane)) continue;
            doit = true;
            break;
        }
        if (doit) {
            this.rebuild();
            this.rePositionItems();
        }
    }

    public void fireLaneTreeChanged() {
        this.rebuild();
        this.rePositionItems();
    }
}

