/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.localization.CurrentLocale;
import com.frinika.midi.DrumMapper;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.MidiResource;
import com.frinika.sequencer.gui.JSpinnerDraggable;
import com.frinika.sequencer.gui.ListProvider;
import com.frinika.sequencer.gui.PopupClient;
import com.frinika.sequencer.gui.PopupSelectorButton;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiQuantizeAction;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.gui.partview.VoiceTree;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPlayOptions;
import com.frinika.sequencer.model.Quantization;
import com.frinika.sequencer.model.util.TimeUtils;
import com.frinika.sequencer.patchname.MyPatch;
import com.frinika.sequencer.patchname.Node;
import com.frinika.sequencer.patchname.PatchNameMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class MidiVoiceView
extends LaneView {
    final MidiResource midiResource;
    MidiDevice midiDev = null;
    int channel;
    ProjectFrame frame;
    boolean drumMapView = false;
    DrumMapper mapper = null;
    TimeUtils timeUtil;
    static HashMap<Lane, MidiQuantizeAction> quantizeDialogCache = new HashMap();
    private static final long serialVersionUID = 1L;
    String patchMapName;

    public MidiVoiceView(MidiLane lane, ProjectFrame frame) {
        super(lane);
        MidiDevice dev;
        this.frame = frame;
        this.timeUtil = frame.getProjectContainer().getTimeUtils();
        frame.getProjectContainer().getSequencer().setPlayOptions(lane.getTrack(), lane.getPlayOptions());
        this.midiResource = lane.getProject().getMidiResource();
        this.midiDev = lane.getMidiDevice();
        if (this.midiDev instanceof SynthWrapper && (dev = ((SynthWrapper)this.midiDev).getRealDevice()) instanceof DrumMapper) {
            this.drumMapView = true;
            this.mapper = (DrumMapper)dev;
        }
        this.init();
    }

    private void toggleDrumMapperView() {
        this.drumMapView = !this.drumMapView;
        this.init();
    }

    protected void makeButtons() {
        MidiDevice dev;
        JPanel devP = new JPanel();
        this.gc.gridwidth = 0;
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        JComponent but = null;
        if (this.mapper == null || this.drumMapView) {
            but = this.createDeviceSelector();
            devP.add(but);
        } else {
            but = this.createDrumMapperDeviceSelector();
            devP.add(but);
        }
        this.gc.gridx = 0;
        if (this.mapper != null) {
            but = this.createDrumMapperChannelSelector();
            devP.add((Component)but, this.gc);
            JButton targetToggle = this.drumMapView ? new JButton("View Target") : new JButton("View DrumMap");
            targetToggle.setMargin(new Insets(0, 0, 0, 0));
            targetToggle.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    MidiVoiceView.this.toggleDrumMapperView();
                }
            });
            devP.add(targetToggle);
        } else {
            but = this.createChannelSelector();
            devP.add((Component)but, this.gc);
        }
        but = this.createPatchMapSelector();
        devP.add((Component)but, this.gc);
        this.gc.anchor = 17;
        this.gc.gridx = 0;
        this.add((Component)devP, this.gc);
        if (this.drumMapView && (dev = ((SynthWrapper)this.midiDev).getRealDevice()) instanceof DrumMapper) {
            this.gc.gridx = 0;
            ++this.gc.gridy;
            this.gc.gridwidth = 0;
            JPanel panel = ((DrumMapper)dev).getGUIPanel(this.frame, (MidiLane)this.lane);
            this.gc.fill = 1;
            this.gc.weighty = 1.0;
            this.gc.weightx = 1.0;
            this.add((Component)panel, this.gc);
            return;
        }
        this.gc.insets.bottom = 5;
        this.gc.insets.top = 5;
        this.gc.insets.right = 5;
        this.gc.insets.left = 5;
        final MidiPlayOptions opt = ((MidiLane)this.lane).getPlayOptions();
        if (opt.quantization == null) {
            opt.quantization = new Quantization();
        }
        JLabel shiftedLabel = new JLabel("Shift");
        final JSpinnerDraggable shifted = new JSpinnerDraggable(new SpinnerNumberModel((int)opt.shiftedTicks, -999, 999, 1));
        shifted.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiLane)MidiVoiceView.this.lane).getPlayOptions().shiftedTicks = ((Integer)shifted.getValue()).intValue();
            }
        });
        this.gc.gridx = 0;
        this.gc.gridwidth = 1;
        ++this.gc.gridy;
        this.gc.anchor = 17;
        this.add((Component)shiftedLabel, this.gc);
        this.gc.anchor = 13;
        ++this.gc.gridx;
        this.gc.fill = 2;
        this.add((Component)shifted, this.gc);
        JLabel loopedLabel = new JLabel("Looped");
        final TimeSelector loopedTimeSelector = new TimeSelector(opt.loopedTicks, true, this.frame.getProjectContainer(), TimeFormat.BEAT_TICK);
        ChangeListener l = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiLane)MidiVoiceView.this.lane).getPlayOptions().loopedTicks = loopedTimeSelector.getTicks();
                try {
                    MidiVoiceView.this.frame.repaintViews();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        loopedTimeSelector.addChangeListener(l);
        l.stateChanged(null);
        ++this.gc.gridx;
        ++this.gc.gridx;
        this.gc.anchor = 17;
        this.add((Component)loopedLabel, this.gc);
        this.gc.anchor = 13;
        ++this.gc.gridx;
        this.add((Component)loopedTimeSelector, this.gc);
        JLabel velLabel = new JLabel("Vel. +/-");
        final JSpinnerDraggable vel = new JSpinnerDraggable(new SpinnerNumberModel(opt.velocityOffset, -127, 127, 1));
        vel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiLane)MidiVoiceView.this.lane).getPlayOptions().velocityOffset = (Integer)vel.getValue();
            }
        });
        this.gc.gridx = 0;
        ++this.gc.gridy;
        this.gc.anchor = 17;
        this.add((Component)velLabel, this.gc);
        ++this.gc.gridx;
        this.add((Component)vel, this.gc);
        JLabel compressorLabel = new JLabel("Compress");
        String[] list = new String[20];
        int c = 100;
        float current = opt.velocityCompression;
        int selectedIndex = 10;
        float delta = 1.0f;
        for (int i = 0; i < list.length; ++i) {
            list[i] = c != 0 ? c + "%" : "-";
            c -= 10;
            float compr = (float)(100 - i * 10) / 100.0f;
            float d = Math.abs(compr - current);
            if (!(d < delta)) continue;
            delta = d;
            selectedIndex = i;
        }
        final JComboBox<String> compressor = new JComboBox<String>(list);
        compressor.setSelectedIndex(selectedIndex);
        compressor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                float compr;
                int index = compressor.getSelectedIndex();
                ((MidiLane)MidiVoiceView.this.lane).getPlayOptions().velocityCompression = compr = (float)(100 - index * 10) / 100.0f;
            }
        });
        ++this.gc.gridx;
        ++this.gc.gridx;
        this.gc.anchor = 17;
        this.add((Component)compressorLabel, this.gc);
        ++this.gc.gridx;
        this.gc.anchor = 13;
        this.add(compressor, this.gc);
        JLabel transposeLabel = new JLabel("Transp. +/-");
        final JSpinnerDraggable transpose = new JSpinnerDraggable(new SpinnerNumberModel(opt.transpose, -127, 127, 1));
        transpose.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value;
                MidiPlayOptions opt = ((MidiLane)MidiVoiceView.this.lane).getPlayOptions();
                opt.transpose = value = ((Integer)transpose.getModel().getValue()).intValue();
            }
        });
        this.gc.gridx = 0;
        ++this.gc.gridy;
        this.gc.anchor = 17;
        this.add((Component)transposeLabel, this.gc);
        ++this.gc.gridx;
        this.add((Component)transpose, this.gc);
        ++this.gc.gridx;
        this.gc.gridwidth = 0;
        this.add((Component)new JPanel(), this.gc);
        final TimeSelector quantizeIntervalTimeSelector = new TimeSelector(this.frame.getProjectContainer(), TimeFormat.NOTE_LENGTH, false);
        quantizeIntervalTimeSelector.setTicks(opt.quantization.interval);
        quantizeIntervalTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int t;
                MidiPlayOptions opt = ((MidiLane)MidiVoiceView.this.lane).getPlayOptions();
                opt.quantization.interval = t = (int)quantizeIntervalTimeSelector.getTicks();
            }
        });
        final JToggleButton quantizeCheckBox = new JToggleButton("Quantize", opt.quantizationActive);
        quantizeCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MidiPlayOptions opt = ((MidiLane)MidiVoiceView.this.lane).getPlayOptions();
                opt.quantizationActive = quantizeCheckBox.isSelected();
            }
        });
        final JSpinnerDraggable quantizeIntensitySpinner = new JSpinnerDraggable(new SpinnerNumberModel((int)(opt.quantization.intensity * 100.0f), 0, 100, 1));
        quantizeIntensitySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MidiPlayOptions opt = ((MidiLane)MidiVoiceView.this.lane).getPlayOptions();
                int value = (Integer)quantizeIntensitySpinner.getModel().getValue();
                opt.quantization.intensity = (float)value / 100.0f;
                if (value == 0) {
                    quantizeCheckBox.setSelected(false);
                }
            }
        });
        JLabel quantizeIntensitySpinnerPercentLabel = new JLabel("%");
        final JButton quantizePatternButton = new JButton("<" + MidiVoiceView.quantizeOptionsInfoString(opt.quantization) + ">");
        quantizePatternButton.setBorderPainted(false);
        quantizePatternButton.setContentAreaFilled(false);
        quantizePatternButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MidiQuantizeAction action = quantizeDialogCache.get(MidiVoiceView.this.lane);
                if (action == null) {
                    action = new MidiQuantizeAction(MidiVoiceView.this.frame);
                    quantizeDialogCache.put(MidiVoiceView.this.lane, action);
                }
                action.q = opt.quantization;
                action.getDialog().show();
                quantizeIntervalTimeSelector.setTicks(opt.quantization.interval);
                if (opt.quantization.intensity < 0.0f) {
                    opt.quantization.intensity = 0.0f;
                }
                quantizeIntensitySpinner.setValue((int)(opt.quantization.intensity * 100.0f));
                quantizePatternButton.setText("<" + MidiVoiceView.quantizeOptionsInfoString(opt.quantization) + ">");
            }
        });
        this.gc.gridx = 0;
        this.gc.gridwidth = 1;
        this.gc.gridy = -1;
        this.add((Component)quantizeCheckBox, this.gc);
        ++this.gc.gridx;
        this.add((Component)quantizeIntensitySpinner, this.gc);
        ++this.gc.gridx;
        this.add((Component)quantizeIntensitySpinnerPercentLabel, this.gc);
        ++this.gc.gridx;
        this.gc.anchor = 17;
        this.add((Component)quantizeIntervalTimeSelector, this.gc);
        ++this.gc.gridx;
        this.gc.gridwidth = 0;
        this.add((Component)quantizePatternButton, this.gc);
        this.gc.gridx = 0;
        this.gc.gridwidth = 0;
        this.gc.gridy = -1;
        this.gc.weighty = 1.0;
        boolean noPanel = this.midiDev == null || !(this.midiDev instanceof SynthWrapper);
        but = !noPanel ? this.createVoiceTree() : null;
        if (but == null) {
            this.gc.weighty = 1.0;
            this.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(10000, 10000), new Dimension(10000, 10000)), this.gc);
        } else {
            this.gc.fill = 1;
            this.gc.weighty = 1.0;
            this.add((Component)but, this.gc);
        }
    }

    JComponent createPatchMapSelector() {
        JButton but = new JButton(CurrentLocale.getMessage("midilane.properties.select_patchmap"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(CurrentLocale.getMessage("midilane.properties.select_patchmap"));
                if (chooser.showOpenDialog(MidiVoiceView.this) == 0) {
                    File file = chooser.getSelectedFile();
                    MidiVoiceView.this.patchMapName = file.getAbsolutePath();
                    MidiVoiceView.this.init();
                }
            }
        });
        return but;
    }

    JComponent createVoiceTree() {
        MidiDevice midiDev1 = this.midiDev;
        if (this.mapper != null) {
            midiDev1 = this.mapper.getDefaultMidiDevice();
        }
        int channel = ((MidiLane)this.lane).getMidiChannel();
        System.out.println(midiDev1);
        PatchNameMap vList = this.patchMapName == null ? this.midiResource.getVoiceList(midiDev1, channel) : this.midiResource.getVoiceList(new File(this.patchMapName));
        if (vList == null) {
            return null;
        }
        final VoiceTree vTree = new VoiceTree(vList);
        JScrollPane ret = new JScrollPane(vTree);
        vTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)vTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.isLeaf()) {
                    Object nodeInfo = node.getUserObject();
                    System.out.println(nodeInfo);
                    if (!(((Node)nodeInfo).getData() instanceof MyPatch)) {
                        System.err.println(" Sorry this is not a patch node ");
                        return;
                    }
                    MyPatch patch = (MyPatch)((Node)nodeInfo).getData();
                    System.out.println(patch);
                    Receiver recv = ((MidiLane)MidiVoiceView.this.lane).getReceiver();
                    if (recv == null) {
                        return;
                    }
                    int chan = ((MidiLane)MidiVoiceView.this.lane).getMidiChannel();
                    int bank = ((0xFF & patch.msb) << 8) + patch.lsb;
                    ShortMessage shm = new ShortMessage();
                    try {
                        shm.setMessage(176, chan, 0, patch.msb);
                        recv.send(shm, -1L);
                        shm.setMessage(176, chan, 32, patch.lsb);
                        recv.send(shm, -1L);
                        shm.setMessage(192, chan, patch.prog, 0);
                        recv.send(shm, -1L);
                    }
                    catch (InvalidMidiDataException e1) {
                        e1.printStackTrace();
                    }
                    ((MidiLane)MidiVoiceView.this.lane).setProgram(patch);
                }
            }
        });
        MyPatch patch = ((MidiLane)this.lane).getProgram();
        if (patch != null) {
            vTree.select(patch);
        }
        return ret;
    }

    PopupSelectorButton createChannelSelector() {
        int channel = ((MidiLane)this.lane).getMidiChannel();
        Object channelHandle = null;
        if (channel > -1) {
            channelHandle = this.midiResource.getOutChannelList(this.midiDev)[channel];
        }
        String chanStr = channelHandle == null ? "null" : channelHandle.toString();
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                return MidiVoiceView.this.midiResource.getOutChannelList(((MidiLane)MidiVoiceView.this.lane).getMidiDevice());
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int cnt) {
                ((MidiLane)MidiVoiceView.this.lane).setMidiChannel(cnt);
                MidiVoiceView.this.init();
                MidiVoiceView.this.validate();
            }
        };
        PopupSelectorButton popsel = new PopupSelectorButton(resource, client, chanStr);
        popsel.setIcon(ProjectFrame.getIconResource("jack_connector.png"));
        return popsel;
    }

    PopupSelectorButton createDrumMapperChannelSelector() {
        System.out.println(" DMCS create ");
        MidiDevice target = this.mapper.getDefaultMidiDevice();
        int channel = ((MidiLane)this.lane).getMidiChannel();
        Object channelHandle = null;
        if (channel > -1) {
            channelHandle = this.midiResource.getOutChannelList(target)[channel];
        }
        System.out.println(" DMCS create " + channel + "   " + channelHandle);
        String chanStr = channelHandle == null ? "null" : channelHandle.toString();
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                return MidiVoiceView.this.midiResource.getOutChannelList(MidiVoiceView.this.mapper.getDefaultMidiDevice());
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int cnt) {
                ((MidiLane)MidiVoiceView.this.lane).setMidiChannel(cnt);
                MidiVoiceView.this.validate();
                MidiVoiceView.this.repaint();
            }
        };
        return new PopupSelectorButton(resource, client, chanStr);
    }

    PopupSelectorButton createDeviceSelector() {
        this.midiDev = ((MidiLane)this.lane).getMidiDevice();
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                return MidiVoiceView.this.lane.getProject().getMidiDeviceDescriptors().toArray();
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int cnt) {
                MidiDevice dev;
                MidiDevice d = ((MidiDeviceDescriptor)o).getMidiDevice();
                ((MidiLane)MidiVoiceView.this.lane).setMidiDevice(d);
                MidiVoiceView.this.drumMapView = false;
                MidiVoiceView.this.mapper = null;
                if (d instanceof SynthWrapper && (dev = ((SynthWrapper)d).getRealDevice()) instanceof DrumMapper) {
                    MidiVoiceView.this.drumMapView = true;
                    MidiVoiceView.this.mapper = (DrumMapper)dev;
                }
                if (o != MidiVoiceView.this.midiDev) {
                    MidiVoiceView.this.init();
                }
            }
        };
        String name = "null";
        Icon icon = null;
        if (this.midiDev != null) {
            MidiDeviceDescriptor des = this.lane.getProject().getMidiDeviceDescriptor(this.midiDev);
            if (des == null) {
                try {
                    throw new Exception(" MidiLane has a mididevice without a descriptor !!! check this ? ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                name = des.getProjectName();
                icon = des.getIcon();
            }
        } else {
            name = "null";
        }
        PopupSelectorButton popsel = new PopupSelectorButton(resource, client, name);
        if (icon != null) {
            popsel.setIcon(icon);
        } else {
            popsel.setIcon(ProjectFrame.getIconResource("midi.png"));
        }
        return popsel;
    }

    PopupSelectorButton createDrumMapperDeviceSelector() {
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                return MidiVoiceView.this.lane.getProject().getMidiDeviceDescriptors().toArray();
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int cnt) {
                MidiDevice dev;
                MidiDevice d = ((MidiDeviceDescriptor)o).getMidiDevice();
                MidiVoiceView.this.drumMapView = false;
                if (d instanceof SynthWrapper && (dev = ((SynthWrapper)d).getRealDevice()) instanceof DrumMapper) {
                    System.err.println("Sorry but I don't think this is a good idea !!!!");
                    MidiVoiceView.this.init();
                    return;
                }
                MidiVoiceView.this.mapper.setDefaultMidiDevice(d);
                MidiVoiceView.this.init();
            }
        };
        MidiDevice d = this.mapper.getDefaultMidiDevice();
        String name = d != null ? d.toString() : "null";
        return new PopupSelectorButton(resource, client, name);
    }

    private static String quantizeOptionsInfoString(Quantization options) {
        StringBuffer sb = new StringBuffer();
        if (options.groovePattern != null) {
            sb.append(options.groovePattern.getName());
        }
        if (options.swing != 0.0f) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("swing ");
            sb.append((int)(options.swing * 100.0f));
            sb.append('%');
        }
        if (sb.length() == 0) {
            return "default";
        }
        return sb.toString();
    }
}

